/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public final class OsfUtils {
    private OsfUtils() {
    }

    public static final void requirePagingParams(Context ctx, Map map, Map<String, Object> result) {
        Object paramRows = map.get("rows");
        Object paramPage = map.get("page");
        if (paramRows == null) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "rows required");
            return;
        }
        if (paramPage == null) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "page required");
            return;
        }
        int rows = (Integer)paramRows;
        int page = (Integer)map.get("page");
        if (rows < 0) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "rows must not be less than 0");
            return;
        }
        if (page < 0) {
            result.put("resultFlag", "failure");
            result.put("errorDes", "page must not be less than 0");
            return;
        }
    }

    public static void notEmpty(Context ctx, Map map, String ... keys) throws EASBizException {
        if (CollectionUtils.isEmpty((Map)map)) {
            throw new EASBizException(new NumericExceptionSubItem("perf", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OSFPARAMEISNOTNULL, ctx)));
        }
        for (String key : keys) {
            Object o = map.get(key);
            if (o != null && !StringUtils.isEmpty((String)o.toString())) continue;
            throw new EASBizException(new NumericExceptionSubItem("perf", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OSFPARAMEISNOTNULLVAR, ctx, new Object[]{key})));
        }
    }

    public static String convertListToString(List<String> list) {
        Object[] array = list.toArray();
        return OsfUtils.convertListToString(array);
    }

    public static String convertListToString(Object[] array) {
        StringBuffer sb = new StringBuffer();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)array[i]);
                sb.append("'");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)array[i]);
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)array[i]);
            sb.append("'");
        }
        return sb.toString();
    }
}

