/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IIndicatorTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfGoalsObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IRecordTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaluFormAreaBase;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWorkFlowDef;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.ScoringWayEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.SubAreaTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.SumScoreRuleEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IGradeTaskNodeInst;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SendMessageService;
import com.kingdee.shr.perfweb.utils.EmailServiceForPerf;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PerfPlanExecuteUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.PerfPlanExecuteUtils");
    private BigDecimal tarScore;

    protected static PositionInfo getPositionInfo(String positionId) {
        try {
            IPosition iposition = PositionFactory.getRemoteInstance();
            PositionInfo posInfo = null;
            PositionCollection posColl = iposition.getPositionCollection("where id='" + positionId + "'");
            if (posColl != null && posColl.size() > 0) {
                posInfo = posColl.get(0);
                return posInfo;
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return null;
    }

    public static PWorkFlowDefInfo getPWorkFlowDefInfo(String workFlow) {
        try {
            IPWorkFlowDef iPworkFlow = PWorkFlowDefFactory.getRemoteInstance();
            PWorkFlowDefInfo pworkFlowInfo = null;
            PWorkFlowDefCollection pWorkFlowColl = iPworkFlow.getPWorkFlowDefCollection("where id='" + workFlow + "'");
            if (pWorkFlowColl != null && pWorkFlowColl.size() > 0) {
                pworkFlowInfo = pWorkFlowColl.get(0);
                return pworkFlowInfo;
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return null;
    }

    public static float calculateEvaObjTargetWeight(Context ctx, String evaObj) {
        try {
            IndicatorTargetCollection indicatorColl;
            boolean sumScoreRuleFlag;
            BigDecimal weight = BigDecimal.ZERO;
            IRecordTarget irecordTarget = RecordTargetFactory.getLocalInstance((Context)ctx);
            IIndicatorTarget iindicatorTarget = IndicatorTargetFactory.getLocalInstance((Context)ctx);
            PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByEvaObj(ctx, evaObj);
            IEvaluFormAreaBase iEvaluFormAreaBase = EvaluFormAreaBaseFactory.getLocalInstance((Context)ctx);
            int scoringWay = ruleInfo.getScoringWay().getValue();
            RecordTargetCollection recordTargetColl = irecordTarget.getRecordTargetCollection("select id,areaBase.id,tarScore,weight where evaObj='" + evaObj + "'");
            if (recordTargetColl != null && recordTargetColl.size() > 0) {
                for (int i = 0; i < recordTargetColl.size(); ++i) {
                    String sumScoreRule = "";
                    RecordTargetInfo recordTargetInfo = recordTargetColl.get(i);
                    sumScoreRuleFlag = false;
                    String areaBase = recordTargetInfo.getAreaBase().getId().toString();
                    EvaluFormAreaBaseCollection areaBaseColl = iEvaluFormAreaBase.getEvaluFormAreaBaseCollection("select id,sumScoreRule where id='" + areaBase + "'");
                    if (areaBaseColl != null && areaBaseColl.size() > 0) {
                        sumScoreRule = areaBaseColl.get(0).getSumScoreRule().getValue();
                        sumScoreRuleFlag = sumScoreRule.equals("400") || sumScoreRule.equals("500");
                    }
                    String targetWeight = null;
                    targetWeight = scoringWay == 1 ? recordTargetInfo.getTarScore() : recordTargetInfo.getWeight();
                    if (StringUtil.isEmpty((String)targetWeight) || sumScoreRuleFlag) continue;
                    weight = weight.add(new BigDecimal(targetWeight));
                }
            }
            if ((indicatorColl = iindicatorTarget.getIndicatorTargetCollection("select id,areaBase.id,tarScore,weight where evaObj='" + evaObj + "'")) != null && indicatorColl.size() > 0) {
                for (int j = 0; j < indicatorColl.size(); ++j) {
                    String sumScoreRule = "";
                    sumScoreRuleFlag = false;
                    IndicatorTargetInfo indicatorTargetInfo = indicatorColl.get(j);
                    String areaBase = indicatorTargetInfo.getAreaBase().getId().toString();
                    EvaluFormAreaBaseCollection areaBaseColl = iEvaluFormAreaBase.getEvaluFormAreaBaseCollection("select id,sumScoreRule,subAreaType where id='" + areaBase + "'");
                    if (areaBaseColl != null && areaBaseColl.size() > 0) {
                        sumScoreRule = areaBaseColl.get(0).getSumScoreRule().getValue();
                        boolean bl = sumScoreRuleFlag = sumScoreRule.equals("400") || sumScoreRule.equals("500");
                    }
                    if (SubAreaTypeEnum.ADDSUB.equals((Object)areaBaseColl.get(0).getSubAreaType())) continue;
                    String targetWeight = null;
                    targetWeight = scoringWay == 1 ? indicatorTargetInfo.getTarScore() : indicatorTargetInfo.getWeight();
                    if (StringUtil.isEmpty((String)targetWeight) || sumScoreRuleFlag) continue;
                    weight = weight.add(new BigDecimal(targetWeight));
                }
            }
            return weight.floatValue();
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            return 0.0f;
        }
    }

    public static HashMap<String, Float> calculateEvaObjTargetWeightBatch(Context ctx, HashSet<String> evaobjSet) throws BOSException {
        try {
            IndicatorTargetCollection indicatorColl;
            if (CollectionUtils.isEmpty(evaobjSet)) {
                return null;
            }
            HashMap<String, Float> evaWeight = new HashMap<String, Float>();
            IRecordTarget irecordTarget = RecordTargetFactory.getLocalInstance((Context)ctx);
            IIndicatorTarget iindicatorTarget = IndicatorTargetFactory.getLocalInstance((Context)ctx);
            logger.error("calculateEvaObjTargetWeightBatch evaobjSet: " + evaobjSet);
            logger.error("calculateEvaObjTargetWeightBatch evaobjId: " + evaobjSet.iterator().next());
            PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByEvaObj(ctx, evaobjSet.iterator().next());
            int scoringWay = ruleInfo.getScoringWay().getValue();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaObj", evaobjSet, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("areaBase.id"));
            sic.add(new SelectorItemInfo("tarScore"));
            sic.add(new SelectorItemInfo("weight"));
            sic.add(new SelectorItemInfo("evaObj.id"));
            sic.add(new SelectorItemInfo("areaBase.*"));
            evi.setSelector(sic);
            RecordTargetCollection recordTargetColl = irecordTarget.getRecordTargetCollection(evi);
            if (recordTargetColl != null && recordTargetColl.size() > 0) {
                for (int i = 0; i < recordTargetColl.size(); ++i) {
                    String evaobjId;
                    BigDecimal weight = BigDecimal.ZERO;
                    String sumScoreRule = "";
                    boolean sumScoreRuleFlag = false;
                    RecordTargetInfo recordTargetInfo = recordTargetColl.get(i);
                    sumScoreRule = recordTargetInfo.getAreaBase().getSumScoreRule().getValue();
                    sumScoreRuleFlag = "400".equals(sumScoreRule) || "500".equals(sumScoreRule);
                    String targetWeight = null;
                    targetWeight = scoringWay == 1 ? recordTargetInfo.getTarScore() : recordTargetInfo.getWeight();
                    if (!StringUtil.isEmpty((String)targetWeight) && !sumScoreRuleFlag) {
                        weight = weight.add(new BigDecimal(targetWeight));
                    }
                    if (evaWeight.containsKey(evaobjId = recordTargetInfo.getEvaObj().getId().toString())) {
                        evaWeight.put(evaobjId, Float.valueOf(new BigDecimal(evaWeight.get(evaobjId).floatValue()).add(weight).floatValue()));
                        continue;
                    }
                    evaWeight.put(evaobjId, Float.valueOf(weight.floatValue()));
                }
            }
            if ((indicatorColl = iindicatorTarget.getIndicatorTargetCollection(evi)) != null && indicatorColl.size() > 0) {
                for (int j = 0; j < indicatorColl.size(); ++j) {
                    String evaobjId;
                    BigDecimal weight = BigDecimal.ZERO;
                    String sumScoreRule = "";
                    boolean sumScoreRuleFlag = false;
                    IndicatorTargetInfo indicatorTargetInfo = indicatorColl.get(j);
                    sumScoreRule = indicatorTargetInfo.getAreaBase().getSumScoreRule().getValue();
                    sumScoreRuleFlag = "400".equals(sumScoreRule) || "500".equals(sumScoreRule);
                    String targetWeight = null;
                    if (SubAreaTypeEnum.ADDSUB.equals((Object)indicatorTargetInfo.getAreaBase().getSubAreaType())) continue;
                    targetWeight = scoringWay == 1 ? indicatorTargetInfo.getTarScore() : indicatorTargetInfo.getWeight();
                    if (!StringUtil.isEmpty((String)targetWeight) && !sumScoreRuleFlag) {
                        logger.error("targetWeight is: " + targetWeight);
                        weight = weight.add(new BigDecimal(targetWeight));
                    }
                    if (evaWeight.containsKey(evaobjId = indicatorTargetInfo.getEvaObj().getId().toString())) {
                        evaWeight.put(evaobjId, Float.valueOf(new BigDecimal(evaWeight.get(evaobjId).floatValue()).add(weight).floatValue()));
                        continue;
                    }
                    evaWeight.put(evaobjId, Float.valueOf(weight.floatValue()));
                }
            }
            return evaWeight;
        }
        catch (Exception e) {
            logger.error("calculateEvaObjTargetWeightBatch error: ", (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static float calculateEvaObjTargetTarScore(Context ctx, String evaObj) {
        try {
            IndicatorTargetCollection indicatorColl;
            BigDecimal tarScore = BigDecimal.ZERO;
            IRecordTarget irecordTarget = RecordTargetFactory.getLocalInstance((Context)ctx);
            IIndicatorTarget iindicatorTarget = IndicatorTargetFactory.getLocalInstance((Context)ctx);
            RecordTargetCollection recordTargetColl = irecordTarget.getRecordTargetCollection("where evaObj='" + evaObj + "'");
            if (recordTargetColl != null && recordTargetColl.size() > 0) {
                for (int i = 0; i < recordTargetColl.size(); ++i) {
                    String targetTarScore;
                    String sumScoreRule = "";
                    boolean sumScoreRuleFlag = false;
                    String areaBase = recordTargetColl.get(i).getAreaBase().getId().toString();
                    EvaluFormAreaBaseCollection areaBaseColl = GetEntityInfoUtils.getEvaluFormAreaBaseCollById(ctx, areaBase);
                    if (areaBaseColl != null && areaBaseColl.size() > 0) {
                        sumScoreRule = areaBaseColl.get(0).getSumScoreRule().getValue();
                        boolean bl = sumScoreRuleFlag = sumScoreRule.equals("400") || sumScoreRule.equals("500");
                    }
                    if (StringUtil.isEmpty((String)(targetTarScore = recordTargetColl.get(i).getTarScore())) || sumScoreRuleFlag) continue;
                    tarScore = tarScore.add(new BigDecimal(targetTarScore));
                }
            }
            if ((indicatorColl = iindicatorTarget.getIndicatorTargetCollection("where evaObj='" + evaObj + "'")) != null && indicatorColl.size() > 0) {
                for (int j = 0; j < indicatorColl.size(); ++j) {
                    String targetTarScore;
                    String sumScoreRule = "";
                    boolean sumScoreRuleFlag = false;
                    String areaBase = indicatorColl.get(j).getAreaBase().getId().toString();
                    EvaluFormAreaBaseCollection areaBaseColl = GetEntityInfoUtils.getEvaluFormAreaBaseCollById(ctx, areaBase);
                    if (areaBaseColl != null && areaBaseColl.size() > 0) {
                        sumScoreRule = areaBaseColl.get(0).getSumScoreRule().getValue();
                        boolean bl = sumScoreRuleFlag = sumScoreRule.equals("400") || sumScoreRule.equals("500");
                    }
                    if (StringUtil.isEmpty((String)(targetTarScore = indicatorColl.get(j).getTarScore())) || sumScoreRuleFlag) continue;
                    tarScore = tarScore.add(new BigDecimal(targetTarScore));
                }
            }
            return tarScore.floatValue();
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            return 0.0f;
        }
    }

    public static String getPerfGoalsObject(String evaObj) {
        try {
            String targetDelievers = "";
            IPerfGoalsObject iperfGoalsObj = PerfGoalsObjectFactory.getRemoteInstance();
            PerfGoalsObjectCollection perfGoalsObjColl = iperfGoalsObj.getPerfGoalsObjectCollection("where perfEvaObject='" + evaObj + "'");
            if (perfGoalsObjColl != null && perfGoalsObjColl.size() > 0) {
                for (int i = 0; i < perfGoalsObjColl.size(); ++i) {
                    targetDelievers = targetDelievers + "," + perfGoalsObjColl.get(i).getPersonName();
                }
            }
            targetDelievers = targetDelievers.replaceFirst(",", "");
            return targetDelievers;
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getPerfGoalsObjectByEvaObjs(Context ctx, Set<String> evaObjs) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("perfEvaObject", evaObjs, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            IPerfGoalsObject iperfGoalsObj = PerfGoalsObjectFactory.getLocalInstance((Context)ctx);
            PerfGoalsObjectCollection coll = iperfGoalsObj.getPerfGoalsObjectCollection(evi);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    PerfGoalsObjectInfo perfGoalsObjectInfo = coll.get(i);
                    String evaObj = perfGoalsObjectInfo.getPerfEvaObject().getId().toString();
                    String goalsObjects = (String)resultMap.get(evaObj);
                    StringBuffer sb = null;
                    sb = goalsObjects == null ? new StringBuffer() : new StringBuffer(goalsObjects);
                    sb.append(perfGoalsObjectInfo.getPersonName()).append(",");
                    resultMap.put(evaObj, sb.toString());
                }
                for (Map.Entry entry : resultMap.entrySet()) {
                    entry.setValue(((String)entry.getValue()).substring(0, ((String)entry.getValue()).length() - 1));
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return resultMap;
    }

    public static HashMap<String, Object> getPerfPlan(Context ctx, String planId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PerfPlanInfo planInfo = GetEntityInfoUtils.getPerfPlanInfo(ctx, planId);
        if (planInfo != null) {
            map.put("targetMakeSure", planInfo.get("targetMakeSure"));
            map.put("perfModelName", planInfo.getPerfModel().getName());
            map.put("perfRule", planInfo.getPerfRule().getId().toString());
            PerformanceRuleInfo performanceRuleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(ctx, planInfo.getPerfRule().getId().toString());
            map.put("perfRuleName", performanceRuleInfo.getName());
            map.put("scoreWay", performanceRuleInfo.getScoringWay().getValue());
        }
        return map;
    }

    public static Map<String, String> getCurrentNodeHandersForEvaObj(Context ctx, Set<String> evaObjs) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", evaObjs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isEffective", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("canEdit", (Object)"1", CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            IGradeTaskNodeInst igradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            GradeTaskNodeInstCollection coll = igradeTaskNodeInst.getGradeTaskNodeInstCollection(evi);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    GradeTaskNodeInstInfo gradeTaskNodeInstInfo = coll.get(i);
                    String evaObj = gradeTaskNodeInstInfo.getEvaObj().getId().toString();
                    String handlers = (String)resultMap.get(evaObj);
                    StringBuffer sb = null;
                    sb = handlers == null ? new StringBuffer() : new StringBuffer(handlers);
                    if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)gradeTaskNodeInstInfo.getNodeHandlerName())) {
                        sb.append(gradeTaskNodeInstInfo.getNodeHandlerName()).append(",");
                    }
                    resultMap.put(evaObj, sb.toString());
                }
                for (Map.Entry entry : resultMap.entrySet()) {
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
                    entry.setValue(((String)entry.getValue()).substring(0, ((String)entry.getValue()).length() - 1));
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return resultMap;
    }

    public static Set<String> getCurrentNodeHandersForEvaObjs(Context ctx, Set<String> evaObjs, String workFlow) {
        HashSet<String> handlerIds = new HashSet<String>();
        HashSet<String> validHandlerIds = new HashSet<String>(16);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", evaObjs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isEffective", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("canEdit", (Object)"1", CompareType.EQUALS));
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)workFlow)) {
            filter.getFilterItems().add(new FilterItemInfo("wfNode.workFlow.id", (Object)workFlow, CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        try {
            IGradeTaskNodeInst igradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            GradeTaskNodeInstCollection coll = igradeTaskNodeInst.getGradeTaskNodeInstCollection(evi);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    GradeTaskNodeInstInfo info = coll.get(i);
                    if (null == info.getNodeHandler() || null == info.getNodeHandler().getId()) continue;
                    String handlerId = info.getNodeHandler().getId().toString();
                    handlerIds.add(handlerId);
                }
                FilterInfo userFilter = new FilterInfo();
                userFilter.getFilterItems().add(new FilterItemInfo("person", handlerIds, CompareType.INCLUDE));
                userFilter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0, CompareType.EQUALS));
                userFilter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)0, CompareType.EQUALS));
                EntityViewInfo userEvi = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("person.id"));
                userEvi.setSelector(sic);
                userEvi.setFilter(userFilter);
                IUser iUser = UserFactory.getLocalInstance((Context)ctx);
                UserCollection userColl = iUser.getUserCollection(userEvi);
                if (null != userColl && userColl.size() > 0) {
                    int userSize = userColl.size();
                    for (int j = 0; j < userSize; ++j) {
                        String personId = userColl.get(j).getPerson().getId().toString();
                        validHandlerIds.add(personId);
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return validHandlerIds;
    }

    public static Map<String, String> getCurrentNodeHanderEvaObjMapForEvaObjs(Context ctx, Set<String> evaObjs, String workFlow) {
        HashSet<String> handlerIds = new HashSet<String>();
        HashSet<String> validHandlerIds = new HashSet<String>(16);
        HashMap<String, String> handlerEvaObjMap = new HashMap<String, String>();
        HashMap<String, String> validHandlerEvaObjMap = new HashMap<String, String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", evaObjs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isEffective", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("canEdit", (Object)"1", CompareType.EQUALS));
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)workFlow)) {
            filter.getFilterItems().add(new FilterItemInfo("wfNode.workFlow.id", (Object)workFlow, CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = evi.getSelector();
        selector.add(new SelectorItemInfo("nodeHandler.id"));
        selector.add(new SelectorItemInfo("evaObj.id"));
        selector.add(new SelectorItemInfo("evaObj.hrUnitOrg.id"));
        evi.setFilter(filter);
        try {
            IGradeTaskNodeInst igradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            GradeTaskNodeInstCollection coll = igradeTaskNodeInst.getGradeTaskNodeInstCollection(evi);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    GradeTaskNodeInstInfo info = coll.get(i);
                    if (null == info.getNodeHandler() || null == info.getNodeHandler().getId()) continue;
                    String handlerId = info.getNodeHandler().getId().toString();
                    handlerIds.add(handlerId);
                    handlerEvaObjMap.put(handlerId, info.getEvaObj().getId().toString() + "," + info.getEvaObj().getHrUnitOrg() != null ? info.getEvaObj().getHrUnitOrg().getId().toString() : "");
                }
                FilterInfo userFilter = new FilterInfo();
                userFilter.getFilterItems().add(new FilterItemInfo("person", handlerIds, CompareType.INCLUDE));
                userFilter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0, CompareType.EQUALS));
                userFilter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)0, CompareType.EQUALS));
                EntityViewInfo userEvi = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("person.id"));
                userEvi.setSelector(sic);
                userEvi.setFilter(userFilter);
                IUser iUser = UserFactory.getLocalInstance((Context)ctx);
                UserCollection userColl = iUser.getUserCollection(userEvi);
                if (null != userColl && userColl.size() > 0) {
                    int userSize = userColl.size();
                    for (int j = 0; j < userSize; ++j) {
                        String personId = userColl.get(j).getPerson().getId().toString();
                        validHandlerIds.add(personId);
                        validHandlerEvaObjMap.put(personId, (String)handlerEvaObjMap.get(personId));
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return validHandlerEvaObjMap;
    }

    public static Set<String> getCurrentSelfOrOtherEvalu(Context ctx, Set<String> evaObjs, int type) {
        HashSet<String> evaObjIdSet = new HashSet<String>(16);
        HashSet<String> scoreStatusSet = new HashSet<String>(8);
        scoreStatusSet.add("1");
        scoreStatusSet.add("5");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", evaObjs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isEffective", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("canEdit", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("scoreStatus", scoreStatusSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isSelf", (Object)type, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        try {
            IGradeTaskNodeInst igradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            GradeTaskNodeInstCollection coll = igradeTaskNodeInst.getGradeTaskNodeInstCollection(evi);
            if (null != coll && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    evaObjIdSet.add(coll.get(i).getEvaObj().getId().toString());
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return evaObjIdSet;
    }

    public static Map<String, Object> sendSMSService(Map<String, String> personIds, Context ctx, String content, String service) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> errlist = new ArrayList<String>();
        try {
            SendMessageService sendMessageService = new SendMessageService();
            String phone = "";
            for (String personId : personIds.keySet()) {
                boolean t;
                PersonInfo personInfo = PersonFactory.getRemoteInstance().getPersonCollection("where id='" + personId + "'").get(0);
                phone = personInfo.getCell();
                if (phone == null || phone.isEmpty()) {
                    errlist.add(personId);
                    continue;
                }
                HashMap<String, String> otherParams = new HashMap<String, String>();
                String evaObjAndHrOrgUnit = personIds.get(personId);
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)evaObjAndHrOrgUnit)) {
                    String[] evaObjAndHrOrgUnitArr = evaObjAndHrOrgUnit.split(",");
                    otherParams.put("evaObjId", evaObjAndHrOrgUnitArr[0]);
                    otherParams.put("hrOrgUnitId", evaObjAndHrOrgUnitArr.length > 1 ? evaObjAndHrOrgUnitArr[1] : "");
                }
                if (t = sendMessageService.SendSMS(ctx, phone, content, service, otherParams)) continue;
                errlist.add(personId);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        map.put("errResult", errlist);
        map.put("errNum", errlist.size());
        return map;
    }

    public static Map<String, Object> sendEmailService(Context ctx, Set<String> personIds, String title, String content) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> errlist = new ArrayList<String>();
        try {
            for (String personId : personIds) {
                String receiverAddress = "";
                PersonInfo personInfo = PersonFactory.getRemoteInstance().getPersonCollection("where id='" + personId + "'").get(0);
                receiverAddress = personInfo.getEmail();
                if (receiverAddress == null || receiverAddress.isEmpty()) {
                    errlist.add(personId);
                    continue;
                }
                boolean t = EmailServiceForPerf.sendEmail(ctx, title, receiverAddress, null, null, content, null);
                if (t) continue;
                errlist.add(personId);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        map.put("errResult", errlist);
        map.put("errNum", errlist.size());
        return map;
    }

    public static Map<String, Object> sendPortalMessageService(Context ctx, String[] objIdArray, String type) {
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance((Context)ctx);
            if (type.equals("201")) {
                map = iPerfEvaObject.urgedPersonalUnsubmit(StringUtils.arrayToString((Object[])objIdArray, (String)","));
            }
            if (type.equals("301")) {
                map = iPerfEvaObject.urgedSuperiorNotgive(StringUtils.arrayToString((Object[])objIdArray, (String)","));
            }
            if (type.equals("401")) {
                iPerfEvaObject.urgedGradeSendSuccess(StringUtils.arrayToString((Object[])objIdArray, (String)","));
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return map;
    }

    public static Map<String, String> getCurrentNodeHandersForEvaObj(Context ctx, Set<String> evaObjSet, String workFlow) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", evaObjSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isEffective", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("canEdit", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("wfNode.workFlow.id", (Object)workFlow, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            IGradeTaskNodeInst igradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            GradeTaskNodeInstCollection coll = igradeTaskNodeInst.getGradeTaskNodeInstCollection(evi);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    GradeTaskNodeInstInfo gradeTaskNodeInstInfo = coll.get(i);
                    String evaObj = gradeTaskNodeInstInfo.getEvaObj().getId().toString();
                    String handlers = (String)resultMap.get(evaObj);
                    StringBuffer sb = null;
                    sb = handlers == null ? new StringBuffer() : new StringBuffer(handlers);
                    if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)gradeTaskNodeInstInfo.getNodeHandlerName())) {
                        sb.append(gradeTaskNodeInstInfo.getNodeHandlerName()).append(",");
                    }
                    resultMap.put(evaObj, sb.toString());
                }
                for (Map.Entry entry : resultMap.entrySet()) {
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
                    entry.setValue(((String)entry.getValue()).substring(0, ((String)entry.getValue()).length() - 1));
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return resultMap;
    }

    public static void getBatchCurrentNodeHandersForEvaObj(Context ctx, Set<String> evaObjSet, Set<String> workFlowSet, Map<String, String> resultMap, Map<String, Set<String>> evaObjHandlerMap, Map<String, Set<String>> workNodeNameMap) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", evaObjSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isEffective", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taskStatus", (Object)"2", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("canEdit", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("wfNode.workFlow.id", workFlowSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isRetain", (Object)"0", CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaObj.id"));
        sic.add(new SelectorItemInfo("nodeHandlerName"));
        sic.add(new SelectorItemInfo("nodeHandler.id"));
        sic.add(new SelectorItemInfo("wfNode.workFlow.*"));
        evi.setFilter(filter);
        HashSet<String> allHandlerIdSet = new HashSet<String>();
        HashSet<String> allWorkNodeIdSet = new HashSet<String>();
        try {
            IGradeTaskNodeInst igradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance((Context)ctx);
            GradeTaskNodeInstCollection coll = igradeTaskNodeInst.getGradeTaskNodeInstCollection(evi);
            if (coll != null && coll.size() > 0) {
                Set<String> workNodeIdSet = null;
                for (int i = 0; i < coll.size(); ++i) {
                    GradeTaskNodeInstInfo info = coll.get(i);
                    if (null != info.getNodeHandler() && null != info.getNodeHandler().getId()) {
                        allHandlerIdSet.add(info.getNodeHandler().getId().toString());
                    }
                    String evaObj = info.getEvaObj().getId().toString();
                    String key = evaObj + "$" + info.getWfNode().getWorkflow().getId().toString();
                    if (info.getWfNode() != null && info.getWfNode().getId() != null) {
                        workNodeIdSet = workNodeNameMap.get(key);
                        if (CollectionUtils.isEmpty(workNodeIdSet)) {
                            workNodeIdSet = new HashSet<String>();
                        }
                        workNodeIdSet.add(info.getWfNode().getId().toString());
                        allWorkNodeIdSet.add(info.getWfNode().getId().toString());
                    }
                    String handlers = resultMap.get(key);
                    Set<String> handlerIdSet = evaObjHandlerMap.get(key);
                    if (CollectionUtils.isEmpty(handlerIdSet)) {
                        handlerIdSet = new HashSet<String>(50);
                        if (null != info.getNodeHandler() && null != info.getNodeHandler().getId()) {
                            handlerIdSet.add(info.getNodeHandler().getId().toString());
                        }
                    } else if (null != info.getNodeHandler() && null != info.getNodeHandler().getId()) {
                        handlerIdSet.add(info.getNodeHandler().getId().toString());
                    }
                    StringBuffer sb = null;
                    sb = handlers == null ? new StringBuffer() : new StringBuffer(handlers);
                    if (null != info.getNodeHandler() && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)info.getNodeHandler().getName(ctx.getLocale()))) {
                        sb.append(info.getNodeHandler().getName(ctx.getLocale())).append(",");
                    }
                    resultMap.put(key, sb.toString());
                    evaObjHandlerMap.put(key, handlerIdSet);
                    workNodeNameMap.put(key, workNodeIdSet);
                }
                for (Map.Entry<String, String> entry : resultMap.entrySet()) {
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entry.getValue()) || entry.getValue().lastIndexOf(",") != entry.getValue().length() - 1) continue;
                    entry.setValue(entry.getValue().substring(0, entry.getValue().length() - 1));
                }
                if (!CollectionUtils.isEmpty(allWorkNodeIdSet)) {
                    PerfPlanExecuteUtils.processNodeNameMap(allWorkNodeIdSet, workNodeNameMap, ctx);
                }
            }
            FilterInfo userFilterAll = new FilterInfo();
            userFilterAll.getFilterItems().add(new FilterItemInfo("person", allHandlerIdSet, CompareType.INCLUDE));
            userFilterAll.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0, CompareType.EQUALS));
            EntityViewInfo userEvi = new EntityViewInfo();
            SelectorItemCollection userSic = new SelectorItemCollection();
            userSic.add(new SelectorItemInfo("id"));
            userSic.add(new SelectorItemInfo("person.id"));
            userSic.add(new SelectorItemInfo("person.name"));
            userEvi.setSelector(userSic);
            userEvi.setFilter(userFilterAll);
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            UserCollection userColl = iUser.getUserCollection(userEvi);
            if (null != userColl && userColl.size() > 0) {
                int usize = userColl.size();
                HashMap<String, PersonInfo> umap = new HashMap<String, PersonInfo>();
                for (int i = 0; i < usize; ++i) {
                    UserInfo userInfo = userColl.get(i);
                    if (userInfo == null || userInfo.getPerson() == null) continue;
                    PersonInfo personInfo = userInfo.getPerson();
                    umap.put(personInfo.getId().toString(), personInfo);
                }
                Set<Map.Entry<String, Set<String>>> evaObjHandlerMapEntries = evaObjHandlerMap.entrySet();
                for (Map.Entry<String, Set<String>> entry : evaObjHandlerMapEntries) {
                    String key = entry.getKey();
                    Set<String> value = entry.getValue();
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)key) || CollectionUtils.isEmpty(value)) continue;
                    StringBuilder sb = new StringBuilder();
                    HashSet<String> waitDeleteIds = new HashSet<String>();
                    for (String pid : value) {
                        PersonInfo personInfo = (PersonInfo)umap.get(pid);
                        if (personInfo == null) {
                            waitDeleteIds.add(pid);
                            continue;
                        }
                        if (StringUtil.isEmpty((String)personInfo.getName(ctx.getLocale()))) continue;
                        sb.append(personInfo.getName()).append(",");
                    }
                    if (!CollectionUtils.isEmpty(waitDeleteIds)) {
                        value.removeAll(waitDeleteIds);
                    }
                    if (sb.length() <= 0) continue;
                    resultMap.put(key, sb.toString());
                }
                for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue())) || !((String)entry.getValue()).endsWith(",")) continue;
                    entry.setValue(((String)entry.getValue()).substring(0, ((String)entry.getValue()).length() - 1));
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
    }

    private static void processNodeNameMap(Set<String> allWorkNodeIdSet, Map<String, Set<String>> workNodeNameMap, Context ctx) throws BOSException {
        FilterInfo nodeFilter = new FilterInfo();
        nodeFilter.getFilterItems().add(new FilterItemInfo("id", allWorkNodeIdSet, CompareType.INCLUDE));
        EntityViewInfo nodeEvi = new EntityViewInfo();
        SelectorItemCollection nodeSelector = new SelectorItemCollection();
        nodeSelector.add(new SelectorItemInfo("id"));
        nodeSelector.add(new SelectorItemInfo("nodeName"));
        nodeEvi.setFilter(nodeFilter);
        nodeEvi.setSelector(nodeSelector);
        WFNodeDefCollection nodeCollection = WFNodeDefFactory.getLocalInstance((Context)ctx).getWFNodeDefCollection(nodeEvi);
        HashMap<String, String> nodeNameMap = new HashMap<String, String>();
        int size = nodeCollection.size();
        for (int index = 0; index < size; ++index) {
            WFNodeDefInfo info = nodeCollection.get(index);
            nodeNameMap.put(info.getId().toString(), info.getNodeName());
        }
        for (Map.Entry<String, Set<String>> entry : workNodeNameMap.entrySet()) {
            Set<String> nodeIdSet = entry.getValue();
            HashSet newSet = new HashSet();
            for (String nodeId : nodeIdSet) {
                if (!nodeNameMap.containsKey(nodeId)) continue;
                newSet.add(nodeNameMap.get(nodeId));
            }
            if (CollectionUtils.isEmpty(newSet)) continue;
            entry.setValue(newSet);
        }
    }

    public static Map<String, BigDecimal> calcEvaObjTargetWeight(CoreBaseCollection indicators) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (indicators == null) {
            return null;
        }
        for (CoreBaseInfo coreBaseInfo : indicators) {
            EvaluFormAreaBaseInfo areaBaseInfo = new EvaluFormAreaBaseInfo();
            PerformanceRuleInfo ruleInfo = null;
            String tarScore = null;
            String weights = null;
            PerfEvaObjectInfo evaObjectInfo = null;
            if (coreBaseInfo instanceof RecordTargetInfo) {
                RecordTargetInfo recordTargetInfo = (RecordTargetInfo)coreBaseInfo;
                areaBaseInfo = recordTargetInfo.getAreaBase();
                ruleInfo = recordTargetInfo.getPerfRule();
                tarScore = recordTargetInfo.getTarScore();
                weights = recordTargetInfo.getWeight();
                evaObjectInfo = recordTargetInfo.getEvaObj();
            } else if (coreBaseInfo instanceof IndicatorTargetInfo) {
                IndicatorTargetInfo indiTargetInfo = (IndicatorTargetInfo)coreBaseInfo;
                areaBaseInfo = indiTargetInfo.getAreaBase();
                ruleInfo = indiTargetInfo.getPerfRule();
                tarScore = indiTargetInfo.getTarScore();
                weights = indiTargetInfo.getWeight();
                evaObjectInfo = indiTargetInfo.getEvaObj();
            }
            if (SubAreaTypeEnum.ADDSUB.equals((Object)areaBaseInfo.getSubAreaType())) continue;
            if (evaObjectInfo == null) {
                logger.error("evaObjectInfo found null for calcEvaObjTargetWeight, targetId is : " + coreBaseInfo.get("id").toString());
                continue;
            }
            if (areaBaseInfo == null) {
                logger.error("areaBaseInfo found null for calcEvaObjTargetWeight, targetId is : " + coreBaseInfo.get("id").toString());
                continue;
            }
            if (ruleInfo == null) {
                logger.error("ruleInfo found null for calcEvaObjTargetWeight, targetId is : " + coreBaseInfo.get("id").toString());
                continue;
            }
            String evaObjId = evaObjectInfo.getId().toString();
            BigDecimal weight = (BigDecimal)map.get(evaObjId);
            if (weight == null) {
                weight = BigDecimal.ZERO;
            }
            boolean sumScoreRuleFlag = SumScoreRuleEnum.PARTICIPATEANDAS.equals((Object)areaBaseInfo.getSumScoreRule()) || SumScoreRuleEnum.NOPARTICIPATEANDAS.equals((Object)areaBaseInfo.getSumScoreRule());
            String targetWeight = ScoringWayEnum.TARGETSCORE.equals((Object)ruleInfo.getScoringWay()) ? tarScore : weights;
            if (!StringUtils.isEmpty((String)targetWeight) && !sumScoreRuleFlag) {
                weight = weight.add(new BigDecimal(targetWeight));
            }
            map.put(evaObjId, weight);
        }
        return map;
    }
}

