/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebMultiOrgResource;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class SHRPerfWebResourceUtil {
    private static final String MISS_RES = "Missing Resource";
    public static final String DEFAULTRESOURCEPATH = "com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource";
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil");
    public static final Pattern PATTERN_MSG_FORMAT = Pattern.compile("\\{\\d+\\}");
    public static final String SIGN_UNDERLINE = "_";

    public static String getRes(SHRPerfWebResource resName, Context ctx) {
        return SHRPerfWebResourceUtil.getRes(DEFAULTRESOURCEPATH, resName.name(), ctx, (Object[])null);
    }

    public static String getRes(SHRPerfWebMultiOrgResource resName, Context ctx) {
        return SHRPerfWebResourceUtil.getRes(DEFAULTRESOURCEPATH, resName.name(), ctx, (Object[])null);
    }

    public static String getRes(SHRPerfWebResource resName, Context ctx, Object[] params) {
        return SHRPerfWebResourceUtil.getRes(DEFAULTRESOURCEPATH, resName.name(), ctx, params);
    }

    public static String getRes(String resName, Context ctx) {
        return SHRPerfWebResourceUtil.getRes(DEFAULTRESOURCEPATH, resName, ctx, (Object[])null);
    }

    public static String getRes(String resName, Context ctx, Object[] params) {
        return SHRPerfWebResourceUtil.getRes(DEFAULTRESOURCEPATH, resName, ctx, params);
    }

    public static String getRes(String resClassName, String resName, Context ctx) {
        return SHRPerfWebResourceUtil.getRes(resClassName, resName, ctx, (Object[])null);
    }

    public static String getRes(String resClassName, String resName, Context ctx, Object[] params) {
        String res = EASResource.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
        if (res == null || MISS_RES.equalsIgnoreCase(res.trim())) {
            return "";
        }
        int formateCount = 0;
        Matcher matcher = PATTERN_MSG_FORMAT.matcher(res);
        while (matcher.find()) {
            ++formateCount;
        }
        if (formateCount > 0 && (params == null || params.length < formateCount)) {
            ArrayList<Object> paramList = new ArrayList<Object>(formateCount);
            for (int i = 0; i < formateCount; ++i) {
                paramList.add(params == null || params.length < i + 1 || params[i] == null ? "" : params[i]);
            }
            params = paramList.toArray();
        }
        return formateCount == 0 ? res : MessageFormat.format(res, params);
    }

    public static String getRes(SHRPerfWebResource resName, Locale locale) {
        return SHRPerfWebResourceUtil.getRes(DEFAULTRESOURCEPATH, resName.name(), locale, (Object[])null);
    }

    public static String getRes(SHRPerfWebResource resName, Locale locale, Object[] params) {
        return SHRPerfWebResourceUtil.getRes(DEFAULTRESOURCEPATH, resName.name(), locale, params);
    }

    public static String getRes(String resName, Locale locale) {
        return SHRPerfWebResourceUtil.getRes(DEFAULTRESOURCEPATH, resName, locale, (Object[])null);
    }

    public static String getRes(String resName, Locale locale, Object[] params) {
        return SHRPerfWebResourceUtil.getRes(DEFAULTRESOURCEPATH, resName, locale, params);
    }

    public static String getRes(String resClassName, String resName, Locale locale) {
        return SHRPerfWebResourceUtil.getRes(resClassName, resName, locale, (Object[])null);
    }

    public static String getRes(String resClassName, String resName, Locale locale, Object[] params) {
        String res = EASResource.getString((String)resClassName, (String)resName, (Locale)locale);
        if (res == null || MISS_RES.equalsIgnoreCase(res.trim())) {
            return "";
        }
        int formateCount = 0;
        Matcher matcher = PATTERN_MSG_FORMAT.matcher(res);
        while (matcher.find()) {
            ++formateCount;
        }
        if (formateCount > 0 && (params == null || params.length < formateCount)) {
            ArrayList<Object> paramList = new ArrayList<Object>(formateCount);
            for (int i = 0; i < formateCount; ++i) {
                paramList.add(params == null || params.length < i + 1 || params[i] == null ? "" : params[i]);
            }
            params = paramList.toArray();
        }
        return formateCount == 0 ? res : MessageFormat.format(res, params);
    }

    public static String getMlFlag(Context ctx) {
        Locale locale;
        Locale locale2 = locale = ctx == null ? null : ctx.getLocale();
        if (locale == null) {
            locale = LocaleUtils.getDefaultLocale();
        }
        return SIGN_UNDERLINE + LocaleUtils.getShortCode((Locale)locale);
    }

    public static String getMlFlag(Locale local) {
        return SIGN_UNDERLINE + LocaleUtils.getShortCode((Locale)local);
    }

    public static void setMultiLanValue(Context ctx, CoreBaseInfo model, String fieldName) {
        if (BOSConfigUtil.isEnableMultiLan()) {
            HashMap<String, String> multiLan = new HashMap<String, String>();
            if (null == model.get(fieldName, LocaleUtils.locale_l1) || "null".equalsIgnoreCase((String)model.get(fieldName, LocaleUtils.locale_l1))) {
                multiLan.put(LocaleUtils.locale_l1.getDisplayName(), "");
            } else {
                multiLan.put(LocaleUtils.locale_l1.getDisplayName(), (String)model.get(fieldName, LocaleUtils.locale_l1));
            }
            if (null == model.get(fieldName, LocaleUtils.locale_l2) || "null".equalsIgnoreCase((String)model.get(fieldName, LocaleUtils.locale_l2))) {
                multiLan.put(LocaleUtils.locale_l2.getDisplayName(), "");
            } else {
                multiLan.put(LocaleUtils.locale_l2.getDisplayName(), (String)model.get(fieldName, LocaleUtils.locale_l2));
            }
            if (null == model.get(fieldName, LocaleUtils.locale_l3) || "null".equalsIgnoreCase((String)model.get(fieldName, LocaleUtils.locale_l3))) {
                multiLan.put(LocaleUtils.locale_l3.getDisplayName(), "");
            } else {
                multiLan.put(LocaleUtils.locale_l3.getDisplayName(), (String)model.get(fieldName, LocaleUtils.locale_l3));
            }
            try {
                model.put(fieldName, (Object)JSONUtils.convertObjectToJson((Context)ctx, multiLan));
            }
            catch (ORMCoreException e) {
                logger.error("ORMCoreException: ", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
        }
    }

    public static void setMultiLanField(Context ctx, CoreBaseInfo model, String fieldName, String defaultValue) {
        if (null == model.get(fieldName, LocaleUtils.locale_l1) || "null".equalsIgnoreCase((String)model.get(fieldName, LocaleUtils.locale_l1)) || LocaleUtils.locale_l1.equals(ctx.getLocale())) {
            model.put(fieldName + SIGN_UNDERLINE + LocaleUtils.locale_l1.getDisplayName(), (Object)defaultValue);
        }
        if (null == model.get(fieldName, LocaleUtils.locale_l2) || "null".equalsIgnoreCase((String)model.get(fieldName, LocaleUtils.locale_l2)) || LocaleUtils.locale_l2.equals(ctx.getLocale())) {
            model.put(fieldName + SIGN_UNDERLINE + LocaleUtils.locale_l2.getDisplayName(), (Object)defaultValue);
        }
        if (null == model.get(fieldName, LocaleUtils.locale_l3) || "null".equalsIgnoreCase((String)model.get(fieldName, LocaleUtils.locale_l3)) || LocaleUtils.locale_l3.equals(ctx.getLocale())) {
            model.put(fieldName + SIGN_UNDERLINE + LocaleUtils.locale_l3.getDisplayName(), (Object)defaultValue);
        }
    }

    public static void copyMultiLanValue(CoreBaseInfo source, CoreBaseInfo target, Set<String> fieldNameSet) {
        if (CollectionUtils.isEmpty(fieldNameSet) || source == null || target == null) {
            return;
        }
        for (String fieldName : fieldNameSet) {
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            try {
                target.put(fieldName, source.get(fieldName, LocaleUtils.locale_L1), LocaleUtils.locale_L1);
                target.put(fieldName, source.get(fieldName, LocaleUtils.locale_L2), LocaleUtils.locale_L2);
                target.put(fieldName, source.get(fieldName, LocaleUtils.locale_L3), LocaleUtils.locale_L3);
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
        }
    }

    public static void copyMultiLanValue(CoreBaseInfo target, Set<String> fieldNameSet, Locale locale) {
        if (CollectionUtils.isEmpty(fieldNameSet)) {
            return;
        }
        for (String fieldName : fieldNameSet) {
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            try {
                if (locale != null) {
                    target.put(fieldName, target.get(fieldName, locale), LocaleUtils.locale_L1);
                    target.put(fieldName, target.get(fieldName, locale), LocaleUtils.locale_L2);
                    target.put(fieldName, target.get(fieldName, locale), LocaleUtils.locale_L3);
                    continue;
                }
                target.put(fieldName, target.get(fieldName), LocaleUtils.locale_L1);
                target.put(fieldName, target.get(fieldName), LocaleUtils.locale_L2);
                target.put(fieldName, target.get(fieldName), LocaleUtils.locale_L3);
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
        }
    }

    public static void copyMultiLanValue(CoreBaseInfo source, CoreBaseInfo target, Set<String> fieldNameSet, Map<String, String> mappers) {
        if (CollectionUtils.isEmpty(mappers)) {
            SHRPerfWebResourceUtil.copyMultiLanValue(source, target, fieldNameSet);
        }
        if (CollectionUtils.isEmpty(fieldNameSet) || source == null || target == null) {
            return;
        }
        for (String fieldName : fieldNameSet) {
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            try {
                String mapperKey = mappers.get(fieldName);
                if (StringUtils.isBlank((CharSequence)mapperKey)) {
                    mapperKey = fieldName;
                }
                target.put(mapperKey, source.get(fieldName, LocaleUtils.locale_L1), LocaleUtils.locale_L1);
                target.put(mapperKey, source.get(fieldName, LocaleUtils.locale_L2), LocaleUtils.locale_L2);
                target.put(mapperKey, source.get(fieldName, LocaleUtils.locale_L3), LocaleUtils.locale_L3);
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
        }
    }

    public static Map<String, Map<String, String>> copyMultiLanValue(CoreBaseInfo source, Set<String> fieldNameSet) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (CollectionUtils.isEmpty(fieldNameSet) || source == null) {
            return result;
        }
        for (String fieldName : fieldNameSet) {
            HashMap<String, String> innerMap = new HashMap<String, String>();
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            try {
                Object f1 = source.get(fieldName, LocaleUtils.locale_L1);
                if (f1 != null) {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l1), f1.toString());
                } else {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l1), "");
                }
                Object f2 = source.get(fieldName, LocaleUtils.locale_L2);
                if (f2 != null) {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l2), f2.toString());
                } else {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l2), "");
                }
                Object f3 = source.get(fieldName, LocaleUtils.locale_L3);
                if (f3 != null) {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l3), f3.toString());
                } else {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l3), "");
                }
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
            result.put(fieldName, innerMap);
        }
        return result;
    }

    public static void copyMultiLanValue(Map<String, Map<String, String>> source, CoreBaseInfo target, Map<String, String> mappers) {
        if (CollectionUtils.isEmpty(source) || target == null) {
            return;
        }
        Set<Map.Entry<String, Map<String, String>>> entries = source.entrySet();
        for (Map.Entry<String, Map<String, String>> entry : entries) {
            String s;
            String key = entry.getKey();
            Map<String, String> value = entry.getValue();
            if (StringUtils.isBlank((CharSequence)key)) continue;
            String mapperKey = key;
            if (!CollectionUtils.isEmpty(mappers) && StringUtils.isNotBlank((CharSequence)(s = mappers.get(key)))) {
                mapperKey = s;
            }
            if (value == null) continue;
            target.put(mapperKey, (Object)value.get(key + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l1)), LocaleUtils.locale_L1);
            target.put(mapperKey, (Object)value.get(key + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l2)), LocaleUtils.locale_L2);
            target.put(mapperKey, (Object)value.get(key + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l3)), LocaleUtils.locale_L3);
        }
    }

    public static Map<String, Map<String, String>> copyMultiLanValue(HashMap<String, String> source, Set<String> fieldNameSet) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (CollectionUtils.isEmpty(fieldNameSet) || source == null) {
            return result;
        }
        for (String fieldName : fieldNameSet) {
            HashMap<String, String> innerMap = new HashMap<String, String>();
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            try {
                String f1 = source.get(fieldName);
                if (f1 != null) {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l1), f1.toString());
                } else {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l1), "");
                }
                String f2 = source.get(fieldName);
                if (f2 != null) {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l2), f2.toString());
                } else {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l2), "");
                }
                String f3 = source.get(fieldName);
                if (f3 != null) {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l3), f3.toString());
                } else {
                    innerMap.put(fieldName + SHRPerfWebResourceUtil.getMlFlag(LocaleUtils.locale_l3), "");
                }
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
            result.put(fieldName, innerMap);
        }
        return result;
    }
}

