/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.IAssignRead;
import com.kingdee.eas.base.message.util.JSONUtil;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendUrgerMessageWebUtil {
    private static Logger logger = LoggerFactory.getLogger((String)SendUrgerMessageWebUtil.class.getName());
    public static final String MCRESOURCES = "com.kingdee.eas.cp.eip.mc.MessageCenter";
    public static final String EASPORTAL_PATH = "/easportal";
    public static final String EASWEB_PATH = "/easweb";
    private static String FAILURE = "failure";
    private static String SUCCESS = "success";
    private static String LOG = "log";
    private static Locale L1 = new Locale("L1");
    private static Locale L2 = new Locale("L2");
    private static Locale L3 = new Locale("L3");

    public static Map<String, String> sendUrgentMessageByBizObjId(Context ctx, String msgType, String bizObjId) {
        Map<String, String> result = new HashMap<String, String>();
        String sendFailed = ResourceBase.getString((String)MCRESOURCES, (String)"sendFailed", (Locale)ctx.getLocale());
        result.put("result", "500");
        result.put("msg", sendFailed);
        if (StringUtils.isEmpty((String)bizObjId)) {
            return result;
        }
        if (StringUtils.isEmpty((String)msgType)) {
            msgType = "msg";
        }
        String sql = "select  a.FASSIGNID FASSIGNID,a.FACTINSTID FACTINSTID,a.FPRIORITY FPRIORITY,a.FPROCINSTID FPROCINSTID,b.FID as USERID from t_wfr_assign a inner join t_pm_user b on a.FPERSONEMPID = b.FPERSONID where a.FBIZOBJID = '" + bizObjId + "'";
        try {
            String actInstId = "";
            ArrayList<String> receivers = new ArrayList<String>();
            String priority = "";
            String procInstId = "";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)procInstId)) {
                    procInstId = rowSet.getString("FPROCINSTID");
                }
                if (StringUtils.isEmpty((String)priority)) {
                    priority = rowSet.getString("FPRIORITY");
                }
                if (StringUtils.isEmpty((String)actInstId)) {
                    actInstId = rowSet.getString("FACTINSTID");
                }
                receivers.add(rowSet.getString("USERID"));
            }
            if (!StringUtils.isEmpty((String)procInstId)) {
                Map<String, String> messageObj = SendUrgerMessageWebUtil.getSendUrgentMessageByProcInstId(ctx, procInstId);
                HashMap<String, String> title = new HashMap<String, String>();
                HashMap<String, String> content = new HashMap<String, String>();
                title.put("l1", messageObj.get("subject_l1"));
                title.put("l2", messageObj.get("subject_l2"));
                title.put("l3", messageObj.get("subject_l3"));
                title.put("default", messageObj.get("subject"));
                content.put("l1", messageObj.get("content_l1"));
                content.put("l2", messageObj.get("content_l2"));
                content.put("l3", messageObj.get("content_l3"));
                content.put("default", messageObj.get("content"));
                result = SendUrgerMessageWebUtil.doSendUrgentMessage(ctx, msgType, actInstId, org.apache.commons.lang3.StringUtils.join(receivers, (String)";"), title, content, priority);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Map<String, String> doSendUrgentMessage(Context ctx, String msgType, String actInstId, String receivers, Map<String, String> title, Map<String, String> body, String priority) {
        HashMap<String, String> result = new HashMap<String, String>();
        String sendSuccess = ResourceBase.getString((String)MCRESOURCES, (String)"sendSuccess", (Locale)ctx.getLocale());
        String sendFailed = ResourceBase.getString((String)MCRESOURCES, (String)"sendFailed", (Locale)ctx.getLocale());
        result.put("result", "200");
        result.put("msg", sendSuccess);
        try {
            actInstId = URLDecoder.decode(actInstId, "utf-8");
            receivers = URLDecoder.decode(receivers, "utf-8");
            for (String key : title.keySet()) {
                title.put(key, URLDecoder.decode(title.get(key), "utf-8"));
            }
            for (String key : body.keySet()) {
                body.put(key, URLDecoder.decode(title.get(key), "utf-8"));
            }
        }
        catch (UnsupportedEncodingException var15) {
            logger.error(var15.getMessage(), (Throwable)var15);
            result.put("result", "500");
            result.put("msg", sendFailed);
            return result;
        }
        try {
            Map<String, Object> stringObjectMap;
            if (msgType.equals("msg")) {
                boolean success = SendUrgerMessageWebUtil.sendUrgentMsg(ctx, actInstId, receivers, title, body);
                if (!success) {
                    result.put("result", "500");
                    result.put("msg", sendFailed);
                    return result;
                }
            } else if (msgType.equals("mobile")) {
                stringObjectMap = SendUrgerMessageWebUtil.sendUrgentMobile(ctx, actInstId, receivers, body.get("default"), priority);
                if (!"1".equals(stringObjectMap.get(SUCCESS))) {
                    result.put("result", "500");
                    result.put("msg", sendFailed);
                    return result;
                }
            } else if (msgType.equals("mail") && !"1".equals((stringObjectMap = SendUrgerMessageWebUtil.sendUrgentMail(ctx, actInstId, receivers, title.get("default"), body.get("default"))).get(SUCCESS))) {
                result.put("result", "500");
                result.put("msg", sendFailed);
                return result;
            }
        }
        catch (Exception var14) {
            result.put("result", "500");
            result.put("msg", sendFailed);
        }
        return result;
    }

    public static boolean sendUrgentMsg(Context ctx, String actInstId, String receiver, Map<String, String> title, Map<String, String> content) throws BOSException, EASBizException {
        boolean result = false;
        if (!StringUtils.isEmpty((String)actInstId) && !StringUtils.isEmpty((String)receiver)) {
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
            AssignmentInfo[] assignArray = service.getAssignmentByActInstId(actInstId, WfAssignmentState.ASSIGNED);
            List receiverList = Arrays.asList((Object[])receiver.split(";"));
            ArrayList<Message> messageList = new ArrayList<Message>();
            for (int i = 0; i < assignArray.length; ++i) {
                String userId = assignArray[i].getUserId();
                if (!receiverList.contains(userId)) continue;
                messageList.add(SendUrgerMessageWebUtil.createDefaultUrgentMessage(ctx, assignArray[i], title, content));
            }
            result = ProcessCenterUtil.sendUrgentMessage(messageList, (Context)ctx);
            return result;
        }
        return result;
    }

    public static Map<String, Object> sendUrgentMobile(Context ctx, String actInstId, String employeeIds, String content, String priority) throws BaseException {
        String assignIds = SendUrgerMessageWebUtil.getUrgentAssignIdsByActInstIdAndOwners(ctx, actInstId, employeeIds);
        Map<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(SUCCESS, "0");
        resultMap.put(FAILURE, "0");
        resultMap.put(LOG, "");
        String returnLog = "";
        String sendSuccess = ResourceBase.getString((String)MCRESOURCES, (String)"sendSuccess", (Locale)ctx.getLocale());
        String sendFailed = ResourceBase.getString((String)MCRESOURCES, (String)"sendFailed", (Locale)ctx.getLocale());
        if (StringUtils.isEmpty((String)assignIds)) {
            logger.error("sendUrgentMobile:assignIds are null");
            resultMap.put(LOG, sendFailed);
            return resultMap;
        }
        if (assignIds.indexOf(";") < 0) {
            boolean success = false;
            success = ProcessCenterUtil.sendUrgentMobile((String)assignIds, (String)content, (String)priority, (Context)ctx);
            if (success) {
                resultMap.put(SUCCESS, "1");
                resultMap.put(LOG, sendSuccess);
                return resultMap;
            }
            resultMap.put(FAILURE, "1");
            resultMap.put(LOG, sendFailed);
            return resultMap;
        }
        Object[] assignIdArray = assignIds.split(";");
        new ArrayList();
        List assignIdList = Arrays.asList((Object[])assignIdArray);
        resultMap = ProcessCenterUtil.sendUrgentMobile((List)assignIdList, (String)content, (String)priority, (Context)ctx);
        return resultMap;
    }

    public static Map<String, Object> sendUrgentMail(Context ctx, String actInstId, String employeeIds, String title, String content) throws BaseException {
        String assignIds = SendUrgerMessageWebUtil.getUrgentAssignIdsByActInstIdAndOwners(ctx, actInstId, employeeIds);
        String returnLog = "";
        String sendSuccess = ResourceBase.getString((String)MCRESOURCES, (String)"sendSuccess", (Locale)ctx.getLocale());
        String sendFailed = ResourceBase.getString((String)MCRESOURCES, (String)"sendFailed", (Locale)ctx.getLocale());
        HashMap<String, Object> resultMap = new HashMap<String, String>();
        HashMap<String, Object> failMap = new HashMap<String, Object>();
        failMap.put(SUCCESS, "0");
        failMap.put(FAILURE, "0");
        failMap.put(LOG, sendFailed);
        if (StringUtils.isEmpty((String)assignIds)) {
            logger.error("sendUrgentMail:assignIds are null");
            return failMap;
        }
        if (assignIds.indexOf(";") < 0) {
            boolean success = false;
            success = ProcessCenterUtil.sendUrgentMail((String)assignIds, (String)title, (String)content, (Context)ctx);
            if (success) {
                resultMap.put(SUCCESS, "1");
                resultMap.put(FAILURE, "0");
                resultMap.put(LOG, sendSuccess);
                return resultMap;
            }
            resultMap.put(SUCCESS, "0");
            resultMap.put(FAILURE, "1");
            resultMap.put(LOG, sendFailed);
            return resultMap;
        }
        Object[] assignIdArray = assignIds.split(";");
        new ArrayList();
        List assignIdList = Arrays.asList((Object[])assignIdArray);
        resultMap = ProcessCenterUtil.sendUrgentMail((List)assignIdList, (String)title, (String)content, (Context)ctx);
        return resultMap;
    }

    private static String getUrgentAssignIdsByActInstIdAndOwners(Context ctx, String actInstId, String employeeIds) throws BaseException {
        StringBuffer buffer = new StringBuffer();
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        AssignmentInfo[] assignArray = service.getAssignmentByActInstId(actInstId, WfAssignmentState.ASSIGNED);
        List receiverList = Arrays.asList((Object[])employeeIds.split(";"));
        new ArrayList();
        for (int i = 0; i < assignArray.length; ++i) {
            String employeeId = assignArray[i].getEmployeeId();
            if (!receiverList.contains(employeeId)) continue;
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(assignArray[i].getAssignmentId());
        }
        return buffer.toString();
    }

    public static Message createDefaultUrgentMessage(Context ctx, AssignmentInfo assignInfo, Map<String, String> title, Map<String, String> body) {
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        String urgencyStr_l1 = ResourceBase.getString((String)MCRESOURCES, (String)"urgency", (Locale)L1) + ":";
        String urgencyStr_l2 = ResourceBase.getString((String)MCRESOURCES, (String)"urgency", (Locale)L2) + ":";
        String urgencyStr_l3 = ResourceBase.getString((String)MCRESOURCES, (String)"urgency", (Locale)L3) + ":";
        String title_l1 = urgencyStr_l1 + title.get("l1");
        String title_l2 = urgencyStr_l2 + title.get("l2");
        String title_l3 = urgencyStr_l3 + title.get("l3");
        String body_l1 = urgencyStr_l1 + body.get("l1");
        String body_l2 = urgencyStr_l2 + body.get("l2");
        String body_l3 = urgencyStr_l3 + body.get("l3");
        message.setLocaleStringHeader("title", title_l1, L1);
        message.setLocaleStringHeader("title", title_l2, L2);
        message.setLocaleStringHeader("title", title_l3, L3);
        message.setLocaleStringHeader("body", body_l1, L1);
        message.setLocaleStringHeader("body", body_l2, L2);
        message.setLocaleStringHeader("body", body_l3, L3);
        String userName_l1 = "";
        String userName_l2 = "";
        String userName_l3 = "";
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            Person person = svc.getPersonByUserID(ctx.getCaller().toString());
            userName_l1 = person.getUserName(L1);
            userName_l2 = person.getUserName(L2);
            userName_l3 = person.getUserName(L3);
        }
        catch (Exception var12) {
            logger.error(var12.getMessage(), (Throwable)var12);
        }
        message.setLocaleStringHeader("sender", userName_l1, L1);
        message.setLocaleStringHeader("sender", userName_l2, L2);
        message.setLocaleStringHeader("sender", userName_l3, L3);
        message.setStringHeader("receiver", assignInfo.getUserId());
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 40);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("sourceID", assignInfo.getAssignmentId());
        try {
            IAssignRead iAssignRead = AssignReadFactory.getLocalInstance((Context)ctx);
            AssignReadInfo assignReadInfo = iAssignRead.getAssignReadInfo("where assignID = '" + assignInfo.getAssignmentId() + "'");
            if (assignReadInfo.isIsWebSupport()) {
                message.setStringHeader("webSupport", "true");
            } else {
                message.setStringHeader("webSupport", "false");
            }
        }
        catch (Exception var11) {
            logger.error(var11.getMessage(), (Throwable)var11);
        }
        return message;
    }

    public static Map<String, String> getSendUrgentMessageByProcInstId(Context ctx, String procInstId) {
        HashMap<String, String> result = new HashMap<String, String>();
        String jsonStr = "";
        try {
            new ArrayList();
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
            List list = ProcessCenterUtil.getUrgentAssignIdByProcInstId((String)procInstId, (Context)ctx);
            HashMap map = new HashMap();
            IUser userService = UserFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < list.size(); ++i) {
                String content;
                String subject;
                HashMap<String, Object> actInstMap = new HashMap<String, Object>();
                List<HashMap<String, String>> userList = new ArrayList();
                List employeeList = new ArrayList();
                ArrayList<String> filterEmployeeList = new ArrayList<String>();
                String id = list.get(i).toString();
                AssignmentInfo assignInfo = service.getAssignmentById(id);
                if (map.containsKey(assignInfo.getActInstId()) && assignInfo.getActInstId() != null) {
                    Map oldactInstMap = (Map)map.get(assignInfo.getActInstId());
                    if (oldactInstMap.get("employeeArray") != null) {
                        employeeList = (List)oldactInstMap.get("employeeArray");
                    }
                    if (oldactInstMap.get("userArray") != null) {
                        userList = (List)oldactInstMap.get("userArray");
                    }
                }
                HashMap<String, String> userMap = new HashMap<String, String>();
                userMap.put("id", assignInfo.getUserId());
                String name = "";
                try {
                    UserInfo userInfo = userService.getUserByID((IObjectPK)new ObjectStringPK(assignInfo.getUserId()));
                    name = userInfo.getNumber() + "(" + userInfo.getName(ctx.getLocale()) + ")";
                }
                catch (EASBizException var17) {
                    logger.error(var17.getMessage(), (Throwable)var17);
                }
                userMap.put("name", StringUtils.isEmpty((String)name) ? assignInfo.getUserName(ctx.getLocale()) : name);
                HashMap<String, String> employeeMap = new HashMap<String, String>();
                userList.add(userMap);
                if (!filterEmployeeList.contains(assignInfo.getEmployeeId())) {
                    employeeMap.put("id", assignInfo.getEmployeeId());
                    employeeMap.put("name", assignInfo.getEmployeeName(ctx.getLocale()) != null ? assignInfo.getEmployeeName(ctx.getLocale()) : "unNamed");
                    employeeList.add(employeeMap);
                    filterEmployeeList.add(assignInfo.getEmployeeId());
                }
                String string = subject = assignInfo.getSubject(ctx.getLocale()) != null ? assignInfo.getSubject(ctx.getLocale()) : "";
                if (StringUtils.isEmpty((String)((String)result.get("subject")))) {
                    String subject_l1 = assignInfo.getSubject(Locale.ENGLISH) != null ? assignInfo.getSubject(Locale.ENGLISH) : "";
                    String subject_l2 = assignInfo.getSubject(Locale.CHINA) != null ? assignInfo.getSubject(Locale.CHINA) : "";
                    String subject_l3 = assignInfo.getSubject(Locale.TAIWAN) != null ? assignInfo.getSubject(Locale.TAIWAN) : "";
                    result.put("subject", subject);
                    result.put("subject_l1", subject_l1);
                    result.put("subject_l2", subject_l2);
                    result.put("subject_l3", subject_l3);
                }
                String string2 = content = assignInfo.getBody(ctx.getLocale()) != null ? assignInfo.getBody(ctx.getLocale()) : "";
                if (StringUtils.isEmpty((String)((String)result.get("content")))) {
                    String content_l1 = assignInfo.getBody(Locale.ENGLISH) != null ? assignInfo.getBody(Locale.ENGLISH) : "";
                    String content_l2 = assignInfo.getBody(Locale.CHINA) != null ? assignInfo.getBody(Locale.CHINA) : "";
                    String content_l3 = assignInfo.getBody(Locale.TAIWAN) != null ? assignInfo.getBody(Locale.TAIWAN) : "";
                    result.put("content", content);
                    result.put("content_l1", content_l1);
                    result.put("content_l2", content_l2);
                    result.put("content_l3", content_l3);
                }
                actInstMap.put("subject", subject);
                actInstMap.put("content", content);
                if (userList.size() <= 0 || employeeList.size() <= 0) continue;
                actInstMap.put("userArray", userList);
                actInstMap.put("employeeArray", employeeList);
                actInstMap.put("actDefName", assignInfo.getAssignInfo().get("actdefname_" + ctx.getLocale().toString()));
                actInstMap.put("actInstId", assignInfo.getActInstId());
                map.put(assignInfo.getActInstId(), actInstMap);
            }
            jsonStr = JSONUtil.getJson4Object(map, (String[])null);
            result.put("data", jsonStr);
        }
        catch (BOSException var18) {
            logger.error(var18.getMessage(), (Throwable)var18);
        }
        return result;
    }
}

