/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfPeriod;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfPlan;
import com.kingdee.shr.perfweb.app.base.evalplan.IUniteIndicator;
import com.kingdee.shr.perfweb.app.base.evalplan.IUniteIndicatorMemory;
import com.kingdee.shr.perfweb.app.base.evalplan.IUniteRecord;
import com.kingdee.shr.perfweb.app.base.evalplan.IUniteRecordMemory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteIndicatorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteIndicatorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteIndicatorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteIndicatorMemoryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteIndicatorMemoryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteRecordCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteRecordFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteRecordInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteRecordMemoryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteRecordMemoryInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaluFormAreaBase;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.util.ServerResponseConst;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitedIndicatorUtils {
    private static Logger logger = LoggerFactory.getLogger(UnitedIndicatorUtils.class);

    public static String detectUnitedAreaIndicatorWeight(Context ctx, String period, String groupId) {
        LinkedList<String> keyList = new LinkedList<String>();
        ArrayList list = new ArrayList();
        BigDecimal totalWeight = BigDecimal.ZERO;
        BigDecimal controlWeight = BigDecimal.ZERO;
        BigDecimal unControlWeight = BigDecimal.ZERO;
        PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByPeriodId(ctx, period);
        int scoringWay = ruleInfo.getScoringWay().getValue();
        EvaluFormAreaBaseCollection evaAreaBaseColl = new UnitedIndicatorUtils().getEvaluFormAreaBaseColl(ctx, period);
        if (evaAreaBaseColl != null && evaAreaBaseColl.size() > 0) {
            for (int i = 0; i < evaAreaBaseColl.size(); ++i) {
                boolean unExtraFlag;
                EvaluFormAreaBaseInfo evaAreaBaseInfo = evaAreaBaseColl.get(i);
                String fid = evaAreaBaseInfo.getId().toString();
                String weightControl = String.valueOf(evaAreaBaseInfo.getWeightControl().getValue());
                String areaWeight = evaAreaBaseInfo.getAreaWeight();
                String name = evaAreaBaseInfo.getName();
                String areaType = evaAreaBaseInfo.getAreaType().getValue();
                String subAreaType = evaAreaBaseInfo.getSubAreaType().getValue();
                String sumScoreRule = "";
                if (evaAreaBaseInfo.getSumScoreRule() != null) {
                    sumScoreRule = evaAreaBaseInfo.getSumScoreRule().getValue();
                }
                keyList.add(fid);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fid", fid);
                map.put("weightControl", weightControl);
                map.put("areaWeight", areaWeight);
                map.put("name", name);
                map.put("sumScoreRule", sumScoreRule);
                map.put("areaType", areaType);
                map.put("subAreaType", subAreaType);
                boolean bl = unExtraFlag = !((String)map.get("sumScoreRule")).equals("400") && !((String)map.get("sumScoreRule")).equals("500") && !((String)map.get("subAreaType")).equals("1");
                if (weightControl.equals(String.valueOf(1)) && !StringUtils.isEmpty((CharSequence)areaWeight) && !areaWeight.equals("null") && unExtraFlag) {
                    controlWeight = controlWeight.add(new BigDecimal(areaWeight));
                }
                list.add(map);
            }
            boolean weightForce100 = true;
            try {
                PerfPeriodCollection perfPeriodCollection = PerfPeriodFactory.getLocalInstance((Context)ctx).getPerfPeriodCollection(" select *,perfPlan.* where id ='" + period + "'");
                if (perfPeriodCollection.size() > 0) {
                    PerfPeriodInfo perfPeriodInfo = perfPeriodCollection.get(0);
                    weightForce100 = perfPeriodInfo.getPerfPlan().isWeightForce100();
                }
            }
            catch (BOSException e) {
                logger.error("getPerfPeriod error: ");
            }
            for (String areaBaseId : keyList) {
                for (int i = 0; i < list.size(); ++i) {
                    float areaIndicatorWeight;
                    boolean unExtraFlag;
                    HashMap areaMap = (HashMap)list.get(i);
                    if (!areaBaseId.equals(areaMap.get("fid"))) continue;
                    boolean bl = unExtraFlag = !((String)areaMap.get("sumScoreRule")).equals("400") && !((String)areaMap.get("sumScoreRule")).equals("500") && !((String)areaMap.get("subAreaType")).equals("1");
                    if (((String)areaMap.get("areaType")).equals("200")) {
                        areaIndicatorWeight = new UnitedIndicatorUtils().calculateAreaIndicatorWeight(ctx, period, areaBaseId, groupId, scoringWay);
                        if (unExtraFlag) {
                            totalWeight = totalWeight.add(new BigDecimal(Float.toString(areaIndicatorWeight)));
                        }
                        if (((String)areaMap.get("weightControl")).equals(String.valueOf(1)) && !StringUtils.isEmpty((CharSequence)((CharSequence)areaMap.get("areaWeight")))) {
                            float areaWeight = Float.parseFloat((String)areaMap.get("areaWeight"));
                            if (!(areaIndicatorWeight > areaWeight)) continue;
                            if (scoringWay == 1) {
                                return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FORMAREATARSCOREOVER, ctx, new Object[]{areaMap.get("name")});
                            }
                            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FORMAREAWEIGHTOVER, ctx, new Object[]{areaMap.get("name")});
                        }
                        if (!unExtraFlag) continue;
                        unControlWeight = unControlWeight.add(new BigDecimal(Float.toString(areaIndicatorWeight)));
                        continue;
                    }
                    if (!((String)areaMap.get("areaType")).equals("300")) continue;
                    areaIndicatorWeight = new UnitedIndicatorUtils().calculateAreaRecordWeight(ctx, period, areaBaseId, groupId, scoringWay);
                    if (unExtraFlag) {
                        totalWeight = totalWeight.add(new BigDecimal(Float.toString(areaIndicatorWeight)));
                    }
                    if (((String)areaMap.get("weightControl")).equals(String.valueOf(1)) && !StringUtils.isEmpty((CharSequence)((CharSequence)areaMap.get("areaWeight")))) {
                        String weightStr = (String)areaMap.get("areaWeight");
                        if (StringUtils.isEmpty((CharSequence)weightStr) || weightStr.equals("undefined")) continue;
                        float areaWeight = Float.parseFloat((String)areaMap.get("areaWeight"));
                        if (scoringWay == 1) {
                            if (!(areaIndicatorWeight > areaWeight)) continue;
                            return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FORMAREATARSCOREOVER, ctx, new Object[]{areaMap.get("name")});
                        }
                        if (!(areaIndicatorWeight > areaWeight)) continue;
                        return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FORMAREAWEIGHTOVER, ctx, new Object[]{areaMap.get("name")});
                    }
                    if (!unExtraFlag) continue;
                    unControlWeight = unControlWeight.add(new BigDecimal(Float.toString(areaIndicatorWeight)));
                }
            }
            if (scoringWay == 1) {
                PerfScoreInfo scoreInfo = GetEntityInfoUtils.getPerfScoreInfoById(ctx, ruleInfo.getPariMutual().getId().toString());
                BigDecimal maxScore = scoreInfo.getMax();
                if (weightForce100 && totalWeight.compareTo(maxScore) > 0) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OVERTARSCOREERR, ctx, new Object[]{maxScore});
                }
                if (controlWeight.compareTo(maxScore) > 0) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FORMAREATARSCOREOVERMAX, ctx);
                }
            } else {
                if (weightForce100 && (double)totalWeight.floatValue() > 100.0) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.OVERWEIGHTERR, ctx);
                }
                if ((double)controlWeight.floatValue() - 100.0 > 0.0) {
                    return SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FORMAREAWEIGHTOVER100, ctx);
                }
            }
        }
        return ServerResponseConst.SUCCESS;
    }

    protected EvaluFormAreaBaseCollection getEvaluFormAreaBaseColl(Context ctx, String period) {
        EvaluFormAreaBaseCollection evaFormAreaBaseColl = null;
        try {
            IEvaluFormAreaBase ievaFormAreaBase = EvaluFormAreaBaseFactory.getLocalInstance((Context)ctx);
            PerfPeriodInfo periodInfo = UnitedIndicatorUtils.getPerfPeriodInfo(ctx, period);
            evaFormAreaBaseColl = ievaFormAreaBase.getEvaluFormAreaBaseCollection(" where performanceRule='" + periodInfo.getPerfRule().getId().toString() + "' and areaType not in ('" + "100" + "','" + "400" + "') order by seq ASC");
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return evaFormAreaBaseColl;
    }

    protected float calculateAreaIndicatorWeight(Context ctx, String period, String areaBaseId, String groupId, int scoreWay) {
        BigDecimal areaIndicatorWeight = BigDecimal.ZERO;
        try {
            IUniteIndicator iUniteIndicator = UniteIndicatorFactory.getLocalInstance((Context)ctx);
            IUniteIndicatorMemory iUnitedIndicatorMemory = UniteIndicatorMemoryFactory.getLocalInstance((Context)ctx);
            UniteIndicatorCollection unitedIndicatorColl = iUniteIndicator.getUniteIndicatorCollection("where  areaBase='" + areaBaseId + "' and beGroup='" + groupId + "'");
            if (unitedIndicatorColl != null && unitedIndicatorColl.size() > 0) {
                for (int j = 0; j < unitedIndicatorColl.size(); ++j) {
                    String unitedIndicatorWeight;
                    UniteIndicatorInfo unitedIndicatorInfo = unitedIndicatorColl.get(j);
                    String uniteIndicatorId = unitedIndicatorInfo.getId().toString();
                    if (iUnitedIndicatorMemory.exists(" where uindicator='" + uniteIndicatorId + "'")) {
                        UniteIndicatorMemoryInfo uniteIndicatorMemInfo = iUnitedIndicatorMemory.getUniteIndicatorMemoryInfo(" where uindicator='" + uniteIndicatorId + "'");
                        if (scoreWay == 1) {
                            if (StringUtils.isEmpty((CharSequence)uniteIndicatorMemInfo.getTarScore())) continue;
                            areaIndicatorWeight = areaIndicatorWeight.add(new BigDecimal(uniteIndicatorMemInfo.getTarScore()));
                            continue;
                        }
                        if (StringUtils.isEmpty((CharSequence)uniteIndicatorMemInfo.getWeight())) continue;
                        areaIndicatorWeight = areaIndicatorWeight.add(new BigDecimal(uniteIndicatorMemInfo.getWeight()));
                        continue;
                    }
                    if (scoreWay == 1) {
                        unitedIndicatorWeight = unitedIndicatorInfo.getTarScore();
                        if (StringUtils.isEmpty((CharSequence)unitedIndicatorWeight)) continue;
                        areaIndicatorWeight = areaIndicatorWeight.add(new BigDecimal(unitedIndicatorWeight));
                        continue;
                    }
                    unitedIndicatorWeight = unitedIndicatorInfo.getWeight();
                    if (StringUtils.isEmpty((CharSequence)unitedIndicatorWeight)) continue;
                    areaIndicatorWeight = areaIndicatorWeight.add(new BigDecimal(unitedIndicatorWeight));
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return areaIndicatorWeight.floatValue();
    }

    protected float calculateAreaRecordWeight(Context cxt, String period, String areaBaseId, String groupId, int scoreWay) {
        BigDecimal areaRecordWeight = BigDecimal.ZERO;
        try {
            IUniteRecord iUniteRecord = UniteRecordFactory.getLocalInstance((Context)cxt);
            IUniteRecordMemory iuniteRecordMemory = UniteRecordMemoryFactory.getLocalInstance((Context)cxt);
            UniteRecordCollection uniteRecordColl = iUniteRecord.getUniteRecordCollection("where  areaBase='" + areaBaseId + "' and beGroup='" + groupId + "'");
            if (uniteRecordColl != null && uniteRecordColl.size() > 0) {
                for (int j = 0; j < uniteRecordColl.size(); ++j) {
                    String unitedRecordWeight;
                    UniteRecordInfo uniteRecordInfo = uniteRecordColl.get(j);
                    String uniteRecordId = uniteRecordInfo.getId().toString();
                    if (iuniteRecordMemory.exists(" where uniteRecord='" + uniteRecordId + "'")) {
                        UniteRecordMemoryInfo uniteRecordMemInfo = iuniteRecordMemory.getUniteRecordMemoryInfo(" where uniteRecord='" + uniteRecordId + "'");
                        if (scoreWay == 1) {
                            String recordMemTarscore = uniteRecordMemInfo.getTarScore();
                            if (StringUtils.isEmpty((CharSequence)recordMemTarscore)) continue;
                            areaRecordWeight = areaRecordWeight.add(new BigDecimal(recordMemTarscore));
                            continue;
                        }
                        if (StringUtils.isEmpty((CharSequence)uniteRecordMemInfo.getWeight())) continue;
                        areaRecordWeight = areaRecordWeight.add(new BigDecimal(uniteRecordMemInfo.getWeight()));
                        continue;
                    }
                    if (scoreWay == 1) {
                        unitedRecordWeight = uniteRecordInfo.getTarScore();
                        if (StringUtils.isEmpty((CharSequence)unitedRecordWeight)) continue;
                        areaRecordWeight = areaRecordWeight.add(new BigDecimal(unitedRecordWeight));
                        continue;
                    }
                    unitedRecordWeight = uniteRecordInfo.getWeight();
                    if (StringUtils.isEmpty((CharSequence)unitedRecordWeight)) continue;
                    areaRecordWeight = areaRecordWeight.add(new BigDecimal(unitedRecordWeight));
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return areaRecordWeight.floatValue();
    }

    public static PerfPlanInfo getPerfPlanInfo(String planId) throws BOSException, EASBizException {
        PerfPlanInfo planInfo = new PerfPlanInfo();
        IPerfPlan iplan = PerfPlanFactory.getRemoteInstance();
        planInfo = iplan.getPerfPlanInfo(" where id='" + planId + "'");
        return planInfo;
    }

    public static PerfPeriodInfo getPerfPeriodInfo(Context ctx, String periodId) throws BOSException, EASBizException {
        PerfPeriodInfo periodInfo = new PerfPeriodInfo();
        IPerfPeriod iperfPeriod = PerfPeriodFactory.getLocalInstance((Context)ctx);
        periodInfo = iperfPeriod.getPerfPeriodInfo(" where id='" + periodId + "'");
        return periodInfo;
    }
}

