/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorAdminRangeCollection;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorAdminRangeFactory;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorCollection;
import com.kingdee.shr.perfweb.app.base.indecator.PerfIndecatorFactory;
import com.kingdee.shr.perfweb.app.common.PerfMessageRecordFactory;
import com.kingdee.shr.perfweb.app.common.PerfSendMessageTaskPoolFactory;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.bean.MsgBean;
import com.kingdee.shr.perfweb.bean.MsgConfigBean;
import com.kingdee.shr.perfweb.bean.ReMsgBean;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.MessageTemplateUtils;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PerfWorkFlowUtils;
import com.kingdee.shr.perfweb.utils.SmsUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminRangeUtils {
    private static final Logger logger = LoggerFactory.getLogger(AdminRangeUtils.class);

    public static Set getRangeSet(Context ctx, String userAdminSQL) {
        String admin = null;
        try {
            IObjectPK userId = ctx.getCaller();
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(userId);
            if (user.getPerson() == null) {
                logger.error("current user is not person");
                throw new RuntimeException("current user not ref person");
            }
            PersonPositionInfo personPositionInfo = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionInfo("where person.id='" + user.getPerson().getId().toString() + "'");
            admin = personPositionInfo.getPersonDep().getId().toString();
        }
        catch (BOSException | EASBizException e) {
            logger.error(e.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("admin.id", (Object)userAdminSQL, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("admin.id", admin, CompareType.EQUALS));
        filter.setMaskString("#0 OR #1)");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("PerfIndecatorAdminUseRange.perfIndecator"));
        view.setSelector(sic);
        view.setFilter(filter);
        HashSet<String> set = new HashSet<String>();
        try {
            PerfIndecatorAdminRangeCollection coll = PerfIndecatorAdminRangeFactory.getLocalInstance((Context)ctx).getPerfIndecatorAdminRangeCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                set.add(coll.get(i).getPerfIndecatorAdminUseRange().getPerfIndecator().getId().toString());
            }
            PerfIndecatorCollection perfIndecatorCollection = PerfIndecatorFactory.getLocalInstance((Context)ctx).getPerfIndecatorCollection(" where  range ='0'");
            for (int i = 0; i < perfIndecatorCollection.size(); ++i) {
                set.add(perfIndecatorCollection.get(i).getId().toString());
            }
        }
        catch (BOSException e) {
            logger.error("", (Throwable)e);
        }
        return set;
    }

    public static void sendMessageToFillers(Context ctx, String[] evaObjIds) {
        try {
            IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(Arrays.asList((Object[])evaObjIds)), CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("period.name"));
            sic.add(new SelectorItemInfo("period.id"));
            sic.add(new SelectorItemInfo("period.perfPlan"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("isSuperiorFiller"));
            sic.add(new SelectorItemInfo("perfFile.position"));
            sic.add(new SelectorItemInfo("isSelfFiller"));
            sic.add(new SelectorItemInfo("person"));
            sic.add(new SelectorItemInfo("evaluOrgAdmin"));
            sic.add(new SelectorItemInfo("personInchargePosition"));
            sic.add(new SelectorItemInfo("unitGoalsStatus"));
            sic.add(new SelectorItemInfo("personalGoalStatus"));
            sic.add(new SelectorItemInfo("hrUnitOrg.id"));
            sic.add(new SelectorItemInfo("isOrg"));
            PerfEvaObjectCollection evaObjColl = iPerfEvaObject.getPerfEvaObjectCollection(viewInfo);
            MsgBean msgBeanOrg = new MsgBean("6a8AAAAHfo5aQ0I5", Boolean.TRUE);
            MsgBean msgBean = new MsgBean("viEAAAQEpdRaQ0I5");
            MsgBean msgBeanSelfOrg = new MsgBean("6a8AAAAHfpVaQ0I5", Boolean.TRUE);
            MsgBean msgBeanSelf = new MsgBean("viEAAAQC/nBaQ0I5");
            int evaObjCollSize = evaObjColl.size();
            MsgConfigBean config = new MsgConfigBean(true, false, false, false);
            config.setMessageService(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.PERFGOALS, ctx));
            for (int i = 0; i < evaObjCollSize; ++i) {
                PerfEvaObjectInfo evaObjectInfo = evaObjColl.get(i);
                boolean isOrg = OrgAssessmentUtils.isOrgAssessment(evaObjectInfo);
                String evaObjId = evaObjectInfo.getId().toString();
                HashMap<String, Object> param = new HashMap<String, Object>();
                SmsUtils.assembleOtherParam(evaObjectInfo, param);
                param.put("perfplan", evaObjectInfo.getPeriod().getPerfPlan().getId().toString());
                param.put("perfperiod", evaObjectInfo.getPeriod().getId().toString());
                if (isOrg) {
                    param.put("config", config);
                    param.put("objAdmin", evaObjectInfo.getEvaluOrgAdmin().getId().toString());
                } else {
                    param.put("config", config);
                    param.put("objPerson", evaObjectInfo.getPerson().getId().toString());
                }
                HashSet<String> personIdSet = new HashSet<String>(2);
                if (!isOrg) {
                    personIdSet.add(evaObjectInfo.getPerson().getId().toString());
                } else {
                    List<String> orgResponserIdByEvaObject = OrgAssessmentUtils.getOrgResponserIdByEvaObject(ctx, evaObjectInfo.getId().toString());
                    personIdSet.addAll(orgResponserIdByEvaObject);
                }
                for (String recePersonId : personIdSet) {
                    if (isOrg) {
                        msgBeanSelfOrg.add(evaObjId, param, recePersonId, evaObjectInfo.getPeriod().getId().toString());
                        continue;
                    }
                    msgBeanSelf.add(evaObjId, param, recePersonId, evaObjectInfo.getPeriod().getId().toString());
                }
                Set<String> perfGoalsFillerSet = PerfWorkFlowUtils.getPerfGoalsFillerObjects(ctx, evaObjectInfo);
                if (!isOrg) {
                    String personId = evaObjectInfo.getPerson().getId().toString();
                    perfGoalsFillerSet.remove(personId);
                }
                for (String fillerId : perfGoalsFillerSet) {
                    if (isOrg) {
                        msgBeanOrg.add(evaObjId, param, fillerId, evaObjectInfo.getPeriod().getId().toString());
                        continue;
                    }
                    msgBean.add(evaObjId, param, fillerId, evaObjectInfo.getPeriod().getId().toString());
                }
            }
            Collection<ReMsgBean> msg = msgBean.excute(ctx);
            Collection<ReMsgBean> msgOrg = msgBeanOrg.excute(ctx);
            msg.addAll(msgOrg);
            msg.addAll(msgBeanSelfOrg.excute(ctx));
            msg.addAll(msgBeanSelf.excute(ctx));
            CoreBaseCollection poolColl = new CoreBaseCollection();
            CoreBaseCollection cool = new CoreBaseCollection();
            for (ReMsgBean reMsgBean : msg) {
                MessageTemplateUtils.asmbleMsg(ctx, poolColl, cool, reMsgBean);
            }
            if (!cool.isEmpty() || !poolColl.isEmpty()) {
                PerfSendMessageTaskPoolFactory.getLocalInstance((Context)ctx).addnew(poolColl);
                PerfMessageRecordFactory.getLocalInstance((Context)ctx).addnew(cool);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }
}

