/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectAssignTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectChangeDealTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectPersonalGoalStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectWFStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.SendTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.base.bean.CustomerFilterItemsBean;
import com.kingdee.shr.perfweb.base.bean.JqGridBean;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfPlanExecuteUtils;
import com.kingdee.shr.perfweb.util.PerfPortalUtils;
import com.kingdee.shr.perfweb.utils.PermitUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPlanExecutionListDataUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.GetPlanExecutionListDataUtils");
    public static String EXPORT_SELECTED = "0";
    public static String EXPORT_ALL = "1";

    public static List<HashMap<String, Object>> getEvaResultListData(Context ctx, HttpServletRequest request) {
        String selectedIds = request.getParameter("selectedIds");
        String fieldNames = request.getParameter("fieldNames");
        String exportType = request.getParameter("exportType");
        String currentPeriod = request.getParameter("currentPeriod");
        String curAdminOrg = request.getParameter("curAdminOrg");
        String tabTag = request.getParameter("tabTag");
        ArrayList<HashMap<String, Object>> dataList = new ArrayList<HashMap<String, Object>>();
        String[] colName = fieldNames.split(",");
        StringBuffer selectSQLBuffer = new StringBuffer();
        selectSQLBuffer.append("SELECT R.FID id,P.FNumber number,P.FName name,P.FPositionName position,P.FWorkFlowStatus workFlowStatus,P.FEmployeeType employeeType,R.FEvaObjID evaObj,R.FPersonID person,").append("R.FSumScore sumScore,R.FGradeLevel gradeLevel,R.FReviseSumScore reviseSumScore,R.FReviseGradeLevel reviseGradeLevel,R.FReviseReason reviseReason,R.FAdminOrgName adminOrUnitName,").append("R.FPlanNumber planNumber,R.FPeriodNumber periodNumber,R.FLastSumScore lastSumScore,R.FLastGradeLevel lastGradeLevel, R.FStatus status ").append(" FROM T_EVA_PerfEvaObject P LEFT JOIN T_EVA_EvaResultSummary R on P.FID=R.FEvaObjID ").append(" WHERE 1=1 and (P.FWorkflowStatus=3 or P.FWorkflowStatus=4)");
        if (EXPORT_SELECTED.equals(exportType)) {
            StringBuffer conditionBuffer = new StringBuffer("(''");
            String[] ids = selectedIds.split(",");
            for (int i = 0; i < ids.length; ++i) {
                conditionBuffer.append(",'").append(ids[i]).append("'");
            }
            conditionBuffer.append(")");
            selectSQLBuffer.append(" and R.FID in ").append(conditionBuffer);
        } else if (EXPORT_ALL.equals(exportType)) {
            AdminOrgUnitInfo adminOrgUnitInfo = GetEntityInfoUtils.getAdminOrgUnitInfo(ctx, curAdminOrg);
            String adminOrgNumber = adminOrgUnitInfo.getLongNumber();
            selectSQLBuffer.append(" and R.FPeriodID='").append(currentPeriod).append("'").append(" and R.FAdminOrgLongNumber like '").append(adminOrgNumber).append("%'");
        }
        if (tabTag.equals("unaudited_tab")) {
            selectSQLBuffer.append(" and R.FBillState=1");
        } else if (tabTag.equals("audited_tab")) {
            selectSQLBuffer.append(" and R.FBillState=3");
        }
        selectSQLBuffer.append(" order by P.FNumber ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSQLBuffer.toString());
            if (rowSet != null) {
                while (rowSet.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (int k = 0; k < colName.length; ++k) {
                        if (colName[k].equals("workFlowStatus")) {
                            map.put(colName[k], PerfEvaObjectWFStatusEnum.getEnum((int)rowSet.getInt(colName[k])).getAlias());
                            continue;
                        }
                        if (colName[k].equals("sumScore") || colName[k].equals("reviseSumScore") || colName[k].equals("lastSumScore")) {
                            map.put(colName[k], Float.valueOf(PerfPortalUtils.roudUpRemainGiveDecimal(2, rowSet.getFloat(colName[k]))));
                            continue;
                        }
                        if (colName[k].equals("status")) {
                            map.put(colName[k], EvaResultSumStatusEnum.getEnum((int)rowSet.getInt(colName[k])).getAlias());
                            continue;
                        }
                        map.put(colName[k], rowSet.getString(colName[k]));
                    }
                    dataList.add(map);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-\u3010" + tabTag + "\u3011EXPORTSELECTEDRECORDERR\uff01", (Throwable)e);
        }
        return dataList;
    }

    public static List<HashMap<String, Object>> getUnSendListData(Context ctx, HttpServletRequest request) {
        String selectedIds = request.getParameter("selectedIds");
        String fieldNames = request.getParameter("fieldNames");
        String exportType = request.getParameter("exportType");
        String currentPeriod = request.getParameter("currentPeriod");
        String curAdminOrg = request.getParameter("curAdminOrg");
        ArrayList<HashMap<String, Object>> dataList = new ArrayList<HashMap<String, Object>>();
        String[] colName = fieldNames.split(",");
        StringBuffer selectSQLBuffer = new StringBuffer();
        selectSQLBuffer.append("select p.FID id,p.FNumber number,p.FName name,p.FPositionName position,P.FEmployeeType employeeType,w.FName workflow,p.FSendTiming sendTiming,p.FAdminOrUnitName adminOrUnitName").append(" from T_EVA_PerfEvaObject p left join T_EVA_PWorkFlowDef w on p.FWorkFlowID=w.FID ").append(" where 1=1 ");
        if (EXPORT_SELECTED.equals(exportType)) {
            StringBuffer conditionBuffer = new StringBuffer("(''");
            String[] ids = selectedIds.split(",");
            for (int i = 0; i < ids.length; ++i) {
                conditionBuffer.append(",'").append(ids[i]).append("'");
            }
            conditionBuffer.append(")");
            selectSQLBuffer.append(" and p.FID in ").append(conditionBuffer);
        } else if (EXPORT_ALL.equals(exportType)) {
            AdminOrgUnitInfo adminOrgUnitInfo = GetEntityInfoUtils.getAdminOrgUnitInfo(ctx, curAdminOrg);
            String adminOrgNumber = adminOrgUnitInfo.getLongNumber();
            selectSQLBuffer.append(" and p.FPeriodID='").append(currentPeriod).append("'").append(" and P.FUnitGoalsStatus=1").append(" and P.FPersonalGoalStatus=").append(3).append(" and p.FScoreTaskStatus='100'").append(" and P.FWorkFlowStatus not in(").append(3).append(",").append(4).append(")").append(" and p.FOrgLongNumber like '").append(adminOrgNumber).append("%'");
        }
        selectSQLBuffer.append(" order by p.FNumber ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSQLBuffer.toString());
            if (rowSet != null) {
                while (rowSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (int k = 0; k < colName.length; ++k) {
                        map.put(colName[k], rowSet.getString(colName[k]));
                    }
                    dataList.add(map);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-EXPORTSELECTEDRECORDERRFORUNSENDLIST\uff01", (Throwable)e);
        }
        return dataList;
    }

    public static List<HashMap<String, Object>> getSentListData(Context ctx, HttpServletRequest request) {
        String selectedIds = request.getParameter("selectedIds");
        String fieldNames = request.getParameter("fieldNames");
        String exportType = request.getParameter("exportType");
        String currentPeriod = request.getParameter("currentPeriod");
        String curAdminOrg = request.getParameter("curAdminOrg");
        ArrayList<HashMap<String, Object>> dataList = new ArrayList<HashMap<String, Object>>();
        String[] colName = fieldNames.split(",");
        StringBuffer selectSQLBuffer = new StringBuffer();
        selectSQLBuffer.append("select p.FID id,p.FNumber number,p.FName name,p.FPositionName position,w.FName workflow,p.FWorkFlowStatus workFlowStatus,p.FSendType sendType,p.FEmployeeType employeeType").append(" from T_EVA_PerfEvaObject p left join T_EVA_PWorkFlowDef w on p.FWorkFlowID=w.FID left join T_EVA_EvaResultSummary r on p.FID=r.FEvaObjID ").append(" where 1=1 ");
        if (EXPORT_SELECTED.equals(exportType)) {
            StringBuffer conditionBuffer = new StringBuffer("(''");
            String[] ids = selectedIds.split(",");
            for (int i = 0; i < ids.length; ++i) {
                conditionBuffer.append(",'").append(ids[i]).append("'");
            }
            conditionBuffer.append(")");
            selectSQLBuffer.append(" and p.FID in ").append(conditionBuffer);
        } else if (EXPORT_ALL.equals(exportType)) {
            AdminOrgUnitInfo adminOrgUnitInfo = GetEntityInfoUtils.getAdminOrgUnitInfo(ctx, curAdminOrg);
            String adminOrgNumber = adminOrgUnitInfo.getLongNumber();
            selectSQLBuffer.append(" and p.FPeriodID='").append(currentPeriod).append("'").append(" and p.FTaskSendStatus=1").append(" and p.FScoreTaskStatus in ('200','600')").append(" and P.FWorkFlowStatus in(").append(1).append(",").append(2).append(")").append(" and p.FOrgLongNumber like '").append(adminOrgNumber).append("%'");
        }
        selectSQLBuffer.append(" order by p.FNumber ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSQLBuffer.toString());
            HashSet<String> evaObjs = new HashSet<String>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (int k = 0; k < colName.length; ++k) {
                        if (colName[k].equals("workFlowStatus")) {
                            map.put(colName[k], PerfEvaObjectWFStatusEnum.getEnum((int)rowSet.getInt(colName[k])).getAlias());
                        } else if (colName[k].equals("sendType")) {
                            map.put(colName[k], SendTypeEnum.getEnum((String)rowSet.getString(colName[k])).getAlias());
                        } else if (!colName[k].equals("currentNodeHandler") && !colName[k].equals("perfGoalsObject")) {
                            map.put(colName[k], rowSet.getString(colName[k]));
                        }
                        evaObjs.add(rowSet.getString("id"));
                    }
                    dataList.add(map);
                }
                if (evaObjs != null && evaObjs.size() > 0) {
                    Map<String, String> goalsObjectMap = PerfPlanExecuteUtils.getPerfGoalsObjectByEvaObjs(ctx, evaObjs);
                    for (HashMap<String, Object> obj : dataList) {
                        Map item = obj;
                        String evaObj = (String)item.get("id");
                        item.put("perfGoalsObject", goalsObjectMap.get(evaObj));
                    }
                    Map<String, String> nodeHandlerMap = PerfPlanExecuteUtils.getCurrentNodeHandersForEvaObj(ctx, evaObjs);
                    for (HashMap<String, Object> obj : dataList) {
                        Map item = obj;
                        String evaObj = (String)item.get("id");
                        item.put("currentNodeHandler", nodeHandlerMap.get(evaObj));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-EXPORTSELECTEDRECORDERRFORUNSENDLIST\uff01", (Throwable)e);
        }
        return dataList;
    }

    public static List<HashMap<String, Object>> getSuperiorUnSubmitListData(Context ctx, HttpServletRequest request) {
        String selectedIds = request.getParameter("selectedIds");
        String fieldNames = request.getParameter("fieldNames");
        String exportType = request.getParameter("exportType");
        String currentPeriod = request.getParameter("currentPeriod");
        String curAdminOrg = request.getParameter("curAdminOrg");
        ArrayList<HashMap<String, Object>> dataList = new ArrayList<HashMap<String, Object>>();
        String[] colName = fieldNames.split(",");
        StringBuffer selectSQLBuffer = new StringBuffer();
        selectSQLBuffer.append("select P.FID id,").append("P.FNumber number,").append("P.FName name,").append("P.FPositionName position,").append("P.FWorkFlowID workflow,").append("P.FPersonalGoalStatus personalGoalStatus,").append("P.FChangeDealType changeDealType,").append("P.FAssignType assignType,").append("P.FEmployeeType employeeType,").append("P.FAdminOrUnitName adminOrUnitName").append(" from T_EVA_PerfEvaObject P ").append(" where 1=1 ");
        if (EXPORT_SELECTED.equals(exportType)) {
            StringBuffer conditionBuffer = new StringBuffer("(''");
            String[] ids = selectedIds.split(",");
            for (int i = 0; i < ids.length; ++i) {
                conditionBuffer.append(",'").append(ids[i]).append("'");
            }
            conditionBuffer.append(")");
            selectSQLBuffer.append(" and P.FID in ").append(conditionBuffer);
        } else if (EXPORT_ALL.equals(exportType)) {
            AdminOrgUnitInfo adminOrgUnitInfo = GetEntityInfoUtils.getAdminOrgUnitInfo(ctx, curAdminOrg);
            String adminOrgNumber = adminOrgUnitInfo.getLongNumber();
            selectSQLBuffer.append(" and P.FPeriodID='").append(currentPeriod).append("'").append(" and P.FUnitGoalsStatus=").append(1).append(" and P.FPersonalGoalStatus=").append(2).append(" and P.FOrgLongNumber like '").append(adminOrgNumber).append("%'");
        }
        selectSQLBuffer.append(" order by FNumber ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSQLBuffer.toString());
            if (rowSet != null) {
                HashSet<String> evaObjs = new HashSet<String>();
                while (rowSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String evaObj = rowSet.getString("id");
                    evaObjs.add(evaObj);
                    for (int k = 0; k < colName.length; ++k) {
                        if (colName[k].equals("workflow")) {
                            String workflow = rowSet.getString("workflow");
                            PWorkFlowDefInfo workFlowDefInfo = PerfPlanExecuteUtils.getPWorkFlowDefInfo(workflow);
                            if (workFlowDefInfo != null) {
                                map.put("workflow", workFlowDefInfo.getName());
                                continue;
                            }
                            map.put("workflow", "");
                            continue;
                        }
                        if (colName[k].equals("weight")) {
                            map.put("weight", PerfPlanExecuteUtils.calculateEvaObjTargetWeight(ctx, evaObj) + "%");
                            continue;
                        }
                        if (colName[k].equals("perfGoalsObject")) continue;
                        if (colName[k].equals("personalGoalStatus")) {
                            map.put("personalGoalStatus", PerfEvaObjectPersonalGoalStatusEnum.getEnum((int)rowSet.getInt("personalGoalStatus")).getAlias());
                            continue;
                        }
                        if (colName[k].equals("changeDealType")) {
                            map.put("changeDealType", PerfEvaObjectChangeDealTypeEnum.getEnum((int)rowSet.getInt("changeDealType")).getAlias());
                            continue;
                        }
                        if (colName[k].equals("assignType")) {
                            map.put("assignType", PerfEvaObjectAssignTypeEnum.getEnum((int)rowSet.getInt("assignType")).getAlias());
                            continue;
                        }
                        map.put(colName[k], rowSet.getString(colName[k]));
                    }
                    dataList.add(map);
                }
                if (evaObjs != null && evaObjs.size() > 0) {
                    Map<String, String> goalsObjectMap = PerfPlanExecuteUtils.getPerfGoalsObjectByEvaObjs(ctx, evaObjs);
                    for (HashMap<String, Object> obj : dataList) {
                        Map item = obj;
                        String evaObj = (String)item.get("id");
                        item.put("perfGoalsObject", goalsObjectMap.get(evaObj));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-EXPORTSELECTEDRECORDERRFORUNSENDLIST\uff01", (Throwable)e);
        }
        return dataList;
    }

    public static List<HashMap<String, Object>> getPersonalUnSubmitListData(Context ctx, HttpServletRequest request) {
        String selectedIds = request.getParameter("selectedIds");
        String fieldNames = request.getParameter("fieldNames");
        String exportType = request.getParameter("exportType");
        String currentPeriod = request.getParameter("currentPeriod");
        String curAdminOrg = request.getParameter("curAdminOrg");
        ArrayList<HashMap<String, Object>> dataList = new ArrayList<HashMap<String, Object>>();
        String[] colName = fieldNames.split(",");
        StringBuffer selectSQLBuffer = new StringBuffer();
        selectSQLBuffer.append("select P.FID id,").append("P.FNumber number,").append("P.FName name,").append("P.FPositionName position,").append("P.FWorkFlowID workflow,").append("P.FPersonalGoalStatus personalGoalStatus,").append("P.FChangeDealType changeDealType,").append("P.FAssignType assignType,").append("P.FEmployeeType employeeType,").append("P.FAdminOrUnitName adminOrUnitName").append(" from T_EVA_PerfEvaObject P ").append(" where 1=1 ");
        if (EXPORT_SELECTED.equals(exportType)) {
            StringBuffer conditionBuffer = new StringBuffer("(''");
            String[] ids = selectedIds.split(",");
            for (int i = 0; i < ids.length; ++i) {
                conditionBuffer.append(",'").append(ids[i]).append("'");
            }
            conditionBuffer.append(")");
            selectSQLBuffer.append(" and P.FID in ").append(conditionBuffer);
        } else if (EXPORT_ALL.equals(exportType)) {
            AdminOrgUnitInfo adminOrgUnitInfo = GetEntityInfoUtils.getAdminOrgUnitInfo(ctx, curAdminOrg);
            String adminOrgNumber = adminOrgUnitInfo.getLongNumber();
            selectSQLBuffer.append(" and P.FPeriodID='").append(currentPeriod).append("'").append(" and P.FUnitGoalsStatus=").append(1).append(" and P.FPersonalGoalStatus in (").append(0).append(",").append(1).append(")").append(" and P.FWorkFlowStatus not in(").append(3).append(",").append(4).append(")").append(" and P.FOrgLongNumber like '").append(adminOrgNumber).append("%'");
        }
        selectSQLBuffer.append(" order by P.FNumber ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSQLBuffer.toString());
            if (rowSet != null) {
                HashSet<String> evaObjs = new HashSet<String>();
                while (rowSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String evaObj = rowSet.getString("id");
                    evaObjs.add(evaObj);
                    for (int k = 0; k < colName.length; ++k) {
                        if (colName[k].equals("workflow")) {
                            String workflow = rowSet.getString("workflow");
                            PWorkFlowDefInfo workFlowDefInfo = PerfPlanExecuteUtils.getPWorkFlowDefInfo(workflow);
                            if (workFlowDefInfo != null) {
                                map.put("workflow", workFlowDefInfo.getName());
                                continue;
                            }
                            map.put("workflow", "");
                            continue;
                        }
                        if (colName[k].equals("weight")) {
                            map.put("weight", PerfPlanExecuteUtils.calculateEvaObjTargetWeight(ctx, evaObj) + "%");
                            continue;
                        }
                        if (colName[k].equals("perfGoalsObject")) continue;
                        if (colName[k].equals("personalGoalStatus")) {
                            map.put("personalGoalStatus", PerfEvaObjectPersonalGoalStatusEnum.getEnum((int)rowSet.getInt("personalGoalStatus")).getAlias());
                            continue;
                        }
                        if (colName[k].equals("changeDealType")) {
                            map.put("changeDealType", PerfEvaObjectChangeDealTypeEnum.getEnum((int)rowSet.getInt("changeDealType")).getAlias());
                            continue;
                        }
                        if (colName[k].equals("assignType")) {
                            map.put("assignType", PerfEvaObjectAssignTypeEnum.getEnum((int)rowSet.getInt("assignType")).getAlias());
                            continue;
                        }
                        map.put(colName[k], rowSet.getString(colName[k]));
                    }
                    dataList.add(map);
                }
                if (evaObjs != null && evaObjs.size() > 0) {
                    Map<String, String> goalsObjectMap = PerfPlanExecuteUtils.getPerfGoalsObjectByEvaObjs(ctx, evaObjs);
                    for (HashMap<String, Object> obj : dataList) {
                        Map item = obj;
                        String evaObj = (String)item.get("id");
                        item.put("perfGoalsObject", goalsObjectMap.get(evaObj));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-EXPORTSELECTEDRECORDERRFORUNSENDLIST\uff01", (Throwable)e);
        }
        return dataList;
    }

    public static String getEvaObjTabListAllIds(Context ctx, HttpServletRequest request) {
        StringBuffer evaObjIds = new StringBuffer();
        String sql = GetPlanExecutionListDataUtils.getEvaObjTabListSQL(ctx, request);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    evaObjIds.append(rs.getString("FID")).append(",");
                }
                evaObjIds.setLength(evaObjIds.length() - 1);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return evaObjIds.toString();
    }

    public static String getEvaObjTabListSQL(Context ctx, HttpServletRequest request) {
        String type = "";
        String period = "";
        String orgId = "";
        String personId = "";
        String selectedIds = request.getParameter("selectedIds");
        String exportType = request.getParameter("exportType");
        StringBuffer getListSQLBuffer = new StringBuffer();
        String filterItems = request.getParameter("filterItems");
        JqGridBean jqGridBean = null;
        String advancedFilterItems = "";
        Gson gson = new Gson();
        if (!StringUtils.isEmpty((String)filterItems)) {
            jqGridBean = (JqGridBean)gson.fromJson(filterItems, JqGridBean.class);
            if (!StringUtils.isEmpty((String)jqGridBean.getCustomeFilterItems())) {
                String customerFiterItems = jqGridBean.getCustomeFilterItems();
                CustomerFilterItemsBean customerFilterItemsBean = (CustomerFilterItemsBean)gson.fromJson(customerFiterItems, CustomerFilterItemsBean.class);
                advancedFilterItems = customerFilterItemsBean.getAdvancedFilterItems();
                if (!StringUtils.isEmpty((String)customerFilterItemsBean.getRows())) {
                    request.setAttribute("rows", (Object)customerFilterItemsBean.getRows());
                } else {
                    request.setAttribute("rows", (Object)jqGridBean.getRows());
                }
                if (!StringUtils.isEmpty((String)customerFilterItemsBean.getPage())) {
                    request.setAttribute("page", (Object)customerFilterItemsBean.getPage());
                } else {
                    request.setAttribute("page", (Object)jqGridBean.getPage());
                }
                type = !StringUtils.isEmpty((String)customerFilterItemsBean.getType()) ? customerFilterItemsBean.getType() : jqGridBean.getType();
                period = !StringUtils.isEmpty((String)customerFilterItemsBean.getPeriod()) ? customerFilterItemsBean.getPeriod() : jqGridBean.getPeriod();
                orgId = !StringUtils.isEmpty((String)customerFilterItemsBean.getOrgId()) ? customerFilterItemsBean.getOrgId() : jqGridBean.getOrgId();
                personId = !StringUtils.isEmpty((String)customerFilterItemsBean.getPersonId()) ? customerFilterItemsBean.getPersonId() : jqGridBean.getPersonId();
            } else {
                request.setAttribute("rows", (Object)jqGridBean.getRows());
                request.setAttribute("page", (Object)jqGridBean.getPage());
                type = jqGridBean.getType();
                period = jqGridBean.getPeriod();
                orgId = jqGridBean.getOrgId();
                personId = jqGridBean.getPersonId();
            }
        } else {
            if (StringUtils.isEmpty((String)type)) {
                type = request.getParameter("type");
            }
            if (StringUtils.isEmpty((String)period)) {
                period = request.getParameter("period");
            }
            if (StringUtils.isEmpty((String)orgId)) {
                orgId = request.getParameter("orgId");
            }
            if (StringUtils.isEmpty((String)personId)) {
                personId = request.getParameter("personId");
            }
        }
        try {
            StringBuffer getSendListBuffer = new StringBuffer();
            getSendListBuffer.append("select  P.FPerson FPerson,").append("P.FID FID,").append("P.FWorkFlowID FWorkFlowID,").append("P.FPersonalGoalStatus FPersonalGoalStatus,").append("P.FNumber FNumber,").append("P.FName FName,").append("P.FChangeDealType,").append("P.FPeriodID FPeriodID,").append("P.FJoinPeriodDate FJoinPeriodDate,").append("P.FPosition FPosition,").append("P.FPositionName FPositionName,").append("P.FJoinCurPosDate FJoinCurPosDate,").append("P.FAdminOrUnit FAdminOrUnit,").append("P.FAdminOrUnitName FAdminOrUnitName,").append("P.FEmployeeType FEmployeeType,").append("P.FAssignType FAssignType,").append("P.FWorkFlowStatus FWorkFlowStatus,").append("P.FSendTiming FSendTiming,").append("P.FSendType FSendType,").append("P.FSendedTime FSendedTime,").append("P.FGoalsPercent FGoalsPercent");
            getSendListBuffer.append(" from T_EVA_PerfEvaObject P ").append(" left join T_ORG_Admin adminOrgUnit ").append(" on P.FAdminOrUnit = adminOrgUnit.fid ").append(" left join T_ORG_POSITION position ").append(" on P.FPosition = position.fid ").append(" left join T_BD_PERSON person ").append(" on P.FPerson = person.fid ");
            getListSQLBuffer.append(getSendListBuffer).append(" where 1=1 ");
            if (type.equals("100")) {
                getListSQLBuffer.append(" and P.FUnitGoalsStatus=1 and P.FPersonalGoalStatus in(");
                getListSQLBuffer.append(0).append(",").append(1).append(")").append(" and P.FWorkFlowStatus not in(").append(3).append(",").append(4).append(")");
                if (!StringUtils.isEmpty((String)advancedFilterItems)) {
                    getListSQLBuffer.append(" and ").append(advancedFilterItems);
                }
            } else if (type.equals("200")) {
                getListSQLBuffer.append(" and P.FUnitGoalsStatus=1 and P.FPersonalGoalStatus=");
                getListSQLBuffer.append(2).append(" and P.FWorkFlowStatus not in(").append(3).append(",").append(4).append(")");
                if (!StringUtils.isEmpty((String)advancedFilterItems)) {
                    getListSQLBuffer.append(" and ").append(advancedFilterItems);
                }
            } else if (type.equals("300")) {
                getListSQLBuffer.append(" and P.FUnitGoalsStatus=1");
                getListSQLBuffer.append(" and P.FPersonalGoalStatus=").append(3);
                getListSQLBuffer.append(" and P.FScoreTaskStatus=").append("100").append(" and P.FWorkFlowStatus not in(").append(3).append(",").append(4).append(")");
                if (!StringUtils.isEmpty((String)advancedFilterItems)) {
                    getListSQLBuffer.append(" and ").append(advancedFilterItems);
                }
            } else if (type.equals("800")) {
                getSendListBuffer.append(" left join T_EVA_EvaResultSummary R on P.FID=R.FEvaObjID WHERE P.FWorkFlowStatus in(").append(1).append(",").append(2).append(")");
                getListSQLBuffer = new StringBuffer();
                getListSQLBuffer.append(getSendListBuffer);
                if (!StringUtils.isEmpty((String)advancedFilterItems)) {
                    getListSQLBuffer.append(" and ").append(advancedFilterItems);
                }
            } else if (type.equals("900")) {
                getListSQLBuffer.append(" and R.FScoreTaskStatus=").append("300");
            } else if (type.equals("600") || type.equals("700")) {
                getListSQLBuffer = new StringBuffer("select R.FID FID,R.FEvaObjID evaObj,P.FPerson person,").append("P.FNumber FNumber,").append("P.FName FName,").append("P.FPositionName FPositionName,").append("P.FWorkFlowID FWorkFlowID,").append("P.FJoinPeriodDate FJoinPeriodDate,").append("P.FPosition FPosition,").append("P.FAdminOrUnit FAdminOrUnit,").append("P.FAdminOrUnitName FAdminOrUnitName,").append("P.FEmployeeType FEmployeeType,").append("P.FWorkFlowStatus FlowStatus,").append("R.FSumScore FSumScore,").append("R.FGradeLevel FGradeLevel,").append("R.FReviseSumScore FReviseSumScore,").append("R.FReviseGradeLevel FReviseGradeLevel,").append("R.FReviseReason FReviseReason,").append("R.FLastSumScore FLastSumScore,").append("R.FLastGradeLevel FLastGradeLevel,").append("R.FStatus FStatus").append(" from T_EVA_EvaResultSummary R  LEFT JOIN T_EVA_PerfEvaObject P on R.FEvaObjID = P.FID");
                getListSQLBuffer.append(" left join T_ORG_Admin adminOrgUnit ");
                getListSQLBuffer.append(" on P.FAdminOrUnit = adminOrgUnit.fid ");
                getListSQLBuffer.append(" left join T_ORG_POSITION position ");
                getListSQLBuffer.append(" on P.FPosition = position.fid ");
                getListSQLBuffer.append(" left join T_BD_PERSON person ");
                getListSQLBuffer.append(" on P.FPerson = person.fid ");
                getListSQLBuffer.append(" where 1=1 ");
                getListSQLBuffer.append(" and (P.FWorkFlowStatus=").append(3).append(" or P.FWorkFlowStatus=").append(4).append(")");
                if (type.equals("600")) {
                    getListSQLBuffer.append(" and R.FBillState=1");
                } else {
                    getListSQLBuffer.append(" and R.FBillState=3");
                }
                if (!StringUtils.isEmpty((String)advancedFilterItems)) {
                    getListSQLBuffer.append(" and ").append(advancedFilterItems);
                }
            }
            if (!StringUtils.isEmpty((String)period)) {
                getListSQLBuffer.append(" and P.FPeriodID='" + period + "'");
            } else {
                getListSQLBuffer.append(" and 1 != 1");
            }
            HashSet<String> userAdminRangeSet = new HashSet<String>();
            if (!StringUtils.isEmpty((String)orgId)) {
                ArrayList<String> orgList = PermitUtil.getInterSectionOrg(PermitUtil.getCurrentUserOwnOrg(ctx), PermitUtil.getCurAndSubOrg(ctx, String.valueOf(orgId)));
                userAdminRangeSet.addAll(orgList);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("ID", userAdminRangeSet, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            ArrayList<String> orgLongNumbers = new ArrayList<String>();
            AdminOrgUnitCollection collection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(evi);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    AdminOrgUnitInfo info = collection.get(i);
                    orgLongNumbers.add(info.getLongNumber());
                }
            }
            getListSQLBuffer.append(" and (P.FOrgLongNumber in (" + GetPlanExecutionListDataUtils.getInParameter(orgLongNumbers, "P.FOrgLongNumber") + "))");
            if (!StringUtils.isEmpty((String)personId)) {
                String[] personIdArr;
                StringBuffer personFilter = new StringBuffer("(''");
                for (String pid : personIdArr = personId.split(",")) {
                    personFilter.append(",'").append(pid).append("'");
                }
                personFilter.append(")");
                getListSQLBuffer.append(" and P.FPerson in " + personFilter);
            }
            if ("0".equals(exportType)) {
                StringBuffer conditionBuffer = new StringBuffer("(''");
                String[] ids = selectedIds.split(",");
                for (int i = 0; i < ids.length; ++i) {
                    conditionBuffer.append(",'").append(ids[i]).append("'");
                }
                conditionBuffer.append(")");
                getListSQLBuffer.append(" and P.FID in ").append(conditionBuffer);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return getListSQLBuffer.toString();
    }

    private static String getInParameter(List list, String parameter) {
        if (!list.isEmpty()) {
            ArrayList<String> setList = new ArrayList<String>(0);
            HashSet<String> set = new HashSet<String>();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i <= list.size(); ++i) {
                set.add("'" + list.get(i - 1) + "'");
                if (i % 900 != 0) continue;
                setList.add(StringUtils.join(set.iterator(), (String)","));
                set.clear();
            }
            if (!set.isEmpty()) {
                setList.add(StringUtils.join(set.iterator(), (String)","));
            }
            stringBuffer.append((String)setList.get(0));
            for (int j = 1; j < setList.size(); ++j) {
                stringBuffer.append(") or " + parameter + " in (");
                stringBuffer.append((String)setList.get(j));
            }
            return stringBuffer.toString();
        }
        return "''";
    }
}

