/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitHISInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.SHRAdminOrgUnitExtendCollection;
import com.kingdee.eas.hr.org.SHRAdminOrgUnitExtendFactory;
import com.kingdee.eas.hr.org.SHRAdminOrgUnitExtendInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IGoalsMessageReceiver;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PortalMesTypeEnum;
import com.kingdee.shr.perfweb.utils.RequestUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgAssessmentUtils {
    private static Logger logger = LoggerFactory.getLogger(OrgAssessmentUtils.class);
    public static final String IS_ORG_COLNAME = "isOrg";
    public static final String ORG_COLNAME = "evaluOrgAdmin";
    public static final String ORG_HIS_COLNAME = "adminHis";
    public static final String ORG_TAG = "ORG";
    public static final boolean isGetHisInfo = true;
    public static final String ORG_ISSEALUP_COLNAME = "adminHis.isSealUp";
    public static final String[] orgfieldParams = new String[]{"orgProperty.name", "simpleName", "orgFunction.name", "juridicalPerson.name", "industry.name", "isJuridicalCompany", "registType.name", "setupDate", "endupDate", "taxNumber", "number", "name", "responPosition.name", "principal.name", "unitLayerType.name", "parent.name", "parent.number", "department.name", "company.name"};
    public static final Map<String, String> orgfieldKV = new HashMap<String, String>(){
        {
            this.put("FORGPROPERTY", "orgProperty.name");
            this.put("FORGFUNCTION", "orgFunction.name");
            this.put("FJURIDICALPERSON", "juridicalPerson.name");
            this.put("FREGISTTYPE", "registType.name");
            this.put("FFRESPONPOSITION", "responPosition.name");
            this.put("FUNITLAYERTYPE", "unitLayerType.name");
            this.put("FPARENTNAME", "parent.name");
            this.put("FPARENTNUMBER", "parent.number");
            this.put("FDEPARTMENT", "department.name");
            this.put("FCOMPANY", "company.name");
        }
    };

    public static boolean isOrgAssessment(PerfEvaObjectInfo evaObjectInfo) {
        return evaObjectInfo != null && "1".equals(evaObjectInfo.getString(IS_ORG_COLNAME));
    }

    public static boolean isOrgAssessment(Context ctx, String evaObjId) throws BOSException, EASBizException {
        PerfEvaObjectInfo info = PerfEvaObjectFactory.getLocalInstance((Context)ctx).getPerfEvaObjectInfo("where id='" + evaObjId + "'");
        return OrgAssessmentUtils.isOrgAssessment(info);
    }

    public static Boolean isOrgAssessment(HttpServletRequest request) {
        if ("1".equals(RequestUtils.getParameter(request, IS_ORG_COLNAME))) {
            return true;
        }
        return false;
    }

    public static List<String> getOrgResponserIdByEvaObject(Context ctx, String evaObj) {
        PerfEvaluAdminResponsorCollection responsorColl = OrgAssessmentUtils.getAdminResponsorByEvaObj(ctx, evaObj);
        ArrayList<String> ret = new ArrayList<String>();
        if (responsorColl != null) {
            for (int i = 0; i < responsorColl.size(); ++i) {
                ret.add(responsorColl.get(i).getPerson().getId().toString());
            }
        }
        return ret;
    }

    public static List<String> getOrgResponserNameByEvaObject(Context ctx, String evaObj) {
        PerfEvaluAdminResponsorCollection responsorColl = OrgAssessmentUtils.getAdminResponsorByEvaObj(ctx, evaObj);
        ArrayList<String> ret = new ArrayList<String>();
        if (responsorColl != null) {
            for (int i = 0; i < responsorColl.size(); ++i) {
                ret.add(responsorColl.get(i).getPerson().getName());
            }
        }
        return ret;
    }

    public static List<Map<String, String>> getOrgResponserByEvaObject(Context ctx, String evaObj) {
        PerfEvaluAdminResponsorCollection responsorColl = OrgAssessmentUtils.getAdminResponsorByEvaObj(ctx, evaObj);
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        HashMap<String, String> tmp = null;
        if (responsorColl != null) {
            for (int i = 0; i < responsorColl.size(); ++i) {
                tmp = new HashMap<String, String>(2);
                PerfEvaluAdminResponsorInfo responsorInfo = responsorColl.get(i);
                if (responsorInfo.getPerson() != null) {
                    tmp.put("personName", responsorInfo.getPerson().getName());
                    tmp.put("person", responsorInfo.getPerson().getId().toString());
                    tmp.put("personNumber", responsorInfo.getPerson().getNumber());
                }
                ret.add(tmp);
            }
        }
        return ret;
    }

    public static String getOrgAdminResPositionIDByEvaObj(Context ctx, PerfEvaObjectInfo perfEvaObjectInfo, boolean isHis) throws BOSException {
        String adminCellName = isHis ? ORG_HIS_COLNAME : ORG_COLNAME;
        String adminId = null;
        if (null != perfEvaObjectInfo) {
            adminId = perfEvaObjectInfo.getString(adminCellName) != null ? perfEvaObjectInfo.getString(adminCellName) : (isHis ? perfEvaObjectInfo.getAdminHis().getId().toString() : perfEvaObjectInfo.getEvaluOrgAdmin().getId().toString());
        }
        if (!StringUtils.isEmpty(adminId)) {
            String sqlString = "select responPosition.id where id = '" + adminId + "'";
            if (isHis) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminId));
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.shr.perfweb.app.base.evalplan.AdminOrgUnitHisF7Query"));
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filter);
                SelectorItemCollection sic = viewInfo.getSelector();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("responPosition.id"));
                exec.setObjectView(viewInfo);
                IRowSet rowset = exec.executeQuery();
                try {
                    if (rowset.next()) {
                        return rowset.getString("responPosition.id");
                    }
                }
                catch (SQLException e) {
                    logger.error("SQLException: ", (Throwable)e);
                }
            } else {
                AdminOrgUnitCollection adminOrgUnitColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(sqlString);
                return adminOrgUnitColl.get(0).getResponPosition().getId().toString();
            }
        }
        return null;
    }

    public static Map<String, List<String>> getOrgResponsors(Context ctx, Set<String> evaObjs) throws BOSException {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        if (evaObjs != null && evaObjs.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaObj.id", evaObjs, CompareType.INCLUDE));
            SorterItemInfo sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setSortType(SortType.ASCEND);
            sorterItemInfo.setPropertyName("evaObj.id");
            SorterItemCollection sorterItemCollection = new SorterItemCollection();
            sorterItemCollection.add(sorterItemInfo);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            evi.setSorter(sorterItemCollection);
            SelectorItemCollection sic = evi.getSelector();
            sic.add(new SelectorItemInfo("evaObj.id"));
            sic.add(new SelectorItemInfo("person.name"));
            PerfEvaluAdminResponsorCollection collection = PerfEvaluAdminResponsorFactory.getLocalInstance((Context)ctx).getPerfEvaluAdminResponsorCollection(evi);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    PerfEvaluAdminResponsorInfo info = collection.get(i);
                    String evaObj = info.getEvaObj().getId().toString();
                    ArrayList<String> responsors = (ArrayList<String>)ret.get(evaObj);
                    if (responsors == null || responsors.size() == 0) {
                        responsors = new ArrayList<String>();
                    }
                    responsors.add(info.getPerson().getName());
                    ret.put(evaObj, responsors);
                }
            }
        }
        return ret;
    }

    public static AdminOrgUnitInfo getEvaluAdminInfo(Context ctx, String orgAdminId) {
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        EntityViewInfo evi = OrgAssessmentUtils.getOrgEntityViewInfo(orgAdminId);
        try {
            AdminOrgUnitCollection coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(evi);
            if (coll != null && coll.size() > 0) {
                adminOrgUnitInfo = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return adminOrgUnitInfo;
    }

    public static AdminOrgUnitHISInfo getEvaluAdminHISInfo(Context ctx, String orgAdminHISId) {
        AdminOrgUnitHISInfo adminOrgUnitInfo = null;
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.shr.perfweb.app.base.evalplan.AdminOrgUnitHisF7Query"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgAdminHISId, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        for (String field : orgfieldParams) {
            sic.add(new SelectorItemInfo(field));
        }
        evi.setSelector(sic);
        evi.setFilter(filterInfo);
        exec.setObjectView(evi);
        try {
            IRowSet rowset = exec.executeQuery();
            if (rowset != null && rowset.next()) {
                adminOrgUnitInfo = new AdminOrgUnitHISInfo();
                for (String field : orgfieldParams) {
                    adminOrgUnitInfo.put(field, (Object)rowset.getString(field));
                }
                adminOrgUnitInfo.put("id", (Object)rowset.getString("id"));
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return adminOrgUnitInfo;
    }

    private static EntityViewInfo getOrgEntityViewInfo(String orgAdminId) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgAdminId, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("responPosition.name"));
        sic.add(new SelectorItemInfo("unitLayerType.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("department.name"));
        sic.add(new SelectorItemInfo("orgProperty.name"));
        sic.add(new SelectorItemInfo("orgFunction.name"));
        sic.add(new SelectorItemInfo("registType.name"));
        evi.setSelector(sic);
        evi.setFilter(filterInfo);
        return evi;
    }

    public static SHRAdminOrgUnitExtendInfo getEvaluAdminExtInfo(Context ctx, String orgAdminId) {
        SHRAdminOrgUnitExtendInfo info = null;
        EntityViewInfo evi = OrgAssessmentUtils.getOrgExtendEntityViewInfo(orgAdminId);
        try {
            SHRAdminOrgUnitExtendCollection coll = SHRAdminOrgUnitExtendFactory.getLocalInstance((Context)ctx).getSHRAdminOrgUnitExtendCollection(evi);
            if (coll != null && coll.size() > 0) {
                info = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return info;
    }

    private static EntityViewInfo getOrgExtendEntityViewInfo(String orgAdminId) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit", (Object)orgAdminId, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("city.name"));
        sic.add(new SelectorItemInfo("enterpriseNature.name"));
        sic.add(new SelectorItemInfo("hrIndustry.name"));
        evi.setSelector(sic);
        evi.setFilter(filterInfo);
        return evi;
    }

    public static PerfEvaluAdminResponsorCollection getAdminResponsorByEvaObj(Context ctx, String evaObj) {
        PerfEvaluAdminResponsorCollection ret = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("person.id");
        selector.add("person.number");
        selector.add("person.name");
        viewInfo.setFilter(filter);
        try {
            ret = PerfEvaluAdminResponsorFactory.getLocalInstance((Context)ctx).getPerfEvaluAdminResponsorCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return ret;
    }

    public static PerfEvaObjectInfo getOrgAssessmentInfoByEvaObj(Context ctx, String evaObj) {
        PerfEvaObjectInfo ret = null;
        try {
            ret = PerfEvaObjectFactory.getLocalInstance((Context)ctx).getPerfEvaObjectInfo("select isOrg,evaluOrgAdmin.id,adminHis.id where id = '" + evaObj + "'");
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return ret;
    }

    public static String getPortalOrgFilterStr(HttpServletRequest request, PortalMesTypeEnum portalMesTypeEnum, Boolean isOrg) {
        boolean _isOrg = false;
        if (null != isOrg) {
            _isOrg = isOrg;
        } else if (null != request) {
            _isOrg = "1".equals(request.getParameter(IS_ORG_COLNAME));
        }
        String filterStr = "";
        switch (portalMesTypeEnum.getValue()) {
            case 12: 
            case 17: {
                if (_isOrg) {
                    filterStr = " AND o.FIsOrg = 1";
                    break;
                }
                filterStr = " AND o.FIsOrg <> 1";
                break;
            }
            case 10: {
                if (_isOrg) {
                    filterStr = " AND FPerson = 'ORG'";
                    break;
                }
                filterStr = " AND FPerson <> 'ORG'";
                break;
            }
            case 15: {
                if (_isOrg) {
                    filterStr = " AND target.evaObj.isOrg = '1'";
                    break;
                }
                filterStr = " AND target.evaObj.isOrg <> '1'";
                break;
            }
            case 21: {
                if (_isOrg) {
                    filterStr = " AND person = 'ORG'";
                    break;
                }
                filterStr = " AND person <> 'ORG'";
                break;
            }
            case 11: {
                filterStr = _isOrg ? " AND receiver.FPerson = 'ORG'" : " AND receiver.FPerson <> 'ORG'";
            }
        }
        return filterStr;
    }

    public static void setPortalOrgFilter(FilterInfo filterInfo, PortalMesTypeEnum portalMesTypeEnum, Boolean isOrg) {
        boolean _isOrg = false;
        if (null != isOrg) {
            _isOrg = isOrg;
        }
        switch (portalMesTypeEnum.getValue()) {
            case 12: 
            case 17: {
                if (_isOrg) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(IS_ORG_COLNAME, (Object)"1"));
                    break;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(IS_ORG_COLNAME, (Object)"1", CompareType.NOTEQUALS));
                break;
            }
            case 10: {
                if (_isOrg) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)ORG_TAG));
                    break;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)ORG_TAG, CompareType.NOTEQUALS));
                break;
            }
            case 15: {
                if (_isOrg) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("target.evaObj.isOrg", (Object)"1"));
                    break;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("target.evaObj.isOrg", (Object)"1", CompareType.NOTEQUALS));
                break;
            }
            case 21: {
                if (_isOrg) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)ORG_TAG));
                    break;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)ORG_TAG, CompareType.NOTEQUALS));
                break;
            }
            case 11: {
                if (_isOrg) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("receiver.person", (Object)ORG_TAG));
                    break;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("receiver.person", (Object)ORG_TAG, CompareType.NOTEQUALS));
            }
        }
    }

    public static void setGiverOrFiller(Context ctx, List<HashMap<String, Object>> rows, Set<String> ids, String keyName) {
        if (rows == null || rows.size() < 1) {
            return;
        }
        if (StringUtils.isEmpty((String)keyName)) {
            keyName = "goalsGiver";
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj.id", ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("evaObj.unitGoalsStatus", (Object)1, CompareType.EQUALS));
        if ("goalsGiver".equals(keyName)) {
            filter.getFilterItems().add(new FilterItemInfo("isSelf", (Object)0, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isSelf", (Object)1, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("msgType", (Object)"0", CompareType.EQUALS));
        HashMap<String, String> goalGeivers = new HashMap<String, String>();
        HashMap<String, String> personNames = new HashMap<String, String>();
        HashSet<String> receivers = new HashSet<String>();
        try {
            IGoalsMessageReceiver igMReceiver = GoalsMessageReceiverFactory.getLocalInstance((Context)ctx);
            GoalsMessageReceiverCollection goalsMReceiverColl = igMReceiver.getGoalsMessageReceiverCollection("SELECT receiverName,receiver,evaObj.id  WHERE " + filter.toSql());
            for (int i = 0; i < goalsMReceiverColl.size(); ++i) {
                receivers.add(goalsMReceiverColl.get(i).getReceiver());
            }
            if (receivers.size() > 0) {
                int i;
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", receivers, CompareType.INCLUDE));
                PersonCollection persons = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select id,name where " + filter.toSql());
                for (i = 0; i < persons.size(); ++i) {
                    personNames.put(persons.get(i).getId().toString(), persons.get(i).getName());
                }
                for (i = 0; i < goalsMReceiverColl.size(); ++i) {
                    if (goalGeivers.get(goalsMReceiverColl.get(i).getEvaObj().getId().toString()) != null) {
                        String name = (String)goalGeivers.get(goalsMReceiverColl.get(i).getEvaObj().getId().toString()) + "," + (String)personNames.get(goalsMReceiverColl.get(i).getReceiver());
                        goalGeivers.put(goalsMReceiverColl.get(i).getEvaObj().getId().toString(), name);
                        continue;
                    }
                    goalGeivers.put(goalsMReceiverColl.get(i).getEvaObj().getId().toString(), (String)personNames.get(goalsMReceiverColl.get(i).getReceiver()));
                }
                for (HashMap<String, Object> mapRecord : rows) {
                    Map map = mapRecord;
                    String id = map.get("id").toString();
                    if (goalGeivers.get(id) == null) continue;
                    map.put(keyName, goalGeivers.get(id));
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
    }

    public static Map<String, String> getResponsorsMap(Context ctx, Set receiverSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", (Object)receiverSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("evaObj.id"));
        SorterItemCollection sortIC = new SorterItemCollection();
        SorterItemInfo evaObjSorter = new SorterItemInfo("evaObj.id");
        evaObjSorter.setSortType(SortType.ASCEND);
        sortIC.add(evaObjSorter);
        view.setSorter(sortIC);
        PerfEvaluAdminResponsorCollection coll = PerfEvaluAdminResponsorFactory.getLocalInstance((Context)ctx).getPerfEvaluAdminResponsorCollection(view);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            if (map.get(coll.get(i).getEvaObj().getId().toString()) != null) {
                map.put(coll.get(i).getEvaObj().getId().toString(), (String)map.get(coll.get(i).getEvaObj().getId().toString()) + "," + coll.get(i).getPerson().getName());
                continue;
            }
            map.put(coll.get(i).getEvaObj().getId().toString(), coll.get(i).getPerson().getName());
        }
        return map;
    }
}

