/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfDateUtils {
    private static Logger logger = LoggerFactory.getLogger(PerfDateUtils.class);
    public static final String TIME_SUFFIX = "00:00:00";
    public static final String TIME_ENDSUFFIX = "23:00:00";
    public static final String TIME_CURRENDSUFFIX = "23:59:59";
    public static final String SYS_EFFDT = "1900-01-01";
    public static final String SYS_LEFFDT = "2099-12-31";

    public static int compareDate(Date date) {
        Date now = new Date();
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date);
        c2.setTime(now);
        return c2.compareTo(c1);
    }

    public static int compareStrDate(String str1, String str2) {
        int compareValue = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            c1.setTime(sdf.parse(str1));
            c2.setTime(sdf.parse(str2));
        }
        catch (ParseException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        compareValue = c1.compareTo(c2);
        return compareValue;
    }

    public static int compareDate(Date d1, Date d2) {
        int compareValue = 0;
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        compareValue = c1.compareTo(c2);
        return compareValue;
    }

    public static Date strToDate(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.parse(date);
        }
        catch (ParseException e) {
            logger.error("ParseException: ", (Throwable)e);
            return null;
        }
    }

    public static Date formatDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date today = new Date();
        try {
            return sdf.parse(sdf.format(today));
        }
        catch (ParseException e) {
            logger.error("ParseException: ", (Throwable)e);
            return null;
        }
    }

    public String calculateDate(String dateType) {
        Date today = new Date();
        String rtnDate = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        if ("1".equals(dateType)) {
            calendar.setTime(today);
            calendar.add(5, -7);
            rtnDate = sdf.format(calendar.getTime());
        } else if ("2".equals(dateType)) {
            calendar.setTime(today);
            calendar.add(5, -14);
            rtnDate = sdf.format(calendar.getTime());
        } else if ("3".equals(dateType)) {
            calendar.setTime(today);
            calendar.add(2, -1);
            rtnDate = sdf.format(calendar.getTime());
        } else if ("4".equals(dateType)) {
            calendar.setTime(today);
            calendar.add(2, -2);
            rtnDate = sdf.format(calendar.getTime());
        } else if ("5".equals(dateType)) {
            calendar.setTime(today);
            calendar.add(2, -3);
            rtnDate = sdf.format(calendar.getTime());
        } else if ("6".equals(dateType)) {
            calendar.setTime(today);
            calendar.add(2, -6);
            rtnDate = sdf.format(calendar.getTime());
        } else if ("7".equals(dateType)) {
            calendar.setTime(today);
            calendar.add(1, -1);
            rtnDate = sdf.format(calendar.getTime());
        } else {
            rtnDate = sdf.format(today);
        }
        return rtnDate;
    }

    public static String formatDate(Object date, String format) {
        String defaultFormat = "yyyy-MM-dd";
        if (StringUtils.isEmpty((String)format)) {
            format = defaultFormat;
        }
        if (!StringUtils.isEmpty((String)format)) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(date);
        }
        return null;
    }

    public static String formatDateFromDate(Date date, String format) {
        String defaultFormat = "yyyy-MM-dd";
        if (StringUtils.isEmpty((String)format)) {
            format = defaultFormat;
        }
        if (!StringUtils.isEmpty((String)format)) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(date);
        }
        return null;
    }

    public static Date strToDateByFormat(String date, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(date);
        }
        catch (ParseException e) {
            logger.error("ParseException: ", (Throwable)e);
            return null;
        }
    }

    public static String dateLongToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return dateStr;
    }

    public static String dateShortToString(Date date) {
        String dateStr = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dateStr = sdf.format(date);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return dateStr;
    }

    public static Date timestampToDate(Timestamp temTimestamp) {
        Date date = new Date();
        try {
            date = temTimestamp;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return date;
    }

    public static Date getDateFirstTimeStamp(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return PerfDateUtils.getDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static Date getDateFirstTimeStamp(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(PerfDateUtils.timestampToDate(ts));
        return PerfDateUtils.getDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, 0, 0, 0);
        return PerfDateUtils.truncate(cal.getTime());
    }

    public static Date truncate(Date date) {
        date = new Date(date.getTime() / 1000L * 1000L);
        return date;
    }

    public static String getDateStr(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static int getRelativeYear(int relativeYear, int curYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(curYear, 0, 1);
        calendar.add(1, relativeYear);
        return calendar.get(1);
    }

    public static int getRelativeYearByGiveYear(int giveYear, int relativeYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(giveYear, 1, 1);
        calendar.add(1, relativeYear);
        return calendar.get(1);
    }
}

