/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsTransmitFacadeControllerBean;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.QuesCloudDataSyncFacadeControllerBean;
import com.kingdee.shr.perfweb.app.multiEvalution.commonTask.QuesCloudDataSyncFacadeFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MulitiPerfRelationReportFacadeControllerBean;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MulitiPerfRelationReportFacadeFactory;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GeneralTaskDealFacadeFactory;
import com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowFacadeControllerBean;
import com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowFacadeFactory;
import com.kingdee.shr.perfweb.job.PerfwebJobUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import com.kingdee.shr.perfweb.utils.TaskPoolUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PerfwebThreadPoolUtils {
    private static ScheduledThreadPoolExecutor schedulePool = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2);
    private static String TARGETFUTURE = "targetFuture";
    private static String EVATASKFUTURE = "evataskFuture";
    private static String MULTIEVATASKFUTURE = "multiEvataskFuture";
    private static String GETSCOREFUTURE = "getScoreFuture";
    private static String AUTOSCANGOALSFUTURE = "autoScanGoalsFuture";
    private static String ENDPERIODFUTURE = "endPeriodFuture";
    private static String SUBMITSCOREFUTURE = "submitScoreFuture";
    private static String CANCELENDFUTURE = "cancleEndFuture";
    private static String CREATEASIGNMENTPOOLFUTURE = "createAsignmentpoolFuture";
    private static String EVALUMSGTOYZJFUTURE = "evaluMsgToYzjFuture";
    private static String THREADCONTROLLERFUTURE = "threadControllerFuture";
    private static final String GENERALTASKCONTROLLERBEAN = "com.kingdee.shr.perfweb.app.workflow.GeneralTaskDealFacadeControllerBean";
    private static final String SENDEVALUMSGTOYZJ_METHODNAME = "sendEvaluTaskMessageToYzj";
    private static String CREATEMSWFUTURE = "createMultiScoreweightDetail";
    private static Map<String, ConcurrentHashMap<String, ScheduledFuture<?>>> futureMap = new ConcurrentHashMap();
    private static String mainInstance = System.getProperty("EAS_INSTANCE_NAME");
    private static Logger logger = LoggerFactory.getLogger(PerfwebThreadPoolUtils.class);
    public static ExecutorService perfSendUrgeMessExecutor = Executors.newFixedThreadPool(6);

    protected static boolean hasFuture(Context ctx, String futureType) {
        ScheduledFuture<?> yourFuture;
        ConcurrentHashMap<String, ScheduledFuture<?>> futureMp = futureMap.get(ctx.getAIS() + mainInstance);
        return !CollectionUtils.isEmpty(futureMp) && null != (yourFuture = futureMp.get(futureType)) && !yourFuture.isCancelled();
    }

    protected static void setFuture(Context ctx, String futureType, ScheduledFuture<?> future) {
        ConcurrentHashMap<String, ScheduledFuture<?>> futureMp = futureMap.get(ctx.getAIS() + mainInstance);
        if (!CollectionUtils.isEmpty(futureMp)) {
            futureMp.put(futureType, future);
        } else {
            ConcurrentHashMap fuMap = new ConcurrentHashMap();
            fuMap.put(futureType, future);
            futureMap.put(ctx.getAIS() + mainInstance, fuMap);
        }
    }

    protected static void cancleFuture(Context ctx, String futureType) {
        ScheduledFuture<?> yourFuture;
        ConcurrentHashMap<String, ScheduledFuture<?>> futureMp = futureMap.get(ctx.getAIS() + mainInstance);
        if (!CollectionUtils.isEmpty(futureMp) && null != (yourFuture = futureMp.get(futureType)) && !yourFuture.isCancelled()) {
            yourFuture.cancel(true);
        }
    }

    public static void autoScanGoalsTaskPool(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, AUTOSCANGOALSFUTURE)) {
            int frequecy = 30;
            String paramVal = TaskPoolUtils.getParamVal(ctx, AUTOSCANGOALSFUTURE, "F100");
            if (!StringUtils.isEmpty((CharSequence)paramVal)) {
                frequecy = Integer.valueOf(paramVal);
            }
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> autoScanGoalsFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.currentThread().isInterrupted() && !PerfwebThreadPoolUtils.noGoalspoolTask(ctx)) {
                        try {
                            GoalsTransmitFacadeControllerBean.getInstance().autoScanGoalsTaskPool(ctx);
                            GoalsTransmitFacadeControllerBean.getInstance().createTargetInstance(ctx);
                        }
                        catch (BOSException e) {
                            logger.error("BOSException: ", (Throwable)e);
                        }
                        catch (EASBizException e) {
                            logger.error("EASBizException: ", (Throwable)e);
                        }
                    } else {
                        PerfwebThreadPoolUtils.cancleFuture(ctx, AUTOSCANGOALSFUTURE);
                        executor.shutdown();
                    }
                }
            }, 1L, frequecy, TimeUnit.SECONDS);
            PerfwebThreadPoolUtils.setFuture(ctx, AUTOSCANGOALSFUTURE, autoScanGoalsFuture);
        }
    }

    public static void targetTransmit(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, TARGETFUTURE)) {
            int frequecy = 30;
            String paramVal = TaskPoolUtils.getParamVal(ctx, TARGETFUTURE, "F101");
            if (!StringUtils.isEmpty((CharSequence)paramVal)) {
                frequecy = Integer.valueOf(paramVal);
            }
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> targetFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.currentThread().isInterrupted() && !PerfwebThreadPoolUtils.noTargetTransmitTask(ctx)) {
                        try {
                            GoalsTransmitFacadeControllerBean.getInstance().createTargetInstance(ctx);
                        }
                        catch (Exception e) {
                            logger.error("Exception: ", (Throwable)e);
                        }
                    } else {
                        PerfwebThreadPoolUtils.cancleFuture(ctx, TARGETFUTURE);
                        executor.shutdown();
                    }
                }
            }, 1L, frequecy, TimeUnit.SECONDS);
            PerfwebThreadPoolUtils.setFuture(ctx, TARGETFUTURE, targetFuture);
        }
    }

    public static void startTimingCreateAsignmentpoolTask(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, CREATEASIGNMENTPOOLFUTURE)) {
            int frequecy = 30;
            String paramVal = TaskPoolUtils.getParamVal(ctx, CREATEASIGNMENTPOOLFUTURE, "F102");
            if (!StringUtils.isEmpty((CharSequence)paramVal)) {
                frequecy = Integer.valueOf(paramVal);
            }
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> createAsignmentPoolFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.currentThread().isInterrupted() && PerfwebThreadPoolUtils.hasTimingTask(ctx)) {
                        try {
                            PerfWorkFlowFacadeControllerBean.getInstance().timingTaskScan(ctx);
                        }
                        catch (BOSException e) {
                            logger.error("BOSException: ", (Throwable)e);
                        }
                    } else {
                        PerfwebThreadPoolUtils.cancleFuture(ctx, CREATEASIGNMENTPOOLFUTURE);
                        executor.shutdown();
                    }
                }
            }, 1L, frequecy, TimeUnit.MINUTES);
            PerfwebThreadPoolUtils.setFuture(ctx, CREATEASIGNMENTPOOLFUTURE, createAsignmentPoolFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasTimingTask(Context ctx) {
        Connection conn = null;
        IRowSet rowset = null;
        try {
            Date now = new Date();
            String nowStr = PerfDateUtils.formatDate(now, "yyyy-MM-dd HH:mm:ss");
            String selectRows = TaskPoolUtils.getParamVal(ctx, "ROWS", "20");
            int handleRows = 100;
            if (!StringUtils.isEmpty((CharSequence)selectRows)) {
                handleRows = Integer.parseInt(selectRows.trim());
            }
            String sql = "SELECT TOP " + handleRows + " o.FID,o.FPeriodID FROM T_EVA_PerfEvaObject o INNER JOIN T_EVA_GoalsTaskPool p ON o.FID=p.FEVAOBJ INNER JOIN T_EVA_GoalsMessage g ON g.FTASKID = p.FID  WHERE o.FScoreTaskStatus='" + "100" + "' AND o.FSendTiming IS NOT NULL AND g.FHANDLESTATUS = '1'";
            conn = EJBFactory.getConnection((Context)ctx);
            sql = new PagingHelper().getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), sql, 0, handleRows);
            rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (null != rowset && rowset.next()) {
                boolean bl = true;
                SQLUtils.cleanup((ResultSet)rowset, null, (Connection)conn);
                return bl;
            }
            SQLUtils.cleanup((ResultSet)rowset, null, (Connection)conn);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup(rowset, null, conn);
        }
        return false;
    }

    public static void startEvatask(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, EVATASKFUTURE)) {
            int frequecy = 30;
            String paramVal = TaskPoolUtils.getParamVal(ctx, EVATASKFUTURE, "F103");
            if (!StringUtils.isEmpty((CharSequence)paramVal)) {
                frequecy = Integer.valueOf(paramVal);
            }
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> evataskFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.currentThread().isInterrupted() && !PerfwebThreadPoolUtils.noStartEvaTask(ctx)) {
                        try {
                            PerfWorkFlowFacadeFactory.getLocalInstance((Context)ctx).scanAsignmentPool();
                        }
                        catch (BOSException e) {
                            logger.error("BOSException: ", (Throwable)e);
                        }
                    } else {
                        PerfwebThreadPoolUtils.cancleFuture(ctx, EVATASKFUTURE);
                        executor.shutdown();
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
            PerfwebThreadPoolUtils.setFuture(ctx, EVATASKFUTURE, evataskFuture);
        }
    }

    public static void startMultiEvatask(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, MULTIEVATASKFUTURE)) {
            int frequecy = 30;
            String paramVal = TaskPoolUtils.getParamVal(ctx, MULTIEVATASKFUTURE, "F104");
            if (!StringUtils.isEmpty((CharSequence)paramVal)) {
                frequecy = Integer.valueOf(paramVal);
            }
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> multiEvataskFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.currentThread().isInterrupted() && !PerfwebThreadPoolUtils.noMultiEvaTask(ctx)) {
                        try {
                            QuesCloudDataSyncFacadeControllerBean.getInstance().sendMultiEvaTask(ctx);
                        }
                        catch (BOSException e) {
                            logger.error("BOSException: ", (Throwable)e);
                        }
                    } else {
                        PerfwebThreadPoolUtils.cancleFuture(ctx, MULTIEVATASKFUTURE);
                        executor.shutdown();
                    }
                }
            }, 1L, frequecy, TimeUnit.SECONDS);
            PerfwebThreadPoolUtils.setFuture(ctx, MULTIEVATASKFUTURE, multiEvataskFuture);
        }
    }

    public static void startGetQuesScoretask(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, GETSCOREFUTURE)) {
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> getScoreFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        QuesCloudDataSyncFacadeFactory.getLocalInstance((Context)ctx).sendMultiEvaTask();
                    }
                    catch (BOSException e1) {
                        logger.error("", (Throwable)e1);
                    }
                }
            }, 1L, 30L, TimeUnit.SECONDS);
            PerfwebThreadPoolUtils.setFuture(ctx, GETSCOREFUTURE, getScoreFuture);
        }
    }

    public static void startCreateMultiScoreweightDetail(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, CREATEMSWFUTURE)) {
            int frequecy = 20;
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> createMswFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.currentThread().isInterrupted() && !PerfwebThreadPoolUtils.noCreateMultiSummaryScoreDetailTask(ctx)) {
                        try {
                            GeneralTaskDealFacadeFactory.getLocalInstance((Context)ctx).createMultiScoreweightDetail();
                        }
                        catch (BOSException e) {
                            logger.error("BOSException: ", (Throwable)e);
                        }
                    } else {
                        PerfwebThreadPoolUtils.cancleFuture(ctx, CREATEMSWFUTURE);
                        executor.shutdown();
                    }
                }
            }, 1L, frequecy, TimeUnit.SECONDS);
            PerfwebThreadPoolUtils.setFuture(ctx, CREATEMSWFUTURE, createMswFuture);
        }
    }

    public static void startEndPeriodtask(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, ENDPERIODFUTURE)) {
            int frequecy = 60;
            String paramVal = TaskPoolUtils.getParamVal(ctx, ENDPERIODFUTURE, "F105");
            if (!StringUtils.isEmpty((CharSequence)paramVal)) {
                frequecy = Integer.valueOf(paramVal);
            }
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> endPeriodFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.currentThread().isInterrupted() && !PerfwebThreadPoolUtils.noEndPeriodTask(ctx)) {
                        try {
                            GeneralTaskDealFacadeFactory.getLocalInstance((Context)ctx).scanEndPeriodTask();
                        }
                        catch (BOSException e) {
                            logger.error("BOSException: ", (Throwable)e);
                        }
                    } else {
                        PerfwebThreadPoolUtils.cancleFuture(ctx, ENDPERIODFUTURE);
                        executor.shutdown();
                    }
                }
            }, 1L, frequecy, TimeUnit.SECONDS);
            PerfwebThreadPoolUtils.setFuture(ctx, ENDPERIODFUTURE, endPeriodFuture);
        }
    }

    public static void startCancleEndPeriodtask(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, CANCELENDFUTURE)) {
            int frequecy = 30;
            String paramVal = TaskPoolUtils.getParamVal(ctx, CANCELENDFUTURE, "F106");
            if (!StringUtils.isEmpty((CharSequence)paramVal)) {
                frequecy = Integer.valueOf(paramVal);
            }
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> cancleEndFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.currentThread().isInterrupted() && !PerfwebThreadPoolUtils.noCancleEndPeriodTask(ctx)) {
                        try {
                            GeneralTaskDealFacadeFactory.getLocalInstance((Context)ctx).scanCancelEndPeriodTask();
                        }
                        catch (BOSException e) {
                            logger.error("BOSException: ", (Throwable)e);
                        }
                    } else {
                        PerfwebThreadPoolUtils.cancleFuture(ctx, CANCELENDFUTURE);
                        executor.shutdown();
                    }
                }
            }, 1L, frequecy, TimeUnit.SECONDS);
            PerfwebThreadPoolUtils.setFuture(ctx, CANCELENDFUTURE, cancleEndFuture);
        }
    }

    public static void startMultiEvaReportTask(Context ctx, String evaObjIds) {
        try {
            MulitiPerfRelationReportFacadeFactory.getLocalInstance((Context)ctx).createReportDetailByEvaObjs(evaObjIds);
        }
        catch (Exception e2) {
            logger.error("", (Throwable)e2);
        }
    }

    public static void startMultiEvaSendTask(Context ctx, String evaObjIds, String sendType, String batchNumber) {
        try {
            MulitiPerfRelationReportFacadeControllerBean.createMultiEvaTasks((Context)ctx, (String)evaObjIds, (String)sendType, (String)batchNumber);
        }
        catch (Exception e2) {
            logger.error("", (Throwable)e2);
        }
    }

    public static void startMultiEvaResendTask(Context ctx, String evaObjIds, String sendType) {
        try {
            MulitiPerfRelationReportFacadeFactory.getLocalInstance((Context)ctx).reSendMultiEvaTaskByEvaObj(evaObjIds, sendType);
        }
        catch (Exception e2) {
            logger.error("", (Throwable)e2);
        }
    }

    public static void startMultiEvaEndTask(Context ctx, String evaObjIds) {
        try {
            MulitiPerfRelationReportFacadeFactory.getLocalInstance((Context)ctx).endMultiEvaTaskProcess(evaObjIds);
        }
        catch (Exception e2) {
            logger.error("", (Throwable)e2);
        }
    }

    public static void startMultiEvaInvalidLoginUrlTask(Context ctx, String taskIds, String newTaskIds) {
        try {
            new MulitiPerfRelationReportFacadeControllerBean().asyncInvalidQuestionnaireLoginurl(ctx, taskIds, newTaskIds);
        }
        catch (Exception e2) {
            logger.error("", (Throwable)e2);
        }
    }

    public static void startThreadController(final Context ctx) {
        PerfwebThreadPoolUtils.startTimingCreateAsignmentpoolTask(ctx);
        if (PerfwebThreadPoolUtils.noMultiEvaTask(ctx)) {
            PerfwebThreadPoolUtils.cancleFuture(ctx, MULTIEVATASKFUTURE);
        } else {
            PerfwebThreadPoolUtils.startMultiEvatask(ctx);
        }
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, THREADCONTROLLERFUTURE)) {
            ScheduledFuture<?> threadControllerFuture = schedulePool.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (PerfwebThreadPoolUtils.noGoalspoolTask(ctx)) {
                            PerfwebThreadPoolUtils.cancleFuture(ctx, AUTOSCANGOALSFUTURE);
                            if (PerfwebThreadPoolUtils.noTargetTransmitTask(ctx)) {
                                PerfwebThreadPoolUtils.cancleFuture(ctx, TARGETFUTURE);
                            } else {
                                PerfwebThreadPoolUtils.targetTransmit(ctx);
                            }
                        } else {
                            PerfwebThreadPoolUtils.autoScanGoalsTaskPool(ctx);
                        }
                        if (PerfwebThreadPoolUtils.noStartEvaTask(ctx)) {
                            PerfwebThreadPoolUtils.cancleFuture(ctx, EVATASKFUTURE);
                        } else {
                            PerfwebThreadPoolUtils.startEvatask(ctx);
                        }
                    }
                    catch (Exception e1) {
                        logger.error("", (Throwable)e1);
                    }
                }
            }, 1L, 3L, TimeUnit.MINUTES);
            PerfwebThreadPoolUtils.setFuture(ctx, THREADCONTROLLERFUTURE, threadControllerFuture);
        }
    }

    public static void submitScore(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, SUBMITSCOREFUTURE)) {
            int frequecy = 10;
            String paramVal = TaskPoolUtils.getParamVal(ctx, EVATASKFUTURE, "F103");
            if (!StringUtils.isEmpty((CharSequence)paramVal)) {
                frequecy = Integer.valueOf(paramVal);
            }
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> submitScoreFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!Thread.currentThread().isInterrupted() && !PerfwebThreadPoolUtils.noSubmitScoreTask(ctx)) {
                        try {
                            GeneralTaskDealFacadeFactory.getLocalInstance((Context)ctx).submitPerfscore();
                        }
                        catch (BOSException e) {
                            logger.error("BOSException: ", (Throwable)e);
                        }
                    } else {
                        PerfwebThreadPoolUtils.cancleFuture(ctx, SUBMITSCOREFUTURE);
                        executor.shutdownNow();
                    }
                }
            }, 1L, 1L, TimeUnit.SECONDS);
            PerfwebThreadPoolUtils.setFuture(ctx, SUBMITSCOREFUTURE, submitScoreFuture);
        }
    }

    private static boolean noTargetTransmitTask(Context ctx) {
        try {
            String targetTransmitSql = "SELECT COUNT(1) FROM T_EVA_GoalsMessage WHERE FHandleStatus='0' AND FMsgType='0' AND FIsAlreadyDeal=0";
            IRowSet rowset2 = DbUtil.executeQuery((Context)ctx, (String)targetTransmitSql);
            return rowset2.next() && rowset2.getInt(1) < 1;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }

    private static boolean noGoalspoolTask(Context ctx) {
        try {
            String goalsMessageSql = "SELECT COUNT(1) from T_EVA_GoalsTaskPool WHERE FTaskStatus='0'";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)goalsMessageSql);
            return rowset.next() && rowset.getInt(1) < 1;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }

    private static boolean noStartEvaTask(Context ctx) {
        try {
            String evataskFutureSql = "SELECT COUNT(1) FROM T_EVA_AsignmentPool WHERE FIsCreateInst='0' and FTaskLock=0 and FExecuteCount<1";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)evataskFutureSql);
            return rowset.next() && rowset.getInt(1) < 1;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }

    private static boolean noMultiEvaTask(Context ctx) {
        try {
            String startMultiEvataskFutureSql = "SELECT COUNT(1) from T_EVA_MultiEvaTask e inner join T_EVA_MultiPerfEvaObject o on e.FBusinessId=o.FID where e.FIsEffect='1' and FStatus in ('0','1') and o.FPaperStatus='200' and FReceiver is not null and FShortUrl is null";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)startMultiEvataskFutureSql);
            return rowset.next() && rowset.getInt(1) < 1;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }

    private static boolean noEndPeriodTask(Context ctx) {
        try {
            StringBuffer sqlBuffer = new StringBuffer("SELECT COUNT(1) ");
            sqlBuffer.append(" FROM T_EVA_GeneralTaskPool WHERE FDealStatus='").append("0").append("' and FIsAlreadyDeal='").append("0").append("' and FLock='").append("0").append("' and FBusinessType='").append("101").append("'");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            return rowset.next() && rowset.getInt(1) < 1;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }

    private static boolean noCreateMultiSummaryScoreDetailTask(Context ctx) {
        try {
            StringBuffer sqlBuffer = new StringBuffer("SELECT COUNT(1) ");
            sqlBuffer.append(" FROM T_EVA_GeneralTaskPool WHERE FDealStatus='").append("0").append("' and FIsAlreadyDeal='").append("0").append("' and FLock='").append("0").append("' and FBusinessType='").append("900").append("'");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            return rowset.next() && rowset.getInt(1) < 1;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }

    private static boolean noSubmitScoreTask(Context ctx) {
        try {
            StringBuffer sqlBuffer = new StringBuffer("SELECT COUNT(1) ");
            sqlBuffer.append(" FROM T_EVA_GeneralTaskPool WHERE FDealStatus='").append("0").append("' and FIsAlreadyDeal='").append("0").append("' and FLock='").append("0").append("' and FBusinessType='").append("800").append("'");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            return rowset.next() && rowset.getInt(1) < 1;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }

    private static boolean noCancleEndPeriodTask(Context ctx) {
        try {
            StringBuffer sqlBuffer = new StringBuffer("SELECT COUNT(1) ");
            sqlBuffer.append(" FROM T_EVA_GeneralTaskPool WHERE FDealStatus='").append("0").append("' and FIsAlreadyDeal='").append("0").append("' and FLock='").append("0").append("' and FBusinessType='").append("102").append("'");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            return rowset.next() && rowset.getInt(1) < 1;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }

    public static void startEvaluMsgToYzjTask(final Context ctx) {
        if (!PerfwebThreadPoolUtils.hasFuture(ctx, EVALUMSGTOYZJFUTURE)) {
            int frequecy = 300;
            String paramVal = TaskPoolUtils.getParamVal(ctx, EVALUMSGTOYZJFUTURE, "F108");
            if (!StringUtils.isEmpty((CharSequence)paramVal)) {
                frequecy = Integer.valueOf(paramVal);
            }
            final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> evaluMsgToYzjFuture = executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!PerfwebThreadPoolUtils.noYzjTask(ctx)) {
                        try {
                            Object[] params = new Object[]{};
                            PerfwebJobUtils.createJobinstImmediateRun(ctx, SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SCORETASKSENDYZJMESSAGE, ctx), PerfwebThreadPoolUtils.GENERALTASKCONTROLLERBEAN, PerfwebThreadPoolUtils.SENDEVALUMSGTOYZJ_METHODNAME, params);
                        }
                        catch (BOSException e1) {
                            logger.error("", (Throwable)e1);
                            try {
                                GeneralTaskDealFacadeFactory.getLocalInstance((Context)ctx).sendEvaluTaskMessageToYzj();
                            }
                            catch (BOSException e) {
                                logger.error("BOSException: ", (Throwable)e);
                            }
                        }
                    } else {
                        PerfwebThreadPoolUtils.cancleFuture(ctx, EVALUMSGTOYZJFUTURE);
                        executor.shutdown();
                    }
                }
            }, 5L, frequecy, TimeUnit.SECONDS);
            PerfwebThreadPoolUtils.setFuture(ctx, EVALUMSGTOYZJFUTURE, evaluMsgToYzjFuture);
        }
    }

    private static boolean noYzjTask(Context ctx) {
        try {
            StringBuffer sqlBuffer = new StringBuffer("SELECT COUNT(1) ");
            sqlBuffer.append("FROM T_EVA_GeneralTaskPool WHERE FDealStatus='").append("0").append("' and FIsAlreadyDeal='").append("0").append("' and FLock='").append("0").append("' and FBusinessType in ('").append("300").append("','").append("500").append("')");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            return rowset.next() && rowset.getInt(1) < 1;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
    }
}

