/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.org.IJobGrade;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfPeriod;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfPlan;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonBaseOfGoalsInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaFormFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaFormFieldConf;
import com.kingdee.shr.perfweb.app.base.evalrule.IEvaluFormAreaBase;
import com.kingdee.shr.perfweb.app.base.evalrule.IPerformanceRule;
import com.kingdee.shr.perfweb.app.base.evalrule.IPersonBaseFieldConf;
import com.kingdee.shr.perfweb.app.base.evalrule.IRecordFieldConf;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PersonBaseFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PersonBaseFieldConfFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PersonBaseFieldConfInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.RecordFieldConfFactory;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import com.kingdee.shr.perfweb.utils.PersonBaseOfGoalsUtils;
import com.kingdee.shr.perfweb.utils.PhotoUtils;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonBaseUtils {
    static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.PersonBaseUtils");

    public static ArrayList<HashMap<String, Object>> getPersonBaseFileds(Context ctx, String periodId) throws BOSException, EASBizException {
        ArrayList<HashMap<String, Object>> fieldList = new ArrayList<HashMap<String, Object>>();
        IPerfPeriod iperfPeriod = PerfPeriodFactory.getLocalInstance((Context)ctx);
        PerfPeriodInfo perfPeriodInfo = iperfPeriod.getPerfPeriodInfo(" where id='" + periodId + "'");
        IPerformanceRule iperfRule = PerformanceRuleFactory.getLocalInstance((Context)ctx);
        PerformanceRuleInfo perfRuleInfo = iperfRule.getPerformanceRuleInfo(" where id='" + perfPeriodInfo.getPerfRule().getId().toString() + "'");
        IEvaluFormAreaBase iEvaFABase = EvaluFormAreaBaseFactory.getLocalInstance((Context)ctx);
        EvaluFormAreaBaseInfo evaFABInfo = iEvaFABase.getEvaluFormAreaBaseInfo(" where performanceRule='" + perfRuleInfo.getId().toString() + "' and areaType='" + "100" + "'");
        IPersonBaseFieldConf ipersonBaseFieldConf = PersonBaseFieldConfFactory.getLocalInstance((Context)ctx);
        PersonBaseFieldConfCollection personBaseFieldColl = ipersonBaseFieldConf.getPersonBaseFieldConfCollection(" where areaBase='" + evaFABInfo.getId().toString() + "' order by seqNo ASC");
        if (personBaseFieldColl != null && personBaseFieldColl.size() > 0) {
            for (int i = 0; i < personBaseFieldColl.size(); ++i) {
                PersonBaseFieldConfInfo personBFConfInfo = personBaseFieldColl.get(i);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("colName", personBFConfInfo.getColName());
                map.put("showName", personBFConfInfo.getShowName());
                map.put("seqNo", personBFConfInfo.getSeqNo());
                fieldList.add(map);
            }
        }
        return fieldList;
    }

    public static String getPersonBaseData(Context ctx, HttpServletRequest request, HttpServletResponse response) throws BOSException, SQLException, EASBizException, EASBizException, IOException {
        String json = "";
        String evaObj = request.getParameter("evaObj");
        String periodId = request.getParameter("periodId");
        ArrayList<HashMap<String, Object>> fieldConfList = PersonBaseUtils.getPersonBaseFileds(ctx, periodId);
        PerfEvaObjectInfo evaObjectInfo = PersonBaseUtils.getPerfEvaObjInfo(ctx, evaObj);
        String personId = evaObjectInfo.getPerson().getId().toString();
        PersonBaseOfGoalsInfo personBaseInfo = null;
        try {
            personBaseInfo = PersonBaseOfGoalsUtils.fillPersonBaseOfGoalsInfo(ctx, evaObj, personId, periodId, evaObjectInfo.getBelongGroup());
        }
        catch (ParserException e) {
            logger.error("update personBaseOfGoalsInfo failed...", (Throwable)e);
        }
        PerfEvaObjectInfo evaObjInfo = evaObjectInfo;
        EntityObjectInfo personBaseEntity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)"com.kingdee.shr.perfweb.app.base.evalplan.PersonBaseOfGoals"));
        JobInfo job = evaObjInfo.getPerfFile().getPosition().getJob();
        if (personBaseInfo != null) {
            for (HashMap<String, Object> map : fieldConfList) {
                String colName = (String)map.get("colName");
                PropertyInfo propertyInfo = personBaseEntity.getPropInfoByColumnName(colName);
                Object value = null;
                if (propertyInfo != null) {
                    value = personBaseInfo.get(propertyInfo.getName());
                }
                if (colName.equals("yourCustomField")) {
                    String yourCustomFieldValue = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.label946, ctx);
                    map.put("colNameVal", yourCustomFieldValue);
                    continue;
                }
                if (colName.equals("FBELONGORG")) {
                    String orgName = evaObjInfo.getPerfFile().getAdminOrgUnit().getName();
                    if (StringUtils.isEmpty((String)orgName)) continue;
                    map.put("colNameVal", orgName);
                    continue;
                }
                if (colName.equals("FCOMPANY")) {
                    IAdminOrgUnit iadminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitInfo adminOrgInfo = iadminOrg.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(evaObjInfo.getPerfFile().getAdminOrgUnit().getId()));
                    if (adminOrgInfo == null || adminOrgInfo.getCompany() == null) continue;
                    AdminOrgUnitInfo adminOrgInfo2 = iadminOrg.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgInfo.getCompany().getId()));
                    String companyName = "";
                    if (adminOrgInfo2 != null) {
                        companyName = adminOrgInfo2.getName();
                    }
                    map.put("colNameVal", companyName == null ? "" : companyName);
                    continue;
                }
                if (colName.equals("FJOB")) {
                    if (job == null) continue;
                    String jobName = job.getName();
                    map.put("colNameVal", jobName);
                    continue;
                }
                if (colName.equals("FPHOTOID")) {
                    request.setAttribute("personId", (Object)evaObjectInfo.getPerson().getId().toString());
                    request.setAttribute("personNumber", (Object)evaObjectInfo.getNumber());
                    String imgPath = PhotoUtils.showCutImage(request, response);
                    map.put("colNameVal", imgPath);
                    continue;
                }
                if (colName.equals("FPNUMBER")) {
                    map.put("colNameVal", evaObjInfo.getPerson().getNumber());
                    continue;
                }
                if (colName.equals("FEMPLOYEETYPEID")) {
                    String employeeTypeId = (String)personBaseInfo.get("employeeType");
                    if (StringUtils.isEmpty((String)employeeTypeId)) continue;
                    EmployeeTypeInfo employeeTypeInfo = GetEntityInfoUtils.getEmployeeTypeInfo(ctx, employeeTypeId);
                    map.put("colNameVal", employeeTypeInfo.getName());
                    continue;
                }
                if (colName.equals("FPOSITIONID")) {
                    String positonName = evaObjInfo.getPerfFile().getPosition().getName();
                    map.put("colNameVal", positonName);
                    continue;
                }
                if (colName.equals("FJOBGRADEID")) {
                    String jobGradeId = (String)personBaseInfo.get("jobGrade");
                    if (!StringUtils.isEmpty((String)jobGradeId)) {
                        IJobGrade ijobGrade = JobGradeFactory.getLocalInstance((Context)ctx);
                        JobGradeCollection jobGradeColl = ijobGrade.getJobGradeCollection(" where id='" + jobGradeId + "'");
                        if (jobGradeColl == null || jobGradeColl.size() <= 0) continue;
                        JobGradeInfo jobGradeInfo = jobGradeColl.get(0);
                        map.put("colNameVal", jobGradeInfo.getName());
                        continue;
                    }
                    map.put("colNameVal", "");
                    continue;
                }
                if (colName.equals("FISKEYSTAFF")) {
                    String isKeyStaff = personBaseInfo.getIsKeyStaff();
                    map.put("colNameVal", isKeyStaff != null && isKeyStaff.equals("1") ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YES, ctx) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NO, ctx));
                    continue;
                }
                if (colName.equals("FISINCHARGELEADER")) {
                    String isInChargeLeader = personBaseInfo.getIsInChargeLeader();
                    map.put("colNameVal", isInChargeLeader != null && isInChargeLeader.equals("1") ? SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YES, ctx) : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.NO, ctx));
                    continue;
                }
                if (colName.equals("FAGE")) {
                    map.put("colNameVal", PersonBaseOfGoalsUtils.getPersonAge(ctx, personId));
                    continue;
                }
                if (colName.equals("FADJUSTGROUPDATE") || colName.equals("FADJUSTCOMPANYDATE") || colName.equals("FADJUSTWORKDATE")) {
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setGroupingUsed(false);
                    nf.setMaximumFractionDigits(3);
                    nf.setMinimumFractionDigits(1);
                    map.put("colNameVal", value == null ? "" : nf.format(value));
                    continue;
                }
                if (colName.equals("FENTERYDATE") || colName.equals("FJOINCOMPANYDATE") || colName.equals("FJOINWORKDATE") || colName.equals("FJOINGROUPDATE") || colName.equals("FTAKEINMANDATE") || colName.equals("FCONVERSIONDATE")) {
                    map.put("colNameVal", value == null ? "" : PerfDateUtils.formatDate(value, "yyyy-MM-dd"));
                    continue;
                }
                map.put("colNameVal", value);
            }
        }
        Gson gson = new Gson();
        json = gson.toJson(fieldConfList);
        return json;
    }

    public static PerfEvaObjectInfo getPerfEvaObjInfo(Context ctx, String evaObj) throws BOSException, EASBizException {
        PerfEvaObjectInfo evaObjInfo = null;
        IPerfEvaObject iperfEvaObj = PerfEvaObjectFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evaObj, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("perfFile.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("perfFile.position.name"));
        sic.add(new SelectorItemInfo("perfFile.position.job.name"));
        sic.add(new SelectorItemInfo("period.id"));
        evi.setSelector(sic);
        evi.setFilter(filterInfo);
        PerfEvaObjectCollection evaObjectColl = iperfEvaObj.getPerfEvaObjectCollection(evi);
        if (evaObjectColl != null && evaObjectColl.size() > 0) {
            evaObjInfo = evaObjectColl.get(0);
        }
        return evaObjInfo;
    }

    public static PerfPeriodInfo getPerfPeriodInfo(Context ctx, String periodId) throws BOSException, EASBizException {
        PerfPeriodInfo periodInfo = null;
        IPerfPeriod iperfPeriod = PerfPeriodFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)periodId, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("perfRule.scoringWay");
        evi.setSelector(selectorItemCollection);
        PerfPeriodCollection periodColl = iperfPeriod.getPerfPeriodCollection(evi);
        if (periodColl != null && periodColl.size() > 0) {
            periodInfo = periodColl.get(0);
        }
        return periodInfo;
    }

    public static PerfPlanInfo getPerfPlanInfo(Context ctx, String planId) throws BOSException, EASBizException {
        PerfPlanInfo planInfo = new PerfPlanInfo();
        IPerfPlan iplan = PerfPlanFactory.getLocalInstance((Context)ctx);
        planInfo = iplan.getPerfPlanInfo("select *,perfrule.name,perfModel.name where id='" + planId + "'");
        return planInfo;
    }

    public static EvaFormFieldConfCollection getEvaFormFieldColl(Context ctx, String areaBaseId) throws BOSException, EASBizException {
        EvaFormFieldConfCollection evaFormFieldColl = null;
        IEvaFormFieldConf ievaFormFieldConf = EvaFormFieldConfFactory.getLocalInstance((Context)ctx);
        evaFormFieldColl = ievaFormFieldConf.getEvaFormFieldConfCollection(" where areaBase='" + areaBaseId + "' order by seqNo ASC");
        return evaFormFieldColl;
    }

    public static boolean getEvaFormFieldContainField(Context ctx, String areaBaseId, String colName) throws BOSException, EASBizException {
        EvaFormFieldConfCollection evaFormFieldColl = null;
        IEvaFormFieldConf ievaFormFieldConf = EvaFormFieldConfFactory.getLocalInstance((Context)ctx);
        evaFormFieldColl = ievaFormFieldConf.getEvaFormFieldConfCollection(" where areaBase='" + areaBaseId + "'  and colName ='" + colName + "'");
        return evaFormFieldColl.size() > 0;
    }

    public static RecordFieldConfCollection getRecordFieldColl(Context ctx, String areaBaseId) throws BOSException, EASBizException {
        RecordFieldConfCollection recordFieldColl = null;
        IRecordFieldConf irecordFieldConf = RecordFieldConfFactory.getLocalInstance((Context)ctx);
        recordFieldColl = irecordFieldConf.getRecordFieldConfCollection(" where areaBase='" + areaBaseId + "' order by seqNo ASC");
        return recordFieldColl;
    }

    public static boolean getRecordFieldContainField(Context ctx, String areaBaseId, String colName) throws BOSException, EASBizException {
        RecordFieldConfCollection recordFieldColl = null;
        IRecordFieldConf irecordFieldConf = RecordFieldConfFactory.getLocalInstance((Context)ctx);
        recordFieldColl = irecordFieldConf.getRecordFieldConfCollection(" where areaBase='" + areaBaseId + "'  and colName ='" + colName + "'");
        return recordFieldColl.size() > 0;
    }

    public static EvaluFormAreaBaseCollection getEvaluFormAreaBaseColl(Context ctx, String evaObj) throws BOSException, EASBizException {
        EvaluFormAreaBaseCollection areaBaseColl = null;
        IEvaluFormAreaBase ievaFormAreaBase = EvaluFormAreaBaseFactory.getLocalInstance((Context)ctx);
        PerfEvaObjectInfo perfEvaObjInfo = PersonBaseUtils.getPerfEvaObjInfo(ctx, evaObj);
        if (perfEvaObjInfo == null || perfEvaObjInfo.getPeriod() == null) {
            return null;
        }
        PerfPeriodInfo periodInfo = PersonBaseUtils.getPerfPeriodInfo(ctx, perfEvaObjInfo.getPeriod().getId().toString());
        areaBaseColl = ievaFormAreaBase.getEvaluFormAreaBaseCollection(" where performanceRule='" + periodInfo.getPerfRule().getId().toString() + "' and areaType not in('" + "100" + "','" + "400" + "') order by seq ASC");
        return areaBaseColl;
    }

    public static String getPositonByPersonId(Context ctx, String person) {
        String positionName = "";
        Date now = new Date();
        String currentDate = PerfDateUtils.formatDate(now, "yyyy-MM-dd");
        try {
            IPosition iperson = PositionFactory.getLocalInstance((Context)ctx);
            String sql = "select FPositionID from T_HR_EmpOrgRelation where FPersonID='" + person + "' and FAssignType=" + 1 + " and FEFFDT<={ts'" + currentDate + "'} and FLEFFDT>={ts'" + currentDate + "'}";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                String postion = rs.getString("FPositionID");
                PositionCollection positionColl = iperson.getPositionCollection("where id='" + postion + "'");
                if (positionColl != null && positionColl.size() > 0) {
                    positionName = positionColl.get(0).getName();
                }
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB-\u3011GETPERSONPRIMARYPOSITIONERRDETAIL:" + e.getMessage());
        }
        return positionName;
    }

    public static Map<String, PositionInfo> getPersonPosition(Context ctx, Set<String> personIds) {
        HashMap res = Maps.newHashMap();
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo memberFilterInfo = new FilterInfo();
            memberFilterInfo.getFilterItems().add(new FilterItemInfo("person", personIds, CompareType.INCLUDE));
            memberFilterInfo.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1, CompareType.EQUALS));
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("person.id"));
            selectorItemCollection.add(new SelectorItemInfo("position.name"));
            selectorItemCollection.add(new SelectorItemInfo("position.id"));
            selectorItemCollection.add(new SelectorItemInfo("*"));
            entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(memberFilterInfo);
            entityViewInfo.setSelector(selectorItemCollection);
            IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection positionMemberColl = iPositionMember.getPositionMemberCollection(entityViewInfo);
            if (null != positionMemberColl && positionMemberColl.size() > 0) {
                for (int j = 0; j < positionMemberColl.size(); ++j) {
                    PositionMemberInfo memberInfo = positionMemberColl.get(j);
                    res.put(memberInfo.getPerson().getId().toString(), memberInfo.getPosition());
                }
            }
            return res;
        }
        catch (BOSException e) {
            logger.error("\u3010PERFWEB-\u3011get person position err :" + e.getMessage());
            return res;
        }
    }
}

