/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.evalplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.AbstractPerfPeriodControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.EndWayEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaPeriodStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfPeriod;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryControllerBean;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.rulehistory.RuleHistoryRecordFacadeFactory;
import com.kingdee.shr.perfweb.app.common.BusinessOpTypeEnum;
import com.kingdee.shr.perfweb.app.common.GeneralTaskPoolFactory;
import com.kingdee.shr.perfweb.app.common.GeneralTaskPoolInfo;
import com.kingdee.shr.perfweb.app.common.IGeneralTaskPool;
import com.kingdee.shr.perfweb.app.common.YesOrNotEnum;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.TaskStatusEnum;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.utils.PerfPeriodUtils;
import com.kingdee.shr.perfweb.utils.PerfwebThreadPoolUtils;
import com.kingdee.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfPeriodControllerBean
extends AbstractPerfPeriodControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodControllerBean");
    public static final String CANCLEENDPROCESS = "0";
    public static final String CANCLEENDPERIOD = "1";

    @Override
    protected void _savePerfPeriod(Context ctx, IObjectCollection perfPeriod) throws BOSException {
        IPerfPeriod iPerfPeriod = PerfPeriodFactory.getLocalInstance(ctx);
        PerfPeriodCollection coll = (PerfPeriodCollection)perfPeriod;
        int size = perfPeriod.size();
        for (int i = 0; i < size; ++i) {
            try {
                PerfPeriodInfo perfPeriodInfo = coll.get(i);
                iPerfPeriod.delete("where number ='" + perfPeriodInfo.getNumber() + "'");
                BOSUuid periodId = perfPeriodInfo.getId();
                if (periodId == null) {
                    periodId = BOSUuid.create((String)"451A88E5");
                    String planId = perfPeriodInfo.getPerfPlan().getId().toString();
                    String perfRuleId = RuleHistoryRecordFacadeFactory.getLocalInstance(ctx).dealCreatePeriod(planId, periodId.toString(), 3);
                    perfPeriodInfo.put("perfRule", perfRuleId);
                }
                iPerfPeriod.addnew(perfPeriodInfo);
                continue;
            }
            catch (EASBizException e) {
                logger.error("EASBizException: ", (Throwable)e);
            }
        }
    }

    @Override
    protected void _endPerfPeriod(Context ctx, String period) throws BOSException {
        try {
            IPerfPeriod iPerfPeriod = PerfPeriodFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("evaPeriodStatus"));
            PerfPeriodInfo periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, period);
            periodInfo.setEvaPeriodStatus(EvaPeriodStatusEnum.EVALUATED);
            iPerfPeriod.updatePartial(periodInfo, sic);
            PerfEvaObjectCollection evaObjColl = GetEntityInfoUtils.getUnScoredPerfEvaObjectColl(ctx, period);
            int size = evaObjColl.size();
            if (evaObjColl != null && size > 0) {
                CoreBaseCollection generalTaskPoolColl = new CoreBaseCollection();
                IGeneralTaskPool iGeneralTaskPool = GeneralTaskPoolFactory.getLocalInstance(ctx);
                int immediateHandleCount = 0;
                for (int i = 0; i < size; ++i) {
                    PerfEvaObjectInfo evaObjectInfo = evaObjColl.get(i);
                    if (evaObjectInfo.getWorkFlowStatus().getValue() == 3 || evaObjectInfo.getWorkFlowStatus().getValue() == 5) continue;
                    if (immediateHandleCount < 20) {
                        EvaResultSummaryFactory.getLocalInstance(ctx).endSingleEvaObjProcess(evaObjectInfo.getId().toString(), EndWayEnum.ENDPERIOD);
                        ++immediateHandleCount;
                    } else {
                        GeneralTaskPoolInfo generalTaskPollInfo = new GeneralTaskPoolInfo();
                        generalTaskPollInfo.setBusinessId(evaObjectInfo.getId().toString());
                        generalTaskPollInfo.setBusinessType(BusinessOpTypeEnum.ENDPERIOD);
                        generalTaskPollInfo.setDealStatus(TaskStatusEnum.UNDEAL);
                        generalTaskPollInfo.setIsAlreadyDeal(YesOrNotEnum.NO);
                        generalTaskPollInfo.setLock(YesOrNotEnum.NO);
                        generalTaskPoolColl.add((CoreBaseInfo)generalTaskPollInfo);
                    }
                    if (generalTaskPoolColl.size() <= 0 || generalTaskPoolColl.size() % 50 != 0) continue;
                    iGeneralTaskPool.createGeneralTaskPool(generalTaskPoolColl);
                    generalTaskPoolColl.clear();
                }
                if (generalTaskPoolColl.size() > 0) {
                    iGeneralTaskPool.createGeneralTaskPool(generalTaskPoolColl);
                    generalTaskPoolColl.clear();
                }
                PerfwebThreadPoolUtils.startEndPeriodtask(ctx);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new BOSException("endPerfPeriod failed...");
        }
    }

    @Override
    protected void _cancelEndPerfPeriod(Context ctx, String period) throws BOSException {
        try {
            IPerfPeriod iPerfPeriod = PerfPeriodFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("evaPeriodStatus"));
            PerfPeriodInfo periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, period);
            EvaPeriodStatusEnum evaPeriodStatusEnum = EvaPeriodStatusEnum.EVALUATING;
            if (!GradeTaskNodeInstFactory.getLocalInstance(ctx).exists("where period = '" + period + "'")) {
                evaPeriodStatusEnum = EvaPeriodStatusEnum.UNEVALUATE;
            }
            periodInfo.setEvaPeriodStatus(evaPeriodStatusEnum);
            iPerfPeriod.updatePartial(periodInfo, sic);
            PerfEvaObjectCollection evaObjColl = GetEntityInfoUtils.getScoredByEndPeriodPerfEvaObjectColl(ctx, period);
            if (evaObjColl != null && evaObjColl.size() > 0) {
                PerfEvaObjectInfo perfEvaObjectInfo;
                int isOrg;
                CoreBaseCollection generalTaskPoolColl = new CoreBaseCollection();
                IGeneralTaskPool iGeneralTaskPool = GeneralTaskPoolFactory.getLocalInstance(ctx);
                int immediateHandleCount = 0;
                int evaObjCollSize = evaObjColl.size();
                String[] evaObjIds = null;
                evaObjIds = evaObjCollSize < 20 ? new String[evaObjColl.size()] : new String[20];
                for (int i = 0; i < evaObjCollSize; ++i) {
                    if (immediateHandleCount < 20) {
                        evaObjIds[i] = evaObjColl.get(i).getId().toString();
                        ++immediateHandleCount;
                    } else {
                        GeneralTaskPoolInfo generalTaskPollInfo = new GeneralTaskPoolInfo();
                        generalTaskPollInfo.setBusinessId(evaObjColl.get(i).getId().toString());
                        generalTaskPollInfo.setBusinessType(BusinessOpTypeEnum.CANCELENDPERIOD);
                        generalTaskPollInfo.setDealStatus(TaskStatusEnum.UNDEAL);
                        generalTaskPollInfo.setIsAlreadyDeal(YesOrNotEnum.NO);
                        generalTaskPollInfo.setLock(YesOrNotEnum.NO);
                        generalTaskPoolColl.add((CoreBaseInfo)generalTaskPollInfo);
                    }
                    if (generalTaskPoolColl.size() <= 0 || generalTaskPoolColl.size() % 50 != 0) continue;
                    iGeneralTaskPool.createGeneralTaskPool(generalTaskPoolColl);
                    generalTaskPoolColl.clear();
                }
                if (generalTaskPoolColl.size() > 0) {
                    iGeneralTaskPool.createGeneralTaskPool(generalTaskPoolColl);
                    generalTaskPoolColl.clear();
                }
                if ((isOrg = (perfEvaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObjIds[0])).getIsOrg().getValue()) == 1) {
                    OrgEvaResultSummaryControllerBean.getInstance().cancelEndProcess(ctx, evaObjIds, CANCLEENDPERIOD);
                } else {
                    EvaResultSummaryControllerBean.getInstance().cancelEndProcess(ctx, evaObjIds, CANCLEENDPERIOD);
                }
                PerfwebThreadPoolUtils.startCancleEndPeriodtask(ctx);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new BOSException("cancelEndPerfPeriod failed...");
        }
    }

    @Override
    protected boolean _oneKeyUpdPeriodName(Context ctx, String planId) throws BOSException {
        PerfPlanCollection perfPlanCollection = PerfPlanFactory.getLocalInstance(ctx).getPerfPlanCollection("where id = '" + planId + "'");
        PerfPeriodCollection perfPeriodCollection = this.getPerfPeriodCollection(ctx, "where perfPlan.id = '" + planId + "'");
        if (perfPlanCollection != null && perfPlanCollection.size() > 0) {
            PerfPlanInfo perfPlanInfo = perfPlanCollection.get(0);
            if (perfPeriodCollection != null && perfPeriodCollection.size() > 0) {
                CoreBaseCollection periodColl = new CoreBaseCollection();
                for (int i = 0; i < perfPeriodCollection.size(); ++i) {
                    PerfPeriodInfo perfPeriodInfo = perfPeriodCollection.get(i);
                    PerfPeriodUtils.setPeriodNameByPlanName(ctx, perfPlanInfo.getName(), perfPlanInfo.getName(LocaleUtils.locale_L1), perfPlanInfo.getName(LocaleUtils.locale_L2), perfPlanInfo.getName(LocaleUtils.locale_L3), perfPeriodInfo);
                    periodColl.add((CoreBaseInfo)perfPeriodInfo);
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("name");
                try {
                    this.updatePartialBatchData(ctx, (IObjectCollection)periodColl, sic);
                }
                catch (EASBizException e) {
                    logger.error("_oneKeyUpdPeriodName error: ", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return true;
    }
}

