/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.app.base.talentReview;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileAssignTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileCollection;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileFactory;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.AbstractTalentReviewResultControllerBean;
import com.kingdee.shr.perfweb.app.base.talentReview.DistributionBasisTypeEnum;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewContentCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewContentFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewContentInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewNotHitTypeEnum;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewObjectCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewObjectFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewObjectInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewResultDetailCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewResultDetailFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewResultDetailInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewResultInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleHorDetailCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleHorDetailInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleHorLevelDetailCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleHorLevelDetailInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleVerDetailCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleVerDetailInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleVerLevelDetailCollection;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewRuleVerLevelDetailInfo;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewSolutionFactory;
import com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewSolutionInfo;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class TalentReviewResultControllerBean
extends AbstractTalentReviewResultControllerBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.app.base.talentReview.TalentReviewResultControllerBean");

    @Override
    protected IObjectValue _generateReviewResult(Context ctx, String solutionId, boolean regenerate) throws BOSException, EASBizException {
        TalentReviewSolutionInfo solutionInfo = TalentReviewSolutionFactory.getLocalInstance(ctx).getTalentReviewSolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
        if (regenerate) {
            TalentReviewResultInfo resultInfo = this.getReviewResultBySolutionId(ctx, solutionId);
            if (resultInfo != null) {
                resultInfo.setSolution(solutionInfo);
                this.save(ctx, (CoreBaseInfo)resultInfo);
            }
            solutionInfo.setRegenerateResult(false);
            TalentReviewSolutionFactory.getLocalInstance(ctx).save((CoreBaseInfo)solutionInfo);
            return resultInfo;
        }
        return null;
    }

    private boolean checkReviewResult(Context ctx, String solutionId) throws BOSException, EASBizException {
        boolean regenerateFlag = false;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("reviewResult.solution", (Object)solutionId));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("person.id"));
        selectors.add(new SelectorItemInfo("horEvaResult.id"));
        selectors.add(new SelectorItemInfo("horEvaResult.lastSumScore"));
        selectors.add(new SelectorItemInfo("horEvaResult.lastGradeLevel"));
        selectors.add(new SelectorItemInfo("verEvaResult.id"));
        selectors.add(new SelectorItemInfo("verEvaResult.lastSumScore"));
        selectors.add(new SelectorItemInfo("verEvaResult.lastGradeLevel"));
        selectors.add(new SelectorItemInfo("horScore"));
        selectors.add(new SelectorItemInfo("horLevel"));
        selectors.add(new SelectorItemInfo("verScore"));
        selectors.add(new SelectorItemInfo("verLevel"));
        selectors.add(new SelectorItemInfo("hit"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectors);
        TalentReviewResultDetailCollection colls = TalentReviewResultDetailFactory.getLocalInstance(ctx).getTalentReviewResultDetailCollection(evi);
        if (colls != null && !colls.isEmpty()) {
            EvaResultSummaryCollection resultColl;
            EvaResultSummaryInfo verEvaResult;
            EvaResultSummaryInfo horEvaResult;
            TalentReviewResultDetailInfo detailInfo;
            TalentReviewRuleInfo ruleInfo = TalentReviewRuleFactory.getLocalInstance(ctx).getTalentReviewRuleInfo("select solution.hrOrgUnit.Id,horPerfModel.id,horTimeNumber,verPerfModel.id,verTimeNumber,horDistributionType, verDistributionType where solution='" + solutionId + "'");
            DistributionBasisTypeEnum horDistributionType = ruleInfo.getHorDistributionType();
            DistributionBasisTypeEnum verDistributionType = ruleInfo.getVerDistributionType();
            HashSet<String> noResultPersonIds = new HashSet<String>();
            Iterator it = colls.iterator();
            while (it.hasNext()) {
                detailInfo = (TalentReviewResultDetailInfo)it.next();
                horEvaResult = detailInfo.getHorEvaResult();
                verEvaResult = detailInfo.getVerEvaResult();
                if (horEvaResult != null || verEvaResult != null) continue;
                noResultPersonIds.add(detailInfo.getPerson().getId().toString());
                it.remove();
            }
            if (noResultPersonIds.size() > 0 && (resultColl = this.getEvaResultBySolution(ctx, ruleInfo, noResultPersonIds)) != null && !resultColl.isEmpty()) {
                return true;
            }
            it = colls.iterator();
            while (it.hasNext()) {
                String verLevel2;
                detailInfo = (TalentReviewResultDetailInfo)it.next();
                horEvaResult = detailInfo.getHorEvaResult();
                verEvaResult = detailInfo.getVerEvaResult();
                if (detailInfo.isHit() && (horEvaResult == null || verEvaResult == null)) {
                    regenerateFlag = true;
                    break;
                }
                BigDecimal horScore1 = null;
                String horLevel1 = null;
                if (horEvaResult != null) {
                    horScore1 = BigDecimal.valueOf(horEvaResult.getLastSumScore()).setScale(2, 4);
                    horLevel1 = horEvaResult.getLastGradeLevel();
                }
                BigDecimal verScore1 = null;
                String verLevel1 = null;
                if (verEvaResult != null) {
                    verScore1 = BigDecimal.valueOf(verEvaResult.getLastSumScore()).setScale(2, 4);
                    verLevel1 = verEvaResult.getLastGradeLevel();
                }
                if (DistributionBasisTypeEnum.SCORE.equals((Object)horDistributionType)) {
                    BigDecimal horScore2 = detailInfo.getHorScore();
                    if (horScore2 == null) {
                        horScore2 = BigDecimal.ZERO;
                    }
                    if (horScore1 == null || horScore2.compareTo(horScore1) != 0) {
                        regenerateFlag = true;
                        break;
                    }
                } else if (DistributionBasisTypeEnum.LEVEL.equals((Object)horDistributionType)) {
                    String horLevel2;
                    String string = horLevel2 = detailInfo.getHorLevel() == null ? "" : detailInfo.getHorLevel();
                    if (!horLevel2.equals(horLevel1)) {
                        regenerateFlag = true;
                        break;
                    }
                }
                if (DistributionBasisTypeEnum.SCORE.equals((Object)verDistributionType)) {
                    BigDecimal verScore2 = detailInfo.getVerScore();
                    if (verScore2 == null) {
                        verScore2 = BigDecimal.ZERO;
                    }
                    if (verScore1 != null && verScore2.compareTo(verScore1) == 0) continue;
                    regenerateFlag = true;
                    break;
                }
                if (!DistributionBasisTypeEnum.LEVEL.equals((Object)verDistributionType) || (verLevel2 = detailInfo.getVerLevel() == null ? "" : detailInfo.getVerLevel()).equals(verLevel1)) continue;
                regenerateFlag = true;
                break;
            }
        }
        return regenerateFlag;
    }

    private TalentReviewRuleCollection getReviewRuleBySolutionId(Context ctx, String solutionId) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solution", (Object)solutionId, CompareType.EQUALS));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("horDistributions.*"));
        selectors.add(new SelectorItemInfo("horDistributions.levels.*"));
        selectors.add(new SelectorItemInfo("verDistributions.*"));
        selectors.add(new SelectorItemInfo("verDistributions.levels.*"));
        selectors.add(new SelectorItemInfo("solution.hrOrgUnit.id"));
        selectors.add(new SelectorItemInfo("solution.adminOrgUnit.id"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectors);
        TalentReviewRuleCollection ruleColls = TalentReviewRuleFactory.getLocalInstance(ctx).getTalentReviewRuleCollection(evi);
        return ruleColls;
    }

    private TalentReviewObjectCollection getReviewObjectBySolutionId(Context ctx, String solutionId) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solution", (Object)solutionId, CompareType.EQUALS));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("person.id"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectors);
        TalentReviewObjectCollection objectColls = TalentReviewObjectFactory.getLocalInstance(ctx).getTalentReviewObjectCollection(evi);
        return objectColls;
    }

    private TalentReviewContentCollection getReviewContentBySolutionId(Context ctx, String solutionId) throws BOSException {
        TalentReviewContentCollection contentColls = TalentReviewContentFactory.getLocalInstance(ctx).getTalentReviewContentCollection("where solution='" + solutionId + "' order by seq");
        return contentColls;
    }

    private TalentReviewResultInfo getReviewResultBySolutionId(Context ctx, String solutionId) throws BOSException, EASBizException {
        TalentReviewRuleCollection ruleColls = this.getReviewRuleBySolutionId(ctx, solutionId);
        if (ruleColls != null && !ruleColls.isEmpty()) {
            TalentReviewRuleInfo ruleInfo = ruleColls.get(0);
            TalentReviewObjectCollection objectColls = this.getReviewObjectBySolutionId(ctx, solutionId);
            if (objectColls == null || objectColls.isEmpty()) {
                return null;
            }
            TalentReviewContentCollection contentColls = this.getReviewContentBySolutionId(ctx, solutionId);
            Set<String> personIds = TalentReviewResultControllerBean.getReviewObjectPersonIds(objectColls);
            EvaResultSummaryCollection resultColl = this.getEvaResultBySolution(ctx, ruleInfo, personIds);
            TalentReviewResultDetailCollection notHits = new TalentReviewResultDetailCollection();
            HashSet<String> notHitPersonIds = new HashSet<String>();
            if (resultColl != null && !resultColl.isEmpty()) {
                HashMap<String, EvaResultSummaryInfo> originalResultInfoMap = new HashMap<String, EvaResultSummaryInfo>();
                HashMap<String, BigDecimal> originalScoreMap = new HashMap<String, BigDecimal>();
                Map<String, List<EvaResultSummaryInfo>> evaResultMap = TalentReviewResultControllerBean.getEvaResultMap(ctx, resultColl, originalResultInfoMap, originalScoreMap);
                HashMap<String, TalentReviewObjectInfo> reviewObjMap = new HashMap<String, TalentReviewObjectInfo>();
                Iterator objIt = objectColls.iterator();
                while (objIt.hasNext()) {
                    TalentReviewObjectInfo reviewObjectInfo = (TalentReviewObjectInfo)objIt.next();
                    reviewObjMap.put(reviewObjectInfo.getId().toString(), reviewObjectInfo);
                }
                if (ruleInfo.getHorDistributions() == null || ruleInfo.getHorDistributions().isEmpty()) {
                    throw new SHRPerfWebBizException(SHRPerfWebBizException.CANNOTINVENTORYRESULT);
                }
                String horPerfModel = ruleInfo.getHorPerfModel().getId().toString();
                String horTimeNumber = ruleInfo.getHorTimeNumber();
                List<EvaResultSummaryInfo> horEvaResult = evaResultMap.get(horPerfModel + horTimeNumber);
                Map<String, Map<String, Integer>> horEvaResultMap = null;
                if (horEvaResult != null) {
                    horEvaResultMap = TalentReviewResultControllerBean.getReviewResultRegionMap(ruleInfo, horEvaResult, originalScoreMap, objectColls, true, notHits, notHitPersonIds);
                }
                if (ruleInfo.getVerDistributions() == null || ruleInfo.getVerDistributions().isEmpty()) {
                    throw new SHRPerfWebBizException(SHRPerfWebBizException.CANNOTVIEWRESULTOFNOTSETYBASIS);
                }
                String verPerfModel = ruleInfo.getVerPerfModel().getId().toString();
                String verTimeNumber = ruleInfo.getVerTimeNumber();
                List<EvaResultSummaryInfo> verEvaResult = evaResultMap.get(verPerfModel + verTimeNumber);
                Map<String, Map<String, Integer>> verEvaResultMap = null;
                if (verEvaResult != null) {
                    verEvaResultMap = TalentReviewResultControllerBean.getReviewResultRegionMap(ruleInfo, verEvaResult, originalScoreMap, objectColls, false, notHits, notHitPersonIds);
                }
                return TalentReviewResultControllerBean.setReviewResult(horEvaResultMap, verEvaResultMap, originalResultInfoMap, reviewObjMap, notHits, notHitPersonIds, ruleInfo, objectColls, contentColls, originalScoreMap);
            }
            TalentReviewResultInfo resultInfo = TalentReviewResultControllerBean.setNotHitInfoByReviewObject(notHits, objectColls, TalentReviewNotHitTypeEnum.ALL_NORESULT);
            resultInfo.setReviewRule(ruleInfo);
            return resultInfo;
        }
        throw new SHRPerfWebBizException(SHRPerfWebBizException.INVENTORYRULENOTSET);
    }

    private static TalentReviewResultInfo setNotHitInfoByReviewObject(TalentReviewResultDetailCollection notHits, TalentReviewObjectCollection objectColls, TalentReviewNotHitTypeEnum notHitTypeEnum) {
        TalentReviewResultInfo resultInfo = new TalentReviewResultInfo();
        resultInfo.setNotHit(objectColls.size());
        resultInfo.setTotal(objectColls.size());
        Iterator objIt = objectColls.iterator();
        while (objIt.hasNext()) {
            TalentReviewObjectInfo objectInfo = (TalentReviewObjectInfo)objIt.next();
            TalentReviewResultDetailInfo notHitDetailInfo = new TalentReviewResultDetailInfo();
            notHitDetailInfo.setPerson(objectInfo.getPerson());
            notHitDetailInfo.setReviewObject(objectInfo);
            notHitDetailInfo.setNotHitType(notHitTypeEnum);
            notHitDetailInfo.setHit(false);
            notHits.add(notHitDetailInfo);
        }
        resultInfo.getDetail().addCollection(notHits);
        return resultInfo;
    }

    private static Map<String, List<EvaResultSummaryInfo>> getEvaResultMap(Context ctx, EvaResultSummaryCollection resultColl, Map<String, EvaResultSummaryInfo> evaResultInfoMap, Map<String, BigDecimal> originalScoreMap) throws EASBizException {
        HashMap<String, List<EvaResultSummaryInfo>> resultMap = new HashMap<String, List<EvaResultSummaryInfo>>();
        HashSet<String> resultIds = new HashSet<String>();
        Iterator it = resultColl.iterator();
        while (it.hasNext()) {
            EvaResultSummaryInfo summaryInfo = (EvaResultSummaryInfo)it.next();
            String perfMode = summaryInfo.getPerfModel().getId().toString();
            String periodTimeNumber = summaryInfo.getPeriodTimeNumber();
            ArrayList<EvaResultSummaryInfo> list = (ArrayList<EvaResultSummaryInfo>)resultMap.get(perfMode + periodTimeNumber);
            if (list == null) {
                list = new ArrayList<EvaResultSummaryInfo>();
            }
            if (evaResultInfoMap != null) {
                EvaResultSummaryInfo copyInfo = new EvaResultSummaryInfo();
                BeanUtils.copyProperties((Object)summaryInfo, (Object)copyInfo);
                evaResultInfoMap.put(summaryInfo.getId().toString(), copyInfo);
            }
            TalentReviewResultControllerBean.translateResultScore(summaryInfo);
            list.add(summaryInfo);
            resultMap.put(perfMode + periodTimeNumber, list);
            resultIds.add(summaryInfo.getId().toString());
        }
        TalentReviewResultControllerBean.setRealEvaResultScore(ctx, resultIds, originalScoreMap);
        return resultMap;
    }

    private static void setRealEvaResultScore(Context ctx, Set<String> reQueryIds, Map<String, BigDecimal> originalScoreMap) throws EASBizException {
        if (reQueryIds.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("FID", reQueryIds, CompareType.INCLUDE));
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT FID, FLastSumScore FROM T_EVA_EvaResultSummary WHERE ").append(filterInfo.toSql());
            try {
                IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                while (dataSet.next()) {
                    String lastSumScore = dataSet.getString("FLastSumScore");
                    if (StringUtils.isEmpty((String)lastSumScore)) continue;
                    originalScoreMap.put(dataSet.getString("FID"), new BigDecimal(lastSumScore).setScale(2, 4));
                }
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
                throw new EASBizException(new NumericExceptionSubItem("TAL003", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.QUERYEVARESULTEXP, ctx)));
            }
        }
    }

    private static Map<String, Map<String, Integer>> getReviewResultRegionMap(TalentReviewRuleInfo ruleInfo, List<EvaResultSummaryInfo> evaResult, Map<String, BigDecimal> originalScoreMap, TalentReviewObjectCollection objectColls, boolean isHorDistribyution, TalentReviewResultDetailCollection notHits, Set<String> notHitPersonIds) {
        DistributionBasisTypeEnum distributionType = ruleInfo.getHorDistributionType();
        TalentReviewNotHitTypeEnum notHitTypeEnum = TalentReviewNotHitTypeEnum.HOR_NORESULT;
        if (!isHorDistribyution) {
            distributionType = ruleInfo.getVerDistributionType();
            notHitTypeEnum = TalentReviewNotHitTypeEnum.VER_NORESULT;
        }
        Map<String, Integer> levelRegionMap = null;
        if (DistributionBasisTypeEnum.LEVEL.equals((Object)distributionType)) {
            levelRegionMap = TalentReviewResultControllerBean.getLevelMap(ruleInfo, isHorDistribyution);
        }
        Map<String, Map<String, Integer>> evaResultMap = new HashMap<String, Map<String, Integer>>();
        HashMap<String, String> evaResultReviewObjMap = new HashMap<String, String>();
        ArrayList<EvaResultSummaryInfo> validEvaResult = new ArrayList<EvaResultSummaryInfo>();
        Iterator objIt = objectColls.iterator();
        block0: while (objIt.hasNext()) {
            TalentReviewObjectInfo objectInfo = (TalentReviewObjectInfo)objIt.next();
            String objectId = objectInfo.getId().toString();
            String objPersonId = objectInfo.getPerson().getId().toString();
            for (EvaResultSummaryInfo resultSummaryInfo : evaResult) {
                BigDecimal realScore;
                String resultId = resultSummaryInfo.getId().toString();
                String resultPersonId = resultSummaryInfo.getPerson().getId().toString();
                PerfFileAssignTypeEnum resultAssignType = PerfFileAssignTypeEnum.MAIN;
                PerfFileInfo perfFileInfo = resultSummaryInfo.getPerfFile();
                if (perfFileInfo != null) {
                    resultAssignType = resultSummaryInfo.getPerfFile().getAssignType();
                }
                if (!resultPersonId.equals(objPersonId) || !PerfFileAssignTypeEnum.MAIN.equals((Object)resultAssignType)) continue;
                if (DistributionBasisTypeEnum.LEVEL.equals((Object)distributionType)) {
                    if (StringUtils.isEmpty((String)resultSummaryInfo.getLastGradeLevel())) continue block0;
                    Integer regionX = TalentReviewResultControllerBean.getEvaResultLeveRegion(resultSummaryInfo, levelRegionMap);
                    HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
                    resultMap.put(resultId, regionX);
                    evaResultMap.put(objectId, resultMap);
                    continue block0;
                }
                if (!DistributionBasisTypeEnum.SCORE.equals((Object)distributionType) || (realScore = originalScoreMap.get(resultId)) == null) continue block0;
                validEvaResult.add(resultSummaryInfo);
                evaResultReviewObjMap.put(resultId, objectId);
                continue block0;
            }
        }
        if (DistributionBasisTypeEnum.SCORE.equals((Object)distributionType) && !CollectionUtils.isEmpty(validEvaResult)) {
            evaResultMap = TalentReviewResultControllerBean.getEvaResultPercentageRegionMap(objectColls.size(), validEvaResult, evaResultReviewObjMap, ruleInfo, isHorDistribyution);
        }
        return evaResultMap;
    }

    private static TalentReviewResultInfo setReviewResult(Map<String, Map<String, Integer>> horEvaResultMap, Map<String, Map<String, Integer>> verEvaResultMap, Map<String, EvaResultSummaryInfo> evaResultInfoMap, Map<String, TalentReviewObjectInfo> reviewObjMap, TalentReviewResultDetailCollection notHits, Set<String> notHitPersonIds, TalentReviewRuleInfo ruleInfo, TalentReviewObjectCollection objectColls, TalentReviewContentCollection contentColls, Map<String, BigDecimal> originalScoreMap) {
        String resultId;
        String reviewObjId;
        TalentReviewResultInfo resultInfo = new TalentReviewResultInfo();
        resultInfo.setTotal(objectColls.size());
        TalentReviewResultDetailCollection resultDetailColl = new TalentReviewResultDetailCollection();
        HashMap<Integer, TalentReviewContentInfo> contentMap = new HashMap<Integer, TalentReviewContentInfo>();
        if (contentColls != null && !contentColls.isEmpty()) {
            Iterator contentIt = contentColls.iterator();
            while (contentIt.hasNext()) {
                TalentReviewContentInfo contentInfo = (TalentReviewContentInfo)contentIt.next();
                contentMap.put(contentInfo.getSeq(), contentInfo);
            }
        }
        HashSet<String> reviewedObjectIds = new HashSet<String>();
        int[][] area = TalentReviewResultControllerBean.getReviewResultRegion(ruleInfo.getHorDistributions().size(), ruleInfo.getVerDistributions().size());
        if (horEvaResultMap != null) {
            for (Map.Entry<String, Map<String, Integer>> entry : horEvaResultMap.entrySet()) {
                EvaResultSummaryInfo resultSummaryInfo;
                reviewObjId = entry.getKey();
                Map<String, Integer> horResultMap = entry.getValue();
                resultId = horResultMap.keySet().iterator().next();
                Integer areaX = horResultMap.get(resultId);
                TalentReviewObjectInfo objectInfo = reviewObjMap.get(reviewObjId);
                String personId = objectInfo.getPerson().getId().toString();
                reviewedObjectIds.add(objectInfo.getId().toString());
                Map<String, Integer> verResultMap = null;
                if (verEvaResultMap != null) {
                    verResultMap = verEvaResultMap.get(reviewObjId);
                }
                if (verResultMap == null) {
                    if (notHitPersonIds.contains(personId)) continue;
                    TalentReviewResultDetailInfo notHitDetailInfo = new TalentReviewResultDetailInfo();
                    resultSummaryInfo = evaResultInfoMap.get(resultId);
                    TalentReviewResultControllerBean.assembleVerNoResultDetailInfo(notHitDetailInfo, objectInfo, resultSummaryInfo, ruleInfo, originalScoreMap);
                    notHits.add(notHitDetailInfo);
                    notHitPersonIds.add(objectInfo.getPerson().getId().toString());
                    continue;
                }
                String verResultId = (String)verResultMap.keySet().iterator().next();
                resultSummaryInfo = evaResultInfoMap.get(resultId);
                EvaResultSummaryInfo verResultSummaryInfo = evaResultInfoMap.get(verResultId);
                if (areaX == null) {
                    TalentReviewResultDetailInfo notHitDetailInfo = new TalentReviewResultDetailInfo();
                    TalentReviewResultControllerBean.assembleHorNoResultDetailInfo(notHitDetailInfo, objectInfo, verResultSummaryInfo, ruleInfo, originalScoreMap);
                    TalentReviewResultControllerBean.assembleHorResultDetailInfo(notHitDetailInfo, resultSummaryInfo, ruleInfo, originalScoreMap);
                    notHits.add(notHitDetailInfo);
                    notHitPersonIds.add(objectInfo.getPerson().getId().toString());
                    continue;
                }
                Integer areaY = verResultMap.get(verResultId);
                if (areaY == null) {
                    TalentReviewResultDetailInfo notHitDetailInfo = new TalentReviewResultDetailInfo();
                    TalentReviewResultControllerBean.assembleVerNoResultDetailInfo(notHitDetailInfo, objectInfo, resultSummaryInfo, ruleInfo, originalScoreMap);
                    TalentReviewResultControllerBean.assembleVerResultDetailInfo(notHitDetailInfo, verResultSummaryInfo, ruleInfo, originalScoreMap);
                    notHits.add(notHitDetailInfo);
                    notHitPersonIds.add(objectInfo.getPerson().getId().toString());
                    continue;
                }
                int contentSeq = area[areaX][areaY];
                TalentReviewResultDetailInfo resultDetailInfo = new TalentReviewResultDetailInfo();
                if (contentMap != null) {
                    resultDetailInfo.setContent((TalentReviewContentInfo)contentMap.get(contentSeq));
                }
                resultDetailInfo.setContentSeq(contentSeq);
                TalentReviewResultControllerBean.assembleHitResultDetailInfo(resultDetailInfo, objectInfo, resultSummaryInfo, verResultSummaryInfo, ruleInfo, originalScoreMap);
                resultDetailColl.add(resultDetailInfo);
            }
        }
        if (verEvaResultMap != null) {
            for (Map.Entry<String, Map<String, Integer>> entry : verEvaResultMap.entrySet()) {
                reviewObjId = entry.getKey();
                if (!CollectionUtils.isEmpty(reviewedObjectIds) && reviewedObjectIds.contains(reviewObjId)) continue;
                Map<String, Integer> verResultMap = entry.getValue();
                resultId = verResultMap.keySet().iterator().next();
                TalentReviewObjectInfo objectInfo = reviewObjMap.get(reviewObjId);
                String personId = objectInfo.getPerson().getId().toString();
                if (notHitPersonIds.contains(personId)) continue;
                TalentReviewResultDetailInfo notHitDetailInfo = new TalentReviewResultDetailInfo();
                EvaResultSummaryInfo resultSummaryInfo = evaResultInfoMap.get(resultId);
                TalentReviewResultControllerBean.assembleHorNoResultDetailInfo(notHitDetailInfo, objectInfo, resultSummaryInfo, ruleInfo, originalScoreMap);
                notHits.add(notHitDetailInfo);
                reviewedObjectIds.add(objectInfo.getId().toString());
                notHitPersonIds.add(objectInfo.getPerson().getId().toString());
            }
        }
        Iterator objectIt = objectColls.iterator();
        while (objectIt.hasNext()) {
            TalentReviewObjectInfo objectInfo = (TalentReviewObjectInfo)objectIt.next();
            String objId = objectInfo.getId().toString();
            String personId = objectInfo.getPerson().getId().toString();
            if (reviewedObjectIds.contains(objId) || notHitPersonIds.contains(personId)) continue;
            TalentReviewResultDetailInfo notHitDetailInfo = new TalentReviewResultDetailInfo();
            TalentReviewResultControllerBean.assembleResultDetailInfo(notHitDetailInfo, objectInfo);
            notHitDetailInfo.setNotHitType(TalentReviewNotHitTypeEnum.ALL_NORESULT);
            notHitDetailInfo.setHit(false);
            notHits.add(notHitDetailInfo);
            notHitPersonIds.add(objectInfo.getPerson().getId().toString());
        }
        resultInfo.setNotHit(notHitPersonIds.size());
        resultInfo.getDetail().addCollection(resultDetailColl);
        resultInfo.getDetail().addCollection(notHits);
        resultInfo.setReviewRule(ruleInfo);
        return resultInfo;
    }

    private static void assembleResultDetailInfo(TalentReviewResultDetailInfo detailInfo, TalentReviewObjectInfo objectInfo) {
        detailInfo.setPerson(objectInfo.getPerson());
        detailInfo.setReviewObject(objectInfo);
    }

    private static void assembleHitResultDetailInfo(TalentReviewResultDetailInfo resultDetailInfo, TalentReviewObjectInfo objectInfo, EvaResultSummaryInfo resultSummaryInfo, EvaResultSummaryInfo verResultSummaryInfo, TalentReviewRuleInfo ruleInfo, Map<String, BigDecimal> originalScoreMap) {
        TalentReviewResultControllerBean.assembleResultDetailInfo(resultDetailInfo, objectInfo);
        TalentReviewResultControllerBean.assembleHorResultDetailInfo(resultDetailInfo, resultSummaryInfo, ruleInfo, originalScoreMap);
        TalentReviewResultControllerBean.assembleVerResultDetailInfo(resultDetailInfo, verResultSummaryInfo, ruleInfo, originalScoreMap);
        resultDetailInfo.setHit(true);
    }

    private static void assembleHorResultDetailInfo(TalentReviewResultDetailInfo resultDetailInfo, EvaResultSummaryInfo resultSummaryInfo, TalentReviewRuleInfo ruleInfo, Map<String, BigDecimal> originalScoreMap) {
        resultDetailInfo.setHorEvaResult(resultSummaryInfo);
        PerfFileInfo perfFileInfo = resultSummaryInfo.getPerfFile();
        resultDetailInfo.setPerfFile(perfFileInfo);
        if (perfFileInfo != null) {
            resultDetailInfo.setAdminOrgUnit(resultSummaryInfo.getPerfFile().getAdminOrgUnit());
        } else {
            resultDetailInfo.setAdminOrgUnit(resultSummaryInfo.getAdminOrg());
        }
        BigDecimal lastSumScore = originalScoreMap.get(resultSummaryInfo.getId().toString());
        resultDetailInfo.setHorScore(lastSumScore);
        resultDetailInfo.setHorLevel(resultSummaryInfo.getLastGradeLevel());
        resultDetailInfo.setHorPerfScore(TalentReviewResultControllerBean.getPerfScore(resultSummaryInfo));
        resultDetailInfo.setHorSystemLevel(TalentReviewResultControllerBean.getPerfSysLevel(resultSummaryInfo));
        if (DistributionBasisTypeEnum.SCORE.equals((Object)ruleInfo.getHorDistributionType())) {
            if (lastSumScore != null) {
                resultDetailInfo.setHorResult(lastSumScore.toString());
            }
        } else if (DistributionBasisTypeEnum.LEVEL.equals((Object)ruleInfo.getHorDistributionType())) {
            resultDetailInfo.setHorResult(resultDetailInfo.getHorLevel());
        }
    }

    private static void assembleVerResultDetailInfo(TalentReviewResultDetailInfo resultDetailInfo, EvaResultSummaryInfo resultSummaryInfo, TalentReviewRuleInfo ruleInfo, Map<String, BigDecimal> originalScoreMap) {
        resultDetailInfo.setVerEvaResult(resultSummaryInfo);
        PerfFileInfo perfFileInfo = resultSummaryInfo.getPerfFile();
        resultDetailInfo.setPerfFile(perfFileInfo);
        if (perfFileInfo != null) {
            resultDetailInfo.setAdminOrgUnit(resultSummaryInfo.getPerfFile().getAdminOrgUnit());
        } else {
            resultDetailInfo.setAdminOrgUnit(resultSummaryInfo.getAdminOrg());
        }
        BigDecimal lastSumScore = originalScoreMap.get(resultSummaryInfo.getId().toString());
        resultDetailInfo.setVerScore(lastSumScore);
        resultDetailInfo.setVerLevel(resultSummaryInfo.getLastGradeLevel());
        resultDetailInfo.setVerPerfScore(TalentReviewResultControllerBean.getPerfScore(resultSummaryInfo));
        resultDetailInfo.setVerSystemLevel(TalentReviewResultControllerBean.getPerfSysLevel(resultSummaryInfo));
        if (DistributionBasisTypeEnum.SCORE.equals((Object)ruleInfo.getVerDistributionType())) {
            if (lastSumScore != null) {
                resultDetailInfo.setVerResult(lastSumScore.toString());
            }
        } else if (DistributionBasisTypeEnum.LEVEL.equals((Object)ruleInfo.getVerDistributionType())) {
            resultDetailInfo.setVerResult(resultDetailInfo.getVerLevel());
        }
    }

    private static void assembleVerNoResultDetailInfo(TalentReviewResultDetailInfo notHitDetailInfo, TalentReviewObjectInfo objectInfo, EvaResultSummaryInfo resultSummaryInfo, TalentReviewRuleInfo ruleInfo, Map<String, BigDecimal> originalScoreMap) {
        TalentReviewResultControllerBean.assembleResultDetailInfo(notHitDetailInfo, objectInfo);
        TalentReviewResultControllerBean.assembleHorResultDetailInfo(notHitDetailInfo, resultSummaryInfo, ruleInfo, originalScoreMap);
        notHitDetailInfo.setNotHitType(TalentReviewNotHitTypeEnum.VER_NORESULT);
        notHitDetailInfo.setHit(false);
    }

    private static void assembleHorNoResultDetailInfo(TalentReviewResultDetailInfo notHitDetailInfo, TalentReviewObjectInfo objectInfo, EvaResultSummaryInfo resultSummaryInfo, TalentReviewRuleInfo ruleInfo, Map<String, BigDecimal> originalScoreMap) {
        TalentReviewResultControllerBean.assembleResultDetailInfo(notHitDetailInfo, objectInfo);
        TalentReviewResultControllerBean.assembleVerResultDetailInfo(notHitDetailInfo, resultSummaryInfo, ruleInfo, originalScoreMap);
        notHitDetailInfo.setNotHitType(TalentReviewNotHitTypeEnum.HOR_NORESULT);
        notHitDetailInfo.setHit(false);
    }

    private Map<String, PerfFileInfo> getMainPerfFileMapByPersonIdsAndHrOrg(Context ctx, Set<String> personIds, String hrOrgUnitId) throws BOSException {
        HashMap<String, PerfFileInfo> resultMap;
        block0: {
            Iterator it;
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)hrOrgUnitId));
            filterInfo.getFilterItems().add(new FilterItemInfo("person", personIds, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("assignType", (Object)1));
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("person.id"));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            evi.setSelector(selectors);
            resultMap = new HashMap<String, PerfFileInfo>();
            PerfFileCollection perfFiles = PerfFileFactory.getLocalInstance(ctx).getPerfFileCollection(evi);
            if (perfFiles == null || perfFiles.isEmpty() || !(it = perfFiles.iterator()).hasNext()) break block0;
            PerfFileInfo perfFileInfo = (PerfFileInfo)it.next();
            resultMap.put(perfFileInfo.getPerson().getId().toString(), perfFileInfo);
        }
        return resultMap;
    }

    private static Map<String, Integer> getLevelMap(TalentReviewRuleInfo ruleInfo, boolean isHorDistribution) {
        if (isHorDistribution) {
            return TalentReviewResultControllerBean.getHorLevelMap(ruleInfo);
        }
        return TalentReviewResultControllerBean.getVerLevelMap(ruleInfo);
    }

    private static Map<String, Integer> getHorLevelMap(TalentReviewRuleInfo ruleInfo) {
        HashMap<String, Integer> levelRegionMap = new HashMap<String, Integer>();
        TalentReviewRuleHorDetailCollection horDetailColl = ruleInfo.getHorDistributions();
        Iterator horDetailIt = horDetailColl.iterator();
        while (horDetailIt.hasNext()) {
            TalentReviewRuleHorDetailInfo horDetailInfo = (TalentReviewRuleHorDetailInfo)horDetailIt.next();
            TalentReviewRuleHorLevelDetailCollection horLevels = horDetailInfo.getLevels();
            Iterator horLevelDetailIt = horLevels.iterator();
            while (horLevelDetailIt.hasNext()) {
                TalentReviewRuleHorLevelDetailInfo horLevelDetailInfo = (TalentReviewRuleHorLevelDetailInfo)horLevelDetailIt.next();
                levelRegionMap.put(horLevelDetailInfo.getName(), horDetailInfo.getSeq());
            }
        }
        return levelRegionMap;
    }

    private static Map<String, Map<String, Integer>> getEvaResultPercentageRegionMap(int personSize, List<EvaResultSummaryInfo> evaResult, Map<String, String> evaResultReviewObjMap, TalentReviewRuleInfo ruleInfo, boolean isHorDistribution) {
        Collections.sort(evaResult, new Comparator<EvaResultSummaryInfo>(){

            @Override
            public int compare(EvaResultSummaryInfo c1, EvaResultSummaryInfo c2) {
                return BigDecimal.valueOf(c2.getLastSumScore()).subtract(BigDecimal.valueOf(c1.getLastSumScore())).setScale(4).intValue();
            }
        });
        if (isHorDistribution) {
            return TalentReviewResultControllerBean.getEvaResultHorPercentageRegionMap(personSize, evaResult, evaResultReviewObjMap, ruleInfo);
        }
        return TalentReviewResultControllerBean.getEvaResultVerPercentageRegionMap(personSize, evaResult, evaResultReviewObjMap, ruleInfo);
    }

    private static Map<String, Map<String, Integer>> getEvaResultHorPercentageRegionMap(int personSize, List<EvaResultSummaryInfo> evaResult, Map<String, String> evaResultReviewObjMap, TalentReviewRuleInfo ruleInfo) {
        HashMap<String, Map<String, Integer>> evaResultRegionMap = new HashMap<String, Map<String, Integer>>();
        TalentReviewRuleHorDetailCollection horDetailColl = ruleInfo.getHorDistributions();
        horDetailColl.sort("seq");
        int totalPercenSize = 0;
        int detailSize = horDetailColl.size();
        for (int count = 0; count < detailSize; ++count) {
            TalentReviewRuleHorDetailInfo horDetailInfo = horDetailColl.get(count);
            int percenSize = TalentReviewResultControllerBean.getPercenSize(personSize, count, detailSize, totalPercenSize, horDetailInfo.getPercentage());
            int realSize = 0;
            if (percenSize != 0) {
                realSize = TalentReviewResultControllerBean.setEvaResultRegionMap(evaResultRegionMap, evaResult, totalPercenSize, percenSize, horDetailInfo.getSeq(), evaResultReviewObjMap);
            }
            if (count != detailSize - 1) {
                totalPercenSize += realSize;
            }
            if (personSize == totalPercenSize) break;
        }
        return evaResultRegionMap;
    }

    private static Map<String, Map<String, Integer>> getEvaResultVerPercentageRegionMap(int personSize, List<EvaResultSummaryInfo> evaResult, Map<String, String> evaResultReviewObjMap, TalentReviewRuleInfo ruleInfo) {
        HashMap<String, Map<String, Integer>> evaResultRegionMap = new HashMap<String, Map<String, Integer>>();
        TalentReviewRuleVerDetailCollection verDetaeilColl = ruleInfo.getVerDistributions();
        verDetaeilColl.sort("seq");
        int totalPercenSize = 0;
        int detailSize = verDetaeilColl.size();
        for (int count = 0; count < detailSize; ++count) {
            TalentReviewRuleVerDetailInfo verDetailInfo = verDetaeilColl.get(count);
            int percenSize = TalentReviewResultControllerBean.getPercenSize(personSize, count, detailSize, totalPercenSize, verDetailInfo.getPercentage());
            int realSize = 0;
            if (percenSize != 0) {
                realSize = TalentReviewResultControllerBean.setEvaResultRegionMap(evaResultRegionMap, evaResult, totalPercenSize, percenSize, verDetailInfo.getSeq(), evaResultReviewObjMap);
            }
            if (count != detailSize - 1) {
                totalPercenSize += realSize;
            }
            if (personSize == totalPercenSize) break;
        }
        return evaResultRegionMap;
    }

    private static int getPercenSize(int size, int count, int detailSize, int totalPercenSize, BigDecimal percentage) {
        int percenSize = count == detailSize - 1 ? size - totalPercenSize : BigDecimal.valueOf(size).multiply(percentage).divide(BigDecimal.valueOf(100L), 0, 4).intValue();
        return percenSize;
    }

    private static int setEvaResultRegionMap(Map<String, Map<String, Integer>> evaResultRegionMap, List<EvaResultSummaryInfo> evaResult, int totalPercenSize, int percenSize, int seq, Map<String, String> evaResultReviewObjMap) {
        int loopCount = totalPercenSize;
        int realSize = 0;
        for (int i = loopCount; i < totalPercenSize + percenSize && i <= evaResult.size() - 1; ++i) {
            String resultId = evaResult.get(i).getId().toString();
            HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
            resultMap.put(resultId, seq);
            evaResultRegionMap.put(evaResultReviewObjMap.get(resultId), resultMap);
            ++realSize;
        }
        for (int checkSize = totalPercenSize + percenSize; evaResult.size() > checkSize; ++checkSize) {
            EvaResultSummaryInfo lastResult = evaResult.get(checkSize - 1);
            EvaResultSummaryInfo nextResult = evaResult.get(checkSize);
            if (nextResult == null || nextResult.getLastSumScore() != lastResult.getLastSumScore()) break;
            String resultId = nextResult.getId().toString();
            HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
            resultMap.put(resultId, seq);
            evaResultRegionMap.put(evaResultReviewObjMap.get(resultId), resultMap);
            ++realSize;
        }
        return realSize;
    }

    private static Map<BigDecimal, Integer> getVerPercentageMap(TalentReviewRuleInfo ruleInfo) {
        HashMap<BigDecimal, Integer> percentageRegionMap = new HashMap<BigDecimal, Integer>();
        TalentReviewRuleVerDetailCollection verDetailColl = ruleInfo.getVerDistributions();
        Iterator verDetailIt = verDetailColl.iterator();
        while (verDetailIt.hasNext()) {
            TalentReviewRuleVerDetailInfo verDetailInfo = (TalentReviewRuleVerDetailInfo)verDetailIt.next();
            percentageRegionMap.put(verDetailInfo.getPercentage(), verDetailInfo.getSeq());
        }
        return percentageRegionMap;
    }

    private static Integer getEvaResultLeveRegion(EvaResultSummaryInfo resultSummaryInfo, Map<String, Integer> levelRegionMap) {
        String sysLevel = TalentReviewResultControllerBean.getPerfSysLevel(resultSummaryInfo);
        if (sysLevel != null) {
            return levelRegionMap.get(sysLevel);
        }
        return null;
    }

    private static String getPerfSysLevel(EvaResultSummaryInfo resultSummaryInfo) {
        String level = resultSummaryInfo.getLastGradeLevel();
        if (!StringUtils.isEmpty((String)level)) {
            PerfScorLevelDefineCollection levelDefineColls;
            String sysLevel = null;
            if (resultSummaryInfo.getPerfScorLevelDefine() != null && resultSummaryInfo.getPerfScorLevelDefine().getSysPerfLevel() != null) {
                sysLevel = resultSummaryInfo.getPerfScorLevelDefine().getSysPerfLevel();
            } else if (resultSummaryInfo.getPerfScorLevel() != null && (levelDefineColls = resultSummaryInfo.getPerfScorLevel().getPerfLevelDefInfo()) != null && !levelDefineColls.isEmpty()) {
                Iterator defineIt = levelDefineColls.iterator();
                while (defineIt.hasNext()) {
                    PerfScorLevelDefineInfo defineInfo = (PerfScorLevelDefineInfo)defineIt.next();
                    if (!level.equals(defineInfo.getPerfLevelName())) continue;
                    sysLevel = defineInfo.getSysPerfLevel();
                    break;
                }
            }
            return sysLevel;
        }
        return null;
    }

    private static Map<String, Integer> getVerLevelMap(TalentReviewRuleInfo ruleInfo) {
        HashMap<String, Integer> levelRegionMap = new HashMap<String, Integer>();
        TalentReviewRuleVerDetailCollection verDetailColl = ruleInfo.getVerDistributions();
        Iterator verDetailIt = verDetailColl.iterator();
        while (verDetailIt.hasNext()) {
            TalentReviewRuleVerDetailInfo verDetailInfo = (TalentReviewRuleVerDetailInfo)verDetailIt.next();
            TalentReviewRuleVerLevelDetailCollection verLevels = verDetailInfo.getLevels();
            Iterator verLevelDetailIt = verLevels.iterator();
            while (verLevelDetailIt.hasNext()) {
                TalentReviewRuleVerLevelDetailInfo verLevelDetailInfo = (TalentReviewRuleVerLevelDetailInfo)verLevelDetailIt.next();
                levelRegionMap.put(verLevelDetailInfo.getName(), verDetailInfo.getSeq());
            }
        }
        return levelRegionMap;
    }

    private static int[][] getReviewResultRegion(int xSize, int ySize) {
        int[][] result = new int[xSize][ySize];
        int count = 0;
        for (int j = 0; j < ySize; ++j) {
            for (int i = xSize - 1; i >= 0; --i) {
                result[i][j] = count++;
            }
        }
        return result;
    }

    private EvaResultSummaryCollection getEvaResultBySolution(Context ctx, TalentReviewRuleInfo ruleInfo, Set<String> personIds) throws BOSException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("person.id"));
        selectors.add(new SelectorItemInfo("positionId"));
        selectors.add(new SelectorItemInfo("perfFile.adminOrgUnit.id"));
        selectors.add(new SelectorItemInfo("hrOrgUnit.id"));
        selectors.add(new SelectorItemInfo("perfModel.id"));
        selectors.add(new SelectorItemInfo("periodTimeNumber"));
        selectors.add(new SelectorItemInfo("periodNumber"));
        selectors.add(new SelectorItemInfo("period.perfRule.pariMutual.id"));
        selectors.add(new SelectorItemInfo("period.perfRule.pariMutual.max"));
        selectors.add(new SelectorItemInfo("period.perfRule.pariMutual.min"));
        selectors.add(new SelectorItemInfo("multiPerfPlan.perfScore"));
        selectors.add(new SelectorItemInfo("multiPerfPlan.perfScore.max"));
        selectors.add(new SelectorItemInfo("multiPerfPlan.perfScore.min"));
        selectors.add(new SelectorItemInfo("perfScorLevelDefine.sysPerfLevel"));
        selectors.add(new SelectorItemInfo("perfScorLevel.perfScoreInfo.id"));
        selectors.add(new SelectorItemInfo("perfScorLevel.perfScoreInfo.max"));
        selectors.add(new SelectorItemInfo("perfScorLevel.perfScoreInfo.min"));
        selectors.add(new SelectorItemInfo("perfScorLevel.perfLevelDefInfo.*"));
        selectors.add(new SelectorItemInfo("lastSumScore"));
        selectors.add(new SelectorItemInfo("lastGradeLevel"));
        selectors.add(new SelectorItemInfo("perfFile.assignType"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit", (Object)ruleInfo.getSolution().getHrOrgUnit().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("person", personIds, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)3));
        filterInfo.getFilterItems().add(new FilterItemInfo("perfModel", (Object)ruleInfo.getHorPerfModel().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("periodTimeNumber", (Object)ruleInfo.getHorTimeNumber()));
        filterInfo.getFilterItems().add(new FilterItemInfo("perfModel", (Object)ruleInfo.getVerPerfModel().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("periodTimeNumber", (Object)ruleInfo.getVerTimeNumber()));
        filterInfo.setMaskString("#0 and #1 and #2 and ((#3 and #4) or (#5 and #6))");
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("perfModel.id"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectors);
        evi.setSorter(sorters);
        return EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection(evi);
    }

    private static void translateResultScore(EvaResultSummaryInfo info) {
        PerfScoreInfo perfscoreInfo = TalentReviewResultControllerBean.getPerfScore(info);
        info.setLastSumScore(TalentReviewResultControllerBean.toHundredMarkScore(perfscoreInfo, info.getLastSumScore()));
    }

    private static PerfScoreInfo getPerfScore(EvaResultSummaryInfo info) {
        PerfScoreInfo perfscoreInfo = new PerfScoreInfo();
        if (info.getPerfScorLevel() != null) {
            perfscoreInfo.setId(info.getPerfScorLevel().getPerfScoreInfo().getId());
            perfscoreInfo.setMax(info.getPerfScorLevel().getPerfScoreInfo().getMax());
            perfscoreInfo.setMin(info.getPerfScorLevel().getPerfScoreInfo().getMin());
        }
        if (info.getPeriod() != null && info.getPeriod().getPerfRule() != null && info.getPeriod().getPerfRule().getPariMutual() != null) {
            perfscoreInfo.setId(info.getPeriod().getPerfRule().getPariMutual().getId());
            perfscoreInfo.setMax(info.getPeriod().getPerfRule().getPariMutual().getMax());
            perfscoreInfo.setMin(info.getPeriod().getPerfRule().getPariMutual().getMin());
        }
        if (info.getMultiPerfPlan() != null && info.getMultiPerfPlan().getPerfScore() != null) {
            perfscoreInfo.setId(info.getMultiPerfPlan().getPerfScore().getId());
            perfscoreInfo.setMax(info.getMultiPerfPlan().getPerfScore().getMax());
            perfscoreInfo.setMin(info.getMultiPerfPlan().getPerfScore().getMin());
        }
        return perfscoreInfo;
    }

    private static double toHundredMarkScore(PerfScoreInfo perfscoreInfo, double score) {
        if (perfscoreInfo != null) {
            BigDecimal max = perfscoreInfo.getMax();
            BigDecimal min = perfscoreInfo.getMin();
            if (max == null || min == null) {
                return score;
            }
            return BigDecimal.valueOf(score).multiply(BigDecimal.valueOf(100L)).divide(max.subtract(min), 2, RoundingMode.HALF_UP).doubleValue();
        }
        return score;
    }

    private static Set<String> getReviewObjectPersonIds(TalentReviewObjectCollection reviewObjectColl) {
        HashSet<String> personIds = new HashSet<String>();
        if (reviewObjectColl != null && !reviewObjectColl.isEmpty()) {
            Iterator it = reviewObjectColl.iterator();
            while (it.hasNext()) {
                TalentReviewObjectInfo objectInfo = (TalentReviewObjectInfo)it.next();
                personIds.add(objectInfo.getPerson().getId().toString());
            }
        }
        return personIds;
    }

    private static Set<String> getReviewObjectPositionIds(TalentReviewObjectCollection reviewObjectColl) {
        HashSet<String> positionIds = new HashSet<String>();
        if (reviewObjectColl != null && !reviewObjectColl.isEmpty()) {
            Iterator it = reviewObjectColl.iterator();
            while (it.hasNext()) {
                TalentReviewObjectInfo objectInfo = (TalentReviewObjectInfo)it.next();
                positionIds.add(objectInfo.getPosition().getId().toString());
            }
        }
        return positionIds;
    }
}

