/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.comprehensive.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EvalplanCycleTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.comprehensive.IPerfScoreConvertFacade;
import com.kingdee.shr.perfweb.app.comprehensive.PerfScoreConvertFacadeFactory;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryPersonEvaObjectFactory;
import com.kingdee.shr.perfweb.app.comprehensive.PerfSummaryPersonEvaObjectInfo;
import com.kingdee.shr.perfweb.app.comprehensive.SumCalDataDetailFactory;
import com.kingdee.shr.perfweb.app.comprehensive.SumCalDataRefTypeEnum;
import com.kingdee.shr.perfweb.app.comprehensive.SumCalDataTypeEnum;
import com.kingdee.shr.perfweb.util.PersonInchargeUtils;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumCalFunService {
    private static Logger logger = LoggerFactory.getLogger(SumCalFunService.class);

    public double getPerPeriodScore(Context ctx, Map<String, Object> params, String year, String frequency, String period, String evaluMode, String hrOrgUnit, String employeeType) throws EASBizException, BOSException {
        BigDecimal max;
        BigDecimal min;
        this.checkParamIsNull(year, frequency, period, evaluMode);
        int frequencyType = this.convertFrequency(frequency);
        String oriPeriod = period;
        if ("0".equals(period)) {
            period = year;
        }
        Integer convertEmployeeType = this.getEmployeeType(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"), employeeType);
        String personId = this.getPersonId(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
        HashSet<String> set = new HashSet<String>();
        set.add(personId);
        EvaResultSummaryCollection evaResultSummaryCollection = this.getEvaResultSummaryCollectionWithAudited(ctx, year, Collections.singleton(period), frequencyType, evaluMode, hrOrgUnit, convertEmployeeType, set);
        if (evaResultSummaryCollection == null || evaResultSummaryCollection.size() == 0) {
            logger.error("current summaryPeriod result is empty, T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
            throw new BOSException("current period result is empty");
        }
        if (evaResultSummaryCollection.size() > 1) {
            logger.error("current period is more than one result, T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
            throw new BOSException("current period is more than one result");
        }
        EvaResultSummaryInfo evaResultSummaryInfo = evaResultSummaryCollection.get(0);
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISSELF, SumCalDataRefTypeEnum.PERSON, evaResultSummaryInfo.getId().toString(), String.valueOf(evaResultSummaryInfo.getLastSumScore()));
        IPerfScoreConvertFacade scoreConvertFacade = PerfScoreConvertFacadeFactory.getLocalInstance(ctx);
        if (evaResultSummaryInfo.getMultiPerfPlan() == null || evaResultSummaryInfo.getMultiPerfPlan().getPerfRate() == null) {
            if (YesOrNoEnum.YES == evaResultSummaryInfo.getIsImportByHand() || evaResultSummaryInfo.getPerfScorLevel() != null) {
                min = evaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMin();
                max = evaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMax();
            } else {
                min = evaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMin();
                max = evaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMax();
            }
        } else {
            min = evaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMin();
            max = evaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMax();
        }
        return scoreConvertFacade.convertScore(evaResultSummaryInfo.getLastSumScore(), min, max, new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMIN")), new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMAX")));
    }

    private String getPersonId(Context ctx, String summaryEvaObjId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((CharSequence)summaryEvaObjId)) {
            throw new BOSException("param [T_EVA_EVARESULTSUMMARY_EVAOBJID] is null");
        }
        PerfSummaryPersonEvaObjectInfo perfSummaryPersonEvaObjectInfo = PerfSummaryPersonEvaObjectFactory.getLocalInstance(ctx).getPerfSummaryPersonEvaObjectInfo("select id, person.id where id = '" + summaryEvaObjId + "'");
        return perfSummaryPersonEvaObjectInfo.getPerson().getId().toString();
    }

    private EvaResultSummaryCollection getEvaResultSummaryCollectionWithAudited(Context ctx, String year, Set<String> periods, int frequencyType, String evaluMode, String hrOrgUnit, Integer employeeType, Set<String> personIdSet) throws BOSException {
        return this.getEvaResultSummaryCollection(ctx, year, periods, frequencyType, evaluMode, hrOrgUnit, employeeType, personIdSet, 3);
    }

    private EvaResultSummaryCollection getEvaResultSummaryCollection(Context ctx, String year, Set<String> periods, int frequencyType, String evaluMode, String hrOrgUnit, Integer employeeType, Set<String> personIdSet, Integer billState) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("billState");
        sic.add("lastSumScore");
        sic.add("lastGradeLevel");
        sic.add("isImportByHand");
        sic.add("period.perfRule.pariMutual.*");
        sic.add("multiPerfPlan.perfRate.*");
        sic.add("perfScorLevel.perfScoreInfo.*");
        evi.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        if (billState != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)billState, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("periodYear", (Object)year, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("periodTime", periods, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)frequencyType, CompareType.EQUALS));
        if (StringUtils.isNotEmpty((CharSequence)evaluMode)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("perfModel.number", (Object)evaluMode, CompareType.EQUALS));
        }
        if (StringUtils.isNotEmpty((CharSequence)hrOrgUnit)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.number", (Object)hrOrgUnit, CompareType.EQUALS));
        }
        if (employeeType != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("perfFile.assignType", (Object)employeeType, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", personIdSet, CompareType.INCLUDE));
        return EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection(evi);
    }

    private Integer getEmployeeType(Context ctx, String summaryEvaObjId, String employeeType) throws BOSException, EASBizException {
        if (StringUtils.isNotEmpty((CharSequence)employeeType)) {
            return Integer.valueOf(employeeType);
        }
        if (StringUtils.isEmpty((CharSequence)summaryEvaObjId)) {
            throw new BOSException("param [T_EVA_EVARESULTSUMMARY_EVAOBJID] is null");
        }
        PerfSummaryPersonEvaObjectInfo perfSummaryPersonEvaObjectInfo = PerfSummaryPersonEvaObjectFactory.getLocalInstance(ctx).getPerfSummaryPersonEvaObjectInfo("select id, assignType where id = '" + summaryEvaObjId + "'");
        return perfSummaryPersonEvaObjectInfo.getAssignType().getValue();
    }

    private int convertFrequency(String frequency) throws BOSException {
        switch (frequency) {
            case "Y": 
            case "100": {
                return 100;
            }
            case "H": 
            case "200": {
                return 200;
            }
            case "Q": 
            case "300": {
                return 300;
            }
            case "M": 
            case "400": {
                return 400;
            }
        }
        return this.convertFrequencyByCycleTypeEnum(frequency);
    }

    private int convertFrequencyByCycleTypeEnum(String frequency) throws BOSException {
        if (EvalplanCycleTypeEnum.FULL_YEAR.getAlias(LocaleUtils.getDefaultLocale()).equals(frequency)) {
            return 100;
        }
        if (EvalplanCycleTypeEnum.HALF_YEAR.getAlias(LocaleUtils.getDefaultLocale()).equals(frequency)) {
            return 200;
        }
        if (EvalplanCycleTypeEnum.QUARTER.getAlias(LocaleUtils.getDefaultLocale()).equals(frequency)) {
            return 300;
        }
        if (EvalplanCycleTypeEnum.MONTHLY.getAlias(LocaleUtils.getDefaultLocale()).equals(frequency)) {
            return 400;
        }
        throw new BOSException("param [frequency] is invalid");
    }

    private void checkParamIsNull(String year, String frequency, String period, String evaluMode) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)year)) {
            throw new BOSException("param [year] is null");
        }
        if (StringUtils.isEmpty((CharSequence)frequency)) {
            throw new BOSException("param [frequency] is null");
        }
        if (StringUtils.isEmpty((CharSequence)period)) {
            throw new BOSException("param [period] is null");
        }
        if (StringUtils.isEmpty((CharSequence)evaluMode)) {
            throw new BOSException("param [evaluMode] is null");
        }
    }

    public String getPerPeriodGrade(Context ctx, Map<String, Object> params, String year, String frequency, String period, String evaluMode, String hrOrgUnit, String employeeType) throws EASBizException, BOSException {
        this.checkParamIsNull(year, frequency, period, evaluMode);
        int frequencyType = this.convertFrequency(frequency);
        String oriPeriod = period;
        if ("0".equals(period)) {
            period = year;
        }
        Integer convertEmployeeType = this.getEmployeeType(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"), employeeType);
        String personId = this.getPersonId(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
        HashSet<String> set = new HashSet<String>();
        set.add(personId);
        EvaResultSummaryCollection evaResultSummaryCollection = this.getEvaResultSummaryCollectionWithAudited(ctx, year, Collections.singleton(period), frequencyType, evaluMode, hrOrgUnit, convertEmployeeType, set);
        if (evaResultSummaryCollection == null || evaResultSummaryCollection.size() == 0) {
            logger.error("current period is empty, T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
            throw new BOSException("current period result is empty");
        }
        if (evaResultSummaryCollection.size() > 1) {
            logger.error("current period is more than one result, T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
            throw new BOSException("current period is more than one result");
        }
        EvaResultSummaryInfo evaResultSummaryInfo = evaResultSummaryCollection.get(0);
        String lastGradeLevel = evaResultSummaryInfo.getLastGradeLevel();
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISSELF, SumCalDataRefTypeEnum.PERSON, evaResultSummaryInfo.getId().toString(), lastGradeLevel);
        return lastGradeLevel;
    }

    public double getOrgPeriodScore(Context ctx, Map<String, Object> params, String year, String frequency, String period, String evaluMode, String hrOrgUnit) throws EASBizException, BOSException {
        BigDecimal max;
        BigDecimal min;
        OrgEvaResultSummaryCollection orgEvaResultSummaryCollection;
        this.checkParamIsNull(year, frequency, period, evaluMode);
        int frequencyType = this.convertFrequency(frequency);
        String oriPeriod = period;
        if ("0".equals(period)) {
            period = year;
        }
        if ((orgEvaResultSummaryCollection = this.getOrgEvaResultSummaryCollectionWithAudited(ctx, year, Collections.singleton(period), frequencyType, evaluMode, hrOrgUnit, this.getOrgAdminId(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID")))) == null || orgEvaResultSummaryCollection.size() == 0) {
            logger.error("current period is empty, T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
            throw new BOSException("current period result is empty");
        }
        if (orgEvaResultSummaryCollection.size() > 1) {
            logger.error("current period is more than one result, T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
            throw new BOSException("current period is more than one result");
        }
        OrgEvaResultSummaryInfo orgEvaResultSummaryInfo = orgEvaResultSummaryCollection.get(0);
        double lastSumScore = orgEvaResultSummaryInfo.getLastSumScore();
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISORG, SumCalDataRefTypeEnum.ORG, orgEvaResultSummaryInfo.getId().toString(), String.valueOf(lastSumScore));
        IPerfScoreConvertFacade scoreConvertFacade = PerfScoreConvertFacadeFactory.getLocalInstance(ctx);
        if (orgEvaResultSummaryInfo.getMultiPerfPlan() == null || orgEvaResultSummaryInfo.getMultiPerfPlan().getPerfRate() == null) {
            if (YesOrNoEnum.YES == orgEvaResultSummaryInfo.getIsImportByHand() || orgEvaResultSummaryInfo.getPerfScorLevel() != null) {
                min = orgEvaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMin();
                max = orgEvaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMax();
            } else {
                min = orgEvaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMin();
                max = orgEvaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMax();
            }
        } else {
            min = orgEvaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMin();
            max = orgEvaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMax();
        }
        return scoreConvertFacade.convertScore(lastSumScore, min, max, new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMIN")), new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMAX")));
    }

    private String getOrgAdminId(Context ctx, String summaryEvaObjId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((CharSequence)summaryEvaObjId)) {
            throw new BOSException("param [T_EVA_EVARESULTSUMMARY_EVAOBJID] is null");
        }
        PerfSummaryPersonEvaObjectInfo perfSummaryPersonEvaObjectInfo = PerfSummaryPersonEvaObjectFactory.getLocalInstance(ctx).getPerfSummaryPersonEvaObjectInfo("select adminOrgUnit.id where id = '" + summaryEvaObjId + "'");
        return perfSummaryPersonEvaObjectInfo.getAdminOrgUnit().getId().toString();
    }

    private OrgEvaResultSummaryCollection getOrgEvaResultSummaryCollectionWithAudited(Context ctx, String year, Set<String> periods, int frequencyType, String evaluMode, String hrOrgUnit, String orgAdminId) throws BOSException {
        return this.getOrgEvaResultSummaryCollection(ctx, year, periods, frequencyType, evaluMode, hrOrgUnit, orgAdminId, 3);
    }

    private OrgEvaResultSummaryCollection getOrgEvaResultSummaryCollection(Context ctx, String year, Set<String> periods, int frequencyType, String evaluMode, String hrOrgUnit, String orgAdminId, Integer billState) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("billState");
        sic.add("lastSumScore");
        sic.add("lastGradeLevel");
        sic.add("isImportByHand");
        sic.add("period.perfRule.pariMutual.*");
        sic.add("multiPerfPlan.perfRate.*");
        sic.add("perfScorLevel.perfScoreInfo.*");
        evi.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        if (billState != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)billState, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("periodYear", (Object)year, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("periodTime", periods, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("periodType", (Object)frequencyType, CompareType.EQUALS));
        if (StringUtils.isNotEmpty((CharSequence)evaluMode)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("perfModel.number", (Object)evaluMode, CompareType.EQUALS));
        }
        if (StringUtils.isNotEmpty((CharSequence)hrOrgUnit)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.number", (Object)hrOrgUnit, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)orgAdminId, CompareType.EQUALS));
        return OrgEvaResultSummaryFactory.getLocalInstance(ctx).getOrgEvaResultSummaryCollection(evi);
    }

    public String getOrgPeriodGrade(Context ctx, Map<String, Object> params, String year, String frequency, String period, String evaluMode, String hrOrgUnit) throws EASBizException, BOSException {
        OrgEvaResultSummaryCollection orgEvaResultSummaryCollection;
        this.checkParamIsNull(year, frequency, period, evaluMode);
        int frequencyType = this.convertFrequency(frequency);
        String oriPeriod = period;
        if ("0".equals(period)) {
            period = year;
        }
        if ((orgEvaResultSummaryCollection = this.getOrgEvaResultSummaryCollectionWithAudited(ctx, year, Collections.singleton(period), frequencyType, evaluMode, hrOrgUnit, this.getOrgAdminId(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID")))) == null || orgEvaResultSummaryCollection.size() == 0) {
            logger.error("current period is empty, T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
            throw new BOSException("current period result is empty");
        }
        if (orgEvaResultSummaryCollection.size() > 1) {
            logger.error("current period is more than one result, T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
            throw new BOSException("current period is more than one result");
        }
        OrgEvaResultSummaryInfo orgEvaResultSummaryInfo = orgEvaResultSummaryCollection.get(0);
        String lastGradeLevel = orgEvaResultSummaryInfo.getLastGradeLevel();
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISORG, SumCalDataRefTypeEnum.ORG, orgEvaResultSummaryInfo.getId().toString(), lastGradeLevel);
        return lastGradeLevel;
    }

    public double getOrgHisPerScore(Context ctx, Map<String, Object> params, String year, String frequency, String timeOffset, String evaluMode, String hrOrgUnit) throws EASBizException, BOSException {
        this.checkParamIsNull(year, frequency, timeOffset, "evaluMode");
        int frequencyType = this.convertFrequency(frequency);
        Set<String> timePeriodSet = this.getTimePeriodSet(timeOffset);
        String orgAdminId = this.getOrgAdminId(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
        OrgEvaResultSummaryCollection orgEvaResultSummaryCollection = this.getOrgEvaResultSummaryCollection(ctx, year, timePeriodSet, frequencyType, evaluMode, hrOrgUnit, orgAdminId, null);
        double result = 0.0;
        if (orgEvaResultSummaryCollection == null || orgEvaResultSummaryCollection.size() == 0) {
            return result;
        }
        int count = 0;
        BigDecimal totalScore = BigDecimal.ZERO;
        HashMap<String, String> refObjectMap = new HashMap<String, String>();
        IPerfScoreConvertFacade scoreConvertFacade = PerfScoreConvertFacadeFactory.getLocalInstance(ctx);
        for (int i = 0; i < orgEvaResultSummaryCollection.size(); ++i) {
            BigDecimal max;
            BigDecimal min;
            OrgEvaResultSummaryInfo orgEvaResultSummaryInfo = orgEvaResultSummaryCollection.get(i);
            if (orgEvaResultSummaryInfo.getBillState() != HRBillStateEnum.AUDITED) {
                logger.error("exist data: result is not audited, T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
                throw new BOSException("exist data: result is not audited");
            }
            ++count;
            double lastSumScore = orgEvaResultSummaryInfo.getLastSumScore();
            if (orgEvaResultSummaryInfo.getMultiPerfPlan() == null || orgEvaResultSummaryInfo.getMultiPerfPlan().getPerfRate() == null) {
                if (YesOrNoEnum.YES == orgEvaResultSummaryInfo.getIsImportByHand()) {
                    min = orgEvaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMin();
                    max = orgEvaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMax();
                } else {
                    min = orgEvaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMin();
                    max = orgEvaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMax();
                }
            } else {
                min = orgEvaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMin();
                max = orgEvaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMax();
            }
            double convertScore = scoreConvertFacade.convertScore(lastSumScore, min, max, new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMIN")), new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMAX")));
            totalScore = totalScore.add(new BigDecimal(String.valueOf(convertScore)));
            refObjectMap.put(orgEvaResultSummaryInfo.getId().toString(), String.valueOf(lastSumScore));
        }
        result = totalScore.divide(new BigDecimal(String.valueOf(count)), 2, RoundingMode.HALF_UP).doubleValue();
        SumCalDataDetailFactory.getLocalInstance(ctx).batchAddCalDataDetail(params, SumCalDataTypeEnum.ISORG, SumCalDataRefTypeEnum.ORG, refObjectMap);
        return result;
    }

    public double getPerHisPerScore(Context ctx, Map<String, Object> params, String year, String frequency, String timeOffset, String evaluMode, String hrOrgUnit, String employeeType) throws EASBizException, BOSException {
        this.checkParamIsNull(year, frequency, timeOffset, "evaluMode");
        int frequencyType = this.convertFrequency(frequency);
        Set<String> timePeriodSet = this.getTimePeriodSet(timeOffset);
        String personId = this.getPersonId(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
        HashSet<String> set = new HashSet<String>();
        set.add(personId);
        Integer employeeTypeInt = StringUtils.isBlank((CharSequence)employeeType) ? null : Integer.valueOf(employeeType);
        EvaResultSummaryCollection resultSummaryCollection = this.getEvaResultSummaryCollection(ctx, year, timePeriodSet, frequencyType, evaluMode, hrOrgUnit, employeeTypeInt, set, null);
        double result = 0.0;
        if (resultSummaryCollection == null || resultSummaryCollection.size() == 0) {
            return result;
        }
        int count = 0;
        BigDecimal totalScore = BigDecimal.ZERO;
        HashMap<String, String> refObjectMap = new HashMap<String, String>();
        IPerfScoreConvertFacade scoreConvertFacade = PerfScoreConvertFacadeFactory.getLocalInstance(ctx);
        for (int i = 0; i < resultSummaryCollection.size(); ++i) {
            BigDecimal max;
            BigDecimal min;
            EvaResultSummaryInfo evaResultSummaryInfo = resultSummaryCollection.get(i);
            if (evaResultSummaryInfo.getBillState() != HRBillStateEnum.AUDITED) {
                logger.error("exist data: result is not audited, T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
                throw new BOSException("exist data: result is not audited");
            }
            ++count;
            String lastSumScor = String.valueOf(evaResultSummaryInfo.getLastSumScore());
            if (evaResultSummaryInfo.getMultiPerfPlan() == null || evaResultSummaryInfo.getMultiPerfPlan().getPerfRate() == null) {
                if (YesOrNoEnum.YES == evaResultSummaryInfo.getIsImportByHand()) {
                    min = evaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMin();
                    max = evaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMax();
                } else {
                    min = evaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMin();
                    max = evaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMax();
                }
            } else {
                min = evaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMin();
                max = evaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMax();
            }
            double convertScore = scoreConvertFacade.convertScore(Double.parseDouble(lastSumScor), min, max, new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMIN")), new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMAX")));
            totalScore = totalScore.add(new BigDecimal(String.valueOf(convertScore)));
            refObjectMap.put(evaResultSummaryInfo.getId().toString(), lastSumScor);
        }
        result = totalScore.divide(new BigDecimal(String.valueOf(count)), 2, RoundingMode.HALF_UP).doubleValue();
        SumCalDataDetailFactory.getLocalInstance(ctx).batchAddCalDataDetail(params, SumCalDataTypeEnum.ISSELF, SumCalDataRefTypeEnum.PERSON, refObjectMap);
        return result;
    }

    private Set<String> getTimePeriodSet(String timeOffset) throws BOSException {
        int lastNum;
        String[] timePeriodArr = timeOffset.split("-");
        if (timePeriodArr.length != 2) {
            throw new BOSException("param [timeOffset] is invalid");
        }
        int startNum = Integer.parseInt(timePeriodArr[0].trim());
        if (startNum > (lastNum = Integer.parseInt(timePeriodArr[1].trim()))) {
            throw new BOSException("param [timeOffset] is invalid, right < left");
        }
        HashSet<String> timePeriodSet = new HashSet<String>();
        do {
            timePeriodSet.add(String.valueOf(startNum++));
        } while (lastNum >= startNum);
        return timePeriodSet;
    }

    public double getOthersScore(Context ctx, Map<String, Object> params, String year, String frequency, String othersType, String periodOffset, String evaluMode, String hrOrgUnit, String employeeType) throws EASBizException, BOSException {
        BigDecimal max;
        BigDecimal min;
        this.checkParamIsNull(year, frequency, periodOffset, evaluMode);
        int frequencyType = this.convertFrequency(frequency);
        if ("0".equals(periodOffset)) {
            periodOffset = year;
        }
        Set personSet = this.getOthersTypePerson(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"), othersType, employeeType);
        Integer convertEmployeeType = this.getEmployeeType(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"), employeeType);
        EvaResultSummaryCollection evaResultSummaryCollection = this.getEvaResultSummaryCollectionWithAudited(ctx, year, Collections.singleton(periodOffset), frequencyType, evaluMode, hrOrgUnit, convertEmployeeType, personSet);
        if (evaResultSummaryCollection == null || evaResultSummaryCollection.size() == 0) {
            throw new BOSException("current period result is empty");
        }
        if (evaResultSummaryCollection.size() > 1) {
            throw new BOSException("current period is more than one result");
        }
        EvaResultSummaryInfo evaResultSummaryInfo = evaResultSummaryCollection.get(0);
        double lastSumScore = evaResultSummaryInfo.getLastSumScore();
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISNOTSELF, SumCalDataRefTypeEnum.PERSON, evaResultSummaryInfo.getId().toString(), String.valueOf(lastSumScore));
        IPerfScoreConvertFacade scoreConvertFacade = PerfScoreConvertFacadeFactory.getLocalInstance(ctx);
        if (evaResultSummaryInfo.getMultiPerfPlan() == null || evaResultSummaryInfo.getMultiPerfPlan().getPerfRate() == null) {
            if (YesOrNoEnum.YES == evaResultSummaryInfo.getIsImportByHand()) {
                min = evaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMin();
                max = evaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMax();
            } else {
                min = evaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMin();
                max = evaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMax();
            }
        } else {
            min = evaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMin();
            max = evaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMax();
        }
        return scoreConvertFacade.convertScore(lastSumScore, min, max, new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMIN")), new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMAX")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set getOthersTypePerson(Context ctx, String summaryEvaObjId, String othersType, String employeeType) throws BOSException, EASBizException {
        String position;
        PerfSummaryPersonEvaObjectInfo perfSummaryPersonEvaObjectInfo = PerfSummaryPersonEvaObjectFactory.getLocalInstance(ctx).getPerfSummaryPersonEvaObjectInfo("select id,position, position.parent.id,position.parent.parent,id, adminOrgUnit.responPosition.id ,assignType where id = '" + summaryEvaObjId + "'");
        if ("0".equals(othersType)) {
            if (perfSummaryPersonEvaObjectInfo.getAdminOrgUnit() == null || perfSummaryPersonEvaObjectInfo.getAdminOrgUnit().getResponPosition() == null) throw new BOSException("param [othersType] can not get ResponPosition");
            position = perfSummaryPersonEvaObjectInfo.getAdminOrgUnit().getResponPosition().getId().toString();
        } else if ("1".equals(othersType)) {
            if (perfSummaryPersonEvaObjectInfo.getPosition() == null || perfSummaryPersonEvaObjectInfo.getPosition().getParent() == null) throw new BOSException("param [othersType] can not get PositionParent");
            position = perfSummaryPersonEvaObjectInfo.getPosition().getParent().getId().toString();
        } else if ("2".equals(othersType)) {
            if (perfSummaryPersonEvaObjectInfo.getPosition() == null || perfSummaryPersonEvaObjectInfo.getPosition().getParent() == null) throw new BOSException("param [othersType] can not get PositionParentParent");
            position = perfSummaryPersonEvaObjectInfo.getPosition().getParent().getParent().getId().toString();
        } else {
            PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select id,name where number = '" + othersType + "'");
            if (personCollection == null || personCollection.size() <= 0) throw new BOSException("param [othersType] can not get person");
            if (personCollection.size() > 1) {
                throw new BOSException("param [othersType] get more then one person");
            }
            HashSet<String> set = new HashSet<String>();
            set.add(personCollection.get(0).getId().toString());
            return set;
        }
        HashSet<String> positionSetSpecial = new HashSet<String>();
        positionSetSpecial.add(position);
        Map<String, List<PersonInfo>> map = PersonInchargeUtils.getPositionMembers(ctx, positionSetSpecial);
        List<PersonInfo> personInfos = map.get(position);
        if (personInfos == null || personInfos.size() <= 0) throw new BOSException("param [othersType] throw position can not get personinfo");
        if (personInfos.size() > 1) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < personInfos.size(); ++i) {
                set.add(personInfos.get(i).getId().toString());
            }
            return set;
        }
        HashSet<String> set = new HashSet<String>();
        set.add(personInfos.get(0).getId().toString());
        return set;
    }

    public String getOthersGrade(Context ctx, Map<String, Object> params, String year, String frequency, String othersType, String periodOffset, String evaluMode, String hrOrgUnit, String employeeType) throws EASBizException, BOSException {
        this.checkParamIsNull(year, frequency, periodOffset, evaluMode);
        int frequencyType = this.convertFrequency(frequency);
        if ("0".equals(periodOffset)) {
            periodOffset = year;
        }
        Set personSet = this.getOthersTypePerson(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"), othersType, employeeType);
        Integer convertEmployeeType = this.getEmployeeType(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"), employeeType);
        EvaResultSummaryCollection evaResultSummaryCollection = this.getEvaResultSummaryCollectionWithAudited(ctx, year, Collections.singleton(periodOffset), frequencyType, evaluMode, hrOrgUnit, convertEmployeeType, personSet);
        if (evaResultSummaryCollection == null || evaResultSummaryCollection.size() == 0) {
            throw new BOSException("current period result is empty");
        }
        if (evaResultSummaryCollection.size() > 1) {
            throw new BOSException("current period is more than one result");
        }
        EvaResultSummaryInfo evaResultSummaryInfo = evaResultSummaryCollection.get(0);
        String lastGradeLevel = evaResultSummaryInfo.getLastGradeLevel();
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISNOTSELF, SumCalDataRefTypeEnum.PERSON, evaResultSummaryInfo.getId().toString(), lastGradeLevel);
        return lastGradeLevel;
    }

    public double getOrgScore(Context ctx, Map<String, Object> params, String year, String frequency, String orgType, String periodOffset, String evaluMode, String hrOrgUnit) throws EASBizException, BOSException {
        BigDecimal max;
        BigDecimal min;
        this.checkParamIsNull(year, frequency, periodOffset, evaluMode);
        int frequencyType = this.convertFrequency(frequency);
        if ("0".equals(periodOffset)) {
            periodOffset = year;
        }
        OrgEvaResultSummaryInfo orgEvaResultSummaryInfo = this.getOrgScoreOrgEvaResultSummaryInfo(ctx, params, year, orgType, periodOffset, evaluMode, hrOrgUnit, frequencyType);
        double lastSumScore = orgEvaResultSummaryInfo.getLastSumScore();
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISORG, SumCalDataRefTypeEnum.ORG, orgEvaResultSummaryInfo.getId().toString(), String.valueOf(lastSumScore));
        IPerfScoreConvertFacade scoreConvertFacade = PerfScoreConvertFacadeFactory.getLocalInstance(ctx);
        if (orgEvaResultSummaryInfo.getMultiPerfPlan() == null || orgEvaResultSummaryInfo.getMultiPerfPlan().getPerfRate() == null) {
            if (YesOrNoEnum.YES == orgEvaResultSummaryInfo.getIsImportByHand()) {
                min = orgEvaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMin();
                max = orgEvaResultSummaryInfo.getPerfScorLevel().getPerfScoreInfo().getMax();
            } else {
                min = orgEvaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMin();
                max = orgEvaResultSummaryInfo.getPeriod().getPerfRule().getPariMutual().getMax();
            }
        } else {
            min = orgEvaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMin();
            max = orgEvaResultSummaryInfo.getMultiPerfPlan().getPerfRate().getPerfScoreInfo().getMax();
        }
        return scoreConvertFacade.convertScore(lastSumScore, min, max, new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMIN")), new BigDecimal((String)params.get("T_EVA_EVARESULTSUMMARY_PARIMUTUALMAX")));
    }

    private OrgEvaResultSummaryInfo getOrgScoreOrgEvaResultSummaryInfo(Context ctx, Map<String, Object> params, String year, String orgType, String periodOffset, String evaluMode, String hrOrgUnit, int frequencyType) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgUnitInfo;
        String currentAdminId = this.getOrgAdminId(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
        String superAdminId = "";
        IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection adminOrgSic = new SelectorItemCollection();
        if ("0".equals(orgType) || "2".equalsIgnoreCase(orgType)) {
            adminOrgSic.add("department.number");
            adminOrgUnitInfo = adminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentAdminId), adminOrgSic);
            if (adminOrgUnitInfo.getDepartment() == null) {
                throw new BOSException("belong to department is null ");
            }
            superAdminId = adminOrgUnitInfo.getDepartment().getId().toString();
        } else if ("1".equals(orgType)) {
            adminOrgSic.add("department.parent.number");
            adminOrgUnitInfo = adminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentAdminId), adminOrgSic);
            if (adminOrgUnitInfo.getDepartment() == null || adminOrgUnitInfo.getDepartment().getParent() == null) {
                throw new BOSException("belong to department is null ");
            }
            if (adminOrgUnitInfo.getDepartment().getParent() == null) {
                throw new BOSException("belong to department.parent is null ");
            }
            AdminOrgUnitInfo parent = adminOrgUnitInfo.getDepartment().getParent();
            superAdminId = parent.getId().toString();
        } else if ("3".equalsIgnoreCase(orgType) || "4".equalsIgnoreCase(orgType)) {
            adminOrgSic.add("company.number");
            adminOrgUnitInfo = adminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentAdminId), adminOrgSic);
            if (adminOrgUnitInfo.getCompany() == null) {
                throw new BOSException("belong to campany is null ");
            }
            superAdminId = adminOrgUnitInfo.getCompany().getId().toString();
        } else {
            AdminOrgUnitCollection adminOrgUnitCollection = adminOrgUnit.getAdminOrgUnitCollection(" where number='" + orgType + "'");
            if (adminOrgUnitCollection.size() > 0) {
                superAdminId = adminOrgUnitCollection.get(0).getId().toString();
            } else {
                throw new BOSException("============= the orgType can not get admin");
            }
        }
        OrgEvaResultSummaryCollection orgEvaResultSummaryCollection = this.getOrgEvaResultSummaryCollectionWithAudited(ctx, year, Collections.singleton(periodOffset), frequencyType, evaluMode, hrOrgUnit, superAdminId);
        if ((orgEvaResultSummaryCollection == null || orgEvaResultSummaryCollection.size() == 0) && ("4".equalsIgnoreCase(orgType) || "2".equalsIgnoreCase(orgType))) {
            adminOrgSic = new SelectorItemCollection();
            adminOrgSic.add("parent.number");
            AdminOrgUnitInfo adminOrgUnitInfo2 = adminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(superAdminId), adminOrgSic);
            AdminOrgUnitInfo parent = adminOrgUnitInfo2.getParent();
            if (null == parent) {
                throw new BOSException("============= the admin " + superAdminId + " \u2019s parent admin is null");
            }
            superAdminId = parent.getId().toString();
            orgEvaResultSummaryCollection = this.getOrgEvaResultSummaryCollectionWithAudited(ctx, year, Collections.singleton(periodOffset), frequencyType, evaluMode, hrOrgUnit, superAdminId);
        }
        if (orgEvaResultSummaryCollection == null || orgEvaResultSummaryCollection.size() == 0) {
            logger.error("current period is empty, belong admin is " + superAdminId + " T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
            throw new BOSException("current period  result is empty");
        }
        if (orgEvaResultSummaryCollection.size() > 1) {
            logger.error("current period is more than one result,belong admin is " + superAdminId + " T_EVA_EVARESULTSUMMARY_EVAOBJID is {}", params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
            throw new BOSException("current period is more than one result");
        }
        OrgEvaResultSummaryInfo orgEvaResultSummaryInfo = orgEvaResultSummaryCollection.get(0);
        return orgEvaResultSummaryInfo;
    }

    public String getOrgGrade(Context ctx, Map<String, Object> params, String year, String frequency, String orgType, String periodOffset, String evaluMode, String hrOrgUnit) throws EASBizException, BOSException {
        this.checkParamIsNull(year, frequency, periodOffset, evaluMode);
        int frequencyType = this.convertFrequency(frequency);
        if ("0".equals(periodOffset)) {
            periodOffset = year;
        }
        OrgEvaResultSummaryInfo orgEvaResultSummaryInfo = this.getOrgScoreOrgEvaResultSummaryInfo(ctx, params, year, orgType, periodOffset, evaluMode, hrOrgUnit, frequencyType);
        String lastGradeLevel = orgEvaResultSummaryInfo.getLastGradeLevel();
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISORG, SumCalDataRefTypeEnum.ORG, orgEvaResultSummaryInfo.getId().toString(), lastGradeLevel);
        return lastGradeLevel;
    }

    public double getIndicatorScore(Context ctx, Map<String, Object> params, String year, String frequency, String indicatorName, String indicatorNumber, String periodOffset, String evaluMode) throws EASBizException, BOSException {
        IndicatorTargetCollection indicatorTargetCollection = this.getIndicatorTargetCollection(ctx, params, year, frequency, indicatorName, indicatorNumber, periodOffset, evaluMode);
        IndicatorTargetInfo indicatorTargetInfo = indicatorTargetCollection.get(0);
        String score = indicatorTargetInfo.getScore();
        if (StringUtils.isEmpty((CharSequence)score)) {
            throw new BOSException(" current  indicatorTarget do not have score");
        }
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISSELF, SumCalDataRefTypeEnum.INDICATORSCORE, indicatorTargetInfo.getId().toString(), score);
        return Double.valueOf(score.toString());
    }

    private IndicatorTargetCollection getIndicatorTargetCollection(Context ctx, Map<String, Object> params, String year, String frequency, String indicatorName, String indicatorNumber, String periodOffset, String evaluMode) throws BOSException, EASBizException {
        IndicatorTargetCollection indicatorTargetCollection;
        this.checkParamIsNull(year, frequency, periodOffset, evaluMode);
        int frequencyType = this.convertFrequency(frequency);
        if ("0".equals(periodOffset)) {
            periodOffset = year;
        }
        if (StringUtils.isEmpty((CharSequence)indicatorName) && StringUtils.isEmpty((CharSequence)indicatorNumber)) {
            throw new BOSException("param [indicatorName] and  param [indicatorNumber]  can not both been null");
        }
        String personId = this.getPersonId(ctx, (String)params.get("T_EVA_EVARESULTSUMMARY_EVAOBJID"));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("score");
        sic.add("grade");
        sic.add("targetValue");
        sic.add("actualCompleValue");
        evi.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("perfPeriod.year", (Object)year, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("perfPeriod.timePeriod", (Object)periodOffset, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("perfPeriod.cycleType", (Object)frequencyType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaPlan.perfModel.number", (Object)evaluMode, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        if (StringUtils.isNotEmpty((CharSequence)indicatorName)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)indicatorName, CompareType.EQUALS));
        }
        if (StringUtils.isNotEmpty((CharSequence)indicatorNumber)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)indicatorNumber, CompareType.EQUALS));
        }
        if ((indicatorTargetCollection = IndicatorTargetFactory.getLocalInstance(ctx).getIndicatorTargetCollection(evi)) == null || indicatorTargetCollection.size() == 0) {
            throw new BOSException("current indicatorTarget result is empty");
        }
        if (indicatorTargetCollection.size() > 1) {
            throw new BOSException("current indicatorTarget is more than one result");
        }
        return indicatorTargetCollection;
    }

    public String getIndicatorGrade(Context ctx, Map<String, Object> params, String year, String frequency, String indicatorName, String indicatorNumber, String periodOffset, String evaluMode) throws EASBizException, BOSException {
        IndicatorTargetCollection indicatorTargetCollection = this.getIndicatorTargetCollection(ctx, params, year, frequency, indicatorName, indicatorNumber, periodOffset, evaluMode);
        IndicatorTargetInfo indicatorTargetInfo = indicatorTargetCollection.get(0);
        String grade = indicatorTargetInfo.getGrade();
        if (StringUtils.isEmpty((CharSequence)grade)) {
            throw new BOSException(" current  indicatorTarget do not have grade");
        }
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISSELF, SumCalDataRefTypeEnum.INDICATORSCORE, indicatorTargetInfo.getId().toString(), grade);
        return grade;
    }

    public String getIndicatorTargetVal(Context ctx, Map<String, Object> params, String year, String frequency, String indicatorName, String indicatorNumber, String periodOffset, String evaluMode) throws EASBizException, BOSException {
        IndicatorTargetCollection indicatorTargetCollection = this.getIndicatorTargetCollection(ctx, params, year, frequency, indicatorName, indicatorNumber, periodOffset, evaluMode);
        IndicatorTargetInfo indicatorTargetInfo = indicatorTargetCollection.get(0);
        String targetValue = indicatorTargetInfo.getTargetValue();
        if (StringUtils.isEmpty((CharSequence)targetValue)) {
            throw new BOSException(" current  targetValue do not have grade");
        }
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISSELF, SumCalDataRefTypeEnum.ACHIEVEMENTDATA, indicatorTargetInfo.getId().toString(), targetValue);
        return targetValue;
    }

    public String getIndiActComVal(Context ctx, Map<String, Object> params, String year, String frequency, String indicatorName, String indicatorNumber, String periodOffset, String evaluMode) throws EASBizException, BOSException {
        IndicatorTargetCollection indicatorTargetCollection = this.getIndicatorTargetCollection(ctx, params, year, frequency, indicatorName, indicatorNumber, periodOffset, evaluMode);
        IndicatorTargetInfo indicatorTargetInfo = indicatorTargetCollection.get(0);
        String actualCompleValue = indicatorTargetInfo.getActualCompleValue();
        if (StringUtils.isEmpty((CharSequence)actualCompleValue)) {
            throw new BOSException(" current  actualCompleValue do not have grade");
        }
        SumCalDataDetailFactory.getLocalInstance(ctx).addCalDataDetail(params, SumCalDataTypeEnum.ISSELF, SumCalDataRefTypeEnum.ACHIEVEMENTDATA, indicatorTargetInfo.getId().toString(), actualCompleValue);
        return actualCompleValue;
    }

    public String getOffsetVal(String originVal, double offset) {
        if (!NumberUtils.isDigits((String)originVal)) {
            return "";
        }
        int result = Integer.valueOf(originVal) + (int)offset;
        return String.valueOf(result);
    }
}

