/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IWholeComment;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentCollection;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentFactory;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentInfo;
import com.kingdee.shr.perfweb.portal.serviceImpl.PerfGoasFillService;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class GetBacthGrandingInfoService
implements IHRMsfService {
    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String[] nodeTaskIds = String.valueOf(param.get("nodeTaskId")).split(",");
        String[] ruleIds = String.valueOf(param.get("ruleId")).split(",");
        HashMap<String, Object> resultAll = new HashMap<String, Object>();
        if (nodeTaskIds != null && nodeTaskIds.length > 0 && ruleIds != null && ruleIds.length > 0) {
            HashSet<String> nodeTaskIdSet = new HashSet<String>();
            nodeTaskIdSet.addAll(Arrays.asList(nodeTaskIds));
            HashSet<String> ruleIdSet = new HashSet<String>();
            ruleIdSet.addAll(Arrays.asList(ruleIds));
            this.getWholeDetails(ctx, nodeTaskIdSet, ruleIdSet, resultAll);
        }
        return resultAll;
    }

    private void getWholeDetails(Context ctx, Set<String> nodeTaskIdSet, Set<String> ruleIdSet, Map<String, Object> resultAll) throws BOSException {
        Map<String, GradeTaskNodeInstInfo> instMap = this.getGradeTaskNodeInstInfoMap(ctx, nodeTaskIdSet);
        Map<String, Map<String, GradeTargetInstInfo>> targetInstMap = this.getGradeTargetInstInfoMap(ctx, nodeTaskIdSet);
        Map<String, WholeCommentInfo> commentMap = this.getWholeCommentInfoMap(ctx, nodeTaskIdSet);
        Map<String, PerformanceRuleInfo> ruleInfoMap = this.getPerformanceRuleInfoMap(ctx, ruleIdSet);
        HashSet<String> perfRateIds = new HashSet<String>();
        for (Map.Entry<String, PerformanceRuleInfo> entry : ruleInfoMap.entrySet()) {
            PerformanceRuleInfo rule = entry.getValue();
            perfRateIds.add(rule.getPerfRate().getId().toString());
        }
        Map<String, Map<String, String>> perfScoreLevelMaps = this.getPerfScoreLevelMap(ctx, perfRateIds);
        Map<String, Map<String, String>> levelPerfScoreKVInfoMaps = this.getLevelPerfScoreKVInfoMap(ctx, perfRateIds);
        HashMap ruleResultMap = new HashMap();
        for (Map.Entry<String, PerformanceRuleInfo> entry : ruleInfoMap.entrySet()) {
            String perfRuleId = entry.getKey();
            PerformanceRuleInfo rule = entry.getValue();
            String perfRateId = rule.getPerfRate().getId().toString();
            HashMap<String, Object> rateMap = new HashMap<String, Object>();
            Map<String, String> perfScoreLevelMap = perfScoreLevelMaps.get(perfRateId);
            rateMap.put("perfRateRange", perfScoreLevelMap);
            Map<String, String> perfScoreLevelRangeMap = levelPerfScoreKVInfoMaps.get(perfRateId);
            rateMap.put("perfScoreLevelRange", perfScoreLevelRangeMap);
            rateMap.put("perfScoreMax", rule.getPerfRate().getPerfScoreInfo().getMax());
            rateMap.put("perfScoreMin", rule.getPerfRate().getPerfScoreInfo().getMin());
            rateMap.put("perfScoreName", rule.getPerfRate().getPerfScoreInfo().getName());
            ruleResultMap.put(perfRuleId, rateMap);
        }
        DecimalFormat df = new DecimalFormat("#.##");
        for (Map.Entry<String, GradeTaskNodeInstInfo> entry : instMap.entrySet()) {
            String nodeTaskId = entry.getKey();
            GradeTaskNodeInstInfo info = entry.getValue();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("isShowWholeGrade", (Object)info.getIsShowWholeGrade());
            result.put("wholeComment", info.getWfNode().getWholeComment().getValue());
            result.put("canRate", info.getWfNode().getNeedScore().getValue());
            result.put("perfGradeEvaluate", info.getWfNode().getPerfGradeEvaluate().getValue());
            Map<String, GradeTargetInstInfo> targetMap = targetInstMap.get(nodeTaskId);
            result.put("targetTask", targetMap);
            WholeCommentInfo wholeInfo = commentMap.get(nodeTaskId);
            if (wholeInfo.get("score") != null) {
                HashMap<String, String> targrtMap = GetEntityInfoUtils.getCalcNodeSumScore(ctx, nodeTaskId, info.getEvaObj().getId().toString());
                if (targrtMap.get("showTarget") != null && targrtMap.get("showTarget").equals("0")) {
                    Object _sumScore = targrtMap.get("sumScore");
                    if (!StringUtils.isEmpty((CharSequence)String.valueOf(_sumScore))) {
                        BigDecimal wholeScore = new BigDecimal(String.valueOf(wholeInfo.get("score"))).subtract(new BigDecimal(String.valueOf(_sumScore)));
                        result.put("wholeScore", wholeScore.compareTo(BigDecimal.ZERO) <= 0 ? "0" : df.format(wholeScore));
                    } else {
                        result.put("wholeScore", df.format(wholeInfo.getScore()));
                    }
                } else {
                    result.put("wholeScore", df.format(wholeInfo.getScore()));
                }
            } else {
                result.put("wholeScore", wholeInfo.get("score"));
            }
            result.put("wholeGrade", wholeInfo.getGrade());
            result.put("comment", wholeInfo.getComment());
            result.put("evaObjId", info.getEvaObj().getId().toString());
            String perfRuleId = info.getPeriod().getPerfPlan().getPerfRule().getId().toString();
            Map perfRateMap = (Map)ruleResultMap.get(perfRuleId);
            result.putAll(perfRateMap);
            resultAll.put(info.getId().toString(), result);
        }
    }

    private Map<String, GradeTaskNodeInstInfo> getGradeTaskNodeInstInfoMap(Context ctx, Set<String> nodeTaskIds) throws BOSException {
        HashMap<String, GradeTaskNodeInstInfo> instMap = new HashMap<String, GradeTaskNodeInstInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaObj.*"));
        sic.add(new SelectorItemInfo("period.perfPlan.perfRule.id"));
        sic.add(new SelectorItemInfo("wfNode.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", nodeTaskIds, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        GradeTaskNodeInstCollection coll = GradeTaskNodeInstFactory.getLocalInstance(ctx).getGradeTaskNodeInstCollection(viewInfo);
        if (coll != null && !coll.isEmpty()) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                GradeTaskNodeInstInfo instInfo = (GradeTaskNodeInstInfo)it.next();
                instMap.put(instInfo.getId().toString(), instInfo);
            }
        }
        return instMap;
    }

    private Map<String, Map<String, GradeTargetInstInfo>> getGradeTargetInstInfoMap(Context ctx, Set<String> nodeTaskIds) throws BOSException {
        HashMap<String, Map<String, GradeTargetInstInfo>> targetMap = new HashMap<String, Map<String, GradeTargetInstInfo>>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("gradeTaskNode", nodeTaskIds, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        GradeTargetInstCollection coll = GradeTargetInstFactory.getLocalInstance(ctx).getGradeTargetInstCollection(viewInfo);
        if (coll != null && !coll.isEmpty()) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                GradeTargetInstInfo instInfo = (GradeTargetInstInfo)it.next();
                String targetID = instInfo.getTarget();
                String taskNodeId = instInfo.getGradeTaskNode().getId().toString();
                HashMap<String, GradeTargetInstInfo> targetInstMap = (HashMap<String, GradeTargetInstInfo>)targetMap.get(taskNodeId);
                if (targetInstMap == null) {
                    targetInstMap = new HashMap<String, GradeTargetInstInfo>();
                }
                targetInstMap.put(targetID, instInfo);
                targetMap.put(taskNodeId, targetInstMap);
            }
        }
        return targetMap;
    }

    private Map<String, WholeCommentInfo> getWholeCommentInfoMap(Context ctx, Set<String> nodeTaskIds) throws BOSException {
        HashMap<String, WholeCommentInfo> commentMap = new HashMap<String, WholeCommentInfo>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("gradeTaskNodeInst", nodeTaskIds, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        WholeCommentCollection coll = WholeCommentFactory.getLocalInstance(ctx).getWholeCommentCollection(viewInfo);
        if (coll != null && !coll.isEmpty()) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                WholeCommentInfo commentInfo = (WholeCommentInfo)it.next();
                String taskNodeId = commentInfo.getGradeTaskNodeInst().getId().toString();
                commentMap.put(taskNodeId, commentInfo);
            }
        }
        return commentMap;
    }

    private Map<String, PerformanceRuleInfo> getPerformanceRuleInfoMap(Context ctx, Set<String> ruleIds) throws BOSException {
        HashMap<String, PerformanceRuleInfo> ruleInfoMap = new HashMap<String, PerformanceRuleInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("pariMutual.*"));
        sic.add(new SelectorItemInfo("scoreRate.*"));
        sic.add(new SelectorItemInfo("perfRate.*"));
        sic.add(new SelectorItemInfo("perfRate.perfScoreInfo.*"));
        sic.add(new SelectorItemInfo("perfRate.perfLevelDefInfo.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ruleIds, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        PerformanceRuleCollection coll = PerformanceRuleFactory.getLocalInstance(ctx).getPerformanceRuleCollection(viewInfo);
        if (coll != null && !coll.isEmpty()) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                PerformanceRuleInfo ruleInfo = (PerformanceRuleInfo)it.next();
                String ruleId = ruleInfo.getId().toString();
                ruleInfoMap.put(ruleId, ruleInfo);
            }
        }
        return ruleInfoMap;
    }

    private Map<String, Map<String, String>> getPerfScoreLevelMap(Context ctx, Set<String> perfRateIds) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        PerfGoasFillService perfGoasFillService = new PerfGoasFillService();
        for (String perfRateId : perfRateIds) {
            Map<String, String> perfScoreLevelMap = perfGoasFillService.getPerfScoreLevelKV(ctx, perfRateId);
            resultMap.put(perfRateId, perfScoreLevelMap);
        }
        return resultMap;
    }

    private Map<String, Map<String, String>> getLevelPerfScoreKVInfoMap(Context ctx, Set<String> perfRateIds) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        PerfGoasFillService perfGoasFillService = new PerfGoasFillService();
        for (String perfRateId : perfRateIds) {
            Map<String, String> perfScoreLevelRangeMap = perfGoasFillService.getLevelPerfScoreKVInfo(ctx, perfRateId);
            resultMap.put(perfRateId, perfScoreLevelRangeMap);
        }
        return resultMap;
    }

    @Deprecated
    private void getWholeDetail(Context ctx, String nodeTaskId, Map<String, Object> resultAll, String ruleId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaObj.*"));
        sic.add(new SelectorItemInfo("wfNode.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)nodeTaskId, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        GradeTaskNodeInstCollection coll = GradeTaskNodeInstFactory.getLocalInstance(ctx).getGradeTaskNodeInstCollection(viewInfo);
        GradeTaskNodeInstInfo info = coll.get(0);
        GradeTargetInstCollection gradeTaskColl = GradeTargetInstFactory.getLocalInstance(ctx).getGradeTargetInstCollection("where gradeTaskNode = '" + nodeTaskId + "'");
        HashMap<String, GradeTargetInstInfo> targetMap = new HashMap<String, GradeTargetInstInfo>();
        for (int i = 0; i < gradeTaskColl.size(); ++i) {
            String targetID = gradeTaskColl.get(i).getTarget();
            GradeTargetInstInfo gradeInfo = gradeTaskColl.get(i);
            targetMap.put(targetID, gradeInfo);
        }
        result.put("isShowWholeGrade", (Object)info.getIsShowWholeGrade());
        result.put("wholeComment", info.getWfNode().getWholeComment().getValue());
        result.put("canRate", info.getWfNode().getNeedScore().getValue());
        result.put("perfGradeEvaluate", info.getWfNode().getPerfGradeEvaluate().getValue());
        result.put("targetTask", targetMap);
        IWholeComment iWholeComment = WholeCommentFactory.getLocalInstance(ctx);
        WholeCommentInfo wholeInfo = iWholeComment.getWholeCommentInfo("WHERE gradeTaskNodeInst ='" + nodeTaskId + "'");
        DecimalFormat df = new DecimalFormat("#.##");
        if (wholeInfo.get("score") != null) {
            HashMap<String, String> targrtMap = GetEntityInfoUtils.getCalcNodeSumScore(ctx, nodeTaskId, info.getEvaObj().getId().toString());
            if (targrtMap.get("showTarget") != null && targrtMap.get("showTarget").equals("0")) {
                Object _sumScore = targrtMap.get("sumScore");
                if (!StringUtils.isEmpty((CharSequence)String.valueOf(_sumScore))) {
                    BigDecimal wholeScore = new BigDecimal(String.valueOf(wholeInfo.get("score"))).subtract(new BigDecimal(String.valueOf(_sumScore)));
                    result.put("wholeScore", wholeScore.compareTo(BigDecimal.ZERO) <= 0 ? "0" : df.format(wholeScore));
                } else {
                    result.put("wholeScore", df.format(wholeInfo.getScore()));
                }
            } else {
                result.put("wholeScore", df.format(wholeInfo.getScore()));
            }
        } else {
            result.put("wholeScore", wholeInfo.get("score"));
        }
        result.put("wholeGrade", wholeInfo.getGrade());
        result.put("comment", wholeInfo.getComment());
        result.put("evaObjId", info.getEvaObj().getId().toString());
        this.getScoreOrRankDetail(ctx, ruleId, result);
        resultAll.put(info.getId().toString(), result);
    }

    private void getScoreOrRankDetail(Context ctx, String ruleId, Map<String, Object> result) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("pariMutual.*"));
        sic.add(new SelectorItemInfo("scoreRate.*"));
        sic.add(new SelectorItemInfo("perfRate.*"));
        sic.add(new SelectorItemInfo("perfRate.perfScoreInfo.*"));
        sic.add(new SelectorItemInfo("perfRate.perfLevelDefInfo.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ruleId, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        PerformanceRuleCollection coll = PerformanceRuleFactory.getLocalInstance(ctx).getPerformanceRuleCollection(viewInfo);
        PerformanceRuleInfo rule = coll.get(0);
        PerfGoasFillService perfGoasFillService = new PerfGoasFillService();
        ArrayList<String> perfRateList = new ArrayList<String>();
        for (int i = 0; i < rule.getPerfRate().getPerfLevelDefInfo().size(); ++i) {
            if (rule.getPerfRate().getPerfLevelDefInfo().get(i).getPerfLevelName() == null) {
                perfRateList.add(rule.getPerfRate().getPerfLevelDefInfo().get(i).getSysPerfLevel());
                continue;
            }
            perfRateList.add(rule.getPerfRate().getPerfLevelDefInfo().get(i).getPerfLevelName());
        }
        Map<String, String> perfScoreLevelMap = perfGoasFillService.getPerfScoreLevelKV(ctx, rule.getPerfRate().getId().toString());
        result.put("perfRateRange", perfScoreLevelMap);
        Map<String, String> perfScoreLevelRangeMap = perfGoasFillService.getLevelPerfScoreKVInfo(ctx, rule.getPerfRate().getId().toString());
        result.put("perfScoreLevelRange", perfScoreLevelRangeMap);
        result.put("perfScoreMax", rule.getPerfRate().getPerfScoreInfo().getMax());
        result.put("perfScoreMin", rule.getPerfRate().getPerfScoreInfo().getMin());
        result.put("perfScoreName", rule.getPerfRate().getPerfScoreInfo().getName());
    }
}

