/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.portal.serviceImpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.portal.bean.AreaFieldBean;
import com.kingdee.shr.perfweb.portal.bean.EvaAreaListBean;
import com.kingdee.shr.perfweb.portal.serviceImpl.AbstractAreaTypeBaseService;
import com.kingdee.shr.perfweb.portal.serviceImpl.AbstractPerfScoreService;
import com.kingdee.shr.perfweb.portal.serviceImpl.AreaTypeServiceFactory;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfFillScoreService
extends AbstractPerfScoreService {
    private final Logger logger = LoggerFactory.getLogger(PerfFillScoreService.class);

    @Override
    protected String buildAreaQuerySql(Context ctx, String gradeTaskNode, String evaObjId, String personId, String reluId) throws SQLException, BOSException {
        StringBuilder areaBaseIdCondition = new StringBuilder("(''");
        StringBuilder evaFormABSb = new StringBuilder(" where id in ");
        String selectSqlSb = "select distinct FAreaBaseID from T_EVA_IndicatorTarget where FEvaObjID=?  and FID in (select FTarget from T_EVA_GradeTargetInst where FGradeTaskNodeID in (select fid from T_EVA_GradeTaskNodeInst where FEvaObjId = ? and FNodeHandlerId = ? and FTaskStatus = '1') and FTargetType='200') union all select distinct FAreaBaseID from T_EVA_RECORDTARGET Target where FEvaObjID=?  and FID in (select FTarget from T_EVA_GradeTargetInst where FGradeTaskNodeID in (select fid from T_EVA_GradeTaskNodeInst where FEvaObjId = ? and FNodeHandlerId = ? and FTaskStatus = '1') and FTargetType='300')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSqlSb, (Object[])new Object[]{evaObjId, evaObjId, personId, evaObjId, evaObjId, personId});
        while (rs.next()) {
            areaBaseIdCondition.append(",'").append(rs.getString("FAreaBaseID")).append("'");
        }
        areaBaseIdCondition.append(")");
        evaFormABSb.append((CharSequence)areaBaseIdCondition).append("and performanceRule='").append(reluId).append("' order by Seq ASC");
        return evaFormABSb.toString();
    }

    @Override
    protected void packageTargetDetailInfo(Context ctx, IRowSet rowSet, EvaAreaListBean evaAreaBean, String gradeTaskNode, String personId, PerfEvaObjectInfo evaObjectInfo) throws SQLException, BOSException, EASBizException {
        AbstractAreaTypeBaseService areaTypeService = AreaTypeServiceFactory.getAreaTypeService(evaAreaBean.getAreaType());
        if (areaTypeService == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("PerfScoreFillService get areaTypeService is null");
            }
            return;
        }
        areaTypeService.packageTargetDetailInfo(ctx, rowSet, evaAreaBean, gradeTaskNode, personId, evaObjectInfo, "1");
    }

    @Override
    protected IRowSet executeTargetQuerySql(Context ctx, YesOrNoEnum isShowQuantity, String areaType, ArrayList<AreaFieldBean> fieldList, String evaObj, String areaId, String personId) throws BOSException {
        StringBuilder sqlBuilder = new StringBuilder("select indicator.FID AS FID,indicator.FEXTENDID AS FEXTENDID,indicator.FWEIGHT AS FWEIGHT");
        for (int k = 0; k < fieldList.size(); ++k) {
            String colName = fieldList.get(k).getColName();
            if (colName.equalsIgnoreCase("FWEIGHT")) continue;
            if (colName.toUpperCase(Locale.ENGLISH).contains("EXTEND")) {
                sqlBuilder.append(",helper.").append(colName).append(" AS ").append(colName);
                continue;
            }
            if ("200".equals(areaType) && IndicatorUtils.multiTBField4Indicator.contains(colName.toUpperCase(Locale.ENGLISH)) || "300".equals(areaType) && IndicatorUtils.multiTBField4Record.contains(colName.toUpperCase(Locale.ENGLISH))) {
                sqlBuilder.append(",indicator.").append(colName).append(SHRPerfWebResourceUtil.getMlFlag(ctx)).append(" AS ").append(colName);
                continue;
            }
            sqlBuilder.append(",indicator.").append(colName).append(" AS ").append(colName);
        }
        if ("200".equals(areaType)) {
            for (String multiField : IndicatorUtils.multiTBFields4Indicator) {
                sqlBuilder.append(",indicator.").append(multiField).append(" AS ").append(multiField);
            }
            if (isShowQuantity == null || isShowQuantity == YesOrNoEnum.YES) {
                sqlBuilder.append(" from T_EVA_IndicatorTarget  indicator left join T_EVA_IndicatorExtendHelper helper on indicator.FExtendId = helper.FID  where indicator.FEvaObjID=? and indicator.FAreaBaseID=? and indicator.FID in (").append(" select FTarget from T_EVA_GradeTargetInst where FGradeTaskNodeID in (").append("select fid from t_eva_gradetasknodeinst where FEvaObjID =? and FNodeHandlerID = ? and FTaskStatus = '1'").append(") and FTargetType='").append("200").append("') order by indicator.FSeq asc, to_char(indicator.FCreateTime, 'YYYY-MM-DD HH24:MI:SS')  asc,indicator.FNumber asc ,indicator.FName").append(SHRPerfWebResourceUtil.getMlFlag(ctx)).append(" asc ");
            } else {
                sqlBuilder.append(" from T_EVA_IndicatorTarget  indicator left join T_EVA_IndicatorExtendHelper helper on indicator.FExtendId = helper.FID  where (indicator.FqualiOrRation = '0' or ((indicator.FScoringFormula is null or indicator.FScoringFormula = '') and indicator.FqualiOrRation = '1' ) ) and indicator.FEvaObjID=? and indicator.FAreaBaseID=? and indicator.FID in (").append(" select FTarget from T_EVA_GradeTargetInst where FGradeTaskNodeID in (").append("select fid from t_eva_gradetasknodeinst where FEvaObjID =? and FNodeHandlerID = ? and FTaskStatus = '1'").append(") and FTargetType='").append("200").append("') order by indicator.FSeq asc, to_char(indicator.FCreateTime, 'YYYY-MM-DD HH24:MI:SS') asc,indicator.FNumber asc, indicator.FName").append(SHRPerfWebResourceUtil.getMlFlag(ctx)).append(" asc ");
            }
            return DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{evaObj, areaId, evaObj, personId});
        }
        if ("300".equals(areaType)) {
            for (String multiField : IndicatorUtils.multiTBFields4Record) {
                sqlBuilder.append(",indicator.").append(multiField).append(" AS ").append(multiField);
            }
            sqlBuilder.append(" from t_eva_gradetargetinst targetinst left join T_EVA_RecordTarget indicator on targetinst.FTarget=indicator.FID ").append(" left join T_EVA_IndicatorExtendHelper helper on indicator.FExtendId = helper.FID").append(" where indicator.FEvaObjID=? and indicator.FAreaBaseID=?  and targetinst.FID in (").append(" select FID from T_EVA_GradeTargetInst where FGradeTaskNodeID in(").append("select fid from t_eva_gradetasknodeinst where FEvaObjID =? and FNodeHandlerID = ? and FTaskStatus = '1'").append(") and FTargetType='").append("300").append("') order by indicator.FSeq asc, to_char(indicator.FCreateTime, 'YYYY-MM-DD HH24:MI:SS')  asc ,indicator.FKeyCode asc,indicator.FKeyItem").append(SHRPerfWebResourceUtil.getMlFlag(ctx)).append(" asc ");
            return DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{evaObj, areaId, evaObj, personId});
        }
        return null;
    }

    @Override
    protected boolean isNeedCopy(String concurrent) {
        return "1".equals(concurrent);
    }

    @Override
    protected String buildGradeTargetSql(String concurrent, String targetTableName, String areaBaseIdStr, String evaObjId, String nodeHandlerId, int wfLevel) {
        String sqlStr = "select nodeInst.fid as id, target.FAreaBaseID as areaBaseId";
        if (this.isNeedCopy(concurrent)) {
            sqlStr = "select nodeInst.fid as id, targetInst.fid as gradeNodeInstId, targetInst.ftarget as targetId, targetInst.ftargetScore as targetScore, targetInst.fgradeRank as gradeRank, targetInst.fisRejection as isRejection, targetInst.fcomment as comments, target.FAreaBaseID as areaBaseId";
        }
        sqlStr = sqlStr + " from t_eva_gradetasknodeinst nodeInst left join T_EVA_GradeTargetInst targetInst on targetInst.FGradeTaskNodeID =nodeInst.FID left join " + targetTableName + " target on target.FID=targetInst.ftarget where target.FAreaBaseID in (" + areaBaseIdStr + ") and nodeInst.FEvaObjID ='" + evaObjId + "' and nodeInst.FNodeHandlerID ='" + nodeHandlerId + "' and nodeInst.ftaskStatus = '1'";
        if (this.isNeedCopy(concurrent)) {
            sqlStr = sqlStr + " and nodeInst.fwfLevel = " + wfLevel;
        }
        return sqlStr;
    }

    @Override
    protected void dealFillTargetInfo(Context ctx, Map<String, Object> result, PerfEvaObjectInfo evaObjectInfo, PerfPeriodInfo periodInfo) throws BOSException, EASBizException {
    }
}

