/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfGoalsObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IUniteIndicatorMemory;
import com.kingdee.shr.perfweb.app.base.evalplan.IUniteRecordMemory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteIndicatorMemoryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.UniteRecordMemoryFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScoreInfo;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JudgeExistsUtils {
    public static final float TOTALWEIGHT = 100.0f;
    private static Logger logger = LoggerFactory.getLogger(JudgeExistsUtils.class);

    public static boolean goalsGroupIsReferenced(String groupId) {
        try {
            IPerfEvaObject iperfEvaObj = PerfEvaObjectFactory.getRemoteInstance();
            if (iperfEvaObj.exists(" where belongGroup='" + groupId + "'")) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        return false;
    }

    public static boolean isExistGoalsTransmitObject(Context ctx, String evaObj) {
        try {
            IPerfGoalsObject iPerfGoalsObject = PerfGoalsObjectFactory.getLocalInstance(ctx);
            if (iPerfGoalsObject.exists(" where perfEvaObject='" + evaObj + "'")) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return false;
    }

    public static int isExistGoalsTransmitObject(Context ctx, String[] evaObjs, Set<String> validEvaObjs, boolean isDirectlyFlag) {
        int noGoalsObjCount = 0;
        try {
            HashSet<String> evaObjIds = new HashSet<String>();
            for (int i = 0; i < evaObjs.length; ++i) {
                evaObjIds.add(evaObjs[i]);
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObject", evaObjIds, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            IPerfGoalsObject iPerfGoalsObject = PerfGoalsObjectFactory.getLocalInstance(ctx);
            PerfGoalsObjectCollection coll = iPerfGoalsObject.getPerfGoalsObjectCollection(evi);
            if (coll == null || coll.size() == 0) {
                noGoalsObjCount = evaObjIds.size();
            } else {
                for (int i = 0; i < coll.size(); ++i) {
                    PerfGoalsObjectInfo perfGoalsObjectInfo = coll.get(i);
                    validEvaObjs.add(perfGoalsObjectInfo.getPerfEvaObject().getId().toString());
                }
                evaObjIds.removeAll(validEvaObjs);
                noGoalsObjCount = evaObjIds.size();
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return noGoalsObjCount;
    }

    public static boolean isDirectlyValidGoalsTransmitObject(Context ctx, String period, String groupId) {
        int scoreWay = 0;
        BigDecimal maxScore = new BigDecimal("0.00");
        try {
            String firstStepSql = "select FPerfRuleID from T_EVA_PerfPeriod where FID = ?";
            Object[] params = new Object[]{period};
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)firstStepSql, (Object[])params);
            BigDecimal totalWeight = BigDecimal.ZERO;
            if (rowset.next()) {
                params[0] = rowset.getString("FPerfRuleID");
                PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfo(ctx, String.valueOf(params[0]));
                scoreWay = ruleInfo.getScoringWay().getValue();
                if (null != ruleInfo.getPariMutual() && null != ruleInfo.getPariMutual().getId()) {
                    PerfScoreInfo scoreInfo = GetEntityInfoUtils.getPerfScoreInfoById(ctx, ruleInfo.getPariMutual().getId().toString());
                    maxScore = scoreInfo.getMax().setScale(2, 4);
                }
                String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
                String secondStepSql = "select fid,FName" + mlFlag + " FName,FAreaWeight,FAreaType,FWeightControl,FSumScoreRule  from T_EVA_EvaluFormAreaBase where FPerformanceRuleID=? and FAreaType not in ('" + "100" + "','" + "400" + "') order by FSeq ASC";
                rowset = DbUtil.executeQuery((Context)ctx, (String)secondStepSql, (Object[])params);
                while (rowset.next()) {
                    BigDecimal areaContorlWeightDec;
                    HashMap map = new HashMap();
                    String areaBaseId = rowset.getString("fid");
                    StringBuffer filedSb = new StringBuffer();
                    String areaType = rowset.getString("FAreaType");
                    String sumScoreRule = rowset.getString("FSumScoreRule");
                    String areaContorlWeight = rowset.getString("FAreaWeight");
                    String weightControl = rowset.getString("FWeightControl");
                    boolean sumScoreRuleFlag = false;
                    if (StringUtils.isNotEmpty((CharSequence)sumScoreRule)) {
                        sumScoreRuleFlag = sumScoreRule.equals("400") || sumScoreRule.equals("500");
                    }
                    String filedConfSQL = "";
                    if (areaType.equals("200")) {
                        filedConfSQL = "select FColName,FShowName" + mlFlag + " AS FShowName,FSeqNo from T_EVA_EvaFormFieldConf where FAreaBase=? order by FSeqNo ASC";
                    } else if (areaType.equals("300")) {
                        filedConfSQL = "select FColName,FShowName" + mlFlag + " AS FShowName,FSeqNo from T_EVA_RecordFieldConf where FAreaBase=? order by FSeqNo ASC";
                    }
                    Object[] params1 = new Object[]{areaBaseId};
                    IRowSet fieldConfRs = DbUtil.executeQuery((Context)ctx, (String)filedConfSQL, (Object[])params1);
                    ArrayList<String> fList = new ArrayList<String>();
                    while (fieldConfRs.next()) {
                        String colName = fieldConfRs.getString("FColName");
                        if (colName.toUpperCase(Locale.ENGLISH).startsWith("FEXTEND")) continue;
                        filedSb.append(",");
                        filedSb.append(colName);
                        fList.add(colName);
                    }
                    String selectField = filedSb.toString().replaceFirst(",", "");
                    if (StringUtils.isEmpty((CharSequence)selectField)) continue;
                    StringBuffer targetSQLBuffer = new StringBuffer();
                    StringBuffer targetMemerySQLBuffer = new StringBuffer();
                    if (areaType.equals("200")) {
                        targetSQLBuffer.append("select FID,").append(selectField).append(" from T_EVA_UniteIndicator where FBeGroupID=? and FPerfPeriod=? and FAreaBase=?");
                        targetMemerySQLBuffer.append("select FID,").append(selectField).append(" from T_EVA_UniteIndicatorMemory where FUindicatorID=?");
                    } else if (areaType.equals("300")) {
                        targetSQLBuffer.append("select FID,").append(selectField).append(" from T_EVA_UniteRecord where FBeGroupID=? and FPerfPeriod=? and FAreaBase=?");
                        targetMemerySQLBuffer.append("select FID,").append(selectField).append(" from T_EVA_UniteRecordMemory where FUniteRecordID=?");
                    }
                    Object[] params2 = new Object[]{groupId, period, areaBaseId};
                    IRowSet targetRs = DbUtil.executeQuery((Context)ctx, (String)targetSQLBuffer.toString(), (Object[])params2);
                    String value = "";
                    BigDecimal areaWeight = BigDecimal.ZERO;
                    IUniteIndicatorMemory iUniteIndicatorMemory = UniteIndicatorMemoryFactory.getLocalInstance(ctx);
                    IUniteRecordMemory iUniteRecordMemory = UniteRecordMemoryFactory.getLocalInstance(ctx);
                    while (targetRs.next()) {
                        String indicatorId = targetRs.getString("FID");
                        if (iUniteIndicatorMemory.exists(" where uindicator='" + indicatorId + "'") || iUniteRecordMemory.exists(" where uniteRecord='" + indicatorId + "'")) {
                            Object[] memeryParams = new Object[]{indicatorId};
                            IRowSet memeryRs = DbUtil.executeQuery((Context)ctx, (String)targetMemerySQLBuffer.toString(), (Object[])memeryParams);
                            while (memeryRs.next()) {
                                for (String colName : fList) {
                                    value = memeryRs.getString(colName);
                                    String string = value = value == null ? "" : value;
                                    if (colName.equals("FWEIGHT") && scoreWay == 0) {
                                        value = value == null || value.equals("") ? "0" : value;
                                        areaWeight = areaWeight.add(new BigDecimal(value));
                                        continue;
                                    }
                                    if (!colName.equals("FTARSCORE") || scoreWay != 1) continue;
                                    value = value == null || value.equals("") ? "0" : value;
                                    areaWeight = areaWeight.add(new BigDecimal(value));
                                }
                            }
                            continue;
                        }
                        for (String colName : fList) {
                            value = targetRs.getString(colName);
                            String string = value = value == null ? "" : value;
                            if (colName.equals("FWEIGHT") && scoreWay == 0) {
                                value = value == null || value.equals("") ? "0" : value;
                                areaWeight = areaWeight.add(new BigDecimal(value));
                                continue;
                            }
                            if (!colName.equals("FTARSCORE") || scoreWay != 1) continue;
                            value = value == null || value.equals("") ? "0" : value;
                            areaWeight = areaWeight.add(new BigDecimal(value));
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)areaContorlWeight) && (areaContorlWeightDec = new BigDecimal(areaContorlWeight)).compareTo(areaWeight) != 0) {
                        return false;
                    }
                    if (sumScoreRuleFlag) continue;
                    totalWeight = totalWeight.add(areaWeight);
                }
            }
            BigDecimal _totalWight = new BigDecimal(String.valueOf(totalWeight)).setScale(2, 4);
            if (scoreWay == 1 && _totalWight.equals(maxScore)) {
                return true;
            }
            if (totalWeight.floatValue() == 100.0f && scoreWay == 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return false;
    }
}

