/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.bean.PerfTaskFilerBean;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import shaded.org.apache.parquet.Strings;

public class PerfTaskUtil {
    private static Logger logger = LoggerFactory.getLogger(PerfTaskUtil.class);

    public static Set<String> getTaskIdsByFilter(Context ctx, String currentPersonId, PerfTaskFilerBean perfTaskFilerBean) {
        HashSet<String> result = new HashSet<String>();
        IRowSet dataSet = null;
        try {
            dataSet = DbUtil.executeQuery((Context)ctx, (String)PerfTaskUtil.getPerfTaskFilterSql(ctx, currentPersonId, perfTaskFilerBean));
            while (dataSet.next()) {
                String taskId = dataSet.getString("TASKID");
                if (StringUtils.isEmpty((String)taskId)) continue;
                result.add(taskId);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return result;
    }

    public static String getPerfTaskFilterSql(Context ctx, String currentPersonId, PerfTaskFilerBean perfTaskFilerBean) {
        boolean IGNORE_VISIBETYPE = false;
        boolean ONLY_MY = false;
        boolean ONLY_OTHERS = false;
        boolean VISIBETYPE_DEPARTMENT = true;
        boolean VISIBETYPE_SUPERIOR = true;
        boolean VISIBETYPE_ALL = true;
        boolean VISIBETYPE_ASSIGNER = true;
        boolean ONLY_SUBORDINATES = false;
        Set<Object> indicatorIds = new HashSet();
        Set<Object> recordIds = new HashSet();
        String customFilterSQL = " ";
        if (perfTaskFilerBean != null) {
            if (!StringUtils.isEmpty((String)perfTaskFilerBean.getCustomFilterSQL())) {
                customFilterSQL = "  AND " + perfTaskFilerBean.getCustomFilterSQL() + " ";
            }
            indicatorIds = perfTaskFilerBean.getIndicatorIds();
            recordIds = perfTaskFilerBean.getRecordIds();
            ONLY_MY = perfTaskFilerBean.isONLY_MY();
            ONLY_OTHERS = perfTaskFilerBean.isONLY_OTHERS();
            VISIBETYPE_DEPARTMENT = perfTaskFilerBean.isVISIBETYPE_DEPARTMENT();
            VISIBETYPE_SUPERIOR = perfTaskFilerBean.isVISIBETYPE_SUPERIOR();
            VISIBETYPE_ALL = perfTaskFilerBean.isVISIBETYPE_ALL();
            VISIBETYPE_ASSIGNER = perfTaskFilerBean.isVISIBETYPE_ASSIGNER();
            ONLY_SUBORDINATES = perfTaskFilerBean.isONLY_SUBORDINATES();
            IGNORE_VISIBETYPE = perfTaskFilerBean.isIGNORE_VISIBETYPE();
        }
        PositionInfo currentPositionInfo = null;
        AdminOrgUnitInfo currentAdminOrgUnit = null;
        try {
            currentPositionInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryPosition(BOSUuid.read((String)currentPersonId));
            if (currentPositionInfo == null) {
                throw new NullPointerException("currentPositionInfo can not be null!");
            }
            currentAdminOrgUnit = currentPositionInfo.getAdminOrgUnit();
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        if (currentAdminOrgUnit == null) {
            throw new NullPointerException("currentAdminOrgUnit can not be null!");
        }
        String MY_OTHER_SQL = " ";
        String VISIBETYPE_DEPARTMENT_SQL = " ";
        String VISIBETYPE_SUPERIOR_SQL = " ";
        String VISIBETYPE_ALL_SQL = " ";
        String VISIBETYPE_ASSIGNER_SQL = " ";
        String ONLYSUBORDINATES_SQL = " ";
        String ONLY_MY_TAIL_SQL = " ";
        String INDICATOR_RECORD_FILTER_SQL = " ";
        if (!CollectionUtils.isEmpty(indicatorIds) || !CollectionUtils.isEmpty(recordIds)) {
            String join;
            INDICATOR_RECORD_FILTER_SQL = "  AND (1=2  ";
            if (!CollectionUtils.isEmpty(indicatorIds)) {
                join = Strings.join((String[])indicatorIds.toArray(new String[indicatorIds.size()]), (String)"','");
                INDICATOR_RECORD_FILTER_SQL = INDICATOR_RECORD_FILTER_SQL + " OR task_tb.FIndicatorID IN ('" + join + "' ) ";
            }
            if (!CollectionUtils.isEmpty(recordIds)) {
                join = Strings.join((String[])recordIds.toArray(new String[recordIds.size()]), (String)"','");
                INDICATOR_RECORD_FILTER_SQL = INDICATOR_RECORD_FILTER_SQL + " OR task_tb.FRecordID IN ('" + join + "' ) ";
            }
            INDICATOR_RECORD_FILTER_SQL = INDICATOR_RECORD_FILTER_SQL + " ) ";
        }
        if (ONLY_MY) {
            IGNORE_VISIBETYPE = true;
            MY_OTHER_SQL = " AND (     ( task_tb.FPersonID = '" + currentPersonId + "' )  OR ( task_tb.FResponserID =  '" + currentPersonId + "' )  OR ( participate_tb.FPersonID =  '" + currentPersonId + "' )  ) ";
        }
        if (ONLY_OTHERS) {
            MY_OTHER_SQL = "  AND ( task_tb.FPersonID IS NULL OR task_tb.FPersonID <> '" + currentPersonId + "' )  AND ( task_tb.FResponserID IS NULL OR task_tb.FResponserID <>  '" + currentPersonId + "' )  AND ( participate_tb.FPersonID IS NULL OR participate_tb.FPersonID <>  '" + currentPersonId + "' )  ";
        }
        if (VISIBETYPE_DEPARTMENT) {
            VISIBETYPE_DEPARTMENT_SQL = "      OR ( task_tb.FVisibeType = '10'            AND (               ( task_tb.FIndicatorID is NULL AND task_tb.FRecordID is NULL AND task_pm_tb.FIsPrimary = '1'  AND task_position_tb.FAdminOrgUnitID = '" + currentAdminOrgUnit.getId().toString() + "')                OR                ((task_tb.FIndicatorID is NOT NULL OR task_tb.FRecordID is NOT NULL)                 AND (indicator_position_tb.FAdminOrgUnitID = '" + currentAdminOrgUnit.getId().toString() + "' OR record_position_tb.FAdminOrgUnitID = '" + currentAdminOrgUnit.getId().toString() + "'))            )       ) ";
        }
        if (VISIBETYPE_SUPERIOR) {
            VISIBETYPE_SUPERIOR_SQL = "      OR ( task_tb.FVisibeType = '20'            AND (               ( task_tb.FIndicatorID is NULL AND task_tb.FRecordID is NULL AND task_pm_tb.FIsPrimary = '1' AND task_position_tb.FParentID = '" + currentPositionInfo.getId().toString() + "')                OR                ((task_tb.FIndicatorID is NOT NULL OR task_tb.FRecordID is NOT NULL)                AND (indicator_position_tb.FParentID = '" + currentPositionInfo.getId().toString() + "' OR record_position_tb.FParentID = '" + currentPositionInfo.getId().toString() + "'))            )       ) ";
        }
        if (VISIBETYPE_ALL) {
            VISIBETYPE_ALL_SQL = "      OR task_tb.FVisibeType = '30' ";
        }
        if (VISIBETYPE_ASSIGNER) {
            VISIBETYPE_ASSIGNER_SQL = "      OR ( task_tb.FVisibeType = '40'            AND assigner_tb.FPersonID = '" + currentPersonId + "'        ) ";
        }
        if (ONLY_SUBORDINATES) {
            ONLYSUBORDINATES_SQL = "         AND (       ( task_tb.FIndicatorID is NULL AND task_tb.FRecordID is NULL AND                (                              (          task_pm_tb.FIsPrimary = '1' AND task_position_tb.FParentID = '" + currentPositionInfo.getId().toString() + "')                              OR (       task_pm_p_tb.FIsPrimary = '1' AND task_position_p_tb.FParentID = '" + currentPositionInfo.getId().toString() + "')                              OR (       task_pm_a_tb.FIsPrimary = '1' AND task_position_a_tb.FParentID = '" + currentPositionInfo.getId().toString() + "')                      )              )                OR                (task_tb.FIndicatorID is NOT NULL OR task_tb.FRecordID is NOT NULL)                AND (indicator_position_tb.FParentID = '" + currentPositionInfo.getId().toString() + "' OR record_position_tb.FParentID = '" + currentPositionInfo.getId().toString() + "')       ) ";
        }
        if (IGNORE_VISIBETYPE) {
            VISIBETYPE_ALL_SQL = "";
            VISIBETYPE_ASSIGNER_SQL = "";
            VISIBETYPE_DEPARTMENT_SQL = "";
            VISIBETYPE_SUPERIOR_SQL = "";
            ONLY_MY_TAIL_SQL = "  OR 1=1  ";
        }
        String sql = "        SELECT DISTINCT task_tb.FID AS TASKID  FROM T_PEF_PerfTask task_tb  LEFT JOIN T_PEF_PerfTaskParticipate participate_tb ON participate_tb.FTaskID = task_tb.FID  LEFT JOIN T_PEF_PerfTaskAssigner assigner_tb ON assigner_tb.FTaskID = task_tb.FID  LEFT JOIN T_EVA_IndicatorTarget indicator_tb ON indicator_tb.FID = task_tb.FIndicatorID  LEFT JOIN T_EVA_RecordTarget record_tb ON record_tb.FID = task_tb.FRecordID  LEFT JOIN T_EVA_PerfEvaObject indicator_obj_tb ON indicator_obj_tb.FID = indicator_tb.FEvaObjID LEFT JOIN T_EVA_PerfEvaObject record_obj_tb ON record_obj_tb.FID = record_tb.FEvaObjID LEFT JOIN T_EVA_PerfFile indicator_pf_tb ON indicator_pf_tb.FID = indicator_obj_tb.FPerfFileID  LEFT JOIN T_EVA_PerfFile record_pf_tb ON record_pf_tb.FID = record_obj_tb.FPerfFileID  LEFT JOIN T_ORG_Position indicator_position_tb ON indicator_position_tb.FID = indicator_pf_tb.FPositionID  LEFT JOIN T_ORG_Position record_position_tb ON record_position_tb.FID = record_pf_tb.FPositionID  LEFT JOIN T_ORG_PositionMember task_pm_tb ON task_pm_tb.FPersonID = task_tb.FResponserID  LEFT JOIN T_ORG_Position task_position_tb ON task_position_tb.FID = task_pm_tb.FPositionID  LEFT JOIN T_ORG_PositionMember task_pm_p_tb ON task_pm_p_tb.FPersonID = task_tb.FPersonID  LEFT JOIN T_ORG_Position task_position_p_tb ON task_position_p_tb.FID = task_pm_p_tb.FPositionID  LEFT JOIN T_ORG_PositionMember task_pm_a_tb ON task_pm_a_tb.FPersonID = participate_tb.FPersonID  LEFT JOIN T_ORG_Position task_position_a_tb ON task_position_a_tb.FID = task_pm_a_tb.FPositionID  WHERE 1=1 " + MY_OTHER_SQL + INDICATOR_RECORD_FILTER_SQL + customFilterSQL + " AND ( 1=2 " + VISIBETYPE_ALL_SQL + VISIBETYPE_ASSIGNER_SQL + VISIBETYPE_DEPARTMENT_SQL + VISIBETYPE_SUPERIOR_SQL + ONLY_MY_TAIL_SQL + ") " + ONLYSUBORDINATES_SQL + "   ";
        return sql;
    }
}

