/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.AppealStateEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.ConfirmStateEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSumStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IOrgEvaResultSummary;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectWFStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodInfo;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPlanInfo;
import com.kingdee.shr.perfweb.bizmanage.utils.GetBizManageEntityUtils;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PeriodUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfWorkflowOptimizationUtils {
    private static Logger logger = LoggerFactory.getLogger(PerfWorkflowOptimizationUtils.class);
    public static int batchHandCount = 200;

    public static EvaResultSummaryInfo assmbleEvaresultSummaryInfo(Context ctx, PerfEvaObjectInfo perfEvaObjectInfo, PerfPeriodInfo periodInfo, PerfPlanInfo planInfo) {
        try {
            EvaResultSummaryInfo evaResultSummaryInfo = new EvaResultSummaryInfo();
            evaResultSummaryInfo.put("evaObj", perfEvaObjectInfo.getId().toString());
            evaResultSummaryInfo.put("evaPlan", periodInfo.getPerfPlan().getId().toString());
            evaResultSummaryInfo.put("period", periodInfo.getId().toString());
            evaResultSummaryInfo.put("planNumber", planInfo.getNumber());
            evaResultSummaryInfo.put("periodNumber", periodInfo.getNumber());
            evaResultSummaryInfo.setNumber("NO" + System.currentTimeMillis());
            evaResultSummaryInfo.setPnumber(perfEvaObjectInfo.getNumber());
            evaResultSummaryInfo.setPname(perfEvaObjectInfo.getName());
            PerfFileInfo perfFileInfo = GetBizManageEntityUtils.getPerfFileInfo(ctx, perfEvaObjectInfo.getPerfFile().getId().toString());
            PositionCollection posColl = GetEntityInfoUtils.getPositionCollection(ctx, perfFileInfo.getPosition().getId().toString());
            if (null != perfFileInfo && null != posColl && posColl.size() > 0) {
                evaResultSummaryInfo.setPositionName(posColl.get(0).getName());
            }
            if (null != perfEvaObjectInfo.getPerfFile().getAssignType()) {
                evaResultSummaryInfo.setAssignType(perfFileInfo.getAssignType().getAlias());
            }
            AdminOrgUnitInfo adminOrgUnitInfo = GetEntityInfoUtils.getAdminOrgUnitInfo(ctx, perfFileInfo.getAdminOrgUnit().getId().toString());
            evaResultSummaryInfo.setAdminOrgNumber(adminOrgUnitInfo.getNumber());
            evaResultSummaryInfo.setAdminOrgLongNumber(adminOrgUnitInfo.getLongNumber());
            evaResultSummaryInfo.setAdminOrgName(adminOrgUnitInfo.getName());
            evaResultSummaryInfo.setFlowStatus(PerfEvaObjectWFStatusEnum.UNDERWAY);
            evaResultSummaryInfo.put("sumScore", null);
            evaResultSummaryInfo.setGradeLevel(null);
            evaResultSummaryInfo.setIsImportByHand(YesOrNoEnum.NO);
            evaResultSummaryInfo.setChangeDealType(perfEvaObjectInfo.getChangeDealType());
            evaResultSummaryInfo.setJoinPeriodDate(perfEvaObjectInfo.getJoinPeriodDate());
            evaResultSummaryInfo.setPeriodYear(periodInfo.getYear());
            evaResultSummaryInfo.setPeriodType(periodInfo.getCycleType());
            evaResultSummaryInfo.setPeriodTime(Integer.parseInt(periodInfo.getTimePeriod()));
            evaResultSummaryInfo.setPeriodName(periodInfo.getName());
            evaResultSummaryInfo.setEvaPlanName(planInfo.getName());
            evaResultSummaryInfo.put("perfModel", planInfo.getPerfModel().getId().toString());
            evaResultSummaryInfo.setStatus(EvaResultSumStatusEnum.NOCARRY);
            evaResultSummaryInfo.setBillState(HRBillStateEnum.SUBMITED);
            evaResultSummaryInfo.setConfirmState(planInfo.isNeedConfirm() ? ConfirmStateEnum.UNCONFIRM : ConfirmStateEnum.NOTREQUIRED);
            evaResultSummaryInfo.setAppealState(planInfo.isAllowAppeal() ? AppealStateEnum.NOAPPEAL : AppealStateEnum.NOTALLOW);
            evaResultSummaryInfo.put("adminOrg", perfFileInfo.getAdminOrgUnit().getId().toString());
            if (null != perfFileInfo.getPosition()) {
                evaResultSummaryInfo.setPositionId(perfFileInfo.getPosition().getId().toString());
            }
            evaResultSummaryInfo.put("person", perfEvaObjectInfo.getPerson());
            evaResultSummaryInfo.setHrOrgUnit(perfEvaObjectInfo.getHrUnitOrg());
            evaResultSummaryInfo.setPerfFile(perfFileInfo);
            evaResultSummaryInfo.setUseDefault(perfFileInfo.isUseDefault());
            evaResultSummaryInfo.put("reviseSumScore", null);
            String periodTimeNumber = PeriodUtil.getTimeNumber(String.valueOf(periodInfo.getCycleType().getValue()), periodInfo.getYear(), periodInfo.getTimePeriod());
            evaResultSummaryInfo.setPeriodTimeNumber(periodTimeNumber);
            return evaResultSummaryInfo;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static OrgEvaResultSummaryInfo assmbleOrgEvaresultSummaryInfo(Context ctx, PerfEvaObjectInfo perfEvaObjectInfo, PerfPeriodInfo periodInfo, PerfPlanInfo planInfo) {
        try {
            OrgEvaResultSummaryInfo evaResultSummaryInfo = new OrgEvaResultSummaryInfo();
            evaResultSummaryInfo.put("evaObj", perfEvaObjectInfo.getId().toString());
            evaResultSummaryInfo.put("evaPlan", periodInfo.getPerfPlan().getId().toString());
            evaResultSummaryInfo.put("period", periodInfo.getId().toString());
            evaResultSummaryInfo.put("planNumber", planInfo.getNumber());
            evaResultSummaryInfo.put("periodNumber", periodInfo.getNumber());
            evaResultSummaryInfo.setNumber("NO" + System.currentTimeMillis());
            evaResultSummaryInfo.setPnumber(perfEvaObjectInfo.getNumber());
            evaResultSummaryInfo.setPname(perfEvaObjectInfo.getName());
            String adminOrgUnitId = perfEvaObjectInfo.getEvaluOrgAdmin().getId().toString();
            AdminOrgUnitInfo adminOrgUnitInfo = GetEntityInfoUtils.getAdminOrgUnitInfo(ctx, adminOrgUnitId);
            evaResultSummaryInfo.setAdminOrgNumber(adminOrgUnitInfo.getNumber());
            evaResultSummaryInfo.setAdminOrgLongNumber(adminOrgUnitInfo.getLongNumber());
            evaResultSummaryInfo.setAdminOrgName(adminOrgUnitInfo.getName());
            evaResultSummaryInfo.setFlowStatus(PerfEvaObjectWFStatusEnum.UNDERWAY);
            evaResultSummaryInfo.put("sumScore", null);
            evaResultSummaryInfo.setGradeLevel(null);
            evaResultSummaryInfo.setIsImportByHand(YesOrNoEnum.NO);
            evaResultSummaryInfo.setChangeDealType(perfEvaObjectInfo.getChangeDealType());
            evaResultSummaryInfo.setJoinPeriodDate(perfEvaObjectInfo.getJoinPeriodDate());
            evaResultSummaryInfo.setPeriodYear(periodInfo.getYear());
            evaResultSummaryInfo.setPeriodType(periodInfo.getCycleType());
            evaResultSummaryInfo.setPeriodTime(periodInfo.getTimePeriod());
            evaResultSummaryInfo.setPeriodName(periodInfo.getName());
            evaResultSummaryInfo.setEvaPlanName(planInfo.getName());
            evaResultSummaryInfo.put("perfModel", planInfo.getPerfModel().getId().toString());
            evaResultSummaryInfo.setStatus(EvaResultSumStatusEnum.NOCARRY);
            evaResultSummaryInfo.setBillState(HRBillStateEnum.SUBMITED);
            evaResultSummaryInfo.setConfirmState(planInfo.isNeedConfirm() ? ConfirmStateEnum.UNCONFIRM : ConfirmStateEnum.NOTREQUIRED);
            evaResultSummaryInfo.setAppealState(planInfo.isAllowAppeal() ? AppealStateEnum.NOAPPEAL : AppealStateEnum.NOTALLOW);
            evaResultSummaryInfo.put("adminOrg", adminOrgUnitId);
            if (null != perfEvaObjectInfo.getEvaluOrgAdmin().getResponPosition()) {
                evaResultSummaryInfo.setPositionId(perfEvaObjectInfo.getEvaluOrgAdmin().getResponPosition().getId().toString());
            }
            evaResultSummaryInfo.put("person", perfEvaObjectInfo.getPerson());
            evaResultSummaryInfo.setHrOrgUnit(perfEvaObjectInfo.getHrUnitOrg());
            evaResultSummaryInfo.put("reviseSumScore", null);
            String periodTimeNumber = PeriodUtil.getTimeNumber(String.valueOf(periodInfo.getCycleType().getValue()), periodInfo.getYear(), periodInfo.getTimePeriod());
            evaResultSummaryInfo.setPeriodTimeNumber(periodTimeNumber);
            return evaResultSummaryInfo;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OrgEvaResultSummaryInfo processMultiOrgEvaResultSummaryInfo(Context ctx, MultiPerfEvaObjectInfo evaObjectInfo, MultiPerfPeriodInfo periodInfo, MultiPerfPlanInfo planInfo, String sumscore, String level) {
        try {
            String businessId = evaObjectInfo.getId().toString();
            IOrgEvaResultSummary iOrgEvaResultSummary = OrgEvaResultSummaryFactory.getLocalInstance(ctx);
            OrgEvaResultSummaryInfo summaryInfo = null;
            if (iOrgEvaResultSummary.exists("where businessId = '" + businessId + "'")) {
                OrgEvaResultSummaryCollection orgEvaResultSummaryCollection = iOrgEvaResultSummary.getOrgEvaResultSummaryCollection("where businessId = '" + businessId + "' order by sumScore desc");
                if (orgEvaResultSummaryCollection != null && orgEvaResultSummaryCollection.size() > 0) {
                    summaryInfo = orgEvaResultSummaryCollection.get(0);
                    if (summaryInfo.getBillState() == HRBillStateEnum.AUDITED) {
                        logger.error("current result is audited, resultId={}", (Object)summaryInfo.getId().toString());
                        return null;
                    }
                    summaryInfo.put("sumScore", sumscore);
                    summaryInfo.setGradeLevel(level);
                    return summaryInfo;
                }
                logger.error("current result is null, evaobjId = {}", (Object)businessId);
                return null;
            }
            summaryInfo = new OrgEvaResultSummaryInfo();
            summaryInfo.put("evaObj", businessId);
            summaryInfo.setBusinessId(businessId);
            summaryInfo.put("evaPlan", planInfo.getId().toString());
            summaryInfo.put("period", periodInfo.getId().toString());
            summaryInfo.put("planNumber", planInfo.getNumber());
            summaryInfo.put("periodNumber", periodInfo.getNumber());
            summaryInfo.setNumber("NO" + System.currentTimeMillis());
            summaryInfo.setPnumber(evaObjectInfo.getNumber());
            summaryInfo.setPname(evaObjectInfo.getName());
            String adminOrgUnitId = evaObjectInfo.getAdminOrgUnit().getId().toString();
            AdminOrgUnitInfo adminOrgUnitInfo = GetEntityInfoUtils.getAdminOrgUnitInfo(ctx, adminOrgUnitId);
            summaryInfo.setAdminOrgNumber(adminOrgUnitInfo.getNumber());
            summaryInfo.setAdminOrgLongNumber(adminOrgUnitInfo.getLongNumber());
            summaryInfo.setAdminOrgName(adminOrgUnitInfo.getName());
            summaryInfo.setFlowStatus(PerfEvaObjectWFStatusEnum.UNDERWAY);
            summaryInfo.put("sumScore", sumscore);
            summaryInfo.setGradeLevel(level);
            summaryInfo.setIsImportByHand(YesOrNoEnum.NO);
            summaryInfo.put("changeDealType", evaObjectInfo.getChangeDealType().getValue());
            summaryInfo.setPeriodYear(periodInfo.getYear());
            summaryInfo.setPeriodType(periodInfo.getCycleType());
            summaryInfo.setPeriodTime(periodInfo.getTimePeriod());
            summaryInfo.setPeriodName(periodInfo.getName());
            summaryInfo.setEvaPlanName(planInfo.getName());
            summaryInfo.put("perfModel", "pER9PCMLSzypG7wVLbGZqqtdChg=");
            summaryInfo.setStatus(EvaResultSumStatusEnum.NOCARRY);
            summaryInfo.setBillState(HRBillStateEnum.SUBMITED);
            summaryInfo.put("adminOrg", adminOrgUnitId);
            if (null != adminOrgUnitInfo.getResponPosition()) {
                summaryInfo.setPositionId(adminOrgUnitInfo.getResponPosition().getId().toString());
            }
            summaryInfo.setHrOrgUnit(evaObjectInfo.getHrUnitOrg());
            summaryInfo.put("reviseSumScore", null);
            String periodTimeNumber = PeriodUtil.getTimeNumber(String.valueOf(periodInfo.getCycleType().getValue()), periodInfo.getYear(), periodInfo.getTimePeriod());
            summaryInfo.setPeriodTimeNumber(periodTimeNumber);
            return summaryInfo;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }
}

