/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.PhotoUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowGraphUtils {
    private static Logger logger = LoggerFactory.getLogger(WorkflowGraphUtils.class);

    public static Map<String, Object> getProcessViewData(Context ctx, String[] asignmentPoolIDs) throws EASBizException {
        StringBuffer sqlBuffer3 = WorkflowGraphUtils.getMyOngoingProcessViewBaseSql(ctx, asignmentPoolIDs);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        LinkedList listDatas = new LinkedList();
        LinkedList list = null;
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer3.toString());
            LinkedList<LinkedHashMap<String, Object>> nodeList = null;
            LinkedList levelList = null;
            int currentLevel = 0;
            String currentNodeID = "";
            String currentPoolId = "";
            HashMap<String, String> persons = new HashMap<String, String>();
            while (rowset.next()) {
                int level = rowset.getInt("FWfLevel");
                String poolId = rowset.getString("FAsignmentPoolID");
                String wfNodeID = rowset.getString("FWfNodeID");
                String taskStatus = rowset.getString("FTaskStatus");
                String personId = rowset.getString("FNodeHandlerId");
                String nodeName = rowset.getString("FNodeName");
                if (StringUtils.isEmpty((CharSequence)nodeName)) {
                    nodeName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.VACANCY, ctx);
                }
                String number = rowset.getString("FNumber");
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("asignmentPoolID", poolId);
                map.put("nodeHandlerId", personId);
                map.put("number", number);
                String nodeHandlerName = rowset.getString("FNodeHandlerName");
                map.put("nodeHandlerName", StringUtils.isEmpty((CharSequence)nodeHandlerName) ? "" : nodeHandlerName);
                map.put("positionName", rowset.getString("FPositionName"));
                map.put("wfLevel", level);
                map.put("wfNodeID", wfNodeID);
                map.put("scoreStatus", rowset.getString("FScoreStatus"));
                map.put("scoreControl", rowset.getString("FScoreControl"));
                map.put("nodeName", nodeName);
                map.put("gradeTaskNodeInst", rowset.getString("FID"));
                map.put("isEffective", rowset.getString("FIsEffective"));
                persons.put(personId, number);
                if (rowset.getString("FIsEffective").equals("1") && rowset.getString("FTaskStatus").equals("2")) {
                    map.put("taskStatus", "2");
                } else if (rowset.getString("FIsEffective").equals("1")) {
                    map.put("taskStatus", "1");
                } else {
                    map.put("taskStatus", "0");
                }
                if (!currentPoolId.equals(poolId)) {
                    list = new LinkedList();
                    levelList = new LinkedList();
                    nodeList = new LinkedList();
                    nodeList.add(map);
                    levelList.add(nodeList);
                    list.add(levelList);
                    listDatas.add(list);
                    currentPoolId = poolId;
                    currentLevel = level;
                    currentNodeID = wfNodeID;
                    continue;
                }
                if (currentLevel != level) {
                    levelList = new LinkedList();
                    nodeList = new LinkedList<LinkedHashMap<String, Object>>();
                    nodeList.add(map);
                    levelList.add(nodeList);
                    ((LinkedList)listDatas.getLast()).add(levelList);
                    currentLevel = level;
                    currentNodeID = wfNodeID;
                    continue;
                }
                if (!currentNodeID.equals(wfNodeID)) {
                    nodeList = new LinkedList();
                    nodeList.add(map);
                    ((LinkedList)((LinkedList)listDatas.getLast()).getLast()).add(nodeList);
                    currentNodeID = wfNodeID;
                    continue;
                }
                ((LinkedList)((LinkedList)((LinkedList)listDatas.getLast()).getLast()).getLast()).add(map);
            }
            resultMap.put("data", listDatas);
            resultMap.put("photo", PhotoUtils.getImages(persons));
        }
        catch (Exception e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return resultMap;
    }

    public static StringBuffer getMyOngoingProcessViewBaseSql(Context ctx, String[] asignmentPoolIDs) {
        if (asignmentPoolIDs == null || asignmentPoolIDs.length == 0) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        for (String item : asignmentPoolIDs) {
            str.append("'").append(item).append("',");
        }
        str.setLength(str.length() - 1);
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        StringBuffer processViewBaseSql = new StringBuffer("select a.FID,a.FIsEffective, ").append("a.FAsignmentPoolID, ").append("a.FNodeHandlerId, ").append("c.FNumber, ").append("c.FName").append(mlFlag).append(" as FNodeHandlerName, ").append("a.FPositionName, ").append("a.FWfLevel, ").append("a.FWfNodeID, ").append("a.FScoreStatus, ").append("b.FScoreControl, ").append("a.FCreateTime, ").append("a.FTaskStatus, ").append("b.FNodeName").append(mlFlag).append(" as FNodeName  ").append("from T_EVA_GradeTaskNodeInst a ").append("left join T_EVA_WFNodeDef b ").append("on a.FWfNodeID = b.FID ").append("left join T_BD_Person c ").append("on a.FNodeHandlerId = c.FID ").append("where a.FAsignmentPoolID in ( " + str.toString() + ")").append("order by  a.FAsignmentPoolID, a.FWfLevel,a.FWfNodeID,a.FCreateTime,a.FScoreStatus");
        return processViewBaseSql;
    }
}

