/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtil {
    private static Logger logger = LoggerFactory.getLogger(XmlUtil.class);

    public static List<Element> getElementsByName(String xml, String name) {
        String rootxml = "<?xml version='1.0' encoding='UTF-8' ?><root>";
        rootxml = rootxml + xml;
        rootxml = rootxml + "</root>";
        List<Element> output = new ArrayList<Element>();
        Document dom = null;
        try {
            dom = DocumentHelper.parseText((String)rootxml);
        }
        catch (DocumentException e) {
            logger.error("DocumentException: ", (Throwable)e);
        }
        if (dom != null) {
            Element root = dom.getRootElement();
            output = XmlUtil.getChildElement(root, name);
        }
        return output;
    }

    public static List<Element> getChildElement(Element input, String name) {
        ArrayList<Element> output = new ArrayList<Element>();
        List list = input.elements();
        if (list != null && list.size() > 0) {
            for (Element e : list) {
                if (e.getName() != null && e.getName().equals(name)) {
                    output.add(e);
                    continue;
                }
                output.addAll(XmlUtil.getChildElement(e, name));
            }
        }
        return output;
    }

    public static org.jdom2.Document parseXML(String xml) throws BOSException {
        SAXBuilder builder = new SAXBuilder();
        org.jdom2.Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(xml));
            return doc;
        }
        catch (JDOMException var4) {
            throw new BOSException((Throwable)var4);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

