/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractDataProcessor;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaPersonInchargeCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaPersonInchargeFactory;
import com.kingdee.shr.perfweb.app.common.PerfEvaluPrintDataProcessorFacadeFactory;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentCollection;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentFactory;
import com.kingdee.shr.perfweb.app.workflow.WholeCommentInfo;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.JsonUtils;
import com.kingdee.shr.perfweb.utils.PerfEvaluPrintUtils;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PerfEvaluPrintDataProcessor
extends AbstractDataProcessor {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.PerfEvaluPrintDataProcessor");
    private static ThreadLocal<Context> threadCtxs = new ThreadLocal();

    public static void setContext(Context ctx) {
        threadCtxs.set(ctx);
    }

    public IRowSet process(IRowSet iRowSet, R1PrintDataSource ds) throws Exception {
        if (iRowSet == null) {
            return null;
        }
        String str_ds = ds.getId();
        Context ctx = threadCtxs.get();
        if (ctx != null) {
            R1PrintDataParameter param;
            if (str_ds.contains("PerfEvaluTargetPrintQuery") || str_ds.contains("PerfEvaluRecordPrintQuery") || str_ds.contains("PerfTargetPrint4OrgQuery") || str_ds.contains("PerfRecordPrint4OrgQuery")) {
                this.processEvaluTargetPrintQuery(ctx, iRowSet, ds);
            } else if (str_ds.contains("PerfEvaluGoalsFilterPrintQuery")) {
                String evaObj;
                Set<String> personIds;
                R1PrintDataParameter param2 = ds.getParam("id");
                if (null != param2 && !CollectionUtils.isEmpty(personIds = PerfEvaluPrintUtils.getPerfEvaluGoalsFilterIdsByEvaObj(ctx, evaObj = param2.getValue().toString()))) {
                    iRowSet = this.getiRowSet(iRowSet, ctx, evaObj, personIds);
                }
            } else if (str_ds.contains("PerfEvaluGoalsGiverPrintQuery")) {
                String evaObj;
                Set<String> personIds;
                R1PrintDataParameter param3 = ds.getParam("id");
                if (null != param3 && !CollectionUtils.isEmpty(personIds = PerfEvaluPrintUtils.getPerfEvaluGoalsGiverIdsByEvaObj(ctx, evaObj = param3.getValue().toString()))) {
                    iRowSet = this.getiRowSet(iRowSet, ctx, evaObj, personIds);
                }
            } else if (str_ds.contains("PerfEvaObjPrintQuery") || str_ds.contains("PerfEvaObjPrint4OrgQuery")) {
                this.processEvaObject(iRowSet, ctx, ds);
            } else if (str_ds.contains("GetPersonEvaResultQuery") && null != (param = ds.getParam("id"))) {
                String personId = param.getValue().toString();
                iRowSet = this.processPersonEvaResult(iRowSet, ctx, personId);
            }
        }
        PerfEvaluPrintDataProcessorFacadeFactory.getLocalInstance(ctx).doProcess(iRowSet, ds);
        return iRowSet;
    }

    public void processEvaluTargetPrintQuery(Context ctx, IRowSet iRowSet, R1PrintDataSource ds) throws BOSException, SQLException {
        R1PrintDataParameter param = ds.getParam("evaObj.id");
        String firstLevel = "";
        R1PrintDataParameter firstLevelParam = ds.getParam("c_firstLevel");
        String lastLevel = "";
        R1PrintDataParameter lastLevelParam = ds.getParam("c_lastLevel");
        if (null != firstLevelParam && !StringUtils.isEmpty((CharSequence)firstLevelParam.getValue().toString())) {
            firstLevel = firstLevelParam.getValue().toString();
        }
        if (null != lastLevelParam && !StringUtils.isEmpty((CharSequence)lastLevelParam.getValue().toString())) {
            lastLevel = lastLevelParam.getValue().toString();
        }
        String queryScoreLevel = "";
        R1PrintDataParameter queryScoreLevelParam = ds.getParam("c_scoreLevel");
        if (null != queryScoreLevelParam && !StringUtils.isEmpty((CharSequence)queryScoreLevelParam.getValue().toString())) {
            queryScoreLevel = queryScoreLevelParam.getValue().toString();
        }
        boolean isHideHandler = true;
        R1PrintDataParameter isHideHandlerParam = ds.getParam("c_isHideHandler");
        if (null != isHideHandlerParam && !StringUtils.isEmpty((CharSequence)isHideHandlerParam.getValue().toString())) {
            isHideHandler = "1".equals(isHideHandlerParam.getValue().toString());
        }
        if (StringUtils.isEmpty((CharSequence)firstLevel) && StringUtils.isEmpty((CharSequence)lastLevel) && StringUtils.isEmpty((CharSequence)queryScoreLevel)) {
            return;
        }
        if (null != param) {
            String evaObj = param.getValue().toString();
            this.assembleTargetInfo(ctx, iRowSet, evaObj, firstLevel, lastLevel, queryScoreLevel, isHideHandler);
        }
    }

    public void assembleTargetInfo(Context ctx, IRowSet iRowSet, String evaObj, String firstLevel, String lastLevel, String queryScoreLevel, boolean isHideHandler) throws BOSException, SQLException {
        HashSet<String> levels = new HashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)queryScoreLevel)) {
            for (String scoreLevel : queryScoreLevel.split(",")) {
                levels.add(scoreLevel);
            }
        } else {
            levels.add(firstLevel);
            levels.add(lastLevel);
        }
        if (CollectionUtils.isEmpty(levels)) {
            return;
        }
        GradeTaskNodeInstCollection taskNodeColl = GradeTaskNodeInstFactory.getLocalInstance(ctx).getGradeTaskNodeInstCollection("select id,wfNode.scoreControl where evaObj='" + evaObj + "' and wfLevel in(" + StringUtils.join(levels, (String)",") + ")");
        HashSet<String> taskNodeIds = new HashSet<String>(8);
        HashMap<String, String> taskNodeScoreControlMap = new HashMap<String, String>(8);
        if (taskNodeColl != null && taskNodeColl.size() > 0) {
            Iterator iterator = taskNodeColl.iterator();
            while (iterator.hasNext()) {
                GradeTaskNodeInstInfo next = (GradeTaskNodeInstInfo)iterator.next();
                taskNodeIds.add(next.getId().toString());
                taskNodeScoreControlMap.put(next.getId().toString(), next.getWfNode().getScoreControl().getValue());
            }
        }
        logger.error("taskNodeScoreControlMap is {}", (Object)JsonUtils.getJsonStr(taskNodeScoreControlMap));
        if (taskNodeIds.size() > 0) {
            String taskNodeIdStr = StringUtils.join(taskNodeIds, (String)"','");
            GradeTargetInstCollection targetInstColl = GradeTargetInstFactory.getLocalInstance(ctx).getGradeTargetInstCollection("select target,targetScore,gradeRank,comment,gradeTaskNode.id, gradeTaskNode.nodeHandlerName,gradeTaskNode.wfLevel where gradeTaskNode.id in('" + taskNodeIdStr + "') order by gradeTaskNode.wfLevel,target");
            HashMap targetInfoMap = new HashMap();
            if (targetInstColl != null && targetInstColl.size() > 0) {
                Iterator iterator = targetInstColl.iterator();
                while (iterator.hasNext()) {
                    ArrayList<String> comments;
                    GradeTargetInstInfo next = (GradeTargetInstInfo)iterator.next();
                    int level = 1;
                    String target = next.getString("target");
                    String comment = next.getString("comment");
                    String gradeRank = next.getString("gradeRank");
                    String targetScore = next.getString("targetScore");
                    String nodeHandlerName = "";
                    String scoreControl = (String)taskNodeScoreControlMap.get(next.getGradeTaskNode().getId().toString());
                    if (StringUtils.isEmpty((CharSequence)scoreControl)) {
                        scoreControl = "1";
                    }
                    if (!isHideHandler) {
                        nodeHandlerName = next.getGradeTaskNode() != null ? next.getGradeTaskNode().getNodeHandlerName() + ":" : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EMPTY, ctx) + ":";
                    }
                    if (next.getGradeTaskNode() != null) {
                        level = next.getGradeTaskNode().getWfLevel();
                    }
                    if ((comments = (ArrayList<String>)targetInfoMap.get(target + "#comment" + level)) == null) {
                        comments = new ArrayList<String>(4);
                    }
                    if (!scoreControl.equals("1") || !StringUtils.isEmpty((CharSequence)comment)) {
                        comments.add(nodeHandlerName + comment);
                    }
                    targetInfoMap.put(target + "#comment" + level, comments);
                    ArrayList<String> gradeRanks = (ArrayList<String>)targetInfoMap.get(target + "#gradeRank" + level);
                    if (gradeRanks == null) {
                        gradeRanks = new ArrayList<String>(4);
                    }
                    if (!scoreControl.equals("1") || !StringUtils.isEmpty((CharSequence)gradeRank)) {
                        gradeRanks.add(nodeHandlerName + gradeRank);
                    }
                    targetInfoMap.put(target + "#gradeRank" + level, gradeRanks);
                    ArrayList<String> targetScores = (ArrayList<String>)targetInfoMap.get(target + "#targetScore" + level);
                    if (targetScores == null) {
                        targetScores = new ArrayList<String>(4);
                    }
                    if (!scoreControl.equals("1") || !StringUtils.isEmpty((CharSequence)targetScore)) {
                        targetScores.add(nodeHandlerName + targetScore);
                    }
                    targetInfoMap.put(target + "#targetScore" + level, targetScores);
                }
            }
            logger.error("targetInfoMap is " + JsonUtils.getJsonStr(targetInfoMap));
            if (!CollectionUtils.isEmpty(targetInfoMap)) {
                while (iRowSet.next()) {
                    String targetId = iRowSet.getString("id");
                    logger.error("targetId is: " + targetId);
                    for (String scoreLevel : levels) {
                        logger.error("current scoreLevel is " + scoreLevel);
                        List comments = (List)targetInfoMap.get(targetId + "#comment" + scoreLevel);
                        logger.error("current comments is " + JsonUtils.getJsonStr(comments));
                        if (!CollectionUtils.isEmpty((Collection)comments)) {
                            iRowSet.updateString("targetComment" + scoreLevel, StringUtils.join((Iterable)comments, (String)"\uff1b"));
                        }
                        List gradeRanks = (List)targetInfoMap.get(targetId + "#gradeRank" + scoreLevel);
                        logger.error("current gradeRanks is " + JsonUtils.getJsonStr(gradeRanks));
                        if (!CollectionUtils.isEmpty((Collection)gradeRanks)) {
                            iRowSet.updateString("targetGradeRank" + scoreLevel, StringUtils.join((Iterable)gradeRanks, (String)"\uff1b"));
                        }
                        List targetScores = (List)targetInfoMap.get(targetId + "#targetScore" + scoreLevel);
                        logger.error("current targetScores is " + JsonUtils.getJsonStr(targetScores));
                        if (CollectionUtils.isEmpty((Collection)targetScores)) continue;
                        iRowSet.updateString("targetScore" + scoreLevel, StringUtils.join((Iterable)targetScores, (String)"\uff1b"));
                    }
                }
            }
        }
    }

    public void processEvaObject(IRowSet iRowSet, Context ctx, R1PrintDataSource ds) throws SQLException, BOSException {
        boolean isAddGoalsFiller = false;
        boolean isAddGoalsGiver = false;
        R1PrintDataParameter isAddGoalsFillerParam = ds.getParam("c_isAddGoalsFiller");
        R1PrintDataParameter isAddGoalsGiverParam = ds.getParam("c_isAddGoalsGiver");
        if (isAddGoalsFillerParam != null) {
            isAddGoalsFiller = "1".equals(isAddGoalsFillerParam.getValue().toString());
        }
        if (isAddGoalsGiverParam != null) {
            isAddGoalsGiver = "1".equals(isAddGoalsGiverParam.getValue().toString());
        }
        boolean isAddWholeInfo = false;
        R1PrintDataParameter isAddWholeInfoParam = ds.getParam("c_isAddWholeInfo");
        if (isAddWholeInfoParam != null) {
            isAddWholeInfo = "1".equals(isAddWholeInfoParam.getValue().toString());
        }
        boolean isAddNodeInfo = false;
        R1PrintDataParameter isAddNodeInfoParam = ds.getParam("c_isAddNodeInfo");
        if (isAddNodeInfoParam != null) {
            isAddNodeInfo = "1".equals(isAddNodeInfoParam.getValue().toString());
        }
        boolean isAddPersonIncharge = false;
        R1PrintDataParameter isPersonInchargeParam = ds.getParam("c_isAddPersonIncharge");
        if (isPersonInchargeParam != null) {
            isAddPersonIncharge = "1".equals(isPersonInchargeParam.getValue().toString());
        }
        String firstLevel = "";
        String lastLevel = "";
        String queryScoreLevel = "";
        if (isAddWholeInfo || isAddNodeInfo || isAddPersonIncharge) {
            R1PrintDataParameter firstLevelParam = ds.getParam("c_firstLevel");
            R1PrintDataParameter lastLevelParam = ds.getParam("c_lastLevel");
            R1PrintDataParameter queryScoreLevelParam = ds.getParam("c_queryScoreLevel");
            if (null != firstLevelParam && !StringUtils.isEmpty((CharSequence)firstLevelParam.getValue().toString())) {
                firstLevel = firstLevelParam.getValue().toString();
            }
            if (null != lastLevelParam && !StringUtils.isEmpty((CharSequence)lastLevelParam.getValue().toString())) {
                lastLevel = lastLevelParam.getValue().toString();
            }
            if (null != queryScoreLevelParam && !StringUtils.isEmpty((CharSequence)queryScoreLevelParam.getValue().toString())) {
                queryScoreLevel = queryScoreLevelParam.getValue().toString();
            }
        }
        while (iRowSet.next()) {
            R1PrintDataParameter isHideHandlerParam;
            String evaObj = iRowSet.getString("id");
            if (isAddGoalsFiller) {
                this.assembleEvaObjFiller(iRowSet, ctx, evaObj);
            }
            if (isAddGoalsGiver) {
                this.assembleEvaObjGiver(iRowSet, ctx, evaObj);
            }
            if (isAddWholeInfo) {
                boolean isHideHandler = true;
                isHideHandlerParam = ds.getParam("c_isHideHandler");
                if (null != isHideHandlerParam && !StringUtils.isEmpty((CharSequence)isHideHandlerParam.getValue().toString())) {
                    isHideHandler = "1".equals(isHideHandlerParam.getValue().toString());
                }
                this.assembleEvaObjWholeInfo(iRowSet, ctx, evaObj, firstLevel, lastLevel, queryScoreLevel, isHideHandler);
            }
            if (isAddNodeInfo) {
                boolean isHideHandler = true;
                isHideHandlerParam = ds.getParam("c_isHideHandler");
                if (null != isHideHandlerParam && !StringUtils.isEmpty((CharSequence)isHideHandlerParam.getValue().toString())) {
                    isHideHandler = "1".equals(isHideHandlerParam.getValue().toString());
                }
                this.assembleEvaObjNodeInfo(iRowSet, ctx, evaObj, firstLevel, lastLevel, queryScoreLevel, isHideHandler);
            }
            if (!isAddPersonIncharge) continue;
            this.assembleEvaObjPersonIncharge(iRowSet, ctx, evaObj);
        }
    }

    public void assembleEvaObjWholeInfo(IRowSet iRowSet, Context ctx, String evaObj, String firstLevel, String lastLevel, String queryScoreLevel, boolean isHideHandler) throws BOSException, SQLException {
        HashSet<String> levels = new HashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)queryScoreLevel)) {
            for (String scoreLevel : queryScoreLevel.split(",")) {
                levels.add(scoreLevel);
            }
        } else {
            levels.add(firstLevel);
            levels.add(lastLevel);
        }
        if (CollectionUtils.isEmpty(levels)) {
            return;
        }
        GradeTaskNodeInstCollection taskNodeColl = GradeTaskNodeInstFactory.getLocalInstance(ctx).getGradeTaskNodeInstCollection("select id where evaObj='" + evaObj + "' and wfLevel in(" + StringUtils.join(levels, (String)",") + ")");
        HashSet<String> taskNodeIds = new HashSet<String>(8);
        if (taskNodeColl != null && taskNodeColl.size() > 0) {
            Iterator iterator = taskNodeColl.iterator();
            while (iterator.hasNext()) {
                GradeTaskNodeInstInfo next = (GradeTaskNodeInstInfo)iterator.next();
                taskNodeIds.add(next.getId().toString());
            }
        }
        if (taskNodeIds != null && taskNodeIds.size() > 0) {
            String taskNodeIdStr = StringUtils.join(taskNodeIds, (String)"','");
            WholeCommentCollection wholeCommentColl = WholeCommentFactory.getLocalInstance(ctx).getWholeCommentCollection("select score,grade,comment,gradeTaskNodeInst.wfLevel,gradeTaskNodeInst.nodeHandlerName where  gradeTaskNodeInst.id in('" + taskNodeIdStr + "') order by gradeTaskNodeInst.wfLevel");
            HashMap<String, ArrayList<String>> wholeInfoMap = new HashMap<String, ArrayList<String>>();
            if (wholeCommentColl != null && wholeCommentColl.size() > 0) {
                Iterator iterator = wholeCommentColl.iterator();
                while (iterator.hasNext()) {
                    ArrayList<String> comments;
                    WholeCommentInfo next = (WholeCommentInfo)iterator.next();
                    int level = 1;
                    String targetScore = next.getString("score");
                    String gradeRank = next.getString("grade");
                    String comment = next.getString("comment");
                    String nodeHandlerName = "";
                    if (!isHideHandler) {
                        nodeHandlerName = next.getGradeTaskNodeInst() != null ? next.getGradeTaskNodeInst().getNodeHandlerName() + ":" : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EMPTY, ctx) + ":";
                    }
                    if (next.getGradeTaskNodeInst() != null) {
                        level = next.getGradeTaskNodeInst().getWfLevel();
                    }
                    if ((comments = (ArrayList<String>)wholeInfoMap.get("#comment" + level)) == null) {
                        comments = new ArrayList<String>(4);
                    }
                    comments.add(nodeHandlerName + comment);
                    wholeInfoMap.put("#comment" + level, comments);
                    ArrayList<String> gradeRanks = (ArrayList<String>)wholeInfoMap.get("#gradeRank" + level);
                    if (gradeRanks == null) {
                        gradeRanks = new ArrayList<String>(4);
                    }
                    gradeRanks.add(nodeHandlerName + gradeRank);
                    wholeInfoMap.put("#gradeRank" + level, gradeRanks);
                    ArrayList<String> targetScores = (ArrayList<String>)wholeInfoMap.get("#targetScore" + level);
                    if (targetScores == null) {
                        targetScores = new ArrayList<String>(4);
                    }
                    targetScores.add(nodeHandlerName + targetScore);
                    wholeInfoMap.put("#targetScore" + level, targetScores);
                }
                for (String level : levels) {
                    List targetScores;
                    List gradeRanks;
                    List comments = (List)wholeInfoMap.get("#comment" + level);
                    if (!CollectionUtils.isEmpty((Collection)comments)) {
                        iRowSet.updateString("targetComment" + level, StringUtils.join((Iterable)comments, (String)"\uff1b"));
                    }
                    if (!CollectionUtils.isEmpty((Collection)(gradeRanks = (List)wholeInfoMap.get("#gradeRank" + level)))) {
                        iRowSet.updateString("targetGradeRank" + level, StringUtils.join((Iterable)gradeRanks, (String)"\uff1b"));
                    }
                    if (CollectionUtils.isEmpty((Collection)(targetScores = (List)wholeInfoMap.get("#targetScore" + level)))) continue;
                    iRowSet.updateString("targetScore" + level, StringUtils.join((Iterable)targetScores, (String)"\uff1b"));
                }
            }
        }
    }

    private void assembleEvaObjNodeInfo(IRowSet iRowSet, Context ctx, String evaObj, String firstLevel, String lastLevel, String queryScoreLevel, boolean isHideHandler) throws BOSException, SQLException {
        HashSet<String> levels = new HashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)queryScoreLevel)) {
            for (String scoreLevel : queryScoreLevel.split(",")) {
                levels.add(scoreLevel);
            }
        } else {
            levels.add(firstLevel);
            levels.add(lastLevel);
        }
        if (CollectionUtils.isEmpty(levels)) {
            return;
        }
        GradeTaskNodeInstCollection taskNodeColl = GradeTaskNodeInstFactory.getLocalInstance(ctx).getGradeTaskNodeInstCollection("select id,wfLevel,nodeSumScore,nodeGrade,nodeHandler.name, wfNode.scoreControl where evaObj='" + evaObj + "' and wfLevel in(" + StringUtils.join(levels, (String)",") + ") order by wfLevel");
        if (taskNodeColl != null && taskNodeColl.size() > 0) {
            HashMap nodeInfoMap = new HashMap();
            Iterator iterator = taskNodeColl.iterator();
            while (iterator.hasNext()) {
                GradeTaskNodeInstInfo next = (GradeTaskNodeInstInfo)iterator.next();
                int level = 1;
                String nodeScore = next.getString("nodeSumScore");
                String nodeGrade = next.getString("nodeGrade");
                String scoreControl = "1";
                if (next.getWfNode().getScoreControl() != null) {
                    scoreControl = next.getWfNode().getScoreControl().getValue();
                }
                String nodeHandlerName = "";
                if (!isHideHandler) {
                    nodeHandlerName = next.getNodeHandler() != null ? next.getNodeHandler().getName() + ":" : SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EMPTY, ctx) + ":";
                }
                level = next.getWfLevel();
                ArrayList<String> nodeGrades = (ArrayList<String>)nodeInfoMap.get("#nodeGrade" + level);
                if (nodeGrades == null) {
                    nodeGrades = new ArrayList<String>(4);
                }
                if (!scoreControl.equals("1") || !StringUtils.isEmpty((CharSequence)nodeGrade)) {
                    nodeGrades.add(nodeHandlerName + nodeGrade);
                }
                nodeInfoMap.put("#nodeGrade" + level, nodeGrades);
                ArrayList<String> nodeScores = (ArrayList<String>)nodeInfoMap.get("#nodeScore" + level);
                if (nodeScores == null) {
                    nodeScores = new ArrayList<String>(4);
                }
                if (!scoreControl.equals("1") || !StringUtils.isEmpty((CharSequence)nodeScore)) {
                    nodeScores.add(nodeHandlerName + nodeScore);
                }
                nodeInfoMap.put("#nodeScore" + level, nodeScores);
            }
            for (String level : levels) {
                logger.error("current scoreLevel is " + level);
                List nodeGrades = (List)nodeInfoMap.get("#nodeGrade" + level);
                logger.error("current nodeGrades is " + JsonUtils.getJsonStr(nodeGrades));
                if (!CollectionUtils.isEmpty((Collection)nodeGrades)) {
                    iRowSet.updateString("nodeGrade" + level, StringUtils.join((Iterable)nodeGrades, (String)"\uff1b"));
                }
                List nodeScores = (List)nodeInfoMap.get("#nodeScore" + level);
                logger.error("current nodeScores is " + JsonUtils.getJsonStr(nodeScores));
                if (CollectionUtils.isEmpty((Collection)nodeScores)) continue;
                iRowSet.updateString("nodeScore" + level, StringUtils.join((Iterable)nodeScores, (String)"\uff1b"));
            }
        }
    }

    public void assembleEvaObjGiver(IRowSet iRowSet, Context ctx, String evaObj) throws BOSException, SQLException {
        PersonCollection goalsGiverCollection = PerfEvaluPrintUtils.getAllPerfEvaluGoalsGiverByEvaObj(ctx, evaObj);
        if (goalsGiverCollection != null && goalsGiverCollection.size() > 0) {
            StringBuilder goalsFiller = new StringBuilder();
            for (PersonInfo next : goalsGiverCollection) {
                goalsFiller.append(next.getName()).append(" ");
            }
            iRowSet.updateString("goalsGiver", goalsFiller.toString());
        }
    }

    public void assembleEvaObjFiller(IRowSet iRowSet, Context ctx, String evaObj) throws BOSException, SQLException {
        PersonCollection goalsFillerCollection = PerfEvaluPrintUtils.getAllPerfEvaluGoalsFillerByEvaObj(ctx, evaObj);
        if (goalsFillerCollection != null && goalsFillerCollection.size() > 0) {
            StringBuilder goalsFiller = new StringBuilder();
            for (PersonInfo next : goalsFillerCollection) {
                goalsFiller.append(next.getName()).append(" ");
            }
            iRowSet.updateString("goalsFiller", goalsFiller.toString());
        }
    }

    public IRowSet getiRowSet(IRowSet iRowSet, Context ctx, String evaObj, Set<String> personIds) throws SQLException, BOSException {
        DynamicRowSet dynamicRowSet = DynamicRowSet.create((IRowSet)iRowSet);
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        String querySql = "select FId AS 'person.id',FName" + mlFlag + " AS 'person.name',FNumber AS 'person.number','" + evaObj + "' AS id from T_BD_Person where FID in ('" + StringUtils.join(personIds, (String)"','") + "')";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
        dynamicRowSet.insertRows(rowSet);
        return dynamicRowSet;
    }

    public IRowSet processPersonEvaResult(IRowSet iRowSet, Context ctx, String personId) throws SQLException, BOSException {
        HashMap<String, String> initRow = new HashMap<String, String>();
        initRow.put("ID", "");
        initRow.put("MONTH1", "");
        initRow.put("MONTH2", "");
        initRow.put("MONTH3", "");
        initRow.put("MONTH4", "");
        initRow.put("MONTH5", "");
        initRow.put("MONTH6", "");
        initRow.put("MONTH7", "");
        initRow.put("MONTH8", "");
        initRow.put("MONTH9", "");
        initRow.put("MONTH10", "");
        initRow.put("MONTH11", "");
        initRow.put("MONTH12", "");
        initRow.put("YEAR", "");
        initRow.put("FINALYEAR", "");
        Date currentDate = new Date();
        int currentYear = DateTimeUtils.getYear((Date)currentDate);
        String querySql = "select FID,FLastSumScore,FPeriodYear,FPeriodType,FPeriodTime from T_EVA_EVARESULTSUMMARY where FPersonID = '" + personId + "' and FPERIODYEAR in('" + String.valueOf(currentYear) + "','" + String.valueOf(currentYear - 1) + "','" + String.valueOf(currentYear - 2) + "') and FPERIODTYPE in('300','400','100') order by FPERIODYEAR,FPeriodType desc,FPERIODTIME ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
        DynamicRowSet dynamicRowSet = new DynamicRowSet(rowSet.size());
        String yearTemp = "";
        boolean isInit = false;
        HashMap<String, String> rowsTemp = new HashMap<String, String>();
        HashMap<String, Integer> quarterMap = new HashMap<String, Integer>();
        quarterMap.put("1", 1);
        quarterMap.put("2", 4);
        quarterMap.put("3", 7);
        quarterMap.put("4", 10);
        DecimalFormat df = new DecimalFormat("#.##");
        while (rowSet.next()) {
            String periodYear = rowSet.getString("FPeriodYear");
            String FID = rowSet.getString("FID");
            if (!yearTemp.equalsIgnoreCase(periodYear)) {
                if (rowsTemp.size() > 0) {
                    IRowSet newRows = PerfEvaluPrintDataProcessor.mapToRowSet(rowsTemp);
                    if (isInit) {
                        isInit = false;
                        dynamicRowSet = DynamicRowSet.create((IRowSet)newRows);
                    }
                    dynamicRowSet.insertRows(newRows);
                }
                rowsTemp = initRow;
                rowsTemp.put("YEAR", periodYear);
                rowsTemp.put("ID", FID);
                if (StringUtils.isEmpty((CharSequence)yearTemp)) {
                    isInit = true;
                }
                yearTemp = periodYear;
            }
            String periodType = rowSet.getString("FPeriodType");
            String lastSumScore = rowSet.getString("FLastSumScore");
            if (StringUtils.isNotEmpty((CharSequence)lastSumScore)) {
                BigDecimal bigDecimal = new BigDecimal(lastSumScore);
                lastSumScore = df.format(bigDecimal);
            }
            String periodTime = rowSet.getString("FPeriodTime");
            if ("100".equalsIgnoreCase(periodType)) {
                rowsTemp.put("FINALYEAR", lastSumScore);
                continue;
            }
            if ("300".equalsIgnoreCase(periodType)) {
                Integer quarter = (Integer)quarterMap.get(periodTime);
                for (int i = 0; i < 3; ++i) {
                    rowsTemp.put("MONTH" + (quarter + i), lastSumScore);
                }
                continue;
            }
            if (!"400".equalsIgnoreCase(periodType)) continue;
            rowsTemp.put("MONTH" + periodTime, lastSumScore);
        }
        dynamicRowSet.insertRows(PerfEvaluPrintDataProcessor.mapToRowSet(rowsTemp));
        return dynamicRowSet;
    }

    public static IRowSet mapToRowSet(Map obj) {
        DynamicRowSet drs = null;
        HashMap<String, String> types = null;
        try {
            drs = new DynamicRowSet(obj.size());
            types = PerfEvaluPrintDataProcessor.createMapRowSet(drs, obj);
            drs.moveToInsertRow();
            PerfEvaluPrintDataProcessor.storeMapToDS(drs, types, obj);
            drs.insertRow();
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        return drs;
    }

    public static HashMap<String, String> createMapRowSet(DynamicRowSet drs, Map value) throws SQLException {
        HashMap<String, String> types = new HashMap<String, String>();
        if (value.get("columnOrder") != null) {
            ArrayList columnOrder = (ArrayList)value.get("columnOrder");
            int index = 1;
            int size = columnOrder.size();
            for (int i = 0; i < size; ++i) {
                int type = 12;
                String colType = "varchar";
                if (value.get(columnOrder.get(i)) instanceof Integer) {
                    type = 4;
                    colType = "int";
                } else if (value.get(columnOrder.get(i)) instanceof BigDecimal) {
                    type = 3;
                    colType = "decimal";
                }
                types.put(columnOrder.get(i).toString(), "" + type);
                ColInfo colInfo = new ColInfo(columnOrder.get(i).toString(), columnOrder.get(i).toString(), 12, null);
                colInfo.colTypeName = colType;
                drs.setColInfo(index, colInfo);
                ++index;
            }
        } else {
            Iterator it = value.entrySet().iterator();
            int index = 1;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int type = 12;
                String colType = "varchar";
                if (entry.getValue() instanceof Integer) {
                    type = 4;
                    colType = "int";
                } else if (entry.getValue() instanceof BigDecimal) {
                    type = 3;
                    colType = "decimal";
                }
                types.put(entry.getKey().toString(), "" + type);
                ColInfo colInfo = new ColInfo(entry.getKey().toString(), entry.getKey().toString(), 12, null);
                colInfo.colTypeName = colType;
                drs.setColInfo(index, colInfo);
                ++index;
            }
        }
        return types;
    }

    public static void storeMapToDS(DynamicRowSet drs, HashMap<String, String> types, Map value) throws SQLException {
        Iterator it = value.entrySet().iterator();
        ResultSetMetaData meta = drs.getMetaData();
        int size = meta.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            String key = meta.getColumnName(i);
            if (!types.containsKey(key)) continue;
            String type = types.get(key);
            if (type.equals("4")) {
                if (value.get(key) != null) {
                    drs.updateInt(key, ((Integer)value.get(key)).intValue());
                    continue;
                }
                drs.updateInt(key, Integer.valueOf(0).intValue());
                continue;
            }
            if (type.equals("3")) {
                if (value.get(key) != null) {
                    drs.updateBigDecimal(key, (BigDecimal)value.get(key));
                    continue;
                }
                drs.updateBigDecimal(key, BigDecimal.valueOf(0L));
                continue;
            }
            if (value.get(key) != null) {
                drs.updateString(key, value.get(key).toString());
                continue;
            }
            drs.updateString(key, "");
        }
    }

    private void assembleEvaObjPersonIncharge(IRowSet iRowSet, Context ctx, String evaObj) throws BOSException, SQLException {
        PerfEvaPersonInchargeCollection personInchargeCollection = PerfEvaPersonInchargeFactory.getLocalInstance(ctx).getPerfEvaPersonInchargeCollection("select person.name where evaObj = '" + evaObj + "'");
        if (personInchargeCollection != null && personInchargeCollection.size() > 0) {
            HashSet<String> personSet = new HashSet<String>();
            int len = personInchargeCollection.size();
            for (int i = 0; i < len; ++i) {
                personSet.add(personInchargeCollection.get(i).getPerson().getName());
            }
            iRowSet.updateString("personIncharge", StringUtils.join(personSet, (String)","));
        }
    }
}

