/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.preentry.util;

import com.kingdee.util.StringUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class BarcodeUtil {
    public static File generate128CodeFile(String msg, String path) {
        File file = new File(path);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            BarcodeUtil.generate128Code(msg, out);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    public static byte[] generate128Code(String msg) {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        BarcodeUtil.generate128Code(msg, ous);
        return ous.toByteArray();
    }

    public static BufferedImage generate128Code(String msg, OutputStream ous) {
        if (StringUtils.isEmpty((String)msg) || ous == null) {
            return null;
        }
        Code128Bean bean = new Code128Bean();
        int dpi = 360;
        bean.setHeight(6.0);
        bean.doQuietZone(true);
        bean.setQuietZone(0.0);
        bean.setFontName("Helvetica");
        bean.setFontSize((double)1.4f);
        bean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        double moduleWidth = UnitConv.in2mm((double)0.0027777778450399637);
        bean.setModuleWidth(moduleWidth);
        String format = "image/png";
        try {
            BitmapCanvasProvider canvas = new BitmapCanvasProvider(ous, format, 360, 12, false, 0);
            bean.generateBarcode((CanvasProvider)canvas, msg);
            canvas.finish();
            return canvas.getBufferedImage();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
    }
}

