/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.preentry.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;

public class HttpUtil {
    private static final Logger logger = Logger.getLogger(HttpUtil.class);
    public static final String DEFAULT_CHARSET = "utf-8";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_SO_TIMEOUT = 30000;

    private static HttpClient createHttpClient() {
        HttpClient httpClient = HttpUtil.createHttpClient(10000, 30000);
        return httpClient;
    }

    private static HttpClient createHttpClient(int connectionTimeout, int soTimeout) {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(connectionTimeout);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(soTimeout);
        return httpClient;
    }

    public static String post(Context ctx, String url, Map<String, String> param) {
        return HttpUtil.post(ctx, url, param, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(Context ctx, String url, Map<String, String> param, String charset) {
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        HttpClient client = HttpUtil.createHttpClient();
        client.getParams().setParameter("http.protocol.content-charset", (Object)charset);
        PostMethod postMethod = new PostMethod(url);
        if (param != null && param.size() > 0) {
            NameValuePair[] datas = new NameValuePair[param.size()];
            int index = 0;
            for (String key : param.keySet()) {
                datas[index++] = new NameValuePair(key, param.get(key));
            }
            postMethod.setRequestBody(datas);
        }
        String result = null;
        try {
            result = HttpUtil.executeMethod(client, (HttpMethod)postMethod);
        }
        catch (IOException e) {
            logger.error((Object)("request fail*********** url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("request fail*********** url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return result;
    }

    private static String executeMethod(HttpClient client, HttpMethod method) throws IOException {
        int statusCode = client.executeMethod(method);
        String body = method.getResponseBodyAsString();
        JSONObject jsonResult = new JSONObject();
        jsonResult.put("code", (Object)statusCode);
        jsonResult.put("body", (Object)body);
        return jsonResult.toString();
    }
}

