/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.dataquery;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.shareservice.dataquery.AbstractSSCBaseDataQueryService;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetEfficRankDataQueryService
extends AbstractSSCBaseDataQueryService {
    private static final Logger logger = LoggerFactory.getLogger(GetEfficRankDataQueryService.class);

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        return this.getPageData(ctx, param);
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        this.checkUserPermission(ctx);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        paramMap.put("userId", userInfo.getId().toString());
        paramMap.put("rows", param.getRows());
        paramMap.put("page", param.getPage());
        Map timeParam = (Map)this.getParamValue(ctx, "time", param);
        paramMap.put("startDate", timeParam.get("_###BEGIN###"));
        paramMap.put("endDate", timeParam.get("_###END###"));
        JsonObject efficRankObj = SSCTaskAppUtil.operateTaskAll(ctx, "GETEFFICRANK", paramMap);
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u4efb\u52a1\u6548\u80fd\u6392\u540d=====" + efficRankObj);
        }
        JsonArray dataArray = efficRankObj.get("efficiencyPaging").getAsJsonArray();
        ArrayList resultList = new ArrayList();
        for (int i = 0; i < dataArray.size(); ++i) {
            JsonObject dataObj = dataArray.get(i).getAsJsonObject();
            HashMap<String, Object> efficRankMap = new HashMap<String, Object>();
            efficRankMap.put("userName", dataObj.get("userName").getAsString());
            efficRankMap.put("groupName", dataObj.get("groupName").getAsString());
            efficRankMap.put("efficiency", dataObj.get("efficiency").getAsString());
            efficRankMap.put("rank", dataObj.get("rank").getAsInt());
            resultList.add(efficRankMap);
        }
        DataResult dataResult = new DataResult();
        dataResult.setRows(resultList);
        return dataResult;
    }
}

