/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.dataquery;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.dataquery.AbstractSSCBaseDataQueryService;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUserTaskRankDataQueryService
extends AbstractSSCBaseDataQueryService {
    private static final Logger logger = LoggerFactory.getLogger(GetUserTaskRankDataQueryService.class);

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        return this.getPageData(ctx, param);
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        this.checkUserPermission(ctx);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        paramMap.put("userId", userInfo.getId().toString());
        paramMap.put("rows", param.getRows());
        paramMap.put("page", param.getPage());
        Map timeParam = (Map)this.getParamValue(ctx, "time", param);
        paramMap.put("startDate", timeParam.get("_###BEGIN###"));
        paramMap.put("endDate", timeParam.get("_###END###"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userInfo.getId().toString());
        params.put("roleType", "hEw8bwRNR8qPRPajcUdX4C0WZ4A=");
        paramMap.put("bussAttr", SSCTaskAppUtil.getSourceDataStr(ctx, "SHRBUSSATTR", params));
        JsonObject efficRankObj = SSCTaskAppUtil.operateTaskAll(ctx, "GETUSERTASKRANK", paramMap);
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u4efb\u52a1\u6548\u80fd\u6392\u540d=====" + efficRankObj);
        }
        ArrayList resultList = new ArrayList();
        if (null != efficRankObj.get("efficiencyPaging")) {
            JsonArray dataArray = efficRankObj.get("efficiencyPaging").getAsJsonArray();
            for (int i = 0; i < dataArray.size(); ++i) {
                JsonObject dataObj = dataArray.get(i).getAsJsonObject();
                HashMap<String, String> efficRankMap = new HashMap<String, String>();
                efficRankMap.put("userName", dataObj.get("userName").getAsString());
                efficRankMap.put("dealNum", dataObj.get("dealNum").getAsString());
                int rank = dataObj.get("rank").getAsInt();
                String tempStr = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCDimension", (String)"rank", (Context)ctx);
                String rankStr = MessageFormat.format(tempStr, rank);
                efficRankMap.put("rank", rankStr);
                resultList.add(efficRankMap);
            }
        }
        long total = 0L;
        if (null != efficRankObj.get("total")) {
            total = efficRankObj.get("total").getAsLong();
        }
        DataResult dataResult = new DataResult();
        dataResult.setRows(resultList);
        dataResult.setPage(param.getPage());
        dataResult.setRecords(total);
        dataResult.setTotal(total);
        return dataResult;
    }
}

