/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.socialSecurity.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.sql.record.SocRecordSQL;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.shr.socialSecurity.AbstractSocTypeHisInfo;
import com.kingdee.shr.socialSecurity.ISocEmpSocFiles;
import com.kingdee.shr.socialSecurity.ISocEmpSocFilesEntry;
import com.kingdee.shr.socialSecurity.ISocEmpSocFilesEntryHis;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryCollection;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryFactory;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryHisCollection;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryHisFactory;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryHisInfo;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryInfo;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesFactory;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesInfo;
import com.kingdee.shr.socialSecurity.SocPersonRecordInfo;
import com.kingdee.shr.socialSecurity.SocTypeHisFactory;
import com.kingdee.shr.socialSecurity.SocTypeInfo;
import com.kingdee.shr.socialSecurity.SocTypeItemHisInfo;
import com.kingdee.shr.socialSecurity.SocialCommonException;
import com.kingdee.shr.socialSecurity.app.AbstractSocEmpSocFilesFacadeControllerBean;
import com.kingdee.shr.socialSecurity.util.SocDateUtil;
import com.kingdee.shr.socialSecurity.util.SocFilesBizUtil;
import com.kingdee.shr.socialSecurity.util.SocStrUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class SocEmpSocFilesFacadeControllerBean
extends AbstractSocEmpSocFilesFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.socialSecurity.app.SocEmpSocFilesFacadeControllerBean");

    @Override
    protected void _updateSocInfoForSnap(Context ctx, String personBURelationIds) throws BOSException {
        String sqlStr = SocRecordSQL.getUpdateSocInfoForSnapSQL((String)personBURelationIds);
        IRowSet rowSet = CmpSQLUtil.executeQuery((Context)ctx, (String)sqlStr);
        if (null == rowSet || rowSet.size() <= 0) {
            return;
        }
        this._InsertSocFilesSnap(ctx, rowSet);
        this._updateSocFilesForRecord(ctx, rowSet);
    }

    private void _updateSocFilesForRecord(Context ctx, IRowSet rowSet) throws BOSException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        String tableName = "T_HR_SSocEmpSocFiles";
        String updateCol = "FBillId";
        String whereCol = "fid";
        String updateSql = SQLHandleUtil.getUpdateSql((String)tableName, (String)updateCol, (String)whereCol, null);
        try {
            while (rowSet.next()) {
                Object[] param = new Object[]{rowSet.getString("newFid"), rowSet.getString("socFid")};
                paramList.add(param);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        CmpSQLUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
    }

    private void _InsertSocFilesSnap(Context ctx, IRowSet rowSet) throws BOSException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        String tableName = "T_HR_SSocEmpSocFilesSnap";
        String columns = "Fid,FPersonId,FSocEmpSocFilesID,FRecordID";
        String insertSql = SQLHandleUtil.getInsertSql((Context)ctx, (String)tableName, (String)columns);
        try {
            while (rowSet.next()) {
                Object[] param = new Object[]{BOSUuid.create((String)"FE01D08A"), rowSet.getString("FPersonId"), rowSet.getString("socFid"), rowSet.getString("oldFid")};
                paramList.add(param);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        CmpSQLUtil.executeBatch((Context)ctx, (String)insertSql, paramList);
    }

    @Override
    protected void _saveSocFilesEntry(Context ctx, String billId, List entryList) throws BOSException, EASBizException {
        List entrys = entryList;
        Map<String, SocEmpSocFilesEntryInfo> entryInfoMap = this.getsocEntryInfoMap(ctx, billId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SocTypeItemHisInfo socTypeItemHisInfo = null;
        SocEmpSocFilesEntryHisInfo entryHisInfo = new SocEmpSocFilesEntryHisInfo();
        ISocEmpSocFilesEntryHis socFilesEntryHis = null;
        ISocEmpSocFilesEntry socFilesEntry = null;
        socFilesEntryHis = SocEmpSocFilesEntryHisFactory.getLocalInstance(ctx);
        socFilesEntry = SocEmpSocFilesEntryFactory.getLocalInstance(ctx);
        BOSObjectType entryHisBosType = entryHisInfo.getBOSType();
        ISocEmpSocFiles socEmpSocFiles = SocEmpSocFilesFactory.getLocalInstance(ctx);
        String oql = "select id, effectDay, socType.id, socType.effectDate, bill.id, bill.leffectDate where id='" + billId + "'";
        SocEmpSocFilesInfo socEmpSocFilesInfo = socEmpSocFiles.getSocEmpSocFilesInfo(oql);
        Date socTypeDate = socEmpSocFilesInfo.getSocType().getEffectDate();
        SocTypeInfo socTypeInfo = socEmpSocFilesInfo.getSocType();
        String socTypeId = socTypeInfo.getId().toString();
        AbstractSocTypeHisInfo socTypeHisInfo = null;
        try {
            String oql2 = "select * where historyRelateID='" + socTypeId + "' order by effectDate";
            socTypeHisInfo = SocTypeHisFactory.getLocalInstance(ctx).getSocTypeHisCollection(oql2).get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (socTypeHisInfo != null) {
            socTypeDate = socTypeHisInfo.getEffectDate();
        }
        Date joinSocDate = socEmpSocFilesInfo.getEffectDay();
        SocPersonRecordInfo recordInfo = socEmpSocFilesInfo.getBill();
        String recordId = recordInfo.getId().toString();
        Date recordLeffectDate = recordInfo.getLeffectDate();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        List<Object> socItemDateList = new ArrayList();
        try {
            socItemDateList = SocFilesBizUtil.getSocItemDateByRecord(ctx, recordId, socTypeId);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        String key = "";
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            String msg;
            String dateStr;
            Map map = (Map)entrys.get(i);
            String socItemId = (String)map.get("socItemId");
            String socItemName = (String)map.get("socItem");
            BigDecimal selfBase = SocStrUtil.toBigDecimal(map.get("SelfBase"));
            BigDecimal companyBase = SocStrUtil.toBigDecimal(map.get("CompanyBase"));
            String socTypeItemId = (String)map.get("SocTypeItemId");
            String entryId = (String)map.get("entry_recId");
            Date newEffectDate = null;
            try {
                newEffectDate = sdf.parse("" + map.get("effectDate"));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new SocialCommonException(SocialCommonException.DATE_FORMAT_ERROR);
            }
            key = socItemId + "_" + SocDateUtil.getDateStr((Date)newEffectDate);
            if (newEffectDate.before(joinSocDate)) {
                dateStr = format.format(joinSocDate);
                msg = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocEmpSocFileResource", (String)"label0", (Locale)ctx.getLocale()) + dateStr;
                throw new EASBizException(new NumericExceptionSubItem("001", msg));
            }
            if (newEffectDate.before(socTypeDate)) {
                dateStr = format.format(socTypeDate);
                msg = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocEmpSocFileResource", (String)"label1", (Locale)ctx.getLocale()) + dateStr;
                throw new EASBizException(new NumericExceptionSubItem("002", msg));
            }
            if (newEffectDate.after(recordLeffectDate)) {
                dateStr = format.format(recordLeffectDate);
                msg = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocEmpSocFileResource", (String)"label2", (Locale)ctx.getLocale()) + dateStr;
                throw new EASBizException(new NumericExceptionSubItem("003", msg));
            }
            if (socItemDateList.contains(key)) {
                String msg2 = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocEmpSocFileResource", (String)"label3", (Locale)ctx.getLocale()) + socItemName + "\u3011\u3010" + SocDateUtil.getDateStr((Date)newEffectDate) + "\u3011";
                throw new EASBizException(new NumericExceptionSubItem("004", msg2));
            }
            SocEmpSocFilesEntryInfo oldEntryInfo = entryInfoMap.get(entryId);
            if (oldEntryInfo == null) {
                this.addNewEntry(ctx, billId, map);
                continue;
            }
            SocEmpSocFilesInfo socFilesInfo = oldEntryInfo.getBill();
            Date effectDay = oldEntryInfo.getEffectDay();
            if (effectDay.after(newEffectDate)) {
                SocEmpSocFilesEntryHisInfo oldSocEntryHisInfo = this.getSocEntryHisInfo(ctx, billId, newEffectDate, socItemId);
                if (oldSocEntryHisInfo != null) {
                    String msg3 = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocEmpSocFileResource", (String)"label4", (Locale)ctx.getLocale());
                    throw new EASBizException(new NumericExceptionSubItem("004", msg3));
                }
                oldSocEntryHisInfo = new SocEmpSocFilesEntryHisInfo();
                oldSocEntryHisInfo.setBill(socFilesInfo);
                socTypeItemHisInfo = new SocTypeItemHisInfo();
                socTypeItemHisInfo.setId(BOSUuid.read((String)socTypeItemId));
                oldSocEntryHisInfo.setSocTypeItem(socTypeItemHisInfo);
                oldSocEntryHisInfo.setSelfBase(selfBase);
                oldSocEntryHisInfo.setCompanyBase(companyBase);
                oldSocEntryHisInfo.setEffectDay(newEffectDate);
                BOSUuid oldId = oldSocEntryHisInfo.getId();
                try {
                    socFilesEntryHis.save(oldSocEntryHisInfo);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SocialCommonException(SocialCommonException.SAVE_ERROR);
                }
            }
            if (!effectDay.before(newEffectDate)) continue;
            entryHisInfo = new SocEmpSocFilesEntryHisInfo();
            try {
                BeanUtils.copyProperties((Object)oldEntryInfo, (Object)entryHisInfo);
                entryHisInfo.setBill(oldEntryInfo.getBill());
                entryHisInfo.setId(BOSUuid.create((BOSObjectType)entryHisBosType));
                socFilesEntryHis.addnew(entryHisInfo);
                socTypeItemHisInfo = new SocTypeItemHisInfo();
                socTypeItemHisInfo.setId(BOSUuid.read((String)socTypeItemId));
                oldEntryInfo.setSocTypeItem(socTypeItemHisInfo);
                oldEntryInfo.setSelfBase(selfBase);
                oldEntryInfo.setCompanyBase(companyBase);
                oldEntryInfo.setEffectDay(newEffectDate);
                socFilesEntry.save(oldEntryInfo);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SocialCommonException(SocialCommonException.SAVE_ERROR);
            }
        }
    }

    private void updateCurEntry(Context ctx, SocEmpSocFilesEntryInfo oldEntryInfo) throws BOSException, EASBizException {
        ISocEmpSocFilesEntry socFilesEntry = SocEmpSocFilesEntryFactory.getLocalInstance(ctx);
        String curEntryId = oldEntryInfo.getId().toString();
        String billId = oldEntryInfo.getBill().getId().toString();
        String oql = "select id,* where bill.id='" + billId + "' order by effectDay desc";
        ISocEmpSocFilesEntryHis socFilesEntryHis = SocEmpSocFilesEntryHisFactory.getLocalInstance(ctx);
        SocEmpSocFilesEntryHisCollection coll = socFilesEntryHis.getSocEmpSocFilesEntryHisCollection(oql);
        if (coll.size() == 0) {
            return;
        }
        SocEmpSocFilesEntryHisInfo socFilesEntryHisInfo = coll.get(0);
        try {
            BeanUtils.copyProperties((Object)socFilesEntryHisInfo, (Object)oldEntryInfo);
            oldEntryInfo.setId(BOSUuid.read((String)curEntryId));
            socFilesEntry.save(oldEntryInfo);
            socFilesEntryHis.delete((IObjectPK)new ObjectUuidPK(socFilesEntryHisInfo.getId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addNewEntry(Context ctx, String billId, Map<String, Object> map) throws EASBizException, BOSException {
        SocEmpSocFilesEntryInfo entryInfo = new SocEmpSocFilesEntryInfo();
        SocEmpSocFilesInfo socEmpSocFilesInfo = new SocEmpSocFilesInfo();
        socEmpSocFilesInfo.setId(BOSUuid.read((String)billId));
        SocTypeItemHisInfo socTypeItemHisInfo = new SocTypeItemHisInfo();
        String entryId = (String)map.get("entry_recId");
        String socTypeItemId = (String)map.get("SocTypeItemId");
        socTypeItemHisInfo.setId(BOSUuid.read((String)socTypeItemId));
        BigDecimal selfBase = SocStrUtil.toBigDecimal((Object)map.get("SelfBase"));
        BigDecimal companyBase = SocStrUtil.toBigDecimal((Object)map.get("CompanyBase"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date effectDate = null;
        try {
            effectDate = sdf.parse("" + map.get("effectDate"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new SocialCommonException(SocialCommonException.DATE_FORMAT_ERROR);
        }
        entryInfo.setId(BOSUuid.read((String)entryId));
        entryInfo.setBill(socEmpSocFilesInfo);
        entryInfo.setSocTypeItem(socTypeItemHisInfo);
        entryInfo.setSelfBase(selfBase);
        entryInfo.setCompanyBase(companyBase);
        entryInfo.setEffectDay(effectDate);
        ISocEmpSocFilesEntry socEmpSocFilesEntry = SocEmpSocFilesEntryFactory.getLocalInstance(ctx);
        socEmpSocFilesEntry.save(entryInfo);
    }

    private Map<String, SocEmpSocFilesEntryInfo> getsocEntryInfoMap(Context ctx, String billId) {
        HashMap<String, SocEmpSocFilesEntryInfo> map = new HashMap<String, SocEmpSocFilesEntryInfo>();
        String oql = "select *,bill.*, socTypeItem.* where bill = '" + billId + "'";
        try {
            ISocEmpSocFilesEntry socEmpSocFilesEntry = SocEmpSocFilesEntryFactory.getLocalInstance(ctx);
            SocEmpSocFilesEntryCollection coll = socEmpSocFilesEntry.getSocEmpSocFilesEntryCollection(oql);
            if (coll == null || coll.size() == 0) {
                return map;
            }
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                SocEmpSocFilesEntryInfo socFilesEntryInfo = coll.get(i);
                String entryId = socFilesEntryInfo.getId().toString();
                map.put(entryId, socFilesEntryInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    private SocEmpSocFilesEntryHisInfo getSocEntryHisInfo(Context ctx, String billId, Date effectDate, String socItemId) {
        SocEmpSocFilesEntryHisInfo socEntryHisInfo = null;
        String oql = "select * where socTypeItem.socItem='" + socItemId + "' and bill='" + billId + "' and effectDay=" + SocDateUtil.toKSqlDate((Date)effectDate);
        try {
            ISocEmpSocFilesEntryHis socEmpSocFilesEntryHis = SocEmpSocFilesEntryHisFactory.getLocalInstance(ctx);
            SocEmpSocFilesEntryHisCollection coll = socEmpSocFilesEntryHis.getSocEmpSocFilesEntryHisCollection(oql);
            if (coll != null && coll.size() > 0) {
                socEntryHisInfo = coll.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return socEntryHisInfo;
    }
}

