/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.socialSecurity.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.socialSecurity.ISocEmpSocFilesEntry;
import com.kingdee.shr.socialSecurity.ISocEmpSocFilesEntryHis;
import com.kingdee.shr.socialSecurity.ISocTypeHis;
import com.kingdee.shr.socialSecurity.ISocTypeItemHis;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryCollection;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryFactory;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryHisFactory;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryHisInfo;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesEntryInfo;
import com.kingdee.shr.socialSecurity.SocEmpSocFilesInfo;
import com.kingdee.shr.socialSecurity.SocItemInfo;
import com.kingdee.shr.socialSecurity.SocTypeException;
import com.kingdee.shr.socialSecurity.SocTypeHisCollection;
import com.kingdee.shr.socialSecurity.SocTypeHisFactory;
import com.kingdee.shr.socialSecurity.SocTypeHisInfo;
import com.kingdee.shr.socialSecurity.SocTypeInfo;
import com.kingdee.shr.socialSecurity.SocTypeItemCollection;
import com.kingdee.shr.socialSecurity.SocTypeItemHisCollection;
import com.kingdee.shr.socialSecurity.SocTypeItemHisFactory;
import com.kingdee.shr.socialSecurity.SocTypeItemHisInfo;
import com.kingdee.shr.socialSecurity.SocTypeItemInfo;
import com.kingdee.shr.socialSecurity.app.AbstractSocTypeFacadeControllerBean;
import com.kingdee.shr.socialSecurity.sql.SocTypeSQL;
import com.kingdee.shr.socialSecurity.util.SocCreateIdUtil;
import com.kingdee.shr.socialSecurity.util.SocDateUtil;
import com.kingdee.shr.socialSecurity.util.SocTypeBizUtil;
import com.kingdee.util.LocaleUtils;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class SocTypeFacadeControllerBean
extends AbstractSocTypeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.socialSecurity.app.SocTypeFacadeControllerBean");

    @Override
    protected void _generateSocTypeHis(Context ctx, IObjectValue socTypeObj) throws BOSException, EASBizException {
        long t1 = System.currentTimeMillis();
        SocTypeInfo socTypeInfo = (SocTypeInfo)socTypeObj;
        CoreBaseCollection coll = new CoreBaseCollection();
        coll.add((CoreBaseInfo)socTypeInfo);
        this.addSocTypeHisOperate(ctx, coll);
        long t2 = System.currentTimeMillis();
        logger.error((Object)("------------_generateSocTypeHis : " + (t2 - t1)));
    }

    protected void addSocTypeHisOperate(Context ctx, CoreBaseCollection coll) throws EASBizException {
        if (coll == null || coll.size() == 0) {
            return;
        }
        try {
            ISocTypeHis socTypeHis = SocTypeHisFactory.getLocalInstance(ctx);
            CoreBaseCollection addColl = new CoreBaseCollection();
            ArrayList<String[]> paramList = new ArrayList<String[]>();
            ArrayList<String[]> updateParamList = new ArrayList<String[]>();
            HashMap socTypeMap = new HashMap();
            ArrayList<Object> socTypeList = null;
            int size = coll.size();
            SHRBasicItemInfo basicItemInfo = new SHRBasicItemInfo();
            basicItemInfo.setId(BOSUuid.read((String)"vyzii1XbUka11K0PxuWEr5Nzh54="));
            for (int i = 0; i < size; ++i) {
                SocTypeInfo socTypeInfo = (SocTypeInfo)coll.get(i);
                String oldSocTypeId = socTypeInfo.getId().toString();
                socTypeInfo = SocTypeBizUtil.getSocTypeInfo(ctx, oldSocTypeId);
                SocTypeItemCollection entry = socTypeInfo.getEntry();
                SocTypeHisInfo socTypeHisInfo = new SocTypeHisInfo();
                this.failureLastSocType(ctx, socTypeInfo);
                BeanUtils.copyProperties((Object)socTypeInfo, (Object)socTypeHisInfo);
                java.util.Date maxEndDate = SocDateUtil.getMaxEndDate();
                socTypeHisInfo.setLeffectDate(maxEndDate);
                socTypeHisInfo.setHistoryRelateID(oldSocTypeId);
                BOSUuid socTypeHisId = SocCreateIdUtil.getSocTypeHisId();
                socTypeHisInfo.setId(socTypeHisId);
                System.out.println("=========prepare his data : his [" + socTypeHisId + "] from old data : old [" + oldSocTypeId + "]");
                SocTypeItemHisCollection socTypeItemHisColl = this.generateSocTypeItemHis(ctx, entry, socTypeHisInfo);
                socTypeHisInfo.put("entry", (Object)socTypeItemHisColl);
                String oldName_l1 = socTypeInfo.getName(LocaleUtils.locale_en_US);
                String oldName_l2 = socTypeInfo.getName(LocaleUtils.locale_zh_CN);
                String oldName_l3 = socTypeInfo.getName(LocaleUtils.locale_zh_TW);
                String oldNumber = socTypeHisInfo.getNumber();
                socTypeHisInfo.setNumber(UUID.randomUUID().toString());
                socTypeHisInfo.setName(UUID.randomUUID().toString());
                socTypeHisInfo.setShrBasicItem(basicItemInfo);
                addColl.add((CoreBaseInfo)socTypeHisInfo);
                String[] params = new String[]{oldNumber, oldName_l1, oldName_l2, oldName_l3, socTypeHisId.toString()};
                paramList.add(params);
                params = new String[]{socTypeInfo.getCensus().getId().toString(), socTypeInfo.getSocArea().getId().toString(), String.valueOf(socTypeInfo.getState().getValue()), String.valueOf(socTypeInfo.getUsePolicy().getValue()), socTypeInfo.getCurrency().getId().toString(), socTypeInfo.getId().toString()};
                updateParamList.add(params);
                socTypeList = new ArrayList<Object>();
                socTypeList.add(socTypeInfo);
                socTypeList.add((Object)socTypeItemHisColl);
                socTypeMap.put(i, socTypeList);
            }
            socTypeHis.saveBatchData(addColl);
            System.out.println("=========batch save finished");
            SocTypeBizUtil.changeNumberAndName(ctx, paramList);
            SocTypeBizUtil.updateUnquoteMes(ctx, updateParamList);
            for (int j = 0; j < size; ++j) {
                List list = (List)socTypeMap.get(j);
                SocTypeInfo socTypeInfo = (SocTypeInfo)list.get(0);
                SocTypeItemHisCollection socTypeItemHisColl = (SocTypeItemHisCollection)((Object)list.get(1));
                this.synchSocEmpSocFilesEntry(ctx, socTypeInfo, socTypeItemHisColl);
                System.out.println("=========sync soc datas : type [" + socTypeInfo.getId() + "]");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SocTypeException(SocTypeException.SOCTYPEHIS_ERROR, e);
        }
    }

    protected void failureLastSocType(Context ctx, SocTypeInfo socTypeInfo) throws BOSException, EASBizException, SQLException {
        String oql;
        String socTypeId = socTypeInfo.getId().toString();
        ISocTypeHis hisInstance = SocTypeHisFactory.getLocalInstance(ctx);
        SocTypeHisCollection hisColl = hisInstance.getSocTypeHisCollection(oql = "where historyRelateID = '" + socTypeId + "'");
        if (hisColl == null || hisColl.size() <= 0) {
            return;
        }
        java.util.Date maxLeffectDate = SocDateUtil.getMaxEndDate();
        Date maxLeffectSqlDate = new Date(maxLeffectDate.getTime());
        java.util.Date effectDate = socTypeInfo.getEffectDate();
        effectDate = SocDateUtil.getCurrentDate(effectDate, -1);
        Date leffectDate = new Date(effectDate.getTime());
        String socTypeHisId = "";
        String maxSocTypeHisSql = SocTypeSQL.getMaxSocTypeHisSql();
        Object[] params = new Object[]{socTypeId, maxLeffectSqlDate};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)maxSocTypeHisSql, (Object[])params);
        while (rs.next()) {
            socTypeHisId = rs.getString("fid");
        }
        String failureSocTypeSql = SocTypeSQL.getUpdateSocTypeHisLeffectSql();
        Object[] updateParam = new Object[]{leffectDate, socTypeHisId};
        DbUtil.execute((Context)ctx, (String)failureSocTypeSql, (Object[])updateParam);
    }

    protected SocTypeItemHisCollection generateSocTypeItemHis(Context ctx, SocTypeItemCollection entry, SocTypeHisInfo socTypeHisInfo) throws IllegalAccessException, InvocationTargetException {
        java.util.Date effectDate = socTypeHisInfo.getEffectDate();
        SocTypeItemHisCollection hisEntry = new SocTypeItemHisCollection();
        if (entry != null && entry.size() > 0) {
            SocTypeItemHisInfo socTypeItemHisInfo = null;
            int size = entry.size();
            for (int i = 0; i < size; ++i) {
                SocTypeItemInfo socTypeItemInfo = entry.get(i);
                socTypeItemHisInfo = new SocTypeItemHisInfo();
                socTypeItemInfo.setBill(null);
                BeanUtils.copyProperties((Object)socTypeItemInfo, (Object)socTypeItemHisInfo);
                BOSUuid socTypeItemHisId = SocCreateIdUtil.getSocTypeItemHisId();
                String socTypeItemId = socTypeItemInfo.getId().toString();
                socTypeItemHisInfo.setId(socTypeItemHisId);
                socTypeItemHisInfo.setHistoryRelateID(socTypeItemId);
                socTypeItemHisInfo.setBill(socTypeHisInfo);
                socTypeItemHisInfo.setEffectDate(effectDate);
                hisEntry.add(socTypeItemHisInfo);
            }
        }
        return hisEntry;
    }

    protected void synchSocEmpSocFilesEntry(Context ctx, SocTypeInfo socTypeInfo, SocTypeItemHisCollection socTypeItemHisColl) throws Exception {
        Map<String, Set<String>> updateSocFiles = this.getUpdateSocFiles(ctx, socTypeInfo);
        java.util.Date effectDate = socTypeInfo.getEffectDate();
        if (updateSocFiles.size() == 0) {
            return;
        }
        Map<String, SocEmpSocFilesEntryCollection> updateSocFilesCollMap = this.initUpdateSocFilesColl(ctx, updateSocFiles.keySet());
        this.generateSocEmpSocFilesEntryHis(ctx, updateSocFilesCollMap, updateSocFiles, effectDate);
        this.changeSocEmpSocFilesEntryHis(ctx, updateSocFilesCollMap, updateSocFiles, socTypeItemHisColl, effectDate);
    }

    protected Map<String, SocEmpSocFilesEntryCollection> initUpdateSocFilesColl(Context ctx, Set<String> updateSocFilesSet) throws BOSException {
        HashMap<String, SocEmpSocFilesEntryCollection> entryCollectionMap = new HashMap<String, SocEmpSocFilesEntryCollection>();
        String entryOql = "select *,bill,socTypeItem.* where bill in (" + CmpStrUtil.convertSetToSqlString(updateSocFilesSet) + ") order by bill";
        ISocEmpSocFilesEntry socFilesEntryInstance = SocEmpSocFilesEntryFactory.getLocalInstance(ctx);
        SocEmpSocFilesEntryCollection socFilesEntryColl = socFilesEntryInstance.getSocEmpSocFilesEntryCollection(entryOql);
        if (socFilesEntryColl == null || socFilesEntryColl.size() <= 0) {
            return entryCollectionMap;
        }
        int size = socFilesEntryColl.size();
        for (int i = 0; i < size; ++i) {
            SocEmpSocFilesEntryInfo socEmpSocFilesEntryInfo = socFilesEntryColl.get(i);
            String socFilesId = socEmpSocFilesEntryInfo.getBill().getId().toString();
            SocEmpSocFilesEntryCollection perSocFilesEntryColl = null;
            perSocFilesEntryColl = entryCollectionMap.containsKey(socFilesId) ? (SocEmpSocFilesEntryCollection)((Object)entryCollectionMap.get(socFilesId)) : new SocEmpSocFilesEntryCollection();
            perSocFilesEntryColl.add(socEmpSocFilesEntryInfo);
            entryCollectionMap.put(socFilesId, perSocFilesEntryColl);
        }
        return entryCollectionMap;
    }

    protected Map<String, Set<String>> getUpdateSocFiles(Context ctx, SocTypeInfo socTypeInfo) throws BOSException, SQLException {
        HashSet<String> socTypeItemSet = new HashSet<String>();
        HashMap<String, Set<String>> updateItemMap = new HashMap<String, Set<String>>();
        String socTypeId = socTypeInfo.getId().toString();
        java.util.Date date = socTypeInfo.getEffectDate();
        Date effectDate = new Date(date.getTime());
        Object[] params = new Object[]{socTypeId, effectDate};
        java.util.Date lastEffectDay = SocDateUtil.getMaxEndDate();
        HashMap<String, Set<String>> personItemMap = new HashMap<String, Set<String>>();
        SocTypeItemCollection entryCollection = socTypeInfo.getEntry();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            String socItem = entryCollection.get(i).getSocItem().getId().toString();
            socTypeItemSet.add(socItem);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT socRecord.fid recordId,socFiles.FPERSONID personid,socFiles.FID socFilesID,socFiles.FSocTypeID socTypeID,socTypeItem.FSOCITEMID socItemID,socEntry.FEFFECTDAY effectDay");
        sb.append(",socStatus.FSocPayStatus socStatus,socStatus.FEffectDate statusEffectDay FROM ").append("\r\n");
        sb.append("T_HR_SSocPersonRecord socRecord ").append("\r\n");
        sb.append("inner join T_HR_SSocEmpSocFiles socFiles on socFiles.FBILLID = socRecord.FID  ").append("\r\n");
        sb.append("inner join T_HR_SSocEmpSocFiles aa on aa.FBILLID = socFiles.FBILLID  ").append("\r\n");
        sb.append("inner join T_HR_SSocEmpSocFilesEntry socEntry on socFiles.FID = socEntry.FBILLID  ").append("\r\n");
        sb.append("inner join T_HR_SSocTypeItemHis socTypeItem on socEntry.FSOCTYPEITEMID = socTypeItem.FID ").append("\r\n");
        sb.append("inner join T_HR_SSocItem socItem on socItem.fid= socTypeItem.FSocItemID ").append("\r\n");
        sb.append("left join T_HR_SSocEmpPayStatus socStatus on socStatus.FSocPersonRecordID = socRecord.FID and socItem.FSocCategoryID = socStatus.FSocCategoryID ").append("\r\n");
        sb.append("where aa.FSocTypeID = ? and socRecord.FLeffectDate>=? ").append("\r\n");
        sb.append("order by socRecord.fid,socTypeItem.FSOCITEMID,socEntry.FEFFECTDAY desc ").append("\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
        while (rs.next()) {
            String recordId = rs.getString("recordId");
            String socFilesId = rs.getString("socFilesID");
            String curSocTypeID = rs.getString("socTypeID");
            String socItemID = rs.getString("socItemID");
            boolean socPayStatus = rs.getBoolean("socStatus");
            Date statusEffectDay = rs.getDate("statusEffectDay");
            Date entryEffectDay = rs.getDate("effectDay");
            if (!socTypeItemSet.contains(socItemID)) continue;
            Set updateItemSet = updateItemMap.containsKey(socFilesId) ? (Set)updateItemMap.get(socFilesId) : new HashSet();
            Set itemSet = personItemMap.containsKey(recordId) ? (Set)personItemMap.get(recordId) : new HashSet();
            if (!itemSet.contains(socItemID)) {
                itemSet.add(socItemID);
                personItemMap.put(recordId, itemSet);
                lastEffectDay = SocDateUtil.getMaxEndDate();
                if (!socTypeId.equals(curSocTypeID)) {
                    lastEffectDay = entryEffectDay;
                    continue;
                }
                if (statusEffectDay == null || socPayStatus && statusEffectDay.before(lastEffectDay) || !entryEffectDay.after(date) && !socPayStatus && statusEffectDay.after(date) || entryEffectDay.after(date) && !socPayStatus && statusEffectDay.after(entryEffectDay)) {
                    updateItemSet.add(socItemID);
                }
            } else {
                if (!socTypeId.equals(curSocTypeID) || !date.before(lastEffectDay)) {
                    lastEffectDay = entryEffectDay;
                    continue;
                }
                if (statusEffectDay == null || socPayStatus && statusEffectDay.before(lastEffectDay) || !entryEffectDay.after(date) && !socPayStatus && statusEffectDay.after(date) || entryEffectDay.after(date) && !socPayStatus && statusEffectDay.after(entryEffectDay)) {
                    updateItemSet.add(socItemID);
                }
            }
            updateItemMap.put(socFilesId, updateItemSet);
        }
        return updateItemMap;
    }

    protected void generateSocEmpSocFilesEntryHis(Context ctx, Map<String, SocEmpSocFilesEntryCollection> updateSocFilesCollMap, Map<String, Set<String>> updateSocFiles, java.util.Date effectDate) throws BOSException, IllegalAccessException, InvocationTargetException, EASBizException {
        ISocEmpSocFilesEntryHis socFilesEntryHisInstance = SocEmpSocFilesEntryHisFactory.getLocalInstance(ctx);
        SocEmpSocFilesEntryHisInfo socEmpSocFilesEntryHisInfo = new SocEmpSocFilesEntryHisInfo();
        SocEmpSocFilesEntryInfo socEmpSocFilesEntryInfo = null;
        java.util.Date entryEffectDate = null;
        CoreBaseCollection batchcoll = new CoreBaseCollection();
        for (String socFilesId : updateSocFiles.keySet()) {
            SocEmpSocFilesEntryCollection perSocFilesEntryColl = null;
            if (updateSocFilesCollMap.containsKey(socFilesId)) {
                perSocFilesEntryColl = updateSocFilesCollMap.get(socFilesId);
            }
            if (perSocFilesEntryColl == null || perSocFilesEntryColl.size() <= 0) continue;
            Set<String> updateItemSet = updateSocFiles.get(socFilesId);
            int entrySize = perSocFilesEntryColl.size();
            for (int j = 0; j < entrySize; ++j) {
                socEmpSocFilesEntryHisInfo = new SocEmpSocFilesEntryHisInfo();
                socEmpSocFilesEntryInfo = perSocFilesEntryColl.get(j);
                entryEffectDate = socEmpSocFilesEntryInfo.getEffectDay();
                if (entryEffectDate.after(effectDate) || entryEffectDate.equals(effectDate) || !updateItemSet.contains(socEmpSocFilesEntryInfo.getSocTypeItem().getSocItem().getId().toString())) continue;
                BeanUtils.copyProperties((Object)socEmpSocFilesEntryInfo, (Object)socEmpSocFilesEntryHisInfo);
                BOSUuid socEmpSocFilesEntryHisId = SocCreateIdUtil.getSocEmpSocFilesEntryHisId();
                socEmpSocFilesEntryHisInfo.setId(socEmpSocFilesEntryHisId);
                batchcoll.add((CoreBaseInfo)socEmpSocFilesEntryHisInfo);
            }
        }
        socFilesEntryHisInstance.saveBatchData(batchcoll);
    }

    protected void changeSocEmpSocFilesEntryHis(Context ctx, Map<String, SocEmpSocFilesEntryCollection> updateSocFilesCollMap, Map<String, Set<String>> updateSocFiles, SocTypeItemHisCollection socTypeItemHisColl, java.util.Date effectDate) throws BOSException, EASBizException {
        ISocEmpSocFilesEntry socFilesEntryInstance = SocEmpSocFilesEntryFactory.getLocalInstance(ctx);
        ISocEmpSocFilesEntryHis socFilesEntryHisInstance = SocEmpSocFilesEntryHisFactory.getLocalInstance(ctx);
        CoreBaseCollection curColl = new CoreBaseCollection();
        CoreBaseCollection hisColl = new CoreBaseCollection();
        CoreBaseCollection updateCurColl = new CoreBaseCollection();
        SocEmpSocFilesEntryInfo socFilesEntryInfo = null;
        SocEmpSocFilesInfo socFilesInfo = null;
        SocEmpSocFilesEntryInfo upSocFilesEntryInfo = null;
        ArrayList<String> oldSocItemIds = new ArrayList<String>();
        HashMap<String, SocEmpSocFilesEntryInfo> updateSocEmpSocFilesEntry = new HashMap<String, SocEmpSocFilesEntryInfo>();
        HashSet<ObjectUuidPK> delSet = new HashSet<ObjectUuidPK>();
        ArrayList<Object[]> upSocFilesDescParams = new ArrayList<Object[]>();
        String updateFilesDescSql = "update T_HR_SSocEmpSocFiles Set FDescription_l1 = ?, FDescription_l2 = ?, FDescription_l3 = ? where FID = ?";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyy-MM-dd HH:mm:ss");
        String timeStr = simpleDateFormat.format(new java.util.Date());
        String automatic_L1 = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"automatic", (Locale)LocaleUtils.locale_L1) + ":" + timeStr;
        String automatic_L2 = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"automatic", (Locale)LocaleUtils.locale_L2) + ":" + timeStr;
        String automatic_L3 = EASResource.getString((String)"com.kingdee.shr.socialSecurity.resource.SocConstant", (String)"automatic", (Locale)LocaleUtils.locale_L3) + ":" + timeStr;
        for (String socFilesId : updateSocFiles.keySet()) {
            SocEmpSocFilesEntryCollection socFilesEntryColl = null;
            if (!updateSocFilesCollMap.containsKey(socFilesId)) continue;
            socFilesEntryColl = updateSocFilesCollMap.get(socFilesId);
            Set<String> updateItemSet = updateSocFiles.get(socFilesId);
            oldSocItemIds.clear();
            updateSocEmpSocFilesEntry.clear();
            int entrySize = socFilesEntryColl.size();
            for (int k = 0; k < entrySize; ++k) {
                SocEmpSocFilesEntryInfo socEmpSocFilesEntryInfo = socFilesEntryColl.get(k);
                java.util.Date socFileEntryDate = socEmpSocFilesEntryInfo.getEffectDay();
                oldSocItemIds.add(socEmpSocFilesEntryInfo.getSocTypeItem().getSocItem().getId().toString());
                BOSUuid socEntryId = socEmpSocFilesEntryInfo.getId();
                if (!updateItemSet.contains(socEmpSocFilesEntryInfo.getSocTypeItem().getSocItem().getId().toString())) continue;
                if (socFileEntryDate.after(effectDate) || socFileEntryDate.equals(effectDate)) {
                    SocItemInfo hisSocItemInfo = socEmpSocFilesEntryInfo.getSocTypeItem().getSocItem();
                    updateSocEmpSocFilesEntry.put(hisSocItemInfo.getId().toString(), socEmpSocFilesEntryInfo);
                    continue;
                }
                delSet.add(new ObjectUuidPK(socEntryId));
            }
            socFilesInfo = new SocEmpSocFilesInfo();
            socFilesInfo.setId(BOSUuid.read((String)socFilesId));
            int socTypeItemSize = socTypeItemHisColl.size();
            for (int i = 0; i < socTypeItemSize; ++i) {
                SocTypeItemHisInfo socTypeItemHisInfo = socTypeItemHisColl.get(i);
                BigDecimal selfBase = socTypeItemHisInfo.getSelfBase();
                BigDecimal companyBase = socTypeItemHisInfo.getCompanyBase();
                SocItemInfo socItem = socTypeItemHisInfo.getSocItem();
                String socItemId = socItem.getId().toString();
                if (!oldSocItemIds.contains(socItemId) || !updateItemSet.contains(socItemId)) continue;
                if (updateSocEmpSocFilesEntry.containsKey(socItemId)) {
                    upSocFilesEntryInfo = (SocEmpSocFilesEntryInfo)updateSocEmpSocFilesEntry.get(socItemId);
                    upSocFilesEntryInfo.setSocTypeItem(socTypeItemHisInfo);
                    if (selfBase != null || companyBase != null) {
                        upSocFilesEntryInfo.setSelfBase(selfBase);
                        upSocFilesEntryInfo.setCompanyBase(companyBase);
                    }
                    updateCurColl.add((CoreBaseInfo)upSocFilesEntryInfo);
                    continue;
                }
                socFilesEntryInfo = new SocEmpSocFilesEntryInfo();
                BOSUuid entryId = SocCreateIdUtil.getSocEmpSocFilesEntryId();
                socFilesEntryInfo.setId(entryId);
                socFilesEntryInfo.setBill(socFilesInfo);
                socFilesEntryInfo.setSocTypeItem(socTypeItemHisInfo);
                if (selfBase != null || companyBase != null) {
                    socFilesEntryInfo.setSelfBase(selfBase);
                    socFilesEntryInfo.setCompanyBase(companyBase);
                    socFilesEntryInfo.setEffectDay(effectDate);
                } else {
                    int socFilesEntrySize = socFilesEntryColl.size();
                    for (int j = 0; j < socFilesEntrySize; ++j) {
                        SocEmpSocFilesEntryInfo oldSocFilesEntryInfo = socFilesEntryColl.get(j);
                        SocTypeItemHisInfo oldSocItemHisInfo = oldSocFilesEntryInfo.getSocTypeItem();
                        BigDecimal oldSelfBase = oldSocFilesEntryInfo.getSelfBase();
                        BigDecimal oldCompanyBase = oldSocFilesEntryInfo.getCompanyBase();
                        String oldSocItemId = oldSocItemHisInfo.getSocItem().getId().toString();
                        if (oldSocItemId.equals(socItemId)) {
                            socFilesEntryInfo.setSelfBase(oldSelfBase);
                            socFilesEntryInfo.setCompanyBase(oldCompanyBase);
                        }
                        socFilesEntryInfo.setEffectDay(effectDate);
                    }
                }
                curColl.add((CoreBaseInfo)socFilesEntryInfo);
                Object[] param = new Object[]{automatic_L1, automatic_L2, automatic_L3, socFilesId};
                upSocFilesDescParams.add(param);
            }
        }
        IObjectPK[] pkArray = new IObjectPK[delSet.size()];
        delSet.toArray(pkArray);
        socFilesEntryInstance.deleteBatchData(pkArray);
        socFilesEntryInstance.saveBatchData(curColl);
        socFilesEntryInstance.updateBatchData(updateCurColl);
        socFilesEntryHisInstance.save(hisColl);
        if (upSocFilesDescParams.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateFilesDescSql, upSocFilesDescParams);
        }
    }

    @Deprecated
    protected Map<String, String> buildSocTypeItemMap(SocTypeItemHisCollection socTypeItemHisColl) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (socTypeItemHisColl == null || socTypeItemHisColl.size() == 0) {
            return map;
        }
        int size = socTypeItemHisColl.size();
        for (int i = 0; i < size; ++i) {
            SocTypeItemHisInfo info = socTypeItemHisColl.get(i);
            String socItemId = info.getSocItem().getId().toString();
            String id = info.getId().toString();
            map.put(socItemId, id);
        }
        return map;
    }

    @Override
    protected void _updateSocTypeHis(Context ctx, IObjectValue socTypeObj) throws BOSException, EASBizException {
        SocTypeInfo socTypeInfo = (SocTypeInfo)socTypeObj;
        CoreBaseCollection coll = new CoreBaseCollection();
        coll.add((CoreBaseInfo)socTypeInfo);
        this.updateSocTypeHisOperate(ctx, coll);
    }

    protected void updateSocTypeHisOperate(Context ctx, CoreBaseCollection coll) throws EASBizException, BOSException {
        if (coll == null || coll.size() == 0) {
            return;
        }
        try {
            SocTypeItemCollection socTypeItemColl;
            ISocTypeHis socTypeHis = SocTypeHisFactory.getLocalInstance(ctx);
            CoreBaseCollection updateColl = new CoreBaseCollection();
            ArrayList<String[]> paramList = new ArrayList<String[]>();
            ArrayList<String[]> updateParamList = new ArrayList<String[]>();
            HashMap socTypeMap = new HashMap();
            ArrayList<Object> socTypeList = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                SocTypeInfo socTypeInfo = (SocTypeInfo)coll.get(i);
                String socTypeId = socTypeInfo.getId().toString();
                socTypeInfo = SocTypeBizUtil.getSocTypeInfo(ctx, socTypeId);
                socTypeItemColl = socTypeInfo.getEntry();
                SocTypeHisInfo socTypeHisInfo = null;
                try {
                    socTypeHisInfo = this.getSocTypeHis(ctx, socTypeId);
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    throw new SocTypeException(SocTypeException.SOCTYPEHIS_UPDATE_ERROR);
                }
                if (socTypeHisInfo == null) {
                    return;
                }
                BOSUuid socTypeHisId = socTypeHisInfo.getId();
                SocTypeItemHisCollection socTypeItemHisColl = socTypeHisInfo.getEntry();
                java.util.Date leffectDate = socTypeHisInfo.getLeffectDate();
                BeanUtils.copyProperties((Object)socTypeInfo, (Object)socTypeHisInfo);
                socTypeHisInfo.setId(socTypeHisId);
                socTypeHisInfo.setLeffectDate(leffectDate);
                String oldNumber = socTypeHisInfo.getNumber();
                String oldName_l1 = socTypeInfo.getName(LocaleUtils.locale_l1);
                String oldName_l2 = socTypeInfo.getName(LocaleUtils.locale_l2);
                String oldName_l3 = socTypeInfo.getName(LocaleUtils.locale_l3);
                socTypeHisInfo.setNumber(UUID.randomUUID().toString());
                socTypeHisInfo.setName(UUID.randomUUID().toString());
                updateColl.add((CoreBaseInfo)socTypeHisInfo);
                String[] params = new String[]{oldNumber, oldName_l1, oldName_l2, oldName_l3, socTypeHisId.toString()};
                paramList.add(params);
                params = new String[]{socTypeInfo.getCensus().getId().toString(), socTypeInfo.getSocArea().getId().toString(), String.valueOf(socTypeInfo.getState().getValue()), String.valueOf(socTypeInfo.getUsePolicy().getValue()), socTypeInfo.getCurrency().getId().toString(), socTypeInfo.getId().toString()};
                updateParamList.add(params);
                socTypeList = new ArrayList<Object>();
                socTypeList.add(socTypeHisInfo);
                socTypeList.add((Object)socTypeItemColl);
                socTypeList.add((Object)socTypeItemHisColl);
                socTypeMap.put(i, socTypeList);
            }
            socTypeHis.updateBatchData(updateColl);
            SocTypeBizUtil.changeNumberAndName(ctx, paramList);
            SocTypeBizUtil.updateUnquoteMes(ctx, updateParamList);
            for (int j = 0; j < size; ++j) {
                List list = (List)socTypeMap.get(j);
                SocTypeHisInfo socTypeHisInfo = (SocTypeHisInfo)list.get(0);
                socTypeItemColl = (SocTypeItemCollection)((Object)list.get(1));
                SocTypeItemHisCollection socTypeItemHisColl = (SocTypeItemHisCollection)((Object)list.get(2));
                this.synchSocTypeItemHis(ctx, socTypeHisInfo, socTypeItemColl, socTypeItemHisColl);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SocTypeException(SocTypeException.SOCTYPEHIS_UPDATE_ERROR, e);
        }
    }

    protected SocTypeHisInfo getSocTypeHis(Context ctx, String socTypeId) throws BOSException, ParserException {
        ISocTypeHis socTypeHis = SocTypeHisFactory.getLocalInstance(ctx);
        String maxEndDate = "{ts '2199-12-31'}";
        FilterInfo filter = new FilterInfo("historyRelateID='" + socTypeId + "'");
        filter.mergeFilter(new FilterInfo("leffectDate=" + maxEndDate), "and");
        SelectorItemCollection selectorItemColl = new SelectorItemCollection();
        selectorItemColl.add(new SelectorItemInfo("*"));
        selectorItemColl.add(new SelectorItemInfo("entry.*"));
        SorterItemCollection sorterItemColl = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("effectDate");
        sortItem.setSortType(SortType.DESCEND);
        sorterItemColl.add(sortItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(selectorItemColl);
        view.setSorter(sorterItemColl);
        SocTypeHisCollection socTypeHisColl = socTypeHis.getSocTypeHisCollection(view);
        if (socTypeHisColl == null || socTypeHisColl.size() <= 0) {
            return null;
        }
        return socTypeHisColl.get(0);
    }

    protected Map<String, List<String>> getSocItemColl(SocTypeItemCollection newSocTypeItemColl, SocTypeItemHisCollection oldSocTypeItemColl) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> newList = new ArrayList<String>();
        ArrayList<String> oldList = new ArrayList<String>();
        int size = newSocTypeItemColl.size();
        for (int i = 0; i < size; ++i) {
            SocTypeItemInfo socTypeItemInfo = newSocTypeItemColl.get(i);
            String newSocItemId = socTypeItemInfo.getSocItem().getId().toString();
            newList.add(newSocItemId);
        }
        size = oldSocTypeItemColl.size();
        for (int j = 0; j < size; ++j) {
            SocTypeItemHisInfo socTypeItemHisInfo = oldSocTypeItemColl.get(j);
            String oldSocItemId = socTypeItemHisInfo.getSocItem().getId().toString();
            oldList.add(oldSocItemId);
        }
        ArrayList<String> interList = new ArrayList<String>();
        ArrayList<String> differNew = new ArrayList<String>();
        ArrayList<String> differHis = new ArrayList<String>();
        interList.addAll(newList);
        differNew.addAll(newList);
        differHis.addAll(oldList);
        interList.retainAll(oldList);
        differNew.removeAll(oldList);
        differHis.removeAll(newList);
        map.put("interList", interList);
        map.put("differNew", differNew);
        map.put("differHis", differHis);
        return map;
    }

    protected void synchSocTypeItemHis(Context ctx, SocTypeHisInfo socTypeHisInfo, SocTypeItemCollection newColl, SocTypeItemHisCollection hisColl) throws BOSException, IllegalAccessException, InvocationTargetException, EASBizException {
        Map<String, List<String>> map = this.getSocItemColl(newColl, hisColl);
        List<String> interList = map.get("interList");
        List<String> differNew = map.get("differNew");
        List<String> differHis = map.get("differHis");
        List<IObjectPK> delList = this.getSocTypeItemHisDelList(differHis, hisColl);
        CoreBaseCollection updateColl = this.getChangedSocTypeItemColl(socTypeHisInfo, newColl, hisColl, interList, differNew);
        IObjectPK[] arr = new IObjectPK[delList.size()];
        delList.toArray(arr);
        ISocTypeItemHis socTypeItemHis = SocTypeItemHisFactory.getLocalInstance(ctx);
        socTypeItemHis.deleteBatchData(arr);
        socTypeItemHis.saveBatchData(updateColl);
    }

    protected List<IObjectPK> getSocTypeItemHisDelList(List<String> differHis, SocTypeItemHisCollection hisColl) {
        ArrayList<IObjectPK> delList = new ArrayList<IObjectPK>();
        int size = hisColl.size();
        for (int i = 0; i < size; ++i) {
            SocTypeItemHisInfo socTypeItemHisInfo = hisColl.get(i);
            String socItemId = socTypeItemHisInfo.getSocItem().getId().toString();
            if (!differHis.contains(socItemId)) continue;
            BOSUuid socTypeItemHisId = socTypeItemHisInfo.getId();
            delList.add((IObjectPK)new ObjectUuidPK(socTypeItemHisId));
        }
        return delList;
    }

    protected CoreBaseCollection getChangedSocTypeItemColl(SocTypeHisInfo socTypeHisInfo, SocTypeItemCollection newColl, SocTypeItemHisCollection hisColl, List<String> interList, List<String> differNew) throws IllegalAccessException, InvocationTargetException {
        java.util.Date effectDate = socTypeHisInfo.getEffectDate();
        CoreBaseCollection updateColl = new CoreBaseCollection();
        SocTypeItemHisInfo tempSocTypeItemHisInfo = null;
        int size = newColl.size();
        for (int j = 0; j < size; ++j) {
            SocTypeItemInfo socTypeItemInfo = newColl.get(j);
            String socTypeItemId = socTypeItemInfo.getId().toString();
            String newSocItemId = socTypeItemInfo.getSocItem().getId().toString();
            if (interList.contains(newSocItemId)) {
                int hisSize = hisColl.size();
                for (int k = 0; k < hisSize; ++k) {
                    SocTypeItemHisInfo socTypeItemHisInfo = hisColl.get(k);
                    BOSUuid socTypeItemHisId = socTypeItemHisInfo.getId();
                    String hisSocItemId = socTypeItemHisInfo.getSocItem().getId().toString();
                    if (!newSocItemId.equals(hisSocItemId)) continue;
                    socTypeItemInfo.setBill(null);
                    BeanUtils.copyProperties((Object)socTypeItemInfo, (Object)socTypeItemHisInfo);
                    socTypeItemHisInfo.setId(socTypeItemHisId);
                    socTypeItemHisInfo.setBill(socTypeHisInfo);
                    socTypeItemHisInfo.setEffectDate(effectDate);
                    updateColl.add((CoreBaseInfo)socTypeItemHisInfo);
                }
                continue;
            }
            if (!differNew.contains(newSocItemId)) continue;
            tempSocTypeItemHisInfo = new SocTypeItemHisInfo();
            socTypeItemInfo.setBill(null);
            BeanUtils.copyProperties((Object)socTypeItemInfo, (Object)tempSocTypeItemHisInfo);
            BOSUuid socTypeItemHisId = SocCreateIdUtil.getSocTypeItemHisId();
            tempSocTypeItemHisInfo.setId(socTypeItemHisId);
            tempSocTypeItemHisInfo.setBill(socTypeHisInfo);
            tempSocTypeItemHisInfo.setHistoryRelateID(socTypeItemId);
            tempSocTypeItemHisInfo.setEffectDate(effectDate);
            updateColl.add((CoreBaseInfo)tempSocTypeItemHisInfo);
        }
        return updateColl;
    }

    @Override
    @Deprecated
    protected boolean _checkSocTypeItemHisQuote(Context ctx, String socTypeItemId) throws BOSException, EASBizException {
        Object[] params = new String[]{socTypeItemId};
        String currentSql = SocTypeSQL.checkSocTypeItemInSocFilesEntrySql();
        String hisSql = SocTypeSQL.checkSocTypeItemInSocFilesEntryHisSql();
        IRowSet cRs = DbUtil.executeQuery((Context)ctx, (String)currentSql, (Object[])params);
        IRowSet hRs = DbUtil.executeQuery((Context)ctx, (String)hisSql, (Object[])params);
        try {
            return cRs.next() || hRs.next();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _checkDateValid(Context ctx, String number, java.util.Date effectDate) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _generateSocTypeHisBatch(Context ctx, CoreBaseCollection socTypeColl) throws BOSException, EASBizException {
        CoreBaseCollection coll = socTypeColl;
        this.addSocTypeHisOperate(ctx, coll);
    }

    @Override
    protected void _updateSocTypeHisBatch(Context ctx, CoreBaseCollection socTypeColl) throws BOSException, EASBizException {
        CoreBaseCollection coll = socTypeColl;
        this.updateSocTypeHisOperate(ctx, coll);
    }
}

