/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.AddServiceLogFactory;
import com.kingdee.bos.bsf.service.ServiceLogManager;
import com.kingdee.bos.bsf.service.app.MSFServiceUtil;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class DigestThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(DigestThread.class);
    private long interval = -1L;
    private boolean stopped = false;
    private List trash;
    private boolean daemon = true;
    ServiceLogManager stateManager = null;
    Map datacenterMap = new ConcurrentHashMap();

    public DigestThread(ServiceLogManager stateManager, long interval) {
        this.stateManager = stateManager;
        this.interval = interval;
        this.parseDC();
    }

    protected final void scan() {
        DigestThread digestThread = this;
        Map<String, Map<String, Map<String, String>>> udpateQueue = digestThread.stateManager.getLogMap();
        for (Map.Entry<String, Map<String, Map<String, String>>> entry : udpateQueue.entrySet()) {
            Context ctx = (Context)this.datacenterMap.get(entry.getKey());
            AddServiceLogFactory.getInstance().addLog(ctx, entry.getValue());
        }
    }

    private void parseDC() {
        ArrayList newList = new ArrayList();
        try {
            newList = DCManager.getInstance().getDCList();
        }
        catch (Exception e1) {
            logger.error((Object)("FaRebuildViewService.newList = " + e1.getMessage()));
        }
        for (int i = 0; i < newList.size(); ++i) {
            try {
                DCInfo info = (DCInfo)newList.get(i);
                Context ctx = new Context(null, info.getSolutionName(), info.getNumber(), null);
                ctx.setUserName(info.getUserName());
                ctx.put((Object)"dbType", (Object)MSFServiceUtil.getDBType((int)info.getDBType()));
                this.datacenterMap.put(ctx.getAIS(), ctx);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("init service config  lose = " + e.getMessage()));
            }
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread t = new Thread((Runnable)this, "HRServiceLog digest Thread");
        t.setDaemon(this.daemon);
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)"HRServiceLog digest Thread start watching ");
        DigestThread digestThread = this;
        synchronized (digestThread) {
            while (!this.stopped) {
                long now;
                long until = System.currentTimeMillis() + this.interval;
                while (!this.stopped && until > (now = System.currentTimeMillis())) {
                    try {
                        this.wait(until - now);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)("Interrupted !" + e.getMessage()));
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.stopped) continue;
                this.scan();
            }
        }
    }
}

