/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.BaseInfoHRBUCollection;
import com.kingdee.shr.base.syssetting.BaseInfoHRBUInfo;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.BasicItemStateEnum;
import com.kingdee.shr.base.syssetting.BasicItemType;
import com.kingdee.shr.base.syssetting.ControlPolicyCollection;
import com.kingdee.shr.base.syssetting.ControlPolicyInfo;
import com.kingdee.shr.base.syssetting.ISHRBasicItem;
import com.kingdee.shr.base.syssetting.IUIView;
import com.kingdee.shr.base.syssetting.MaintainPolicy;
import com.kingdee.shr.base.syssetting.ManagerPolicyEnum;
import com.kingdee.shr.base.syssetting.SHRBasicItemCollection;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SysSettingHrOrgUnitUtil;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class SysSettingSHRBasicItemUtil {
    private static Logger logger = Logger.getLogger(SysSettingSHRBasicItemUtil.class);
    private static final String CACHE_TYPE = "shr.shrBasicItem";

    protected SysSettingSHRBasicItemUtil() {
    }

    public static SHRBasicItemInfo getSHRBasicItemInfoFromDBByEntityName(Context ctx, String entityName) throws EASBizException, BOSException {
        SHRBasicItemInfo dbInfo = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entityName", (Object)entityName, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("realEntityName", (Object)entityName, CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        ISHRBasicItem iSHRBasicItem = null;
        iSHRBasicItem = null == ctx ? SHRBasicItemFactory.getRemoteInstance() : SHRBasicItemFactory.getLocalInstance(ctx);
        String oql = "where entityName = '" + entityName + "' or realEntityName = '" + entityName + "'";
        if (iSHRBasicItem.exists(filter)) {
            dbInfo = iSHRBasicItem.getSHRBasicItemInfo(oql);
        }
        return dbInfo;
    }

    public static SHRBasicItemInfo getSHRBasicItemInfoFromDBById(Context ctx, String id) throws EASBizException, BOSException {
        SHRBasicItemInfo dbInfo = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        ISHRBasicItem iSHRBasicItem = null;
        iSHRBasicItem = null == ctx ? SHRBasicItemFactory.getRemoteInstance() : SHRBasicItemFactory.getLocalInstance(ctx);
        String oql = "where id = '" + id + "'";
        if (iSHRBasicItem.exists(filter)) {
            dbInfo = iSHRBasicItem.getSHRBasicItemInfo(oql);
        }
        return dbInfo;
    }

    public static void addSHRBasicItemInfoToCacheByEntityName(Context ctx, String entityName, SHRBasicItemInfo info) throws BOSException {
        CacheService.getInstance().put(CACHE_TYPE, SysSettingSHRBasicItemUtil.generateKeyByEntityName(ctx, entityName), (Object)info);
    }

    public static void addSHRBasicItemInfoToCacheById(Context ctx, String id, SHRBasicItemInfo info) throws BOSException {
        CacheService.getInstance().put(CACHE_TYPE, SysSettingSHRBasicItemUtil.generateKeyById(ctx, id), (Object)info);
    }

    public static void removeSHRBasicItemInfoFromCacheByEntityName(Context ctx, String entityName) throws BOSException {
        SHRBasicItemInfo info = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromCacheByEntityName(ctx, entityName);
        if (null != info) {
            CacheService.getInstance().remove(CACHE_TYPE, entityName);
        }
    }

    public static void removeSHRBasicItemInfoFromCacheById(Context ctx, String id) throws BOSException {
        SHRBasicItemInfo info = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromCacheById(ctx, id);
        if (null != info) {
            CacheService.getInstance().remove(CACHE_TYPE, id);
        }
    }

    private static String generateKeyByEntityName(Context ctx, String entityName) throws BOSException {
        if (null == ctx) {
            throw new BOSException("context should not be null!");
        }
        return MessageFormat.format("{0}", entityName);
    }

    private static String generateKeyById(Context ctx, String id) throws BOSException {
        return MessageFormat.format("{0}", id);
    }

    public static SHRBasicItemInfo getSHRBasicItemInfoFromCacheByEntityName(Context ctx, String entityName) throws BOSException {
        Object obj = CacheService.getInstance().get(CACHE_TYPE, entityName);
        if (null == obj) {
            return null;
        }
        return (SHRBasicItemInfo)obj;
    }

    public static SHRBasicItemInfo getSHRBasicItemInfoFromCacheById(Context ctx, String id) throws BOSException {
        Object obj = CacheService.getInstance().get(CACHE_TYPE, id);
        if (null == obj) {
            return null;
        }
        return (SHRBasicItemInfo)obj;
    }

    public static SHRBasicItemInfo getSHRBasicItemInfoByEntityName(Context ctx, String entityName) throws EASBizException, BOSException {
        SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromCacheByEntityName(ctx, entityName);
        if (null == shrBasicItemInfo && null != (shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromDBByEntityName(ctx, entityName))) {
            SysSettingSHRBasicItemUtil.addSHRBasicItemInfoToCacheByEntityName(ctx, entityName, shrBasicItemInfo);
        }
        return shrBasicItemInfo;
    }

    public static SHRBasicItemInfo getSHRBasicItemInfoById(Context ctx, String id) throws EASBizException, BOSException {
        SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromCacheById(ctx, id);
        if (null == shrBasicItemInfo && null != (shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoFromDBById(ctx, id))) {
            SysSettingSHRBasicItemUtil.addSHRBasicItemInfoToCacheById(ctx, id, shrBasicItemInfo);
        }
        return shrBasicItemInfo;
    }

    public static void checkIsUIView(Context ctx, String entityName, String uipk) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)entityName)) {
            throw new BaseItemException(BaseItemException.ENTITY_NOT_BE_NULL);
        }
        if (StringUtils.isEmpty((String)uipk)) {
            throw new BaseItemException(BaseItemException.UIPK_NOT_BE_NULL);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uipk", (Object)uipk, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("model", (Object)entityName, CompareType.EQUALS));
        IUIView iUIView = null;
        iUIView = null == ctx ? UIViewFactory.getRemoteInstance() : UIViewFactory.getLocalInstance(ctx);
        if (!iUIView.exists(filter)) {
            throw new BaseItemException(BaseItemException.UIPK_CONFIGURE_ERROR, new Object[]{uipk});
        }
    }

    public static void addRootSHRBUAuth(Context ctx, SHRBasicItemInfo model) throws EASBizException, BOSException {
        BaseInfoHRBUInfo baseInfoHRBUInfo = new BaseInfoHRBUInfo();
        HROrgUnitInfo hROrgUnitInfo = SysSettingHrOrgUnitUtil.getRootHrOrgUnit(ctx);
        baseInfoHRBUInfo.setHrOrg(hROrgUnitInfo);
        baseInfoHRBUInfo.setShrBasicItem(model);
        baseInfoHRBUInfo.setIsAllow(true);
        model.getCrHRBUAuth().add(baseInfoHRBUInfo);
    }

    private static void deleteOthers(String id, String entityName, ISHRBasicItem iSHRBasicItem) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entityName", (Object)entityName, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        if (iSHRBasicItem.exists(filter)) {
            iSHRBasicItem.delete(filter);
        }
    }

    public static SHRBasicItemInfo createOrUpdateBasicItemInfo(Context ctx, Map<String, String> enetityAliasMap, String entityName, String maintainUipk, String useUipk) throws EASBizException, BOSException {
        ISHRBasicItem iSHRBasicItem = null;
        iSHRBasicItem = null == ctx ? SHRBasicItemFactory.getRemoteInstance() : SHRBasicItemFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entityName", (Object)entityName, CompareType.EQUALS));
        SHRBasicItemInfo info = null;
        IObjectPK pk = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String number = sdf.format(new Date());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (iSHRBasicItem.exists(filter)) {
            EntityViewInfo view0;
            SHRBasicItemCollection coll = iSHRBasicItem.getSHRBasicItemCollection(view);
            SHRBasicItemInfo oldInfo = coll.get(0);
            SysSettingSHRBasicItemUtil.deleteOthers(oldInfo.getId().toString(), entityName, iSHRBasicItem);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)oldInfo.getName(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)oldInfo.getId().toString(), CompareType.NOTEQUALS));
            if (iSHRBasicItem.exists(filter)) {
                view0 = new EntityViewInfo();
                view0.setFilter(filter);
                SHRBasicItemCollection collName = iSHRBasicItem.getSHRBasicItemCollection(view0);
                oldInfo.setName(oldInfo.getName() + (collName.size() + 1) + "_custom");
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)oldInfo.getNumber(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)oldInfo.getId().toString(), CompareType.NOTEQUALS));
            if (iSHRBasicItem.exists(filter)) {
                view0 = new EntityViewInfo();
                view0.setFilter(filter);
                SHRBasicItemCollection collNumber = iSHRBasicItem.getSHRBasicItemCollection(view0);
                oldInfo.setNumber(oldInfo.getNumber() + (collNumber.size() + 1) + "_custom");
            }
            if (null == oldInfo.getDefPolicy()) {
                oldInfo.setDefPolicy(UsePolicy.GLOBALLY_SHARED);
                oldInfo.setUsePolicyText(UsePolicy.GLOBALLY_SHARED.getAlias());
            }
            if (StringUtils.isEmpty((String)oldInfo.getNumber())) {
                oldInfo.setNumber(number);
            }
            ControlPolicyInfo cInfo = new ControlPolicyInfo();
            cInfo.setUsePolicy(oldInfo.getDefPolicy());
            cInfo.setMaintainPolicy(MaintainPolicy.SELF_ORG_MAINTAIN);
            if (null == oldInfo.getManagePolicy()) {
                oldInfo.setManagePolicy(ManagerPolicyEnum.ENABLED_CREATED);
            }
            oldInfo.setState(BasicItemStateEnum.ENABLE);
            oldInfo.setIsFirstEnable(false);
            if (null == oldInfo.getConPolicy() || oldInfo.getConPolicy().size() == 0) {
                oldInfo.put("conPolicy", (Object)new ControlPolicyCollection());
                cInfo.setUsePolicy(oldInfo.getDefPolicy());
                oldInfo.getConPolicy().add(cInfo);
            }
            if (null == oldInfo.getRelationHREntity() && !oldInfo.isIsPreset()) {
                oldInfo.setRelationHREntity("com.kingdee.shr.base.syssetting.app.BaseItemRelHRCustom");
            }
            if (ManagerPolicyEnum.DISABLED_CREATED.equals((Object)oldInfo.getManagePolicy())) {
                SysSettingSHRBasicItemUtil.addRootSHRBUAuth(ctx, oldInfo);
            }
            oldInfo.setMaintainUipk(maintainUipk);
            oldInfo.setUseUipk(useUipk);
            pk = iSHRBasicItem.save((CoreBaseInfo)oldInfo);
            info = oldInfo;
        } else {
            info = new SHRBasicItemInfo();
            info.setType(BasicItemType.COMMON);
            MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)"name", (IObjectValue)info, enetityAliasMap);
            info.setNumber(number);
            info.setDefPolicy(UsePolicy.GLOBALLY_SHARED);
            info.setManagePolicy(ManagerPolicyEnum.ENABLED_CREATED);
            info.setState(BasicItemStateEnum.ENABLE);
            info.setIsFirstEnable(false);
            info.setEntityName(entityName);
            info.setMaintainUipk(maintainUipk);
            info.setUseUipk(useUipk);
            info.setIsPreset(false);
            HashMap<String, String> mulMap = new HashMap<String, String>();
            List<Map<String, String>> languageMapingList = BOSConfigUtil.getLanguageMapingList();
            for (Map<String, String> lan : languageMapingList) {
                String lang = lan.get("lang");
                Locale locale = LocaleUtils.getLocale(lang);
                mulMap.put(lang, UsePolicy.DISTRIBUTION_SHARED.getAlias(locale));
            }
            MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)"usePolicyText", (IObjectValue)info, mulMap);
            if (null == info.getConPolicy()) {
                info.put("conPolicy", (Object)new ControlPolicyCollection());
            }
            if (!info.isIsPreset()) {
                info.setRelationHREntity("com.kingdee.shr.base.syssetting.app.BaseItemRelHRCustom");
            }
            ControlPolicyInfo cInfo = new ControlPolicyInfo();
            cInfo.setUsePolicy(info.getDefPolicy());
            cInfo.setMaintainPolicy(MaintainPolicy.SELF_ORG_MAINTAIN);
            info.getConPolicy().add(cInfo);
            if (null == info.getCrHRBUAuth()) {
                info.put("crHRBUAuth", (Object)new BaseInfoHRBUCollection());
            }
            pk = iSHRBasicItem.save((CoreBaseInfo)info);
        }
        if (null == info.getId()) {
            info.setId(BOSUuid.read((String)pk.toString()));
        }
        return info;
    }

    public static boolean isAllHrOrgUnitMaintain(Context ctx, UsePolicy usePolicy, String entityName) throws EASBizException, BOSException {
        SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, entityName);
        return SysSettingSHRBasicItemUtil.isAllHrOrgUnitMaintain(ctx, usePolicy, shrBasicItemInfo);
    }

    public static boolean isAllHrOrgUnitMaintain(Context ctx, UsePolicy usePolicy, SHRBasicItemInfo shrBasicItemInfo) throws EASBizException, BOSException {
        boolean isGControlPoliy = Boolean.FALSE;
        if (UsePolicy.GLOBALLY_SHARED.equals((Object)usePolicy)) {
            int total = shrBasicItemInfo.getConPolicy().size();
            for (int i = 0; i < total; ++i) {
                ControlPolicyInfo controlPolicyInfo = shrBasicItemInfo.getConPolicy().get(i);
                if (!UsePolicy.GLOBALLY_SHARED.equals((Object)controlPolicyInfo.getUsePolicy()) || !MaintainPolicy.ALL_ORG_MAINTAIN.equals((Object)controlPolicyInfo.getMaintainPolicy())) continue;
                isGControlPoliy = Boolean.TRUE;
                break;
            }
        }
        return isGControlPoliy;
    }

    public static void removeAll() {
        CacheService.getInstance().removeAll(CACHE_TYPE);
    }

    public static LinkPropertyInfo getRelationProperty(Context ctx, SHRBasicItemInfo shrBasicItemInfo) {
        if (null == shrBasicItemInfo) {
            return null;
        }
        if (StringUtils.isEmpty((String)shrBasicItemInfo.getRealEntityName())) {
            return null;
        }
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, shrBasicItemInfo.getEntityName());
        PropertyCollection propertyCollection = entityObjectInfo.getPropertiesRuntime();
        int total = propertyCollection.size();
        for (int i = 0; i < total; ++i) {
            LinkPropertyInfo lp;
            EntityObjectInfo so;
            if (!(propertyCollection.get(i) instanceof LinkPropertyInfo) || !(so = (lp = (LinkPropertyInfo)propertyCollection.get(i)).getRelationship().getSupplierObject()).getFullName().equals(shrBasicItemInfo.getRealEntityName())) continue;
            return lp;
        }
        return null;
    }
}

