/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util.custom;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SHRDBUtils {
    private static Logger logger = Logger.getLogger(SHRDBUtils.class);

    public static boolean dbHaveData(Connection cn, String tableName) throws SQLException {
        boolean bl;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT 1 FROM " + tableName + " WHERE EXISTS (SELECT 1  FROM " + tableName + ")";
            stmt = cn.createStatement();
            rs = stmt.executeQuery(sql);
            bl = rs.next();
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((ResultSet)rs);
        return bl;
    }

    public static boolean isTableExists(Connection cn, String tableName) throws SQLException {
        boolean sql2;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            if (!StringUtils.isEmpty((String)tableName)) {
                String sql2 = "SELECT 1 FROM KSQL_USERTABLES WHERE EXISTS (SELECT 1  FROM KSQL_USERTABLES WHERE KSQL_TABNAME = ?)";
                stmt = cn.prepareStatement(sql2);
                stmt.setString(1, tableName.toUpperCase());
                rs = stmt.executeQuery();
            }
            if (null == rs) break block6;
            boolean sql2 = rs.next();
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return sql2;
        }
        try {
            sql2 = false;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return sql2;
    }

    public static SQLType getSQLType(short dataType) {
        switch (dataType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return SQLType.INT;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return SQLType.NUMERIC;
            }
            case 1: {
                return SQLType.CHAR;
            }
            case 12: {
                return SQLType.VARCHAR;
            }
            case -1: {
                return SQLType.CLOB;
            }
            case 91: 
            case 92: 
            case 93: {
                return SQLType.DATETIME;
            }
            case -2: {
                return SQLType.BINARY;
            }
            case -3: {
                return SQLType.VARBINARY;
            }
            case -4: {
                return SQLType.BLOB;
            }
            case 2004: {
                return SQLType.BLOB;
            }
            case 2005: {
                return SQLType.CLOB;
            }
        }
        return null;
    }

    public static String getColSQL(ColumnInfo col) {
        String sql = "";
        String sqlpost = SHRDBUtils.getDataType(col);
        String defValue = col.getDefaultValue();
        if (defValue != null) {
            sqlpost = sqlpost + " DEFAULT " + defValue;
        }
        sqlpost = sqlpost + (col.isNullable() ? " NULL" : " NOT NULL");
        if (col.isMultilingual()) {
            for (int i = 1; i <= 3; ++i) {
                sql = sql + col.getName() + "_l" + i + " " + sqlpost;
                if (i >= 3) continue;
                sql = sql + ",";
            }
        } else {
            sql = col.getName() + " " + sqlpost;
        }
        return sql;
    }

    public static String getColSQLWithoutMultiLanguage(ColumnInfo col) {
        String sql = col.getName() + " " + SHRDBUtils.getDataType(col);
        String defValue = col.getDefaultValue();
        if (defValue != null) {
            sql = sql + " DEFAULT " + defValue;
        }
        sql = sql + (col.isNullable() ? " NULL" : " NOT NULL");
        return sql;
    }

    public static String getColSQLInMultiLanguage(ColumnInfo col, int language) {
        String sql = col.getName() + "_l" + language + " " + SHRDBUtils.getDataType(col);
        String defValue = col.getDefaultValue();
        if (defValue != null) {
            sql = sql + " DEFAULT " + defValue;
        }
        sql = sql + (col.isNullable() ? " NULL" : " NOT NULL");
        return sql;
    }

    public static String getDataType(ColumnInfo col) {
        SQLType name = col.getTypeName();
        if (SQLType.CHAR.equals((Object)name) || SQLType.VARCHAR.equals((Object)name) || SQLType.NCHAR.equals((Object)name) || SQLType.NVARCHAR.equals((Object)name) || SQLType.CLOB.equals((Object)name) || SQLType.BLOB.equals((Object)name) || SQLType.NCLOB.equals((Object)name) || SQLType.BINARY.equals((Object)name) || SQLType.VARBINARY.equals((Object)name)) {
            return name.getName() + "(" + col.getLength() + ")";
        }
        if (SQLType.NUMERIC.equals((Object)name)) {
            return "DECIMAL(" + col.getPrecision() + "," + col.getScale() + ")";
        }
        if (SQLType.INT.equals((Object)name) || SQLType.DATETIME.equals((Object)name)) {
            return name.getName();
        }
        logger.error((Object)("invalid col DataType " + col.getTypeName().getName()), (Throwable)new Exception("invalid col DataType"));
        return name.getName();
    }

    public static ColumnInfo getColumnByName(AbstractTableInfo table, String name) {
        int s = table.getColumns().size();
        for (int i = 0; i < s; ++i) {
            ColumnInfo col = table.getColumns().get(i);
            if (!col.getName().equalsIgnoreCase(name)) continue;
            return col;
        }
        return null;
    }

    public static IndexInfo getIndexByName(AbstractTableInfo table, String name) {
        int s = table.getIndexes().size();
        for (int i = 0; i < s; ++i) {
            IndexInfo info = table.getIndexes().get(i);
            if (!info.getName().equalsIgnoreCase(name)) continue;
            return info;
        }
        return null;
    }

    public static void fillIndex(ResultSet rs, AbstractTableInfo table) throws SQLException {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            if (indexName == null || table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
            IndexInfo index = null;
            for (int i = 0; i < table.getIndexes().size(); ++i) {
                if (!table.getIndexes().get(i).getName().equals(indexName)) continue;
                index = table.getIndexes().get(i);
                break;
            }
            if (index == null) {
                index = new IndexInfo();
                index.setName(rs.getString("INDEX_NAME"));
                index.setUnique(!rs.getBoolean("NON_UNIQUE"));
                table.getIndexes().add(index);
            }
            IndexColumnInfo indexColumn = new IndexColumnInfo();
            indexColumn.setColumn(SHRDBUtils.getColumnByName(table, rs.getString("COLUMN_NAME")));
            indexColumn.setSortType(rs.getString("ASC_OR_DESC").equals("A") ? SortType.ASCEND : SortType.DESCEND);
            index.getIndexColumns().add(indexColumn);
        }
    }

    public static ForeignKeyCollection getRefFKList(Connection cn, String tableName) throws SQLException {
        ForeignKeyCollection fkList = new ForeignKeyCollection();
        ResultSet rs = cn.getMetaData().getExportedKeys(null, null, tableName);
        while (rs.next()) {
            String fkName = rs.getString("FK_NAME");
            ForeignKeyInfo fk = null;
            for (int i = 0; i < fkList.size(); ++i) {
                if (!fkList.get(i).getName().equals(fkName)) continue;
                fk = fkList.get(i);
                break;
            }
            if (fk == null) {
                fk = new ForeignKeyInfo();
                AbstractTableInfo refTable = new AbstractTableInfo();
                refTable.setName(rs.getString("FKTABLE_NAME"));
                fk.setRefTable(refTable);
                fk.setName(fkName);
                fkList.add(fk);
            }
            FKColumnPairInfo fkcol = new FKColumnPairInfo();
            ColumnInfo fkcolumn = new ColumnInfo();
            fkcolumn.setName(rs.getString("FKCOLUMN_NAME"));
            fkcol.setForeignKeyColumn(fkcolumn);
            ColumnInfo pkcolumn = new ColumnInfo();
            pkcolumn.setName(rs.getString("PKCOLUMN_NAME"));
            fkcol.setPrimaryKeyColumn(pkcolumn);
            fk.getFKColumnPairs().add(fkcol);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return fkList;
    }
}

