/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inte.cq.token;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.inte.cq.ex.APIException;
import com.kingdee.shr.inte.cq.util.HttpClientUtil;
import com.kingdee.util.StringUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TokenManger {
    private static String getTokenUrl = "/kapi/oauth2/getToken";
    private static String verifyTokenUrl = "/kapi/oauth2/verifyToken";
    private static String refreshTokenUrl = "/kapi/oauth2/refreshToken";
    private static TokenManger instance;
    private Map<String, JSONObject> tokens = new ConcurrentHashMap<String, JSONObject>();

    private TokenManger() {
    }

    public static TokenManger getInstance() {
        if (null == instance) {
            instance = new TokenManger();
        }
        return instance;
    }

    private String getkey(String clientId, String accountId, String agentUser) {
        StringBuilder sb = new StringBuilder();
        sb.append(accountId).append("_").append(clientId).append("_").append(agentUser);
        return sb.toString();
    }

    public JSONObject getToken(Context ctx, String url, String clientId, String accountId, String clientSecret, String agentUser, String language, String type, boolean isTest) {
        String key = this.getkey(clientId, accountId, agentUser);
        if (isTest) {
            return this.getNewToken(ctx, url, clientId, accountId, clientSecret, agentUser, language);
        }
        JSONObject token = this.tokens.get(key);
        if (null == token) {
            token = this.getNewToken(ctx, url, clientId, accountId, clientSecret, agentUser, language);
            this.tokens.put(key, token);
        } else {
            boolean isNew = false;
            if (token.get((Object)"data") instanceof Map) {
                Map data = (Map)token.get((Object)"data");
                LocalDateTime timestampOld = (LocalDateTime)token.get((Object)"timestamp");
                LocalDateTime timestampNow = LocalDateTime.now();
                Duration d = Duration.between(timestampOld, timestampNow);
                long dTime = d.toMillis();
                if ("access_token".equals(type)) {
                    long expires_in = 0L;
                    if (data.get("expires_in") instanceof Integer) {
                        expires_in = ((Integer)data.get("expires_in")).intValue();
                    } else if (data.get("expires_in") instanceof Long) {
                        expires_in = (Long)data.get("expires_in");
                    }
                    String access_token = (String)data.get("access_token");
                    if (StringUtils.isEmpty((String)access_token) || dTime >= expires_in - 1000L) {
                        isNew = true;
                    }
                } else {
                    long id_token_expires_in = 0L;
                    if (data.get("id_token_expires_in") instanceof Integer) {
                        id_token_expires_in = ((Integer)data.get("id_token_expires_in")).intValue();
                    } else if (data.get("id_token_expires_in") instanceof Long) {
                        id_token_expires_in = (Long)data.get("id_token_expires_in");
                    }
                    String id_token = (String)data.get("id_token");
                    if (StringUtils.isEmpty((String)id_token) || dTime >= id_token_expires_in - 1000L) {
                        isNew = true;
                    }
                }
            } else {
                isNew = true;
            }
            if (isNew) {
                token = this.getNewToken(ctx, url, clientId, accountId, clientSecret, agentUser, language);
                this.tokens.put(key, token);
            }
        }
        return token;
    }

    public String getAccessToken(Context ctx, String url, String clientId, String accountId, String clientSecret, String agentUser, String language, boolean isTest) {
        JSONObject token = this.getToken(ctx, url, clientId, accountId, clientSecret, agentUser, language, "access_token", isTest);
        Map data = (Map)token.get((Object)"data");
        String access_token = (String)data.get("access_token");
        return access_token;
    }

    public String getIdToken(Context ctx, String url, String clientId, String accountId, String clientSecret, String agentUser, String language, boolean isTest) {
        JSONObject token = this.getToken(ctx, url, clientId, accountId, clientSecret, agentUser, language, "id_token", isTest);
        Map data = (Map)token.get((Object)"data");
        String id_token = (String)data.get("id_token");
        return id_token;
    }

    private JSONObject getNewToken(Context ctx, String url, String clientId, String accountId, String clientSecret, String agentUser, String language) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("client_id", clientId);
        body.put("client_secret", clientSecret);
        body.put("username", agentUser);
        body.put("accountId", accountId);
        body.put("language", language);
        String uuid = UUID.randomUUID().toString();
        body.put("nonce", uuid);
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formatDateTime = now.format(formatter);
        body.put("timestamp", formatDateTime);
        String responseString = HttpClientUtil.post(url + getTokenUrl, header, body);
        JSONObject jsonObject = JSON.parseObject((String)responseString);
        if (!StringUtils.isEmpty((String)jsonObject.getString("errorcode")) && jsonObject.getString("errorcode").startsWith("login.login") || "login.loginBizException".equals(jsonObject.getString("errorcode")) || "login.loginWrongAccountException".equals(jsonObject.getString("errorcode"))) {
            throw new APIException(jsonObject.getString("errorcode"), jsonObject.getString("errorCode") + ":" + jsonObject.getString("description"), JSONUtils.convertObjectToJson(ctx, header) + "\n" + JSONUtils.convertObjectToJson(ctx, body), responseString);
        }
        if (!"0".equals(jsonObject.getString("errorCode"))) {
            throw new APIException(jsonObject.getString("errorCode"), jsonObject.getString("errorCode") + ":" + jsonObject.getString("message"), JSONUtils.convertObjectToJson(ctx, header) + "\n" + JSONUtils.convertObjectToJson(ctx, body), responseString);
        }
        jsonObject.put("timestamp", (Object)now);
        return jsonObject;
    }
}

