/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.ISHRCloudFeedBack;
import com.kingdee.shr.base.syssetting.SHRCloudFeedBackFactory;
import com.kingdee.shr.base.syssetting.SHRCloudFeedBackInfo;
import com.kingdee.shr.base.syssetting.app.AbstractSHRCloudFeedBackFacadeControllerBean;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class SHRCloudFeedBackFacadeControllerBean
extends AbstractSHRCloudFeedBackFacadeControllerBean {
    private static final long serialVersionUID = -5877629353671144397L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.SHRCloudFeedBackFacadeControllerBean");
    private final String defaultId = "lPIKxbFSTS23MuXHvFiFe77SQbc=";
    private final String CLOUD_SERVER_URL = "http://appcenter.cmcloud.cn/feedback/hr/feedbackActionHR.do";
    private final String DATEFORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";

    @Override
    protected void _synCloudFeedBackToSHR(Context ctx) throws BOSException, EASBizException {
        StringBuffer buffer = new StringBuffer();
        String messages = buffer.toString();
        this.pushCloudFeedBackToSHRMessageSystem(ctx, messages);
        String reqDate = this.getFeedReqDateStr(ctx);
        String respDate = this.fetchMaxResponseDateFromMessage(ctx, messages);
        this.updateFeedBackDate(ctx, reqDate, respDate);
    }

    private String fetchMaxResponseDateFromMessage(Context ctx, String messages) {
        HashMap msgMap = this.getMessagesMap(ctx, messages);
        return "2013-09-08 15:16:44";
    }

    private HashMap getMessagesMap(Context ctx, String messages) {
        return JSONUtils.convertJsonToObject(ctx, messages);
    }

    private void pushCloudFeedBackToSHRMessageSystem(Context ctx, String messages) throws BOSException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        HashMap msgMap = this.getMessagesMap(ctx, messages);
        Message message = null;
        Locale locale2 = null;
        String userId = null;
        ArrayList msgList = (ArrayList)msgMap.get("returnMsg");
        int size = msgList.size();
        for (int i = 0; i < size; ++i) {
            msgMap = (HashMap)msgList.get(i);
            message = MessageFactory.newMessage((String)"kingdee.workflow");
            message.setStringHeader("category", SHRSysSettingResourceUtil.getResource("cloud_feedback", ctx));
            message.setIntHeader("type", 0);
            message.setIntHeader("bizType", 0);
            message.setIntHeader("sourceStatus", 0);
            message.setIntHeader("priority", 10);
            message.setStringHeader("databaseCenter", ctx.getAIS());
            message.setStringHeader("solution", ctx.getSolution());
            for (Locale locale2 : this.getContextLocales(ctx)) {
                message.setLocaleStringHeader("title", "messageTitle", locale2);
                message.setLocaleStringHeader("sender", "sender", locale2);
                message.setLocaleStringHeader("body", this.assembleMessageBody(ctx, msgMap.get("evaluateDate").toString()), locale2);
            }
            userId = msgMap.get("userId").toString();
            message.setStringHeader("receiver", userId);
            senderAgent.sendMessage(message);
        }
    }

    private String fetchFeedBackFromCloud(Context ctx) throws BOSException, EASBizException {
        HttpClient client = new HttpClient();
        String cloudUrl = this.getFeedBackUrl(ctx);
        GetMethod method = new GetMethod(cloudUrl);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(5, true));
        byte[] responseBody = null;
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                logger.info((Object)("Method  invocked failed: " + method.getStatusLine()));
            }
            responseBody = method.getResponseBody();
        }
        catch (HttpException e) {
            logger.info((Object)("httpClient.executeMethod exception " + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        return new String(responseBody);
    }

    private String getFeedBackUrl(Context ctx) {
        StringBuffer urlBuffer = new StringBuffer();
        urlBuffer.append("http://appcenter.cmcloud.cn/feedback/hr/feedbackActionHR.do");
        return urlBuffer.toString();
    }

    private String getFeedReqDateStr(Context ctx) throws BOSException, EASBizException {
        Date formatDate;
        ISHRCloudFeedBack iSHRCloudFeedBack = SHRCloudFeedBackFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("feedBackDate"));
        SHRCloudFeedBackInfo shrCloudFeedBackInfo = iSHRCloudFeedBack.getSHRCloudFeedBackInfo((IObjectPK)new ObjectUuidPK("lPIKxbFSTS23MuXHvFiFe77SQbc="), sic);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date feedBackDate = shrCloudFeedBackInfo.getFeedBackDate();
        try {
            formatDate = simpleDateFormat.parse(feedBackDate.toLocaleString());
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        return simpleDateFormat.format(formatDate);
    }

    private void updateFeedBackDate(Context ctx, String reqDate, String respDate) throws BOSException, EASBizException {
        boolean isNeededUpdateFeedBackDate = this.isNeededUpdateFeedBackDate(reqDate, respDate);
        if (isNeededUpdateFeedBackDate) {
            this.doUpdateFeedBackDate(ctx, respDate);
        }
    }

    private void doUpdateFeedBackDate(Context ctx, String respDate) throws BOSException, EASBizException {
        ISHRCloudFeedBack iSHRCloudFeedBack = SHRCloudFeedBackFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("feedBackDate"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SHRCloudFeedBackInfo shrCloudFeedBackInfo = new SHRCloudFeedBackInfo();
        shrCloudFeedBackInfo.setId(BOSUuid.read((String)"lPIKxbFSTS23MuXHvFiFe77SQbc="));
        try {
            shrCloudFeedBackInfo.setFeedBackDate(sdf.parse(respDate));
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        iSHRCloudFeedBack.update((IObjectPK)new ObjectUuidPK("lPIKxbFSTS23MuXHvFiFe77SQbc="), shrCloudFeedBackInfo);
    }

    private boolean isNeededUpdateFeedBackDate(String reqDate, String respDate) throws BOSException {
        String compareDatePattern = "yyyy-MM-dd HH:mm";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(compareDatePattern);
        Date requestDate = null;
        Date responseDate = null;
        try {
            requestDate = simpleDateFormat.parse(reqDate);
            responseDate = simpleDateFormat.parse(respDate);
        }
        catch (ParseException e) {
            logger.info((Object)("simpleDateFormat parse date  " + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        return responseDate.after(requestDate);
    }

    public Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    private String assembleMessageBody(Context ctx, String evaluateDate) {
        return SHRSysSettingResourceUtil.getResource("comment_has_feedback", ctx, evaluateDate);
    }
}

