/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.builder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.org.AdminOrgTreeHISFacadeFactory;
import com.kingdee.eas.hr.org.AdminTreeNodeInfo;
import com.kingdee.eas.hr.org.HROrgUnitFacadeFactory;
import com.kingdee.shr.base.syssetting.app.builder.ITreeBuilder;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgUnitTreeBuilder
implements ITreeBuilder {
    private static Logger logger = Logger.getLogger(OrgUnitTreeBuilder.class);

    @Override
    public Object getRootNode(Context ctx, Map<String, String> params) throws EASBizException, BOSException {
        String nodeId = params.get("nodeId");
        String domain = params.get("domain");
        String userAdminOrgRangeSql = params.get("userAdminOrgRangeSql");
        boolean includeSealup = this.iSContainSealup(params);
        long t0 = System.currentTimeMillis();
        String adminOrgHisDate = params.get("adminOrgHisDate");
        AdminTreeNodeInfo obj = null;
        if (!StringUtils.isEmpty((String)adminOrgHisDate)) {
            this.checkAdminOrgHisDate(ctx, adminOrgHisDate);
            long startTime = System.currentTimeMillis();
            obj = AdminOrgTreeHISFacadeFactory.getLocalInstance((Context)ctx).getRootNodeAdminInfo(nodeId, this.isUserOrgRange(domain), includeSealup, false, userAdminOrgRangeSql, adminOrgHisDate);
            long endTime = System.currentTimeMillis();
            float excTime = (float)(endTime - startTime) / 1000.0f;
            System.out.println("History navigation tree interface time :getRootNode" + excTime + "s");
        } else {
            obj = HROrgUnitFacadeFactory.getLocalInstance((Context)ctx).getRootNodeAdminInfo(nodeId, this.isUserOrgRange(domain), includeSealup, false, userAdminOrgRangeSql);
        }
        long t1 = System.currentTimeMillis();
        return obj;
    }

    @Override
    public Object getChildren(Context ctx, Map<String, String> params) throws EASBizException, BOSException {
        String nodeId = params.get("nodeId");
        String domain = params.get("domain");
        String userAdminOrgRangeSql = params.get("userAdminOrgRangeSql");
        boolean includeSealup = this.iSContainSealup(params);
        AdminTreeNodeInfo nodeInfo = null;
        long t0 = System.currentTimeMillis();
        String adminOrgHisDate = params.get("adminOrgHisDate");
        if (!StringUtils.isEmpty((String)adminOrgHisDate)) {
            this.checkAdminOrgHisDate(ctx, adminOrgHisDate);
            long startTime = System.currentTimeMillis();
            nodeInfo = AdminOrgTreeHISFacadeFactory.getLocalInstance((Context)ctx).getAdminOrgTreeData(nodeId, this.isUserOrgRange(domain), includeSealup, false, userAdminOrgRangeSql, adminOrgHisDate);
            long endTime = System.currentTimeMillis();
            float excTime = (float)(endTime - startTime) / 1000.0f;
            System.out.println("History navigation tree interface time :getChildren" + excTime + "s");
        } else {
            nodeInfo = HROrgUnitFacadeFactory.getLocalInstance((Context)ctx).getAdminOrgTreeData(nodeId, this.isUserOrgRange(domain), includeSealup, false, userAdminOrgRangeSql);
        }
        long t1 = System.currentTimeMillis();
        if (null == nodeInfo) {
            return null;
        }
        return nodeInfo.getSubAdminlist();
    }

    private boolean iSContainSealup(Map<String, String> params) {
        String isSealUp = params.get("isSealUp");
        boolean includeSealup = false;
        if (!StringUtils.isEmpty((String)isSealUp) && ("1".equals(isSealUp) || "true".equals(isSealUp))) {
            includeSealup = true;
        }
        return includeSealup;
    }

    private boolean isUserOrgRange(String domain) {
        return domain != null && domain.indexOf("'$UserAdminRangeFilter'") > -1;
    }

    private void checkAdminOrgHisDate(Context ctx, String adminOrgHisDate) throws HRCommonException {
        try {
            DateTimeUtils.parseDate((String)adminOrgHisDate.toString(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, new Object[]{SHRSysSettingResourceUtil.getResource("date_format_error", ctx)});
        }
    }

    @Override
    public Object getAllNodes(Context ctx, Map<String, String> params) throws EASBizException, BOSException {
        String nodeId = params.get("nodeId");
        String domain = params.get("domain");
        String userAdminOrgRangeSql = params.get("userAdminOrgRangeSql");
        boolean includeSealup = this.iSContainSealup(params);
        long t0 = System.currentTimeMillis();
        String adminOrgHisDate = params.get("adminOrgHisDate");
        List obj = null;
        if (!StringUtils.isEmpty((String)adminOrgHisDate)) {
            this.checkAdminOrgHisDate(ctx, adminOrgHisDate);
            long startTime = System.currentTimeMillis();
            obj = AdminOrgTreeHISFacadeFactory.getLocalInstance((Context)ctx).getSyncAdminOrgTreeData(nodeId, this.isUserOrgRange(domain), includeSealup, false, userAdminOrgRangeSql, adminOrgHisDate);
            long endTime = System.currentTimeMillis();
            float excTime = (float)(endTime - startTime) / 1000.0f;
            System.out.println("History navigation tree interface time :getRootNode" + excTime + "s");
        } else {
            obj = HROrgUnitFacadeFactory.getLocalInstance((Context)ctx).getRootAllAdminInfo(nodeId, this.isUserOrgRange(domain), includeSealup, false, userAdminOrgRangeSql);
        }
        long t1 = System.currentTimeMillis();
        return obj;
    }
}

