/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.fieldrule.IFieldRuleProcessor;
import com.kingdee.shr.base.syssetting.fieldrule.formula.function.BaseFieldRuleFunctions;
import com.kingdee.shr.base.syssetting.fieldrule.formula.function.IFunctionProvider;
import com.kingdee.shr.base.syssetting.fieldrule.model.DefaultValueRule;
import com.kingdee.shr.base.syssetting.fieldrule.model.FieldRule;
import com.kingdee.shr.base.syssetting.fieldrule.model.FilterRule;
import com.kingdee.shr.base.syssetting.fieldrule.model.LinkRule;
import com.kingdee.shr.base.syssetting.fieldrule.processor.DefaultValueProcessor;
import com.kingdee.shr.base.syssetting.fieldrule.processor.FieldFilterProcessor;
import com.kingdee.shr.base.syssetting.fieldrule.processor.LinkFieldProcessor;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRuleCacheHelper {
    private static Logger log = LoggerFactory.getLogger(FieldRuleCacheHelper.class);
    private static final String CACHE_TYPE = "shr.fieldRuleCache";
    public static final String FUNCTION_FIELDRULE = "BaseFieldRuleFunctions_{0}";
    private static final String SQL = "SELECT T0.FCONTENT SCONFIG, T1.FCONTENT ECONFIG,T0.FID FROM T_SHR_FIELDRULE T0 LEFT JOIN T_SHR_FIELDRULEEXT T1 ON T0.FID = T1.FPARENTID INNER JOIN  S_BS_UIVIEW T2 ON T0.FUIVIEWID = T2.FID  and  T2.FTYPE = 'form' WHERE T2.FUIPK = ?";

    private FieldRuleCacheHelper() {
    }

    public static void remove(Context ctx, String uipk) {
        CacheService.getInstance().remove(CACHE_TYPE, FieldRuleCacheHelper.getRealUipk(uipk));
    }

    public static void removeAll(Context ctx) {
        CacheService.getInstance().removeAll(CACHE_TYPE);
    }

    public static Map<String, Object> get(Context ctx, String uipk) {
        return FieldRuleCacheHelper.initFieldRuleConfig(ctx, FieldRuleCacheHelper.getContent(ctx, uipk));
    }

    public static String getContent(Context ctx, String uipk) {
        uipk = FieldRuleCacheHelper.getRealUipk(uipk);
        String obj = (String)CacheService.getInstance().get(CACHE_TYPE, uipk);
        if (null == obj) {
            obj = FieldRuleCacheHelper.getFieldRuleFromDB(ctx, uipk);
            FieldRuleCacheHelper.add(ctx, uipk, obj);
        }
        return obj;
    }

    public static String getFieldRuleFromDB(Context ctx, String uipk) {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SQL, (Object[])new Object[]{uipk});
            String content = null;
            if (rs.next()) {
                String econfig = rs.getString("ECONFIG");
                content = rs.getString("SCONFIG");
                if (!StringUtils.isEmpty((String)econfig)) {
                    content = econfig;
                }
            }
            if (!StringUtils.isEmpty(content)) {
                return content;
            }
        }
        catch (Exception e) {
            log.error("GetFieldRuleFromDB init error ! viewInfoUipk is : [{}]", (Object)uipk);
        }
        return "";
    }

    public static IFunctionProvider getFunctions(Context ctx) {
        String key = MessageFormat.format(FUNCTION_FIELDRULE, ctx.getLocale());
        BaseFieldRuleFunctions defaultFuncProvider = (BaseFieldRuleFunctions)CacheService.getInstance().get(CACHE_TYPE, key);
        if (null == defaultFuncProvider) {
            defaultFuncProvider = new BaseFieldRuleFunctions(ctx);
            FieldRuleCacheHelper.add(ctx, key, defaultFuncProvider);
        }
        return defaultFuncProvider;
    }

    private static void add(Context ctx, String key, Object object) {
        CacheService.getInstance().put(CACHE_TYPE, key, object);
    }

    private static Map<String, Object> initFieldRuleConfig(Context ctx, String content) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)content)) {
            return params;
        }
        try {
            LinkRule linkRule;
            FilterRule filterRule;
            FieldRule fieldRule = (FieldRule)JSONUtils.convertJsonToObject(ctx, content, FieldRule.class);
            IFieldRuleProcessor processor = null;
            DefaultValueRule defaultValueRule = fieldRule.getDefaultValueRule();
            if (null != defaultValueRule && defaultValueRule.isEnable() && defaultValueRule.getConfig() instanceof List) {
                processor = new DefaultValueProcessor(ctx, defaultValueRule);
                processor.exec(params);
            }
            if (null != (filterRule = fieldRule.getFilterRule()) && filterRule.isEnable() && filterRule.getConfig() instanceof List) {
                processor = new FieldFilterProcessor(ctx, filterRule);
                processor.exec(params);
            }
            if (null != (linkRule = fieldRule.getLinkRule()) && linkRule.isEnable() && (linkRule.getLinkConfig() instanceof List || linkRule.getCalculateConfig() instanceof List)) {
                processor = new LinkFieldProcessor(ctx, linkRule);
                processor.exec(params);
            }
        }
        catch (Exception e) {
            log.error("InitFieldRuleConfig error ! fieldRuleContent is : [{}]", (Object)content);
        }
        return params;
    }

    private static String getRealUipk(String uipk) {
        if (StringUtils.isEmpty((String)uipk)) {
            return null;
        }
        if (uipk.indexOf("$") == -1) {
            return uipk;
        }
        return uipk.split("\\$")[0];
    }
}

