/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.filter;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.app.domain.CompareTypeConvert;
import com.kingdee.shr.base.syssetting.app.domain.DomainParserConstant;
import com.kingdee.shr.base.syssetting.app.filter.TimeFilterParserHelper;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AdvanceFilterService {
    public static final String CUSTOME_FILTER_MASK_REPLACE_KEY = "@";
    public static final String FILTER_LOGIC_AND = "and";
    public static final String FILTER_LOGIC_OR = "or";
    public static final String CONDITION_PREFIX = "t";
    public static final String WELL_NUMBER = "#";
    public static final String SINGLE_SPACE = " ";
    public static final String LEFTBRACKET = "(";
    public static final String LEFTBRACKET_SPACE = " ( ";
    public static final String RIGHTBRACKET = ")";
    public static final String RIGHTBRACKET_SPACE = " ) ";
    public static final String CONDITION_ITEM_PATTERN = "^t\\d*$";
    public static final String NUMBER_PATTERN = "\\d*$";
    public static final String FILTERITEM_KEY_NAME = "name";
    public static final String FILTERITEM_KEY_COMPARETYPE = "compareType";
    public static final String FILTERITEM_KEY_VALUE = "value";
    public static final String FILTERITEM_KEY_TYPE = "type";
    public static final String FILTERITEM_KEY_UIPK = "uipk";
    public static final String QUERYCTRL = "queryCtrl";
    public static final String CONDITION_KEY = "condition_key";
    public static final String ADVANCEFILTER_KEY_FILTERITEMMAPPING = "filterItemMaping";
    public static final String ADVANCEFILTER_KEY_CONDITIOIN = "condition";
    public static final String ADVANCEFILTER_LIKEVALUE_FORMAT = "%{0}%";
    public static final String ADVANCEFILTER_PRELIKEVALUE_FORMAT = "{0}%";
    public static final String ADVANCEFILTER_AFTERLIKEVALUE_FORMAT = "%{0}";
    public static final String FILTERITEM_KEY_BOOLEAN_TYPE = "Boolean";
    public static final String COMPARETYPE_LOGIC_ISNOT = "isnot";
    public static final String COMPARETYPE_LOGIC_IS = "is";
    public static final String COMPARETYPE_PRELIKE = "preLike";
    public static final String COMPARETYPE_AFTERLIKE = "afterLike";
    public static final String COMPARETYPE_NOT_PRELIKE = "not preLike";
    public static final String COMPARETYPE_NOT_AFTERLIKE = "not afterLike";
    private static Pattern pattern = Pattern.compile("^\\d*");
    private Context ctx;
    private static final Logger logger = Logger.getLogger(AdvanceFilterService.class);

    public AdvanceFilterService(Context ctx) {
        this.ctx = ctx;
    }

    public FilterInfo parse(String filterExpression) {
        HashMap filterMap = JSONUtils.convertJsonToObject(this.ctx, filterExpression);
        Map filterItemMaping = (Map)filterMap.get(ADVANCEFILTER_KEY_FILTERITEMMAPPING);
        if (null == filterItemMaping) {
            return null;
        }
        String condition = String.valueOf(filterMap.get(ADVANCEFILTER_KEY_CONDITIOIN));
        Map<String, Object> filterItemMap = this.convertFilterItemMappingToFilterItemInfoMap(filterItemMaping);
        FilterInfo filterInfo = this.convertFilterItemMappingToFilterInfo(filterItemMap, condition);
        return filterInfo;
    }

    private String addLeftAndRightBRACKET(String source) {
        return MessageFormat.format("{0} {1} {2}", LEFTBRACKET, source, RIGHTBRACKET);
    }

    private int findMaxMaskStringIndex(String existMaskString) {
        String targetStr = existMaskString.trim().replaceAll(WELL_NUMBER, "");
        String[] targetNumArr = targetStr.split(SINGLE_SPACE);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String numStr : targetNumArr) {
            if (!this.isNumber(numStr.trim())) continue;
            list.add(Integer.parseInt(numStr.trim()));
        }
        if (list.size() == 0) {
            return 0;
        }
        Integer max = (Integer)Collections.max(list);
        return max;
    }

    public FilterInfo convertFilterItemMappingToFilterInfo(Map<String, Object> filterItemMaping, String condition) {
        String[] conditionArray = this.assembleFormatConditionArray(condition);
        String convertConditionToFilterMask = this.convertConditionToFilterMask(condition).replaceAll(WELL_NUMBER, CUSTOME_FILTER_MASK_REPLACE_KEY);
        HashMap<String, String> maskMap = new HashMap<String, String>();
        FilterInfo filterInfo = new FilterInfo();
        int tnCount = 0;
        int len = conditionArray.length;
        for (int i = 0; i < len; ++i) {
            String item = conditionArray[i].trim();
            if (!this.isConditionItem(item)) continue;
            Object fillterInfoObj = filterItemMaping.get(item);
            if (fillterInfoObj instanceof FilterInfo) {
                FilterInfo filterInfo0 = (FilterInfo)fillterInfoObj;
                FilterItemCollection filterItems = filterInfo0.getFilterItems();
                for (int j = 0; j < filterItems.size(); ++j) {
                    filterInfo.getFilterItems().add(filterItems.get(j));
                }
                String maskString = filterInfo0.getMaskString();
                if (StringUtils.isEmpty((String)maskString)) {
                    String existMaskString = filterInfo.getMaskString();
                    if (StringUtils.isEmpty((String)existMaskString)) {
                        maskString = this.addLeftAndRightBRACKET("#0");
                    } else {
                        int maxMaskStringIndex = this.findMaxMaskStringIndex(existMaskString);
                        String source = WELL_NUMBER + (maxMaskStringIndex + 1);
                        maskString = this.addLeftAndRightBRACKET(source);
                    }
                }
                if (!StringUtils.isEmpty((String)maskString)) {
                    String tNum = item.substring(1);
                    int num = Integer.parseInt(tNum);
                    String filterMaskPrefix = CUSTOME_FILTER_MASK_REPLACE_KEY;
                    String tnMaskKey = tnCount + filterMaskPrefix + (num - 1);
                    maskMap.put(tnMaskKey, this.addLeftAndRightBRACKET(item.replace(item, maskString)));
                    maskString = this.addLeftAndRightBRACKET(maskString);
                    filterInfo.setMaskString(maskString);
                }
                ++tnCount;
                continue;
            }
            if (!(fillterInfoObj instanceof FilterItemInfo)) continue;
            filterInfo.getFilterItems().add((FilterItemInfo)fillterInfoObj);
        }
        filterInfo.setMaskString(this.assembleFilterMask(convertConditionToFilterMask, maskMap));
        return filterInfo;
    }

    private String assembleFilterMask(String convertConditionToFilterMask, Map<String, String> maskMap) {
        for (Map.Entry<String, String> entry : maskMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String realKey = key.substring(0, key.indexOf(CUSTOME_FILTER_MASK_REPLACE_KEY));
            String repalceKey = this.assembleRepalceRealKey(realKey);
            if (convertConditionToFilterMask.indexOf(repalceKey) <= -1) continue;
            convertConditionToFilterMask = this.replaceRealKey(convertConditionToFilterMask, repalceKey, value);
        }
        char[] arr = convertConditionToFilterMask.toCharArray();
        StringBuilder maskBuilder = new StringBuilder();
        int pos = 0;
        int preNumber = -1;
        for (int i = 0; i < arr.length; ++i) {
            char a = arr[i];
            String valueOf = String.valueOf(a);
            if (pattern.matcher(valueOf).matches()) {
                int currentNum = Integer.parseInt(valueOf);
                if (currentNum == 0 && pos == 0) {
                    maskBuilder.append(currentNum);
                    ++pos;
                } else {
                    if (preNumber != -1) continue;
                    maskBuilder.append(pos);
                    ++pos;
                }
                if (preNumber != -1) continue;
                preNumber = currentNum;
                continue;
            }
            if (preNumber != -1) {
                preNumber = -1;
            }
            maskBuilder.append(valueOf);
        }
        return maskBuilder.toString();
    }

    public String assembleRepalceRealKey(String realKey) {
        return CUSTOME_FILTER_MASK_REPLACE_KEY + realKey;
    }

    public String replaceRealKey(String convertConditionToFilterMask, String repalceKey, String value) {
        String[] arr;
        StringBuilder builder = new StringBuilder();
        for (String item : arr = convertConditionToFilterMask.split(SINGLE_SPACE)) {
            if (item.startsWith(CUSTOME_FILTER_MASK_REPLACE_KEY)) {
                String exressNumber = item.substring(1);
                String express = this.assembleRepalceRealKey(exressNumber);
                if (repalceKey.equals(express)) {
                    builder.append(value);
                    continue;
                }
                this.processNotEqualsReplaceKey(builder, item);
                continue;
            }
            this.processNotEqualsReplaceKey(builder, item);
        }
        return builder.toString();
    }

    public void processNotEqualsReplaceKey(StringBuilder builder, String item) {
        if (StringUtils.isEmpty((String)item)) {
            builder.append(SINGLE_SPACE);
        } else {
            if (LEFTBRACKET.equals(item)) {
                item = LEFTBRACKET_SPACE;
            }
            if (RIGHTBRACKET.equals(item)) {
                item = RIGHTBRACKET_SPACE;
            }
            this.addItemSpace(builder, item);
            builder.append(item);
            this.addItemSpace(builder, item);
        }
    }

    public void addItemSpace(StringBuilder builder, String item) {
        if (FILTER_LOGIC_AND.equalsIgnoreCase(item) || FILTER_LOGIC_OR.equalsIgnoreCase(item)) {
            builder.append(SINGLE_SPACE);
        }
    }

    private boolean isBigObject(String dbType) {
        if (SQLType.CLOB.getName().equalsIgnoreCase(dbType)) {
            return true;
        }
        if (SQLType.NCLOB.getName().equalsIgnoreCase(dbType)) {
            return true;
        }
        if (SQLType.BLOB.getName().equalsIgnoreCase(dbType)) {
            return true;
        }
        if (SQLType.BINARY.getName().equalsIgnoreCase(dbType)) {
            return true;
        }
        return SQLType.VARBINARY.getName().equalsIgnoreCase(dbType);
    }

    public Map<String, Object> convertFilterItemMappingToFilterItemInfoMap(Map filterItemMaping) {
        Set entries = filterItemMaping.entrySet();
        HashMap<String, Object> filterInfoMapping = new HashMap<String, Object>();
        String dbType0 = ContextUtil.getDbType((Context)this.ctx);
        boolean isContainNotEqualsNull = DbType.getName((int)2).equalsIgnoreCase(dbType0) || DbType.getName((int)8).equalsIgnoreCase(dbType0) || DbType.getName((int)7).equalsIgnoreCase(dbType0) || DbType.getName((int)5).equalsIgnoreCase(dbType0) || DbType.getName((int)12).equalsIgnoreCase(dbType0) || DbType.getName((int)11).equalsIgnoreCase(dbType0);
        for (Map.Entry entry : entries) {
            FilterInfo filterInfo;
            String compareTypeStr;
            String key = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            String compareField = String.valueOf(value.get(FILTERITEM_KEY_NAME));
            Object compareValue = value.get(FILTERITEM_KEY_VALUE);
            String dataType = String.valueOf(value.get(FILTERITEM_KEY_TYPE));
            String compareType = String.valueOf(value.get(FILTERITEM_KEY_COMPARETYPE));
            String uipk = String.valueOf(value.get(FILTERITEM_KEY_UIPK));
            Object conditionKey = value.get(CONDITION_KEY);
            String queryCtrl = "";
            compareValue = this.getRealValue(dataType, compareValue);
            compareType = this.convertCompareTypeForCheckEmptyValue(compareValue, compareType);
            String dbType = null;
            Map datetimeOptionsMap = null;
            if (conditionKey instanceof Map) {
                Object datetimeOptionsObj;
                Map itemConfig = (Map)conditionKey;
                dbType = (String)itemConfig.get("dbType");
                queryCtrl = String.valueOf(itemConfig.get(QUERYCTRL));
                Object extendOptionsObj = itemConfig.get("extendOptions");
                Map extendOptionsMap = null;
                if (extendOptionsObj instanceof Map && (datetimeOptionsObj = (extendOptionsMap = (Map)extendOptionsObj).get("datetimeOptions")) instanceof Map) {
                    datetimeOptionsMap = (Map)datetimeOptionsObj;
                }
            }
            if (COMPARETYPE_LOGIC_ISNOT.equalsIgnoreCase(compareTypeStr = compareType.trim())) {
                compareTypeStr = "is not";
            }
            CompareType compareType0 = CompareTypeConvert.getInstance().getCompareType(compareTypeStr);
            if (this.isNotEmptyTimeFilter(dataType, compareType)) {
                filterInfo = TimeFilterParserHelper.buildTimestampFilterItemInfo(compareField, compareValue, compareType, compareType0, queryCtrl, dataType, datetimeOptionsMap);
                filterInfoMapping.put(key, filterInfo);
                continue;
            }
            if (CompareType.IS.equals((Object)compareType0) && "string".equalsIgnoreCase(dataType)) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo(compareField, null, CompareType.EQUALS));
                if (!isContainNotEqualsNull && !this.isBigObject(dbType)) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)"", CompareType.EQUALS));
                    filterInfo.setMaskString("(#0 or #1)");
                }
                filterInfoMapping.put(key, filterInfo);
                continue;
            }
            if (CompareType.ISNOT.equals((Object)compareType0) && "string".equalsIgnoreCase(dataType)) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo(compareField, null, CompareType.NOTEQUALS));
                if (!isContainNotEqualsNull && !this.isBigObject(dbType)) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)"", CompareType.NOTEQUALS));
                    filterInfo.setMaskString("(#0 and #1)");
                }
                filterInfoMapping.put(key, filterInfo);
                continue;
            }
            filterInfo = this.convertFilterItemInfoByCompareType(dataType, compareField, compareType, compareValue, uipk);
            filterInfoMapping.put(key, filterInfo);
        }
        return filterInfoMapping;
    }

    private String convertCompareTypeForCheckEmptyValue(Object compareValue, String compareType) {
        boolean isEmptyValue = null == compareValue || "null".equals(compareValue.toString()) || StringUtils.isEmpty((String)compareValue.toString());
        boolean compareValueMustBeEmptyValueCheck = false;
        if (CompareType.getEnum((String)compareType) != null) {
            compareValueMustBeEmptyValueCheck = true;
        }
        if (COMPARETYPE_LOGIC_IS.equalsIgnoreCase(compareType) || COMPARETYPE_LOGIC_ISNOT.equalsIgnoreCase(compareType)) {
            compareValueMustBeEmptyValueCheck = false;
        }
        if (isEmptyValue && compareValueMustBeEmptyValueCheck) {
            compareType = COMPARETYPE_LOGIC_IS;
        }
        return compareType;
    }

    private boolean isNotEmptyTimeFilter(String dataType, String compareType) {
        return this.isTimestampType(dataType) && !CompareType.IS.getName().endsWith(compareType) && !COMPARETYPE_LOGIC_ISNOT.endsWith(compareType);
    }

    private FilterInfo convertFilterItemInfoByCompareType(String dataType, String compareField, String compareType, Object compareValue, String uipk) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        CompareType compareType0 = CompareTypeConvert.getInstance().getCompareType(compareType.trim());
        String compareValueStr = "";
        if (null != compareValue && compareValue instanceof String && !FILTERITEM_KEY_BOOLEAN_TYPE.equalsIgnoreCase(dataType)) {
            List compareValueList = this.convertCompareValueWhenListType(compareValue);
            int size = compareValueList.size();
            if (size > 0) {
                compareValue = size == 1 ? compareValueList.get(0) : compareValueList;
            } else {
                compareValueStr = compareValue.toString();
            }
        } else if (compareValue instanceof List) {
            if ("link".equalsIgnoreCase(dataType)) {
                compareValue = this.assemleF7value(compareValue);
            }
        } else if (compareValue instanceof Map) {
            compareValue = this.convertCompareValueWhenMapType(dataType, compareField, compareValue);
        } else if ("Date".equalsIgnoreCase(dataType)) {
            compareValue = this.convetCompareValue2Date(dataType, compareValue);
        } else if (FILTERITEM_KEY_BOOLEAN_TYPE.equalsIgnoreCase(dataType)) {
            compareValue = this.convetCompareValue2Boolean(dataType, compareValue);
        }
        if (null == compareValue || StringUtils.isEmpty((String)compareValue.toString())) {
            if (COMPARETYPE_LOGIC_ISNOT.equalsIgnoreCase(compareType)) {
                compareType0 = CompareTypeConvert.getInstance().getCompareType("is not");
            } else if (COMPARETYPE_LOGIC_IS.equalsIgnoreCase(compareType)) {
                compareType0 = CompareTypeConvert.getInstance().getCompareType(COMPARETYPE_LOGIC_IS);
            }
        }
        if (CompareType.INCLUDE.equals((Object)compareType0)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = this.assembleLinkFilterItemInfo(compareField, compareValue, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, this.assembleIncludeValue(compareValueStr), CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.NOTINCLUDE.equals((Object)compareType0)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = this.assembleLinkFilterItemInfo(compareField, compareValue, CompareType.NOTINCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, this.assembleIncludeValue(compareValueStr), CompareType.NOTINCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.IS.equals((Object)compareType0)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = new FilterItemInfo(compareField + ".id", null);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, null, CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.ISNOT.equals((Object)compareType0)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = new FilterItemInfo(compareField + ".id", null, CompareType.NOTEQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, null, CompareType.NOTEQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.NOTLIKE.equals((Object)compareType0)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = this.assembleLinkFilterItemInfo(compareField, compareValue, CompareType.NOTINCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else if (this.isStringTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForStringTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.NOTLIKE);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, (Object)MessageFormat.format(ADVANCEFILTER_LIKEVALUE_FORMAT, compareValue), CompareType.NOTLIKE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (COMPARETYPE_NOT_PRELIKE.equals(compareType)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = this.assembleLinkFilterItemInfo(compareField, compareValue, CompareType.NOTINCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else if (this.isStringTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForStringTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.NOTLIKE);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, (Object)MessageFormat.format(ADVANCEFILTER_LIKEVALUE_FORMAT, compareValue), CompareType.NOTLIKE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (COMPARETYPE_NOT_AFTERLIKE.equals(compareType)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = this.assembleLinkFilterItemInfo(compareField, compareValue, CompareType.NOTINCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else if (this.isStringTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForStringTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.NOTLIKE);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, (Object)MessageFormat.format(ADVANCEFILTER_LIKEVALUE_FORMAT, compareValue), CompareType.NOTLIKE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.LIKE.equals((Object)compareType0)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = this.assembleLinkFilterItemInfo(compareField, compareValue, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else if (this.isStringTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForStringTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.LIKE);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, (Object)MessageFormat.format(ADVANCEFILTER_LIKEVALUE_FORMAT, compareValue), CompareType.LIKE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (COMPARETYPE_PRELIKE.equals(compareType)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = this.assembleLinkFilterItemInfo(compareField, compareValue, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else if (this.isStringTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForStringTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.LIKE);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, (Object)MessageFormat.format(ADVANCEFILTER_PRELIKEVALUE_FORMAT, compareValue), CompareType.LIKE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (COMPARETYPE_AFTERLIKE.equals(compareType)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = this.assembleLinkFilterItemInfo(compareField, compareValue, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else if (this.isStringTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForStringTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.LIKE);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, (Object)MessageFormat.format(ADVANCEFILTER_AFTERLIKEVALUE_FORMAT, compareValue), CompareType.LIKE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.EQUALS.equals((Object)compareType0)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = this.assembleLinkFilterItemInfo(compareField, compareValue, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else if (this.isNumberTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForNumberTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.EQUALS);
            } else if (this.isStringTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForStringTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.EQUALS);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, compareValue, CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.NOTEQUALS.equals((Object)compareType0)) {
            if (this.isLinkType(dataType)) {
                filterItemInfo = this.assembleLinkFilterItemInfo(compareField, compareValue, CompareType.NOTINCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            } else if (this.isNumberTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForNumberTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.NOTEQUALS);
            } else if (this.isStringTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForStringTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.NOTEQUALS);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, compareValue, CompareType.NOTEQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.GREATER.equals((Object)compareType0)) {
            if (this.isNumberTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForNumberTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.GREATER);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, compareValue, CompareType.GREATER);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.GREATER_EQUALS.equals((Object)compareType0)) {
            if (this.isNumberTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForNumberTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.GREATER_EQUALS);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, compareValue, CompareType.GREATER_EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.LESS.equals((Object)compareType0)) {
            if (this.isNumberTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForNumberTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.LESS);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, compareValue, CompareType.LESS);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        } else if (CompareType.LESS_EQUALS.equals((Object)compareType0)) {
            if (this.isNumberTypeMultipleNameValue(dataType, compareValue)) {
                filterInfo = this.assembleMultipleNameValueForNumberTypeFilterInfo(dataType, compareField, compareType, compareValue, CompareType.LESS_EQUALS);
            } else {
                filterItemInfo = new FilterItemInfo(compareField, compareValue, CompareType.LESS_EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
        }
        return filterInfo;
    }

    private Object getRealValue(String dataType, Object compareValue) {
        if (null == compareValue) {
            return compareValue;
        }
        if (compareValue instanceof String && StringUtils.isEmpty((String)((String)compareValue))) {
            return compareValue;
        }
        if ("short".equalsIgnoreCase(dataType) || "integer".equalsIgnoreCase(dataType) || "int".equalsIgnoreCase(dataType)) {
            if (compareValue instanceof Double) {
                return ((Double)compareValue).intValue();
            }
            if (compareValue instanceof Integer) {
                return compareValue;
            }
            if (compareValue instanceof Float) {
                return ((Float)compareValue).intValue();
            }
            if (compareValue instanceof Long) {
                return ((Long)compareValue).intValue();
            }
            if (compareValue instanceof BigDecimal) {
                return ((BigDecimal)compareValue).intValue();
            }
            return Integer.parseInt(compareValue.toString());
        }
        if ("long".equalsIgnoreCase(dataType)) {
            if (compareValue instanceof Double) {
                return ((Double)compareValue).longValue();
            }
            if (compareValue instanceof Integer) {
                return ((Integer)compareValue).longValue();
            }
            if (compareValue instanceof Float) {
                return ((Float)compareValue).longValue();
            }
            if (compareValue instanceof Long) {
                return compareValue;
            }
            if (compareValue instanceof BigDecimal) {
                return ((BigDecimal)compareValue).longValue();
            }
            return Long.parseLong(compareValue.toString());
        }
        if ("double".equalsIgnoreCase(dataType)) {
            if (compareValue instanceof Double) {
                return compareValue;
            }
            if (compareValue instanceof Integer) {
                return ((Integer)compareValue).doubleValue();
            }
            if (compareValue instanceof Float) {
                return ((Float)compareValue).doubleValue();
            }
            if (compareValue instanceof Long) {
                return ((Long)compareValue).doubleValue();
            }
            if (compareValue instanceof BigDecimal) {
                return ((BigDecimal)compareValue).doubleValue();
            }
            return Double.parseDouble(compareValue.toString());
        }
        if ("float".equalsIgnoreCase(dataType)) {
            if (compareValue instanceof Double) {
                return Float.valueOf(((Double)compareValue).floatValue());
            }
            if (compareValue instanceof Integer) {
                return Float.valueOf(((Integer)compareValue).floatValue());
            }
            if (compareValue instanceof Float) {
                return compareValue;
            }
            if (compareValue instanceof Long) {
                return Float.valueOf(((Long)compareValue).floatValue());
            }
            if (compareValue instanceof BigDecimal) {
                return Float.valueOf(((BigDecimal)compareValue).floatValue());
            }
            return Float.valueOf(Float.parseFloat(compareValue.toString()));
        }
        if ("bigdecimal".equalsIgnoreCase(dataType)) {
            String tempValue = compareValue.toString();
            if (compareValue instanceof Double) {
                return new BigDecimal(tempValue);
            }
            if (compareValue instanceof Integer) {
                return new BigDecimal(tempValue);
            }
            if (compareValue instanceof Float) {
                return new BigDecimal(tempValue);
            }
            if (compareValue instanceof Long) {
                return new BigDecimal(tempValue);
            }
            if (compareValue instanceof BigDecimal) {
                return compareValue;
            }
            return new BigDecimal(tempValue);
        }
        return compareValue;
    }

    public Object convertCompareValueWhenMapType(String dataType, String compareField, Object compareValue) {
        if (compareValue instanceof Map) {
            Map valueMap = (Map)((Object)compareValue);
            if ("String".equalsIgnoreCase(dataType)) {
                Object v = valueMap.get(compareField);
                if (null == v) {
                    v = valueMap.get(LocaleUtils.getShortCode((Locale)this.ctx.getLocale()));
                }
                compareValue = null == v ? valueMap.get(FILTERITEM_KEY_NAME) : v;
            } else if ("link".equalsIgnoreCase(dataType)) {
                compareValue = this.assemleF7value(compareValue);
            }
        }
        return compareValue;
    }

    public Object convetCompareValue2Boolean(String dataType, Object compareValue) {
        if (FILTERITEM_KEY_BOOLEAN_TYPE.equalsIgnoreCase(dataType)) {
            compareValue = compareValue.toString();
        }
        return compareValue;
    }

    public Object convetCompareValue2Date(String dataType, Object compareValue) {
        if ("Date".equalsIgnoreCase(dataType)) {
            try {
                compareValue = DateTimeUtils.parseDate((String)compareValue.toString(), (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return compareValue;
    }

    public List convertCompareValueWhenListType(Object compareValue) {
        Set<String> valueSet;
        ArrayList<String> list = new ArrayList<String>();
        if (null != compareValue && compareValue instanceof String && (valueSet = this.assembleIncludeValue(compareValue.toString())).size() > 0) {
            for (String value : valueSet) {
                list.add(value);
            }
        }
        return list;
    }

    private boolean isLinkType(String dataType) {
        return "link".equalsIgnoreCase(dataType);
    }

    private boolean isTimestampType(String dataType) {
        return "Timestamp".equalsIgnoreCase(dataType) || "Date".equalsIgnoreCase(dataType);
    }

    private FilterItemInfo assembleLinkFilterItemInfo(String compareField, Object compareValue, CompareType compareType) {
        return new FilterItemInfo(compareField + ".id", compareValue, compareType);
    }

    private Set<String> assemleF7value(Object compareValue) {
        HashSet<String> idValueSet = new HashSet<String>();
        if (compareValue instanceof List) {
            List f7Value = (List)compareValue;
            for (Object next : f7Value) {
                Map item;
                String idValue;
                if (!(next instanceof Map) || StringUtils.isEmpty((String)(idValue = String.valueOf((item = (Map)next).get("id"))))) continue;
                idValueSet.add(idValue);
            }
        } else if (compareValue instanceof Map) {
            Map v = (Map)compareValue;
            idValueSet.add(v.get("id").toString());
        }
        return idValueSet;
    }

    private Set<String> assembleMultipleNameValueSet(String dataType, Object compareValue) {
        HashSet<String> nameValueSet = new HashSet<String>();
        if ("String".equalsIgnoreCase(dataType) && compareValue instanceof List) {
            List values = (List)compareValue;
            for (Object value : values) {
                if (value instanceof String) {
                    nameValueSet.add(String.valueOf(value));
                    continue;
                }
                if (!(value instanceof Map)) continue;
                Map valueMap = (Map)value;
                nameValueSet.add(String.valueOf(valueMap.get(FILTERITEM_KEY_NAME)));
            }
        }
        return nameValueSet;
    }

    private boolean isStringTypeMultipleNameValue(String dataType, Object compareValue) {
        return "String".equalsIgnoreCase(dataType) && compareValue instanceof List;
    }

    private boolean isNumberTypeMultipleNameValue(String dataType, Object compareValue) {
        String[] numberTypes = new String[]{"short", "double", "bigdecimal", "integer", "long", "float", "int"};
        boolean isNubmerType = false;
        for (String type : numberTypes) {
            if (!type.equalsIgnoreCase(dataType)) continue;
            isNubmerType = true;
            break;
        }
        return isNubmerType && compareValue instanceof List;
    }

    private FilterInfo assembleMultipleNameValueForNumberTypeFilterInfo(String dataType, String compareField, String compareType, Object compareValue, CompareType realCompareType) {
        FilterInfo filterInfo = new FilterInfo();
        HashSet nameValueSet = null;
        if (!(compareValue instanceof List)) {
            return null;
        }
        nameValueSet = new HashSet((List)compareValue);
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int valueSize = nameValueSet.size();
        for (String value : nameValueSet) {
            boolean equals = CompareType.EQUALS.getName().equalsIgnoreCase(realCompareType.getName());
            boolean notEquals = CompareType.NOTEQUALS.getName().equalsIgnoreCase(realCompareType.getName());
            boolean greater = CompareType.GREATER.getName().equalsIgnoreCase(realCompareType.getName());
            boolean greaterEquals = CompareType.GREATER_EQUALS.getName().equalsIgnoreCase(realCompareType.getName());
            boolean less = CompareType.LESS.getName().equalsIgnoreCase(realCompareType.getName());
            boolean lessEquals = CompareType.LESS_EQUALS.getName().equalsIgnoreCase(realCompareType.getName());
            if (equals || greater || greaterEquals || less || lessEquals) {
                builder.append(WELL_NUMBER).append(index).append(SINGLE_SPACE);
                filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)value, realCompareType));
                if (valueSize - 1 == index) continue;
                builder.append(SINGLE_SPACE).append(" or ").append(SINGLE_SPACE);
            } else if (notEquals) {
                builder.append(WELL_NUMBER).append(index).append(SINGLE_SPACE);
                filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)value, realCompareType));
                if (valueSize - 1 == index) continue;
                builder.append(SINGLE_SPACE).append(" AND ").append(SINGLE_SPACE);
            }
            ++index;
        }
        filterInfo.setMaskString(LEFTBRACKET + builder.toString() + RIGHTBRACKET);
        return filterInfo;
    }

    private FilterInfo assembleMultipleNameValueForStringTypeFilterInfo(String dataType, String compareField, String compareType, Object compareValue, CompareType realCompareType) {
        FilterInfo filterInfo = new FilterInfo();
        Set<String> nameValueSet = this.assembleMultipleNameValueSet(dataType, compareValue);
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int valueSize = nameValueSet.size();
        for (String value : nameValueSet) {
            boolean likeType = CompareType.LIKE.getName().equalsIgnoreCase(realCompareType.getName());
            boolean notlikeType = CompareType.NOTLIKE.getName().equalsIgnoreCase(realCompareType.getName());
            boolean equals = CompareType.EQUALS.getName().equalsIgnoreCase(realCompareType.getName());
            boolean notEquals = CompareType.NOTEQUALS.getName().equalsIgnoreCase(realCompareType.getName());
            if (likeType) {
                builder.append(WELL_NUMBER).append(index).append(SINGLE_SPACE);
                filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)MessageFormat.format(ADVANCEFILTER_LIKEVALUE_FORMAT, value), realCompareType));
                if (valueSize - 1 == index) continue;
                builder.append(SINGLE_SPACE).append(" or ").append(SINGLE_SPACE);
            } else if (notlikeType) {
                builder.append(WELL_NUMBER).append(index).append(SINGLE_SPACE);
                filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)MessageFormat.format(ADVANCEFILTER_LIKEVALUE_FORMAT, value), realCompareType));
                if (valueSize - 1 == index) continue;
                builder.append(SINGLE_SPACE).append(" AND ").append(SINGLE_SPACE);
            } else if (equals) {
                builder.append(WELL_NUMBER).append(index).append(SINGLE_SPACE);
                filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)value, realCompareType));
                if (valueSize - 1 == index) continue;
                builder.append(SINGLE_SPACE).append(" or ").append(SINGLE_SPACE);
            } else if (notEquals) {
                builder.append(WELL_NUMBER).append(index).append(SINGLE_SPACE);
                filterInfo.getFilterItems().add(new FilterItemInfo(compareField, (Object)value, realCompareType));
                if (valueSize - 1 == index) continue;
                builder.append(SINGLE_SPACE).append(" AND ").append(SINGLE_SPACE);
            }
            ++index;
        }
        filterInfo.setMaskString(builder.toString());
        return filterInfo;
    }

    private Set<String> assembleIncludeValue(String compareValue) {
        HashSet<String> valueSet = new HashSet<String>();
        if (StringUtils.isEmpty((String)compareValue)) {
            return valueSet;
        }
        compareValue = compareValue.replaceAll("\uff0c", DomainParserConstant.elementsSeperator);
        String[] splitValue = compareValue.split(DomainParserConstant.elementsSeperator);
        for (int i = 0; i < splitValue.length; ++i) {
            valueSet.add(splitValue[i]);
        }
        return valueSet;
    }

    public String convertConditionToFilterMask(String condition) {
        String[] conditionArray = this.assembleFormatConditionArray(condition);
        String filterMask = this.assembleFilterMaskString(conditionArray);
        return filterMask;
    }

    public String[] assembleFormatConditionArray(String condition) {
        String formattedCondition = condition.replace(LEFTBRACKET, LEFTBRACKET_SPACE).replace(RIGHTBRACKET, RIGHTBRACKET_SPACE);
        String[] conditionArray = formattedCondition.split(SINGLE_SPACE);
        return conditionArray;
    }

    public String assembleFilterMaskString(String[] conditionArray) {
        StringBuffer conditionBuffer = new StringBuffer();
        int filterMaskIndex = 0;
        int len = conditionArray.length;
        for (int i = 0; i < len; ++i) {
            String item = conditionArray[i].trim();
            if (!this.isConditionItem(item)) {
                this.addSpaceToConditionItem(conditionBuffer, item);
                conditionBuffer.append(item);
                this.addSpaceToConditionItem(conditionBuffer, item);
                continue;
            }
            conditionBuffer.append(WELL_NUMBER);
            conditionBuffer.append(filterMaskIndex);
            conditionBuffer.append(SINGLE_SPACE);
            ++filterMaskIndex;
        }
        return conditionBuffer.toString();
    }

    public void addSpaceToConditionItem(StringBuffer conditionBuffer, String item) {
        if (!SINGLE_SPACE.trim().equals(item.trim())) {
            conditionBuffer.append(SINGLE_SPACE);
        }
    }

    public List<String> convertConditionItemToList(String[] conditionArray) {
        ArrayList<String> conditionItemList = new ArrayList<String>();
        for (String item : conditionArray) {
            String itemTrim = item.trim();
            if (!this.isConditionItem(itemTrim)) continue;
            conditionItemList.add(itemTrim);
        }
        return conditionItemList;
    }

    public boolean isConditionItem(String item) {
        if (StringUtils.isEmpty((String)item)) {
            return false;
        }
        Pattern pattern = Pattern.compile(CONDITION_ITEM_PATTERN);
        return pattern.matcher(item).matches();
    }

    public boolean isNumber(String item) {
        if (StringUtils.isEmpty((String)item)) {
            return false;
        }
        Pattern pattern = Pattern.compile(NUMBER_PATTERN);
        return pattern.matcher(item).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        String filePath = "W:" + File.separator + "advancedFilter.json";
        String str = "";
        StringBuilder sb = new StringBuilder();
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            File f = new File(filePath);
            fr = new FileReader(f);
            br = new BufferedReader(fr);
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            HashMap filterMap = JSONUtils.convertJsonToObject(this.ctx, sb.toString());
            Map filterItemMaping = (Map)filterMap.get(ADVANCEFILTER_KEY_FILTERITEMMAPPING);
            String condition = String.valueOf(filterMap.get(ADVANCEFILTER_KEY_CONDITIOIN));
            Map<String, Object> filterItemMap = this.convertFilterItemMappingToFilterItemInfoMap(filterItemMaping);
            FilterInfo filterInfo = this.convertFilterItemMappingToFilterInfo(filterItemMap, condition);
            String maskString = this.convertConditionToFilterMask(condition);
            filterInfo.setMaskString(maskString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error((Object)"cleanup error", (Throwable)e);
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    logger.error((Object)"cleanup error", (Throwable)e);
                }
            }
        }
    }
}

