/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class HRFilterUtils {
    private static Logger logger = Logger.getLogger(HRFilterUtils.class);

    public static String getCurrentUserId(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
    }

    public static String getCurrentPersonId(Context ctx) {
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            return ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        return "";
    }

    public static String getCurrentHROID(Context ctx) {
        try {
            HRFilterUtils.initOrgUnit(ctx);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
    }

    public static String getCurrentCUID(Context ctx) {
        if (ContextUtil.getCurrentCtrlUnit((Context)ctx) == null) {
            return "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
    }

    public static CtrlUnitInfo getCurrentCU(Context ctx) {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }

    public static String getUserAdminRangeSql(Context ctx, String userID, String permItemId) {
        return SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userID, (String)permItemId);
    }

    public static String getHROAndUserRangeSql(Context ctx, String userID, String hroID, String permItemId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID ='");
        sql.append(hroID);
        sql.append("' AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN (").append(SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userID, (String)permItemId));
        sql.append(")");
        return sql.toString();
    }

    @Deprecated
    public static String getUserHRORangeSql(Context ctx, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT range.FOrgID FROM T_PM_OrgRange  range  inner join t_org_hro hro on range.forgid = hro.fid  WHERE range.FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND range.FType = ");
        sql.append(10);
        return sql.toString();
    }

    @Deprecated
    public static String getUserAllHrAndAdminRangeSql(Context ctx, String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID IN(");
        sql.append(HRFilterUtils.getUserHRORangeSql(ctx, userID));
        sql.append(") AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN (");
        sql.append("SELECT t0.FOrgID FOrgID FROM T_PM_OrgRange t0 INNER JOIN T_ORG_ADMIN t1 on t0.FORGID = t1.FID WHERE t0.FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND t0.FType = ");
        sql.append(20);
        sql.append(" and t1.FISSTARTSHR = 1 ");
        sql.append(")");
        return sql.toString();
    }

    public static String getUserAllHrAndAdminRangeSql(Context ctx, String userID, String permItemId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID IN(");
        sql.append(SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userID, (String)permItemId));
        sql.append(") AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN (").append(HRFilterUtils.getUserAdminRangeSql(ctx, userID, permItemId));
        sql.append(")");
        return sql.toString();
    }

    public static String getCurDateString() {
        return "{ts'" + DateTimeUtils.format((Date)DateTimeUtils.truncateDate((Date)new Date())) + "'}";
    }

    public static Object convertValue(String keyValue) {
        if ("true".equals(keyValue) || "1".equals(keyValue)) {
            return true;
        }
        return false;
    }

    public static void initOrgUnit(Context ctx) throws BOSException, EASBizException {
        CtrlUnitInfo cuSource = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (null != cuSource && cuSource.isIsHROrgUnit()) {
            if (null == ContextUtil.getCurrentHRUnit((Context)ctx)) {
                HROrgUnitInfo hro = new HROrgUnitInfo();
                hro.setId(cuSource.getId());
                hro.setNumber(cuSource.getNumber());
                hro.setName(cuSource.getName());
                ContextUtil.setCurrentHRUnit((Context)ctx, (HROrgUnitInfo)hro);
            }
            return;
        }
        UserInfo u = ContextUtil.getCurrentUserInfo((Context)ctx);
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo cu = null;
        cu = null == ContextUtil.getCurrentCtrlUnit((Context)ctx) ? iCtrlUnit.getCtrlUnitInfo("select * where parent is null") : (null == u.getCU() ? iCtrlUnit.getCtrlUnitInfo("select * where parent is null") : iCtrlUnit.getCtrlUnitInfo("select * where id = '" + u.getCU().getId().toString() + "'"));
        if (null == cu) {
            return;
        }
        CtrlUnitInfo cu0 = null;
        cu0 = cu.isIsHROrgUnit() ? cu : HRFilterUtils.getContainHrOrgCu(cu, iCtrlUnit);
        HROrgUnitInfo hr = new HROrgUnitInfo();
        if (cu0 == null) {
            hr.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        } else {
            hr.setId(cu0.getId());
        }
        ContextUtil.setCurrentHRUnit((Context)ctx, (HROrgUnitInfo)hr);
    }

    private static CtrlUnitInfo getContainHrOrgCu(CtrlUnitInfo cu, ICtrlUnit iCtrlUnit) throws EASBizException, BOSException {
        if (null != cu.getParent()) {
            CtrlUnitInfo _cu = iCtrlUnit.getCtrlUnitInfo("select * where id = '" + cu.getParent().getId().toString() + "'");
            if (null == _cu) {
                return null;
            }
            if (_cu.isIsHROrgUnit()) {
                return _cu;
            }
            return HRFilterUtils.getContainHrOrgCu(_cu, iCtrlUnit);
        }
        return null;
    }
}

