/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.app.osf.IOSFCacheSyn;
import com.kingdee.shr.base.syssetting.app.osf.OSFCacheSyn;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OSFCacheSynFactory
implements IOSFCacheSyn {
    private static Logger logger = Logger.getLogger((String)OSFCacheSyn.class.getName());
    private List servers = new ArrayList();

    private OSFCacheSynFactory() {
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    public static IOSFCacheSyn getInstance() {
        OSFCacheSynFactory syn = new OSFCacheSynFactory();
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"------RPCServerView is null :");
            }
            OSFCacheSyn pcs = new OSFCacheSyn();
            syn.servers.add(pcs);
            return syn;
        }
        IRPCServer[] ss = sv.getServers();
        for (int i = 0; i < ss.length; ++i) {
            IOSFCacheSyn pcs;
            IRPCServer s = ss[i];
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("find server :" + s.getUrl()));
            }
            if (s.connectionFailed()) continue;
            String url = s.getUrl();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("detected server :" + url));
            }
            if (StringUtils.isEmpty((String)url)) continue;
            if (OSFCacheSynFactory.isLocal(url)) {
                pcs = new OSFCacheSyn();
                syn.servers.add(pcs);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("-----OSFCacheSyn regited server :" + url));
                continue;
            }
            pcs = (IOSFCacheSyn)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.shr.base.syssetting.app.osf.OSFCacheSyn", IOSFCacheSyn.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("-----OSFCacheSyn regited server :" + url));
            }
            syn.servers.add(pcs);
        }
        return syn;
    }

    @Override
    public void disable(Context ctx, String configID) throws BOSException, EASBizException {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            ((IOSFCacheSyn)this.servers.get(i)).disable(ctx, configID);
        }
    }

    @Override
    public void enable(Context ctx, String configID) throws BOSException, EASBizException {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            ((IOSFCacheSyn)this.servers.get(i)).enable(ctx, configID);
        }
    }

    @Override
    public void restartService(Context ctx) throws BOSException, EASBizException {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            ((IOSFCacheSyn)this.servers.get(i)).restartService(ctx);
        }
    }

    @Override
    public void stopService(Context ctx) throws BOSException, EASBizException {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            ((IOSFCacheSyn)this.servers.get(i)).stopService(ctx);
        }
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this;
    }
}

