/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.upgrade;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.ListFilterSolutionCollection;
import com.kingdee.shr.base.syssetting.ListFilterSolutionInfo;
import com.kingdee.shr.base.syssetting.ListQuerySchemeTypeEnum;
import com.kingdee.shr.base.syssetting.UIViewCollection;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.upgrade.SchemeUpgradeUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class CommonListFilterSchemeUpgraderHepler {
    private static Logger logger = Logger.getLogger(CommonListFilterSchemeUpgraderHepler.class);

    public static ListFilterSolutionCollection assembleSystemSchemeModel(Context ctx, UIViewCollection coll) throws Exception {
        ListFilterSolutionCollection listFilterSolutionCollection = new ListFilterSolutionCollection();
        if (null == coll || coll.size() <= 0) {
            return listFilterSolutionCollection;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            ListFilterSolutionInfo listFilterSolutionInfo = new ListFilterSolutionInfo();
            UIViewInfo uiViewInfo = coll.get(i);
            Document doc = null;
            String content = "";
            String uipk0 = "";
            try {
                content = uiViewInfo.getContent();
                uipk0 = uiViewInfo.getUipk();
                doc = SchemeUpgradeUtils.parseXML(content);
            }
            catch (Exception e) {
                e.printStackTrace();
                String logMsg = MessageFormat.format("[invoke assembleSystemSchemeModel error, ] uipk is:{0},content : {1}", uipk0, content);
                logger.error((Object)logMsg);
            }
            Element root = null;
            Element element = null;
            if (doc != null) {
                root = doc.getRootElement();
                element = SchemeUpgradeUtils.getElement(root, "defaultQuerySolution");
            }
            if (null == element) continue;
            String schemeName = element.getAttributeValue("name");
            listFilterSolutionInfo.setName(schemeName);
            listFilterSolutionInfo.setIsDefault(Boolean.TRUE);
            listFilterSolutionInfo.setOwner(null);
            listFilterSolutionInfo.setUiview(uiViewInfo);
            listFilterSolutionInfo.setType(ListQuerySchemeTypeEnum.SYSTEM);
            listFilterSolutionInfo.setState(StateEnum.ENABLE);
            listFilterSolutionInfo.setInner(Boolean.TRUE);
            Timestamp time = SchemeUpgradeUtils.getTime();
            listFilterSolutionInfo.setCreateTime(time);
            listFilterSolutionInfo.setLastUpdateTime(time);
            List children = element.getChildren("filterItem");
            if (children == null) continue;
            Element childrenElement = (Element)children.get(0);
            HashMap<String, Object> filterItemMaping = new HashMap<String, Object>();
            String fieldName = childrenElement.getAttributeValue("fieldName");
            String compareType = childrenElement.getAttributeValue("compareType");
            String value = childrenElement.getAttributeValue("value");
            filterItemMaping.put("name", fieldName);
            filterItemMaping.put("compareType", compareType);
            filterItemMaping.put("value", value);
            String uipk = uiViewInfo.getUipk();
            HashMap<String, String> conditionKeyMap = new HashMap<String, String>();
            conditionKeyMap.put("id", value);
            conditionKeyMap.put("uipk", null);
            conditionKeyMap.put("enumSource", null);
            filterItemMaping.put("condition_key", conditionKeyMap);
            String dataType = "intenum";
            PropertyInfo propertyInfo = BaseMetaDataUtil.getPropertyInfo(ctx, uiViewInfo.getModel(), fieldName);
            if (null != propertyInfo) {
                String alias = propertyInfo.getAlias(LocaleUtils.locale_zh_CN);
                conditionKeyMap.put("name", alias);
                if (!StringUtils.isEmpty((String)alias)) {
                    listFilterSolutionInfo.setName(alias);
                }
            }
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo o = (OwnPropertyInfo)propertyInfo;
                String dataTypeString = o.getDataType().toString();
                if (DataType.ENUM.toString().equals(dataTypeString)) {
                    BizEnumInfo enumInfo = o.getEnumType();
                    if (enumInfo != null) {
                        conditionKeyMap.put("enumSource", enumInfo.getClassName());
                        if (BizEnumValueType.STRING.equals((Object)enumInfo.getDataType())) {
                            dataType = "stringenum";
                            filterItemMaping.put("type", dataType);
                        } else if (BizEnumValueType.INTEGER.equals((Object)enumInfo.getDataType())) {
                            dataType = "intenum";
                        }
                    }
                } else if (DataType.BOOLEAN.toString().equals(dataTypeString)) {
                    dataType = "boolean";
                }
            }
            conditionKeyMap.put("type", dataType);
            filterItemMaping.put("type", dataType);
            String fieldRuntimeAlias = SchemeUpgradeUtils.getFieldRuntimeAlias(ctx, uipk, fieldName);
            String searchViewfieldRuntimeAlias = "";
            try {
                searchViewfieldRuntimeAlias = SchemeUpgradeUtils.getAdvancedSearchFieldsFieldRuntimeAlias(ctx, uipk, fieldName);
            }
            catch (Exception e) {
                logger.error((Object)MessageFormat.format(" SchemeUpgradeUtils.getAdvancedSearchFieldsFieldRuntimeAlias error , uipk is {0},", uipk));
                e.printStackTrace();
                continue;
            }
            if (StringUtils.isEmpty((String)searchViewfieldRuntimeAlias)) continue;
            fieldRuntimeAlias = searchViewfieldRuntimeAlias;
            String assembleConditionAlias = CommonListFilterSchemeUpgraderHepler.assembleConditionAlias(ctx, uiViewInfo, fieldName, compareType, value, fieldRuntimeAlias);
            filterItemMaping.put("alias", assembleConditionAlias);
            Map<String, Map<String, ?>> targetMap = CommonListFilterSchemeUpgraderHepler.assembleTargetFilterSchemeModelMap(filterItemMaping);
            String jsonStr = JSONUtils.convertObjectToJson(ctx, targetMap);
            listFilterSolutionInfo.setConfig(jsonStr);
            listFilterSolutionCollection.add(listFilterSolutionInfo);
        }
        return listFilterSolutionCollection;
    }

    private static String assembleConditionAlias(Context ctx, UIViewInfo uiViewInfo, String fieldName, String compareType, String value, String fieldAlias) {
        String compareTypeAlias = SchemeUpgradeUtils.getCompareMappingAlias(ctx, compareType);
        String uipk = uiViewInfo.getUipk();
        String query = SchemeUpgradeUtils.getQuryName(ctx, uipk);
        if (StringUtils.isEmpty((String)compareTypeAlias) && !StringUtils.isEmpty((String)query)) {
            compareTypeAlias = SchemeUpgradeUtils.getQueryFieldAlias(ctx, query, fieldName);
        }
        String fieldDataType = SchemeUpgradeUtils.getFieldDataType(ctx, uipk, fieldName);
        String valueAlias = "";
        if ("Boolean".equalsIgnoreCase(fieldDataType)) {
            valueAlias = SchemeUpgradeUtils.getBooleanFieldAlias(ctx, fieldDataType, value);
        } else if ("Enum".equalsIgnoreCase(fieldDataType)) {
            valueAlias = SchemeUpgradeUtils.getEnumFieldAlias(ctx, uiViewInfo, fieldName, compareTypeAlias, fieldDataType, value);
        } else if ("String".equalsIgnoreCase(fieldDataType) || "Integer".equalsIgnoreCase(fieldDataType)) {
            valueAlias = value;
        }
        return MessageFormat.format("{0} {1} {2}", fieldAlias, compareTypeAlias, valueAlias);
    }

    private static Map<String, Map<String, ?>> assembleTargetFilterSchemeModelMap(Map<String, Object> filterItemMaping) {
        HashMap targetMap = new HashMap();
        HashMap fastFilterItemMap = new HashMap();
        HashMap<String, Object> advancedFilter = new HashMap<String, Object>();
        advancedFilter.put("condition", "t1");
        HashMap<String, Map<String, Object>> filterItemMapingItem = new HashMap<String, Map<String, Object>>();
        filterItemMapingItem.put("t1", filterItemMaping);
        advancedFilter.put("filterItemMaping", filterItemMapingItem);
        targetMap.put("advancedFilter", advancedFilter);
        targetMap.put("fastFilterItem", fastFilterItemMap);
        return targetMap;
    }

    private static String parseFilterConfig(Context ctx, UIViewInfo uiViewInfo, String schemeName, String filterConfig) {
        String uipk = uiViewInfo.getUipk();
        Object jsonObject = JSONUtils.convertJsonToObject(ctx, filterConfig, List.class);
        HashMap targetMap = new HashMap();
        if (jsonObject instanceof List) {
            StringBuffer conditionBuffer = new StringBuffer();
            HashMap fastFilterItemMap = new HashMap();
            HashMap<String, Serializable> advancedFilter = new HashMap<String, Serializable>();
            List queryFilterList = (List)jsonObject;
            String tn = null;
            int tIndex = 1;
            HashMap filterItemMaping0 = new HashMap();
            int len = queryFilterList.size();
            for (int j = 0; j < len; ++j) {
                Object filterObj = queryFilterList.get(j);
                tn = "t" + tIndex;
                ++tIndex;
                if (filterObj instanceof List) {
                    List filterObjList = (List)filterObj;
                    int filterObjListLen = filterObjList.size();
                    for (int k = 0; k < filterObjListLen; ++k) {
                        Object filterObjListObj = filterObjList.get(k);
                        if (!(filterObjListObj instanceof Map)) continue;
                        Map map = (Map)filterObjListObj;
                    }
                    continue;
                }
                if (!(filterObj instanceof Map)) continue;
                Map filterMap = (Map)filterObj;
                String name = (String)filterMap.get("prop_field");
                String compareType = (String)filterMap.get("prop_op");
                String fieldDataType = SchemeUpgradeUtils.getFieldDataType(ctx, uipk, name);
                Object propValueObj = filterMap.get("prop_value");
                String value = "";
                if (propValueObj instanceof String) {
                    value = String.valueOf(propValueObj);
                } else if (propValueObj instanceof Map) {
                    Map propValueMap = (Map)propValueObj;
                    if (propValueMap != null && propValueMap.get("id") != null) {
                        value = String.valueOf(propValueMap.get("id"));
                    }
                    fieldDataType = "link";
                }
                HashMap<String, Object> filterItemMaping = new HashMap<String, Object>();
                filterItemMaping.put("name", name);
                filterItemMaping.put("compareType", compareType);
                filterItemMaping.put("value", value);
                HashMap<String, Object> conditionKeyMap = new HashMap<String, Object>();
                conditionKeyMap.put("id", tIndex);
                conditionKeyMap.put("uipk", null);
                conditionKeyMap.put("enumSource", null);
                conditionKeyMap.put("field", name);
                filterItemMaping.put("condition_key", conditionKeyMap);
                String dataType = "intenum";
                PropertyInfo propertyInfo = null;
                String field0 = "";
                String field1 = "";
                if (name.contains(".")) {
                    String[] fields = name.split("\\.");
                    field0 = fields[0];
                    field1 = fields[1];
                    PropertyInfo prop = BaseMetaDataUtil.getPropertyInfo(ctx, uiViewInfo.getModel(), field0);
                    if (null == prop || !(prop instanceof LinkPropertyInfo)) continue;
                    String entityName = "";
                    if (prop instanceof LinkPropertyInfo) {
                        LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
                        entityName = linkProp.getRelationship().getSupplierObject().getFullName();
                    }
                    propertyInfo = BaseMetaDataUtil.getPropertyInfo(ctx, entityName, field1);
                } else {
                    propertyInfo = BaseMetaDataUtil.getPropertyInfo(ctx, uiViewInfo.getModel(), name);
                }
                if (null == propertyInfo) continue;
                if (propertyInfo instanceof OwnPropertyInfo) {
                    OwnPropertyInfo o = (OwnPropertyInfo)propertyInfo;
                    String dataTypeString = o.getDataType().toString();
                    if (DataType.ENUM.toString().equals(dataTypeString)) {
                        BizEnumInfo enumInfo = o.getEnumType();
                        if (enumInfo != null) {
                            conditionKeyMap.put("enumSource", enumInfo.getClassName());
                            if (BizEnumValueType.STRING.equals((Object)enumInfo.getDataType())) {
                                dataType = "stringenum";
                                filterItemMaping.put("type", dataType);
                            } else if (BizEnumValueType.INTEGER.equals((Object)enumInfo.getDataType())) {
                                dataType = "intenum";
                            }
                        }
                    } else {
                        dataType = DataType.BOOLEAN.toString().equals(dataTypeString) ? "boolean" : dataTypeString;
                    }
                }
                conditionKeyMap.put("name", propertyInfo.getAlias());
                conditionKeyMap.put("type", dataType);
                filterItemMaping.put("type", fieldDataType);
                HashMap<String, HashMap<String, Object>> filterItemMapingItem = new HashMap<String, HashMap<String, Object>>();
                if (len - 1 == j) {
                    conditionBuffer.append(tn);
                } else {
                    conditionBuffer.append(tn);
                    conditionBuffer.append(" and ");
                }
                filterItemMapingItem.put(tn, filterItemMaping);
                String fieldRuntimeAlias = SchemeUpgradeUtils.getFieldRuntimeAlias(ctx, uipk, name);
                String assembleConditionAlias = CommonListFilterSchemeUpgraderHepler.assembleConditionAlias(ctx, uiViewInfo, name, compareType, value, fieldRuntimeAlias);
                if (StringUtils.isEmpty((String)assembleConditionAlias)) {
                    filterItemMaping.put("alias", schemeName);
                } else {
                    filterItemMaping.put("alias", assembleConditionAlias);
                }
                filterItemMaping0.put(tn, filterItemMaping);
            }
            advancedFilter.put("filterItemMaping", filterItemMaping0);
            advancedFilter.put("condition", conditionBuffer);
            targetMap.put("advancedFilter", advancedFilter);
            targetMap.put("fastFilterItem", fastFilterItemMap);
        }
        return JSONUtils.convertObjectToJson(ctx, targetMap);
    }

    public static ListFilterSolutionCollection assembleUserSchemeModel(Context ctx) throws Exception {
        ListFilterSolutionCollection listFilterSolutionCollection = new ListFilterSolutionCollection();
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)CommonListFilterSchemeUpgraderHepler.assembleSearchViewSql());
        while (iRowSet.next()) {
            String id = iRowSet.getString("fid");
            String userId = iRowSet.getString("userid");
            String uiviewID = iRowSet.getString("uiviewID");
            String name = iRowSet.getString("name");
            UIViewInfo uIViewInfo = SchemeUpgradeUtils.getUIViewInfo(ctx, uiviewID);
            boolean isDefault = iRowSet.getBoolean("isDefault");
            String filterConfig = iRowSet.getString("filterConfig");
            if (StringUtils.isEmpty((String)filterConfig) || "[]".equalsIgnoreCase(filterConfig)) continue;
            ListFilterSolutionInfo listFilterSolutionInfo = new ListFilterSolutionInfo();
            listFilterSolutionInfo.setName(name);
            listFilterSolutionInfo.setIsDefault(isDefault);
            UserInfo owner = new UserInfo();
            owner.setId(BOSUuid.read((String)userId));
            listFilterSolutionInfo.setSrcID(id);
            UIViewInfo uiViewInfo = new UIViewInfo();
            uiViewInfo.setId(BOSUuid.read((String)uiviewID));
            listFilterSolutionInfo.setOwner(owner);
            listFilterSolutionInfo.setUiview(uiViewInfo);
            listFilterSolutionInfo.setType(ListQuerySchemeTypeEnum.USER);
            listFilterSolutionInfo.setState(StateEnum.ENABLE);
            listFilterSolutionInfo.setInner(Boolean.FALSE);
            Timestamp time = SchemeUpgradeUtils.getTime();
            listFilterSolutionInfo.setCreateTime(time);
            listFilterSolutionInfo.setLastUpdateTime(time);
            listFilterSolutionInfo.setConfig(CommonListFilterSchemeUpgraderHepler.parseFilterConfig(ctx, uIViewInfo, name, filterConfig));
            listFilterSolutionCollection.add(listFilterSolutionInfo);
        }
        return listFilterSolutionCollection;
    }

    public static String assembleSearchViewSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select ");
        sql.append(" t1.fid, u.fid userid,uiview.fid as uiviewID,t1.fviewname as name,t1.fuipk as uipk,t1.fQueryfilter as filterConfig,t1.fisdefault as isDefault  ");
        sql.append(" from S_BS_SearchView t1 ");
        sql.append(" inner join t_bd_person person on  person.fid = t1.fpersonid ");
        sql.append(" inner join t_pm_user u on u.FPERSONID  = person.fid ");
        sql.append(" inner join s_bs_uiview uiview on uiview.fuipk = t1.fuipk ");
        sql.append(" where uiview.FType = '").append("list").append("'");
        return sql.toString();
    }
}

