/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.upgrade;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.util.StringUtils;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public final class SchemeUpgradeUtils {
    private static Logger logger = Logger.getLogger(SchemeUpgradeUtils.class);
    private static final String SPACE = " ";

    public static XMLOutputter getXMLOutputter() {
        XMLOutputter outter = new XMLOutputter();
        outter.setFormat(Format.getPrettyFormat());
        return outter;
    }

    public static String attributesToString(Element element) {
        return SchemeUpgradeUtils.attributesToString(element, null);
    }

    public static String attributesToString(Element element, Collection<String> excludeAttribute) {
        if (element == null) {
            return SPACE;
        }
        List attributes = element.getAttributes();
        Attribute attribute = null;
        StringBuilder sb = new StringBuilder();
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            attribute = (Attribute)attributes.get(i);
            if (excludeAttribute != null && excludeAttribute.contains(attribute.getName())) continue;
            sb.append(SchemeUpgradeUtils.attributeToString(attribute));
        }
        return sb.toString();
    }

    public static String attributeToString(Attribute attribute) {
        StringBuilder sb = new StringBuilder();
        String value = attribute.getValue();
        if (!StringUtils.isEmpty((String)value)) {
            sb.append(SPACE);
            sb.append(attribute.getName());
            sb.append("=");
            sb.append("\"");
            sb.append(value);
            sb.append("\"");
        }
        return sb.toString();
    }

    public static Document parseXML(String xml) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        XMLUtil.setReaderFeature(builder);
        Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(xml));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return doc;
    }

    public static Element getElement(Element root, String elementName) {
        if (root.getName().equalsIgnoreCase(elementName)) {
            return root;
        }
        Element element = null;
        Element result = null;
        if (root.getChildren() != null) {
            List children = root.getChildren();
            int size = children.size();
            for (int i = 0; i < size && (result = SchemeUpgradeUtils.getElement(element = (Element)children.get(i), elementName)) == null; ++i) {
            }
        }
        return result;
    }

    public static List<Element> getElements(Element root, String elementName, List<Element> elements) {
        if (root.getName().equalsIgnoreCase(elementName)) {
            elements.add(root);
        }
        Element element = null;
        if (root.getChildren() != null) {
            List children = root.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                element = (Element)children.get(i);
                SchemeUpgradeUtils.getElements(element, elementName, elements);
            }
        }
        return elements;
    }

    public static Element mergeElement(Element base, Element newElement) {
        if (!base.getName().equalsIgnoreCase(newElement.getName())) {
            return base;
        }
        SchemeUpgradeUtils.overwriteAttribute(base, newElement);
        List children = base.getChildren();
        Element subElement = null;
        Element newSubElement = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            subElement = (Element)children.get(i);
            newSubElement = SchemeUpgradeUtils.getElement(newElement, subElement.getName());
            if (newSubElement == null) continue;
            SchemeUpgradeUtils.mergeElement(subElement, newSubElement);
            newSubElement.detach();
        }
        children = newElement.getChildren();
        while (children.size() > 0) {
            subElement = (Element)children.get(0);
            subElement.detach();
            base.addContent((Content)subElement);
        }
        return base;
    }

    public static void overwriteAttribute(Element base, Element newElement) {
        List attributes = newElement.getAttributes();
        Attribute attribute = null;
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            attribute = (Attribute)attributes.get(i);
            base.setAttribute(attribute.getName(), attribute.getValue());
        }
    }

    public static void removeExcludeAttribute(Element element, Collection<String> excludeAttribute) {
        for (String item : excludeAttribute) {
            element.removeAttribute(item);
        }
    }

    public static Class<?> getUIViewUtilInstance() {
        Class<?> class0 = null;
        try {
            class0 = Class.forName("com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return class0;
    }

    public static String getFieldDataType(Context ctx, String uipk, String fieldName) {
        String fieldDataType = "";
        Class<?> instance = SchemeUpgradeUtils.getUIViewUtilInstance();
        if (null == instance) {
            return fieldDataType;
        }
        try {
            Constructor<?> ct0 = instance.getDeclaredConstructor(new Class[0]);
            Method m0 = instance.getDeclaredMethod("getFieldDataType", Context.class, String.class, String.class);
            Object result = m0.invoke(ct0.newInstance(new Object[0]), ctx, uipk, fieldName);
            if (null != result) {
                fieldDataType = String.valueOf(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldDataType;
    }

    public static String getFieldRuntimeAlias(Context ctx, String uipk, String fieldName) {
        String fieldRuntimeAlias = "";
        if (!SchemeUpgradeUtils.existUIViewInfo(ctx, uipk)) {
            logger.error((Object)MessageFormat.format("uipk not exist , uipk is {0}", uipk));
            return fieldRuntimeAlias;
        }
        Class<?> instance = SchemeUpgradeUtils.getUIViewUtilInstance();
        try {
            Constructor<?> ct0 = instance.getDeclaredConstructor(new Class[0]);
            Method m0 = instance.getDeclaredMethod("getFieldRuntimeAlias", Context.class, String.class, String.class);
            Object result = m0.invoke(ct0.newInstance(new Object[0]), ctx, uipk, fieldName);
            if (null != result) {
                fieldRuntimeAlias = String.valueOf(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldRuntimeAlias;
    }

    public static String getAdvancedSearchFieldsFieldRuntimeAlias(Context ctx, String uipk, String fieldName) throws Exception {
        String fieldRuntimeAlias = "";
        if (!SchemeUpgradeUtils.existUIViewInfo(ctx, uipk)) {
            logger.error((Object)MessageFormat.format("uipk not exist , uipk is {0}", uipk));
            return fieldRuntimeAlias;
        }
        Class<?> instance = SchemeUpgradeUtils.getUIViewUtilInstance();
        Object result = null;
        if (null != instance) {
            Constructor<?> ct0 = instance.getDeclaredConstructor(new Class[0]);
            Method m0 = instance.getDeclaredMethod("getAdvancedSearchFieldsFieldRuntimeAlias", Context.class, String.class, String.class);
            result = m0.invoke(ct0.newInstance(new Object[0]), ctx, uipk, fieldName);
        }
        if (null != result) {
            fieldRuntimeAlias = String.valueOf(result);
        }
        return fieldRuntimeAlias;
    }

    public static boolean existUIViewInfo(Context ctx, String uipk) {
        boolean flag = true;
        Class<?> instance = SchemeUpgradeUtils.getUIViewUtilInstance();
        try {
            Constructor<?> ct0 = instance.getDeclaredConstructor(new Class[0]);
            Method m0 = instance.getDeclaredMethod("existUIViewInfo", Context.class, String.class);
            Object result = m0.invoke(ct0.newInstance(new Object[0]), ctx, uipk);
            flag = Boolean.valueOf(result.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }
        return flag;
    }

    public static String getQuryName(Context ctx, String uipk) {
        String query = "";
        Class<?> instance = SchemeUpgradeUtils.getUIViewUtilInstance();
        try {
            Constructor<?> ct0 = instance.getDeclaredConstructor(new Class[0]);
            Method m0 = instance.getDeclaredMethod("getQuryName", Context.class, String.class);
            Object result = m0.invoke(ct0.newInstance(new Object[0]), ctx, uipk);
            if (null != result) {
                query = String.valueOf(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return query;
    }

    public static String getQueryFieldAlias(Context ctx, String query, String value, String fieldName) {
        String queryFieldAlias = "";
        PropertyUnitCollection propertyUnitCollection0 = SchemeUpgradeUtils.getQueryInfo(ctx, query).getUnits();
        block0: for (int i = 0; i < propertyUnitCollection0.size(); ++i) {
            PropertyUnitInfo propertyUnitInfo0 = propertyUnitCollection0.get(i);
            PropertyRefCollection propertyRefCollection0 = propertyUnitInfo0.getPropertyRefs();
            for (int j = 0; j < propertyRefCollection0.size(); ++j) {
                PropertyRefInfo propertyRefInfo0 = propertyRefCollection0.get(j);
                String queryField = propertyRefInfo0.getSubEntity().getName();
                PropertyInfo propertyInfo0 = propertyRefInfo0.getRefProperty();
                if (!fieldName.equalsIgnoreCase(propertyInfo0.getName())) continue;
                String entityName0 = MetaDataUtil.getEntityNameByQueryField(ctx, query, queryField);
                queryFieldAlias = SchemeUpgradeUtils.getEnumAliasByValue(ctx, entityName0, fieldName, value);
                continue block0;
            }
        }
        return queryFieldAlias;
    }

    public static UIViewInfo getUIViewInfo(Context ctx, String id) {
        UIViewInfo uIViewInfo = null;
        try {
            uIViewInfo = UIViewFactory.getLocalInstance(ctx).getUIViewInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uIViewInfo;
    }

    public static String getEnumFieldAlias(Context ctx, UIViewInfo uiViewInfo, String fieldName, String compareType, String fieldDataType, String value) {
        String enumFieldAlias = "";
        String entityName = uiViewInfo.getModel();
        String[] arr = value.split(",");
        if (StringUtils.isEmpty((String)entityName)) {
            return enumFieldAlias;
        }
        String query = SchemeUpgradeUtils.getQuryName(ctx, uiViewInfo.getUipk());
        if (StringUtils.isEmpty((String)query)) {
            return SchemeUpgradeUtils.getEnumAliasByValue(ctx, entityName, fieldName, value);
        }
        StringBuffer aliasBuffer = new StringBuffer();
        for (String v : arr) {
            String alias0 = SchemeUpgradeUtils.getEnumAliasByValue(ctx, entityName, fieldName, v);
            if (StringUtils.isEmpty((String)alias0)) {
                if (fieldName.indexOf(".") > 0) {
                    String[] fieldArr = fieldName.split("\\.");
                    String prefix = fieldArr[0];
                    String post = fieldArr[1];
                    SchemeUpgradeUtils.getQueryFieldAlias(ctx, query, value, post);
                } else {
                    alias0 = SchemeUpgradeUtils.getQueryFieldAlias(SchemeUpgradeUtils.getQueryInfo(ctx, query), fieldName);
                }
            }
            aliasBuffer.append(alias0).append(SPACE);
        }
        enumFieldAlias = aliasBuffer.toString();
        return enumFieldAlias;
    }

    public static String getBooleanFieldAlias(Context ctx, String fieldDataType, String value) {
        String booleanFieldAlias = "";
        if ("0".equalsIgnoreCase(value)) {
            booleanFieldAlias = SHRSysSettingResourceUtil.getResource("false", ctx);
        } else if ("1".equalsIgnoreCase(value)) {
            booleanFieldAlias = SHRSysSettingResourceUtil.getResource("true", ctx);
        }
        return booleanFieldAlias;
    }

    public static String getEnumAliasByValue(Context ctx, String entityName, String fieldName, String value) {
        BizEnumInfo enmuInfo = SchemeUpgradeUtils.getFieldEnum(ctx, entityName, fieldName);
        BizEnumValueInfo bizEnumValueInfo = null;
        String emumAlias = "";
        if (null == enmuInfo) {
            return emumAlias;
        }
        BizEnumValueCollection coll = enmuInfo.getEnumValue();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            bizEnumValueInfo = coll.get(i);
            if (!value.equalsIgnoreCase(String.valueOf(bizEnumValueInfo.getValue()))) continue;
            emumAlias = bizEnumValueInfo.getAlias();
            break;
        }
        return emumAlias;
    }

    public static BizEnumInfo getFieldEnum(Context ctx, String entityName, String fieldName) {
        PropertyInfo propertyInfo = BaseMetaDataUtil.getPropertyInfo(ctx, entityName, fieldName);
        BizEnumInfo bizEnumInfo = BaseMetaDataUtil.getBizEnumInfo(ctx, propertyInfo);
        return bizEnumInfo;
    }

    public static String getQueryFieldAlias(Context ctx, String query, String fieldName) {
        return SchemeUpgradeUtils.getQueryFieldAlias(SchemeUpgradeUtils.getQueryInfo(ctx, query), fieldName);
    }

    public static QueryInfo getQueryInfo(Context ctx, String query) {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getQuery((IMetaDataPK)MetaDataPK.create((String)query));
    }

    public static String getQueryFieldAlias(QueryInfo queryInfo, String fieldName) {
        String queryFieldAlias = "";
        PropertyUnitCollection coll = queryInfo.getUnits();
        if (null == coll) {
            return queryFieldAlias;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PropertyUnitInfo propertyUnitInfo = coll.get(i);
            if (null == propertyUnitInfo || !fieldName.endsWith(propertyUnitInfo.getName())) continue;
            queryFieldAlias = propertyUnitInfo.getDisplayName();
            break;
        }
        return queryFieldAlias;
    }

    public static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static String getCompareMappingAlias(Context ctx, String compareType) {
        String compareTypeAlias = "";
        if (CompareType.EQUALS.getAlias().equalsIgnoreCase(compareType)) {
            compareTypeAlias = SHRSysSettingResourceUtil.getResource("equal", ctx);
        } else if (CompareType.LESS.getAlias().equalsIgnoreCase(compareType)) {
            compareTypeAlias = SHRSysSettingResourceUtil.getResource("less_than", ctx);
        } else if (CompareType.GREATER.getAlias().equalsIgnoreCase(compareType)) {
            compareTypeAlias = SHRSysSettingResourceUtil.getResource("greater_than", ctx);
        } else if (CompareType.LESS_EQUALS.getAlias().equalsIgnoreCase(compareType)) {
            compareTypeAlias = SHRSysSettingResourceUtil.getResource("less_equal", ctx);
        } else if (CompareType.GREATER_EQUALS.getAlias().equalsIgnoreCase(compareType)) {
            compareTypeAlias = SHRSysSettingResourceUtil.getResource("greater_than", ctx);
        } else if (CompareType.NOTEQUALS.getAlias().equalsIgnoreCase(compareType)) {
            compareTypeAlias = SHRSysSettingResourceUtil.getResource("not_equal", ctx);
        } else if (CompareType.LIKE.getAlias().equalsIgnoreCase(compareType)) {
            compareTypeAlias = SHRSysSettingResourceUtil.getResource("include", ctx);
        } else if ("in".equalsIgnoreCase(compareType)) {
            compareTypeAlias = SHRSysSettingResourceUtil.getResource("not_include", ctx);
        }
        return compareTypeAlias;
    }
}

