/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.cloud;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.app.CloudMsgInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.cloud.HttpClientUtil;
import com.kingdee.shr.base.syssetting.cloud.ISendForewarnMessage;
import com.kingdee.shr.base.syssetting.cloud.SendForewarnMessageConstant;
import com.kingdee.shr.base.syssetting.cloud.bean.ModelListBean;
import com.kingdee.shr.base.syssetting.cloud.bean.ModelListBeanExt;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.lightapp.xt.XTServiceConfig;
import com.kingdee.util.ConfigurationItem;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractSendForewarnMessage
implements ISendForewarnMessage {
    private static Logger logger = Logger.getLogger(AbstractSendForewarnMessage.class);
    protected Map<String, String> forewarnMessagePostConfig;

    @Override
    public void sendCloudMsg(Context ctx, List<CloudMsgInfo> messageAndReceivers, ForewarnItemInfo forewarnItemInfo) throws BOSException, EASBizException {
        System.out.println("debugwarn: start calling push cloudhub");
        long begin = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"----------------------Early warning push start ----------------------");
        }
        if (null == messageAndReceivers || messageAndReceivers.size() <= 0) {
            return;
        }
        this.initForewarnMessagePostConfig(ctx, forewarnItemInfo);
        System.out.println("debugwarn:init push info" + this.forewarnMessagePostConfig);
        List<JSONObject> objs = this.initData(ctx, messageAndReceivers);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Early warning push data: " + JSONUtils.convertObjectToJson(ctx, objs)));
        }
        System.out.println("debugwarn Early warning push data\uff1a" + JSONUtils.convertObjectToJson(ctx, objs));
        for (JSONObject obj : objs) {
            this.send(obj);
        }
        System.out.println("debugwarn push end: ");
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"----------------------Early warning push end ----------------------");
            logger.debug((Object)("----------------------cost time \uff1a" + (end - begin) + " ms----------------------"));
        }
    }

    protected final void initForewarnMessagePostConfig() throws BOSException {
        this.forewarnMessagePostConfig = new HashMap<String, String>();
        XTServiceConfig xtServiceConfig = XTServiceConfig.getInstance();
        ConfigurationItem ct = xtServiceConfig.getConfiguration().getConfigItem(SendForewarnMessageConstant.XT_FW_MESSAGE);
        if (null == ct || ct.getAllChildren().size() <= 0) {
            throw new BOSException("Alert message push configuration is incorrect, please complete alert message push information correctly,path: " + xtServiceConfig.getFilePath());
        }
        List cl = ct.getAllChildren();
        boolean isConfiged = false;
        int total = cl.size();
        for (int i = 0; i < total; ++i) {
            ConfigurationItem item = (ConfigurationItem)cl.get(i);
            if (!SendForewarnMessageConstant.XT_FW_SHR_MESSAGE.equals(item.getName())) continue;
            this.forewarnMessagePostConfig = item.getProperties();
            isConfiged = true;
        }
        if (!isConfiged) {
            throw new BOSException("Alert message push configuration is incorrect, please complete alert message push information correctly,path: " + xtServiceConfig.getFilePath());
        }
    }

    protected final void initForewarnMessagePostConfig(Context ctx, ForewarnItemInfo forewarnItemInfo) throws BOSException {
        String id = forewarnItemInfo.getTemplet().getId().toString();
        System.out.println("debugwarn:Early warning item id\uff1a" + id);
        this.forewarnMessagePostConfig = new HashMap<String, String>();
        this.forewarnMessagePostConfig = this.getWarnConfigById(ctx, id);
    }

    protected abstract List<JSONObject> initData(Context var1, List<CloudMsgInfo> var2) throws BOSException, EASBizException;

    protected abstract int getTextType();

    protected abstract int getModelType();

    protected final JSONObject getData(JSONObject from, JSONArray to, String type, JSONObject msg) {
        JSONObject data = new JSONObject();
        data.put((Object)"from", (Object)from);
        data.put((Object)"to", (Object)to);
        data.put((Object)"type", (Object)type);
        data.put((Object)"msg", (Object)msg);
        return data;
    }

    protected final JSONObject getFromData() throws BOSException {
        JSONObject form = new JSONObject();
        String time = String.valueOf(System.currentTimeMillis());
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException();
        }
        String nonce = "";
        if (null != random) {
            nonce = String.valueOf(random.nextDouble() * 1000000.0);
        }
        form.put((Object)"no", (Object)this.forewarnMessagePostConfig.get("no"));
        form.put((Object)"pub", (Object)this.forewarnMessagePostConfig.get("pub"));
        form.put((Object)"time", (Object)time);
        form.put((Object)"nonce", (Object)nonce);
        form.put((Object)"pubtoken", (Object)this.getToKen(time, nonce));
        return form;
    }

    private String getToKen(String time, String nonce) {
        Object[] array = new String[]{this.forewarnMessagePostConfig.get("no"), this.forewarnMessagePostConfig.get("pub"), this.forewarnMessagePostConfig.get("pubKey"), nonce, time};
        Arrays.sort(array);
        return DigestUtils.shaHex((String)StringUtils.join((Object[])array));
    }

    protected final JSONArray getTo(Set<String> openIds) {
        JSONArray to = new JSONArray();
        JSONObject item = new JSONObject();
        JSONArray user = new JSONArray();
        for (String openId : openIds) {
            user.add((Object)openId);
        }
        item.put((Object)"no", (Object)this.forewarnMessagePostConfig.get("no"));
        item.put((Object)"user", (Object)user);
        to.add((Object)item);
        return to;
    }

    protected final JSONObject getTextMsg(String text) {
        JSONObject msg = new JSONObject();
        msg.put((Object)"text", (Object)text);
        return msg;
    }

    protected final JSONObject getTextLinkMsg(String text, String url, String appid, int todo, String sourceid) {
        JSONObject msg = new JSONObject();
        msg.put((Object)"text", (Object)text);
        msg.put((Object)"url", (Object)url);
        msg.put((Object)"appid", (Object)appid);
        msg.put((Object)"todo", (Object)todo);
        msg.put((Object)"sourceid", (Object)sourceid);
        return msg;
    }

    protected final JSONObject getTextImageMsg(String model, int todo, String sourceid, JSONArray list) {
        JSONObject msg = new JSONObject();
        msg.put((Object)"model", (Object)model);
        msg.put((Object)"todo", (Object)todo);
        msg.put((Object)"sourceid", (Object)sourceid);
        msg.put((Object)"list", (Object)list);
        return msg;
    }

    protected final JSONArray getModelList(List<ModelListBean> list) {
        JSONArray array = new JSONArray();
        int total = list.size();
        for (int i = 0; i < total; ++i) {
            ModelListBean bean = list.get(i);
            array.add((Object)this.getModelListBean(bean));
        }
        return array;
    }

    protected final JSONArray getModelListExt(List<ModelListBeanExt> list) {
        JSONArray array = new JSONArray();
        int total = list.size();
        for (int i = 0; i < total; ++i) {
            ModelListBeanExt bean = list.get(i);
            array.add((Object)this.getModelListBeanExt(bean));
        }
        return array;
    }

    private JSONObject getModelListBean(ModelListBean bean) {
        JSONObject msg = new JSONObject();
        msg.put((Object)"date", (Object)bean.getDate());
        msg.put((Object)"title", (Object)bean.getTitle());
        msg.put((Object)"text", (Object)bean.getText());
        msg.put((Object)"zip", (Object)bean.getZip());
        msg.put((Object)"url", (Object)bean.getUrl());
        msg.put((Object)"appid", (Object)bean.getAppid());
        return msg;
    }

    private JSONObject getModelListBeanExt(ModelListBeanExt bean) {
        JSONObject msg = this.getModelListBean(bean);
        msg.put((Object)"name", (Object)bean.getName());
        msg.put((Object)"pic", (Object)bean.getPic());
        return msg;
    }

    protected final void send(JSONObject obj) throws BOSException {
        HttpClientUtil.postForwarnMessageToClould(XTServiceConfig.getInstance().getXTServerUrl(), obj);
    }

    protected final String getOpenId(Context ctx, String userId) throws BOSException, SQLException {
        String sql = "select fxtid from t_pm_easxtusermap where fuserid = ?";
        String openId = "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId});
        while (rs.next()) {
            openId = rs.getString("fxtid");
        }
        return openId;
    }

    protected final Set<String> getOpenId(Context ctx, UserInfo user) throws BOSException, EASBizException {
        if (user == null) {
            throw new SyssettinException(SyssettinException.CUSTOM_EXCEPTION, new Object[]{SHRSysSettingResourceUtil.getResource("no_shruser", ctx)});
        }
        HashSet<String> openIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.fxtid from t_pm_easxtusermap t0 where fuserid = '" + user.getId().toString() + "'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                openIds.add(rs.getString("fxtid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return openIds;
    }

    protected final Set<String> getOpenIds(Context ctx, Set<UserInfo> users) throws BOSException, EASBizException {
        HashSet<String> openIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.fxtid from t_pm_easxtusermap t0 where fuserid in (");
        Set<String> userIds = this.getUnDumpUserIds(users);
        StringBuffer param = new StringBuffer();
        if (userIds.size() <= 0) {
            throw new SyssettinException(SyssettinException.NO_USERINFO);
        }
        try {
            if (userIds.size() <= SendForewarnMessageConstant.SQL_IN_MAX_COUNT) {
                int i = 0;
                for (String key : userIds) {
                    if (i > 0) {
                        param.append(",");
                    }
                    param.append("'").append(key).append("'");
                    ++i;
                }
            } else {
                String tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_shr_easxtusermapping(FID varchar(44))");
                String insertSql = "insert into " + tempTableName + "(FID) values(?)";
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                for (String key : userIds) {
                    paramsList.add(new Object[]{key});
                }
                DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
                param.append("select FID from ").append(tempTableName);
            }
            sql.append(param.toString()).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                openIds.add(rs.getString("fxtid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return openIds;
    }

    private Set<String> getUnDumpUserIds(Set<UserInfo> users) {
        HashSet<String> userIds = new HashSet<String>();
        for (UserInfo u : users) {
            if (userIds.contains(u.getId().toString())) continue;
            userIds.add(u.getId().toString());
        }
        return userIds;
    }

    private Map<String, String> getWarnConfigById(Context ctx, String warnId) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "SELECT circle.FNo as no,Addr.FPub as pub,Addr.FPubKey as pubKey FROM T_FW_ForewarnItem AS FOREWARNITEM inner JOIN T_SHR_WarnItemPublicAddrLink AS  Link ON Link.FWarnItemID = FOREWARNITEM.FID inner JOIN T_SHR_PublicAddress AS Addr ON Link.FPublicAddrID = Addr.FID inner join T_SHR_WorkCircle as circle on Addr.FWorkCircleID = circle.fid   WHERE FOREWARNITEM.FID in ('" + warnId + "')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.size() <= 0) {
            throw new BOSException(SHRSysSettingResourceUtil.getResource("configuration_path", ctx));
        }
        try {
            while (rs.next()) {
                map.put("no", rs.getString("no"));
                map.put("pub", rs.getString("pub"));
                map.put("pubKey", rs.getString("pubKey"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }
}

