/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula.parse;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.app.cache.FieldRuleCacheHelper;
import com.kingdee.shr.base.syssetting.fieldrule.formula.IObjectLoaderProvider;
import com.kingdee.shr.base.syssetting.fieldrule.formula.ParserException;
import com.kingdee.shr.base.syssetting.fieldrule.formula.TypeUtils;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.ArrayIndexerExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.BigDecimalExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.BinaryOpExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.BinaryOpType;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.BoolExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.CharExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.CodeExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.ConditionExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.DoubleExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.FloatExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.IdentifierExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.IntExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.LongExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.MethodInvokeExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.NewFunctionExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.NullExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.ObjectCreateExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.PropertyExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.StringExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.UnaryExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.expr.VectorCreateExpr;
import com.kingdee.shr.base.syssetting.fieldrule.formula.function.IFunctionProvider;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.ExprParser;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.FieldRuleScriptParser;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Lexer;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Source;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.TokenList;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.FieldRuleFormulaUtil;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.FunctionObject;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.InterpreterException;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveBoolean;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveCharacter;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveDouble;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveFloat;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveInt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveLong;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveValue;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.ReflectionUtils;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.ToString;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.BlockStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.CodeStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ElseIfItem;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ExprListStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ExprStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.Function;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.IfStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.ReturnStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.VarDeclItem;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.VarDeclStmt;
import com.kingdee.util.TODOException;
import com.kingdee.util.Uuid;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRuleInterpreter {
    private static final Logger log = LoggerFactory.getLogger(FieldRuleInterpreter.class);
    private Context ctx;
    private List<String> namespaces = new ArrayList<String>();
    private Map<String, Object> classMap = new HashMap<String, Object>();
    private Map<String, Function> funcDeclMap = new HashMap<String, Function>();
    public final List<IFunctionProvider> publicFuncProviderList = new ArrayList<IFunctionProvider>();
    private static List<String> internalFunctionList = new ArrayList<String>();
    private boolean synchronizedCallMethod = false;
    private boolean properyExprOwnerNullIgore = true;
    private Source source = null;
    private Map<String, Method> methodCache = new HashMap<String, Method>();
    private static final String METHOD_GET = "_GET_";
    private Map<String, FieldRuleScriptParser> parseCache = new HashMap<String, FieldRuleScriptParser>();
    public static final String KS_COLLECT_VALUE = "_KS_VALUE";
    public static final String KS_COLLECT_OWNER = "_KS_OWNER";
    private IObjectLoaderProvider bizObjectProvider = null;

    public Source getSource() {
        return this.source;
    }

    public FieldRuleInterpreter(Context ctx) {
        this.ctx = ctx;
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap.put("boolean", Boolean.TYPE);
        this.classMap.put("boolean[]", boolean[].class);
        this.classMap.put("char", Character.TYPE);
        this.classMap.put("char[]", char[].class);
        this.classMap.put("[C", char[].class);
        this.classMap.put("byte", Byte.TYPE);
        this.classMap.put("byte[]", byte[].class);
        this.classMap.put("[B", byte[].class);
        this.classMap.put("short", Short.TYPE);
        this.classMap.put("short[]", short[].class);
        this.classMap.put("[S", short[].class);
        this.classMap.put("int", Integer.TYPE);
        this.classMap.put("int[]", int[].class);
        this.classMap.put("[I", int[].class);
        this.classMap.put("long", Long.TYPE);
        this.classMap.put("long[]", long[].class);
        this.classMap.put("[J", long[].class);
        this.classMap.put("float", Float.TYPE);
        this.classMap.put("float[]", float[].class);
        this.classMap.put("[F", float[].class);
        this.classMap.put("double", Double.TYPE);
        this.classMap.put("double[]", double[].class);
        this.classMap.put("[D", double[].class);
        try {
            this.bizObjectProvider = (IObjectLoaderProvider)Class.forName("com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.FieldRuleScriptObjectLoader").newInstance();
            if (null != this.bizObjectProvider) {
                this.bizObjectProvider.setContext(ctx);
            }
        }
        catch (InstantiationException e) {
            log.warn("cannot registe ObjectLoader[com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.FieldRuleScriptObjectLoader]. Because : InstantiationException");
        }
        catch (IllegalAccessException e) {
            log.warn("cannot registe ObjectLoader[com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.FieldRuleScriptObjectLoader]. Because : IllegalAccessException");
        }
        catch (ClassNotFoundException e) {
            log.warn("cannot registe ObjectLoader[com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.FieldRuleScriptObjectLoader]. Because : ClassNotFoundException");
        }
        if (null != ctx) {
            IFunctionProvider defaultFuncProvider = FieldRuleCacheHelper.getFunctions(ctx);
            this.publicFuncProviderList.add(defaultFuncProvider);
        }
    }

    public Object eval(String text, Map<String, Object> param) throws InterpreterException, ParserException {
        Object rtnValue = null;
        FieldRuleScriptParser parser = this.parseCache.get(text);
        if (parser == null) {
            parser = new FieldRuleScriptParser(text, this.namespaces, this.classMap);
            parser.functionDeclMap = this.funcDeclMap;
            long begin = System.currentTimeMillis();
            parser.parse();
            long end = System.currentTimeMillis();
            long cost = end - begin;
            if (cost > 1000L && log.isDebugEnabled()) {
                log.debug("FieldRuleInterpreter.eval  formulaStr:{}", (Object)text);
                log.debug("FieldRuleInterpreter.eval  cost:{} ms, {} s", (Object)cost, (Object)((double)cost / 1000.0));
            }
            this.parseCache.put(text, parser);
        }
        List<CodeStmt> stmtList = parser.stmtList;
        this.source = parser.source;
        if (stmtList.size() == 1 && stmtList.get(0) instanceof ExprStmt) {
            CodeExpr expr = ((ExprStmt)stmtList.get((int)0)).expr;
            rtnValue = this.evalExprInternal(expr, param);
        } else {
            rtnValue = this.evalBlockStmtList(stmtList, param, true);
        }
        if (rtnValue == NoneReturnValue.NoneReturn) {
            rtnValue = null;
        }
        if (rtnValue instanceof PrimitiveValue) {
            rtnValue = ((PrimitiveValue)rtnValue).getBoxValue();
        }
        Object[] keyArray = param.keySet().toArray();
        for (int i = 0; i < keyArray.length; ++i) {
            Object val = param.get(keyArray[i]);
            if (!(val instanceof PrimitiveValue)) continue;
            val = ((PrimitiveValue)val).getBoxValue();
            param.put((String)keyArray[i], val);
        }
        return rtnValue;
    }

    private Object evalBlockStmtList(List<CodeStmt> stmtList, Map<String, Object> param) throws InterpreterException {
        return this.evalBlockStmtList(stmtList, param, true);
    }

    private Object evalBlockStmtList(List<CodeStmt> stmtList, Map<String, Object> param, boolean initVarFlag) throws InterpreterException {
        Object rtnValue = NoneReturnValue.NoneReturn;
        ArrayList<String> localVarList = new ArrayList<String>();
        HashMap<String, Object> replacedVarMap = new HashMap<String, Object>();
        for (CodeStmt stmt : stmtList) {
            if (stmt instanceof VarDeclStmt) {
                VarDeclStmt varDeclStmt = (VarDeclStmt)stmt;
                for (VarDeclItem varItem : varDeclStmt.varDeclList) {
                    if (localVarList.contains(varItem.name)) {
                        throw (InterpreterException)new InterpreterException("local variant already declared. variant's name is '" + varItem.name + "'").setInfoId("LOCAL_VAR_ALREADY_DECLARED").addArg(varItem.name).addArg(stmt.toString()).setErrorLineCode(this.getSource());
                    }
                    localVarList.add(varItem.name);
                    if (param.containsKey(varItem.name)) {
                        replacedVarMap.put(varItem.name, param.get(varItem.name));
                    }
                    if (varItem.initExpr == null) {
                        if (initVarFlag) {
                            param.put(varItem.name, param.get(varItem.name));
                            continue;
                        }
                        param.put(varItem.name, null);
                        continue;
                    }
                    Object initValue = this.evalExprInternal(varItem.initExpr, param);
                    param.put(varItem.name, initValue);
                }
                continue;
            }
            rtnValue = this.evalStmt(stmt, param);
            if (rtnValue == NoneReturnValue.NoneReturn) continue;
            break;
        }
        for (int i = 0; i < localVarList.size(); ++i) {
            param.remove(localVarList.get(i));
        }
        for (Map.Entry entry : replacedVarMap.entrySet()) {
            param.put((String)entry.getKey(), entry.getValue());
        }
        return rtnValue;
    }

    public synchronized Object evalExpr(String text, Map<String, Object> param) throws InterpreterException, ParserException {
        Source s;
        Object rtnValue;
        if (param == null) {
            param = new HashMap<String, Object>();
        }
        if ((rtnValue = this.evalExprInternal(s = new Source(text), param)) instanceof PrimitiveValue) {
            rtnValue = ((PrimitiveValue)rtnValue).getBoxValue();
        }
        Object[] keyArray = param.keySet().toArray();
        for (int i = 0; i < keyArray.length; ++i) {
            Object val = param.get(keyArray[i]);
            if (!(val instanceof PrimitiveValue)) continue;
            val = ((PrimitiveValue)val).getBoxValue();
            param.put((String)keyArray[i], val);
        }
        if (rtnValue instanceof NoneReturnValue) {
            rtnValue = null;
        }
        return rtnValue;
    }

    public synchronized Object evalExpr(CodeExpr expr, Map<String, Object> param) throws InterpreterException {
        Object rtnValue;
        if (param == null) {
            param = new HashMap<String, Object>();
        }
        if ((rtnValue = this.evalExprInternal(expr, param)) instanceof PrimitiveValue) {
            rtnValue = ((PrimitiveValue)rtnValue).getBoxValue();
        }
        Object[] keyArray = param.keySet().toArray();
        for (int i = 0; i < keyArray.length; ++i) {
            Object val = param.get(keyArray[i]);
            if (!(val instanceof PrimitiveValue)) continue;
            val = ((PrimitiveValue)val).getBoxValue();
            param.put((String)keyArray[i], val);
        }
        if (rtnValue instanceof NoneReturnValue) {
            return null;
        }
        return rtnValue;
    }

    private Object evalExprInternal(Source source, Map<String, Object> param) throws InterpreterException, ParserException {
        Lexer lexer = new Lexer(source);
        TokenList tokList = new TokenList(lexer);
        ExprParser parser = new ExprParser(tokList, this.namespaces, this.classMap);
        ArrayList<CodeExpr> exprList = new ArrayList<CodeExpr>();
        parser.exprList(exprList);
        Object rtnValue = null;
        for (int i = 0; i < exprList.size(); ++i) {
            CodeExpr expr = (CodeExpr)exprList.get(i);
            this.typeCheck(expr, param);
            rtnValue = this.evalExprInternal(expr, param);
        }
        return rtnValue;
    }

    private void typeCheck(CodeExpr expr, Map<String, Object> param) {
        Class<?> exprClass = expr.getExprClass();
        if (exprClass != null) {
            return;
        }
        if (expr instanceof IdentifierExpr) {
            IdentifierExpr identExpr = (IdentifierExpr)expr;
            Object identObj = param.get(identExpr.value);
            if (identObj != null) {
                identExpr.setExprClass(identObj.getClass());
            }
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            this.typeCheck(binaryOpExpr.left, param);
            this.typeCheck(binaryOpExpr.right, param);
            if (binaryOpExpr.operator == 7 || binaryOpExpr.operator == 8 || binaryOpExpr.operator == 10 || binaryOpExpr.operator == 23 || binaryOpExpr.operator == 11 || binaryOpExpr.operator == 12 || binaryOpExpr.operator == 14 || binaryOpExpr.operator == 15) {
                binaryOpExpr.setExprClass(Boolean.TYPE);
                return;
            }
            Class<?> leftClass = binaryOpExpr.left.getExprClass();
            Class<?> rightClass = binaryOpExpr.right.getExprClass();
            if (leftClass != null && rightClass != null) {
                int leftNumber = this.getClassIdentNumber(leftClass);
                int rightNumber = this.getClassIdentNumber(rightClass);
                if (rightNumber > leftNumber) {
                    binaryOpExpr.setExprClass(rightClass);
                } else {
                    binaryOpExpr.setExprClass(leftClass);
                }
            }
        } else if (expr instanceof ConditionExpr) {
            ConditionExpr conditionExpr = (ConditionExpr)expr;
            if (conditionExpr.testExpr.getExprClass() != null) {
                conditionExpr.testExpr.setExprClass(Boolean.TYPE);
            }
            this.typeCheck(conditionExpr.trueExpr, param);
            this.typeCheck(conditionExpr.falseExpr, param);
            Class<?> leftClass = conditionExpr.trueExpr.getExprClass();
            Class<?> rightClass = conditionExpr.falseExpr.getExprClass();
            if (leftClass != null && rightClass != null) {
                int leftNumber = this.getClassIdentNumber(leftClass);
                int rightNumber = this.getClassIdentNumber(rightClass);
                if (rightNumber > leftNumber) {
                    conditionExpr.setExprClass(rightClass);
                } else {
                    conditionExpr.setExprClass(leftClass);
                }
            }
        }
    }

    private int getClassIdentNumber(Class<?> exprClass) {
        if (exprClass.equals(Byte.TYPE)) {
            return 1;
        }
        if (exprClass.equals(Byte.TYPE)) {
            return -1;
        }
        if (exprClass.equals(Short.TYPE)) {
            return 2;
        }
        if (exprClass.equals(Short.TYPE)) {
            return -2;
        }
        if (exprClass.equals(Integer.TYPE)) {
            return 3;
        }
        if (exprClass.equals(Integer.TYPE)) {
            return -3;
        }
        if (exprClass.equals(Long.TYPE)) {
            return 4;
        }
        if (exprClass.equals(Long.TYPE)) {
            return -4;
        }
        if (exprClass.equals(Float.TYPE)) {
            return 5;
        }
        if (exprClass.equals(Float.TYPE)) {
            return -5;
        }
        if (exprClass.equals(Double.TYPE)) {
            return 6;
        }
        if (exprClass.equals(Double.TYPE)) {
            return -6;
        }
        if (exprClass.equals(String.class)) {
            return 10;
        }
        return 0;
    }

    private Object evalStmt(CodeStmt stmt, Map<String, Object> param) throws InterpreterException {
        if (stmt == null) {
            return null;
        }
        if (stmt instanceof ExprStmt) {
            ExprStmt exprStmt = (ExprStmt)stmt;
            this.evalExprInternal(exprStmt.expr, param);
        } else if (stmt instanceof ExprListStmt) {
            ExprListStmt exprListStmt = (ExprListStmt)stmt;
            for (CodeExpr expr : exprListStmt.exprList) {
                this.evalExprInternal(expr, param);
            }
        } else {
            if (stmt instanceof ReturnStmt) {
                ReturnStmt rtnStmt = (ReturnStmt)stmt;
                return this.evalExprInternal(rtnStmt.expr, param);
            }
            if (stmt instanceof IfStmt) {
                IfStmt ifStmt = (IfStmt)stmt;
                Object testValue = this.evalExprInternal(ifStmt.testExpr, param);
                if (testValue instanceof PrimitiveValue) {
                    testValue = ((PrimitiveValue)testValue).getBoxValue();
                }
                boolean flag = false;
                Object rtnValue = NoneReturnValue.NoneReturn;
                if (testValue.equals(Boolean.TRUE)) {
                    rtnValue = this.evalBlockStmtList(ifStmt.trueStmtList, param);
                } else {
                    for (ElseIfItem elseIfItem : ifStmt.elseIfList) {
                        testValue = this.evalExprInternal(elseIfItem.testExpr, param);
                        if (testValue instanceof PrimitiveValue) {
                            testValue = ((PrimitiveValue)testValue).getBoxValue();
                        }
                        if (!testValue.equals(Boolean.TRUE)) continue;
                        rtnValue = this.evalBlockStmtList(elseIfItem.stmtList, param);
                        flag = true;
                    }
                    if (!flag) {
                        rtnValue = this.evalBlockStmtList(ifStmt.elseStmtList, param);
                    }
                }
                return rtnValue;
            }
            if (stmt instanceof BlockStmt) {
                BlockStmt blockStmt = (BlockStmt)stmt;
                return this.evalBlockStmtList(blockStmt.stmtList, param);
            }
            throw (InterpreterException)new InterpreterException("UNSUPPORT. stmt's class is : " + stmt.getClass().getName()).setInfoId("UNSUPPORTED_STATEMENT").addArg(stmt.getClass().getName()).addArg(stmt.toString()).setErrorLineCode(this.getSource());
        }
        return NoneReturnValue.NoneReturn;
    }

    private Object evalExprInternal(CodeExpr expr, Map<String, Object> param) throws InterpreterException {
        if (expr == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object rtnValue = null;
            if (expr instanceof BinaryOpExpr) {
                try {
                    rtnValue = this.evalBinaryOpExpr((BinaryOpExpr)expr, param);
                }
                catch (Exception ex) {
                    if (ex instanceof InterpreterException) {
                        throw ex;
                    }
                    this.doEvalOPError(ex, ((BinaryOpExpr)expr).operator, (BinaryOpExpr)expr);
                }
            } else if (expr instanceof IdentifierExpr) {
                rtnValue = this.evalIndentExpr((IdentifierExpr)expr, param);
            } else if (expr instanceof ConditionExpr) {
                rtnValue = this.evalConditionExpr((ConditionExpr)expr, param);
            } else if (expr instanceof PropertyExpr) {
                rtnValue = this.evalPropExpr((PropertyExpr)expr, param);
            } else if (expr instanceof MethodInvokeExpr) {
                rtnValue = this.evalMethodInvokeExpr((MethodInvokeExpr)expr, param);
            } else if (expr instanceof ObjectCreateExpr) {
                rtnValue = this.evalObjectCreateExpr((ObjectCreateExpr)expr, param);
            } else if (expr instanceof BoolExpr) {
                rtnValue = ((BoolExpr)expr).val ? PrimitiveBoolean.TRUE : PrimitiveBoolean.FALSE;
            } else if (expr instanceof CharExpr) {
                rtnValue = new PrimitiveCharacter(((CharExpr)expr).val);
            } else if (expr instanceof NullExpr) {
                rtnValue = null;
            } else if (expr instanceof IntExpr) {
                rtnValue = new PrimitiveInt(((IntExpr)expr).intValue());
            } else if (expr instanceof LongExpr) {
                rtnValue = new PrimitiveLong(((LongExpr)expr).longValue());
            } else {
                if (expr instanceof FloatExpr) {
                    return new PrimitiveFloat(((FloatExpr)expr).floatValue());
                }
                if (expr instanceof DoubleExpr) {
                    return new PrimitiveDouble(((DoubleExpr)expr).doubleValue());
                }
                if (expr instanceof BigDecimalExpr) {
                    return ((BigDecimalExpr)expr).value;
                }
                if (expr instanceof StringExpr) {
                    rtnValue = ((StringExpr)expr).getJavaString();
                } else if (expr instanceof UnaryExpr) {
                    rtnValue = this.evalUnaryExpr((UnaryExpr)expr, param);
                } else if (expr instanceof ArrayIndexerExpr) {
                    rtnValue = this.evalArrayIndexerExpr((ArrayIndexerExpr)expr, param);
                } else if (expr instanceof VectorCreateExpr) {
                    rtnValue = this.evalVectorCreateExpr((VectorCreateExpr)expr, param);
                } else if (expr instanceof NewFunctionExpr) {
                    rtnValue = this.evalNewFuncExpr((NewFunctionExpr)expr, param);
                } else {
                    throw (InterpreterException)new InterpreterException("UNSUPPORT, expr class : " + expr.getClass().getName(), expr).setInfoId("UNSUPPORTED_STATEMENT").addArg(expr.getClass().getName()).addArg(expr.toString()).setErrorLineCode(this.getSource());
                }
            }
            return rtnValue;
        }
        catch (Exception ex) {
            if (ex instanceof InterpreterException) {
                if (((InterpreterException)((Object)ex)).getErrorLineNum() == 0 && expr.position != null) {
                    ((InterpreterException)((Object)ex)).setErrorLineNum(expr.position.beginLine);
                    ((InterpreterException)((Object)ex)).setErrorLineCode(this.getSource());
                }
                throw (InterpreterException)((Object)ex);
            }
            throw (InterpreterException)new InterpreterException(ex.toString(), expr, ex).setErrorLineCode(this.getSource());
        }
    }

    private Object evalBinaryOpExpr(BinaryOpExpr expr, Map<String, Object> param) throws InterpreterException {
        Object rtnVal;
        if (expr.operator == 2) {
            return this.assign(expr.left, expr.right, param);
        }
        if (expr.operator == 28) {
            BinaryOpExpr addExpr = new BinaryOpExpr(expr.position);
            addExpr.left = expr.left;
            addExpr.operator = 0;
            addExpr.right = expr.right;
            return this.assign(expr.left, addExpr, param);
        }
        if (expr.operator == 29) {
            BinaryOpExpr subExpr = new BinaryOpExpr(expr.position);
            subExpr.left = expr.left;
            subExpr.operator = 26;
            subExpr.right = expr.right;
            return this.assign(expr.left, subExpr, param);
        }
        if (expr.operator == 30) {
            BinaryOpExpr mulExpr = new BinaryOpExpr(expr.position);
            mulExpr.left = expr.left;
            mulExpr.operator = 22;
            mulExpr.right = expr.right;
            return this.assign(expr.left, mulExpr, param);
        }
        if (expr.operator == 31) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 9;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, param);
        }
        if (expr.operator == 32) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 21;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, param);
        }
        if (expr.operator == 33) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 17;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, param);
        }
        if (expr.operator == 34) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 19;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, param);
        }
        if (expr.operator == 35) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 27;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, param);
        }
        if (expr.operator == 36) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 3;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, param);
        }
        if (expr.operator == 37) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 5;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, param);
        }
        if (expr.operator == 38) {
            BinaryOpExpr divExpr = new BinaryOpExpr(expr.position);
            divExpr.left = expr.left;
            divExpr.operator = 6;
            divExpr.right = expr.right;
            return this.assign(expr.left, divExpr, param);
        }
        Object leftValue = this.evalExprInternal(expr.left, param);
        if (expr.operator == 7) {
            if (leftValue instanceof Boolean && !((Boolean)leftValue).booleanValue()) {
                return PrimitiveBoolean.FALSE;
            }
            if (leftValue instanceof PrimitiveBoolean && !((PrimitiveBoolean)leftValue).getValue()) {
                return PrimitiveBoolean.FALSE;
            }
        } else if (expr.operator == 8) {
            if (leftValue instanceof Boolean && ((Boolean)leftValue).booleanValue()) {
                return PrimitiveBoolean.TRUE;
            }
            if (leftValue instanceof PrimitiveBoolean && ((PrimitiveBoolean)leftValue).getValue()) {
                return PrimitiveBoolean.TRUE;
            }
        }
        Object rightValue = this.evalExprInternal(expr.right, param);
        switch (expr.operator) {
            case 0: {
                rtnVal = TypeUtils.add(leftValue, rightValue);
                break;
            }
            case 9: {
                rtnVal = TypeUtils.div(leftValue, rightValue);
                break;
            }
            case 11: {
                boolean boolVal = TypeUtils.greaterThan(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(boolVal);
                break;
            }
            case 12: {
                boolean boolVal = TypeUtils.greaterThanOrEqual(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(boolVal);
                break;
            }
            case 14: {
                boolean boolVal = TypeUtils.lessThan(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(boolVal);
                break;
            }
            case 15: {
                boolean boolVal = TypeUtils.lessThanOrEqual(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(boolVal);
                break;
            }
            case 10: {
                boolean boolVal = TypeUtils.equal(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(boolVal);
                break;
            }
            case 23: {
                boolean boolVal = TypeUtils.equal(leftValue, rightValue);
                rtnVal = PrimitiveBoolean.getPrimitiveBoolean(!boolVal);
                break;
            }
            case 22: {
                rtnVal = TypeUtils.multi(leftValue, rightValue);
                break;
            }
            case 26: {
                rtnVal = TypeUtils.sub(leftValue, rightValue);
                break;
            }
            case 13: {
                rtnVal = TypeUtils.evalInstanceOf(leftValue, rightValue);
                break;
            }
            case 3: {
                rtnVal = TypeUtils.bitwiseAnd(leftValue, rightValue);
                break;
            }
            case 5: {
                rtnVal = TypeUtils.bitwiseOr(leftValue, rightValue);
                break;
            }
            case 6: {
                rtnVal = TypeUtils.bitwiseXor(leftValue, rightValue);
                break;
            }
            case 17: {
                rtnVal = TypeUtils.leftShift(leftValue, rightValue);
                break;
            }
            case 19: {
                rtnVal = TypeUtils.rightShift(leftValue, rightValue);
                break;
            }
            case 27: {
                rtnVal = TypeUtils.rightUnsignShift(leftValue, rightValue);
                break;
            }
            case 21: {
                rtnVal = TypeUtils.mod(leftValue, rightValue);
                break;
            }
            case 7: {
                rtnVal = TypeUtils.booleanAnd(leftValue, rightValue);
                break;
            }
            case 8: {
                rtnVal = TypeUtils.booleanOr(leftValue, rightValue);
                break;
            }
            default: {
                throw new InterpreterException("Unsupported operator!");
            }
        }
        return rtnVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object assign(CodeExpr left, CodeExpr right, Map<String, Object> param) throws InterpreterException {
        Object rightValue = this.evalExprInternal(right, param);
        if (left instanceof IdentifierExpr) {
            IdentifierExpr identExpr = (IdentifierExpr)left;
            String ident = identExpr.value;
            param.put(ident, rightValue);
            return rightValue;
        } else if (left instanceof ArrayIndexerExpr) {
            ArrayIndexerExpr arrayIndexerExpr = (ArrayIndexerExpr)left;
            Object targetObj = this.evalExprInternal(arrayIndexerExpr.targetObjExpr, param);
            Object indexerObj = this.evalExprInternal(arrayIndexerExpr.indexExpr, param);
            int index = ((Number)indexerObj).intValue();
            Object value = rightValue instanceof PrimitiveValue ? ((PrimitiveValue)rightValue).getBoxValue() : rightValue;
            if (targetObj.getClass().isArray()) {
                Array.set(targetObj, index, value);
                return rightValue;
            } else {
                if (!(targetObj instanceof List)) throw (InterpreterException)new InterpreterException("assign to array error. target object is not an array or a list", left).setInfoId("ASSIGN_ARRAY_TO_NO_ARRAY").addArg(left.toString()).addArg(right.toString()).addArg(this.getContext(param)).setErrorLineCode(this.getSource());
                ((List)targetObj).set(index, value);
            }
            return rightValue;
        } else {
            if (!(left instanceof PropertyExpr)) return rightValue;
            PropertyExpr propExpr = (PropertyExpr)left;
            Object ownerValue = this.evalExprInternal(propExpr.owner, param);
            Class<?> type = ownerValue.getClass();
            Field field = TypeUtils.findField(type, propExpr.propName);
            if (rightValue instanceof PrimitiveValue) {
                rightValue = ((PrimitiveValue)rightValue).getBoxValue();
            }
            if (field != null) {
                try {
                    field.set(ownerValue, rightValue);
                    return rightValue;
                }
                catch (IllegalArgumentException e) {
                    throw (InterpreterException)new InterpreterException("IllegalArgumentException", propExpr, e).setErrorLineCode(this.getSource());
                }
                catch (IllegalAccessException e) {
                    throw (InterpreterException)new InterpreterException("IllegalAccessException", propExpr, e).setErrorLineCode(this.getSource());
                }
            } else {
                Method method = FieldRuleFormulaUtil.findSetMethod(type, propExpr.propName);
                if (method != null) {
                    this.invokeMethod(ownerValue, method, new Object[]{rightValue});
                    return rightValue;
                } else {
                    if (!this.isObjectValue(ownerValue)) throw (InterpreterException)new InterpreterException("assign error.", left).setErrorLineCode(this.getSource());
                    this.setObjectValuePropValue(ownerValue, propExpr.propName, rightValue);
                }
            }
        }
        return rightValue;
    }

    private void doEvalOPError(Throwable ex, int op, BinaryOpExpr expr) throws InterpreterException {
        String infoId = null;
        infoId = op == 3 || op == 4 || op == 36 || op == 5 || op == 37 || op == 6 || op == 38 ? "bitwise_OP_ERROR" : (op == 7 || op == 8 ? "BOOL_OP_ERROR" : (op == 19 || op == 34 || op == 17 || op == 33 ? "SHIFT_OP_ERROR" : "EXEC_OP_ERROR"));
        InterpreterException ne = (InterpreterException)new InterpreterException("invoke operator error", expr, ex).setInfoId(infoId).addArg(BinaryOpType.getName(expr.operator)).addArg(expr.left.toString()).addArg(expr.left.typename()).addArg(expr.right.toString()).addArg(expr.right.typename()).setErrorLineCode(this.getSource());
        throw ne;
    }

    private Object evalIndentExpr(IdentifierExpr expr, Map<String, Object> param) {
        Class<?> rtnValue = null;
        String ident = expr.value;
        rtnValue = param.containsKey(ident) ? param.get(expr.value) : TypeUtils.classForName(this.namespaces, this.classMap, ident);
        return rtnValue;
    }

    private Object evalConditionExpr(ConditionExpr expr, Map<String, Object> param) throws InterpreterException {
        Object rtnValue = this.evalExprInternal(expr.testExpr, param);
        if (rtnValue instanceof Boolean) {
            if (rtnValue.equals(Boolean.TRUE)) {
                return this.evalExprInternal(expr.trueExpr, param);
            }
            return this.evalExprInternal(expr.falseExpr, param);
        }
        if (rtnValue instanceof PrimitiveBoolean) {
            if (rtnValue.equals(PrimitiveBoolean.TRUE)) {
                return this.evalExprInternal(expr.trueExpr, param);
            }
            return this.evalExprInternal(expr.falseExpr, param);
        }
        throw (InterpreterException)new InterpreterException("expr result is not boolean, it's :" + expr != null ? expr.getClass().getName() : "null", expr).setErrorLineCode(this.getSource());
    }

    private Object evalPropExpr(PropertyExpr propExpr, Map<String, Object> param) throws InterpreterException {
        if (param.containsKey(propExpr.toString())) {
            return param.get(propExpr.toString());
        }
        String ownerExprStr = propExpr.owner.toString();
        Class<?> ownerValue = TypeUtils.classForName(this.namespaces, this.classMap, ownerExprStr);
        if (ownerValue == null) {
            ownerValue = this.evalExprInternal(propExpr.owner, param);
        }
        if (ownerValue == null) {
            if (!this.properyExprOwnerNullIgore) {
                log.error("properExpr's owner is null. expr is : {}", (Object)propExpr);
                throw (InterpreterException)new InterpreterException("properExpr's owner is null. expr is : " + propExpr.toString(), propExpr).setInfoId("EVAL_PROP_OWNER_NULL").addArg(ownerExprStr).addArg(propExpr).setErrorLineCode(this.getSource());
            }
            return null;
        }
        Class<?> type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
        if (type.isArray() && propExpr.propName.equals("length")) {
            return new PrimitiveInt(Array.getLength(ownerValue));
        }
        this.lazyLoadGetProperty(ownerValue, propExpr.propName, propExpr);
        Field field = null;
        String key = type.getName() + METHOD_GET + propExpr.propName;
        Method method = this.methodCache.get(key);
        if (method != null) {
            return this.invokeMethod(ownerValue, method, null);
        }
        method = FieldRuleFormulaUtil.findGetMethod(type, propExpr.propName);
        this.methodCache.put(key, method);
        if (method != null) {
            return this.invokeMethod(ownerValue, method, null);
        }
        if (this.isObjectValue(ownerValue)) {
            if (this.isObjectValueContainPropName(ownerValue, propExpr.propName)) {
                return this.getObjectValuePropValueByName(ownerValue, propExpr.propName);
            }
            return this.lazyLoadGetProperty(ownerValue, propExpr.propName, propExpr);
        }
        if (this.isObjectCollection(ownerValue)) {
            if (this.getObjectCollectionSize(ownerValue) <= 0) {
                return null;
            }
            int index = null != param.get("entrys#Index") ? (Integer)param.get("entrys#Index") : 0;
            if ((ownerValue = this.getObjectCollectionChildByIndex(ownerValue, index)) == null) {
                throw new NullPointerException("properExpr's owner is null.");
            }
            type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
            this.lazyLoadGetProperty(ownerValue, propExpr.propName, propExpr);
            key = type.getName() + METHOD_GET + propExpr.propName;
            method = this.methodCache.get(key);
            if (method != null) {
                return this.invokeMethod(ownerValue, method, null);
            }
            method = FieldRuleFormulaUtil.findGetMethod(type, propExpr.propName);
            this.methodCache.put(key, method);
            if (method != null) {
                return this.invokeMethod(ownerValue, method, null);
            }
            if (this.isObjectValue(ownerValue)) {
                PropertyExpr itemPropExpr = new PropertyExpr(propExpr.position);
                itemPropExpr.owner = new IdentifierExpr(propExpr.position.nullStart(), "item");
                itemPropExpr.propName = propExpr.propName;
                HashMap<String, Object> itemCtx = new HashMap<String, Object>();
                itemCtx.put("item", ownerValue);
                return this.evalPropExpr(itemPropExpr, itemCtx);
            }
            field = TypeUtils.findField(type, propExpr.propName);
            if (field != null) {
                try {
                    return field.get(ownerValue);
                }
                catch (Exception e) {
                    this.doWitdInvokeException(e, ownerValue, propExpr.propName, null, param);
                }
            }
            throw (InterpreterException)new InterpreterException("eval properExpr error. not such field or getMethod.", propExpr).setInfoId("EVAL_PROP_NO_PROP").addArg(ownerValue).addArg(ownerValue.getClass()).addArg(propExpr).addArg(this.getContext(param)).setErrorLineCode(this.getSource());
        }
        field = TypeUtils.findField(type, propExpr.propName);
        if (field != null) {
            try {
                field.setAccessible(true);
                return field.get(ownerValue);
            }
            catch (Exception e) {
                this.doWitdInvokeException(e, ownerValue, propExpr.propName, null, param);
            }
        }
        throw (InterpreterException)new InterpreterException("expr is : " + propExpr.toString(), propExpr, null).setErrorLineCode(this.getSource());
    }

    private Object evalMethodInvokeExpr(MethodInvokeExpr methodInvokeExpr, Map<String, Object> context) throws InterpreterException {
        if (this.isInternalFunction(methodInvokeExpr)) {
            HashMap<String, Object> tempCont = new HashMap<String, Object>();
            tempCont.putAll(context);
            return this.evalInternalFunction(methodInvokeExpr, tempCont);
        }
        long t = System.currentTimeMillis();
        Class<?> ownerValue = null;
        if (methodInvokeExpr.owner != null) {
            if (methodInvokeExpr.owner instanceof PropertyExpr) {
                String ownerExprStr = methodInvokeExpr.owner.toString();
                ownerValue = TypeUtils.classForName(this.namespaces, this.classMap, ownerExprStr);
            }
            if (ownerValue == null) {
                ownerValue = this.evalExprInternal(methodInvokeExpr.owner, context);
            }
        }
        if (ownerValue == null) {
            Function funcObj = this.funcDeclMap.get(methodInvokeExpr.methodName);
            if (funcObj != null) {
                return this.evalFunction(funcObj, methodInvokeExpr, context);
            }
            Object contextVal = context.get(methodInvokeExpr.methodName);
            Object returnObj = null;
            if (contextVal instanceof Function) {
                returnObj = this.evalFunction((Function)contextVal, methodInvokeExpr, context);
            } else if (contextVal instanceof FunctionObject) {
                returnObj = this.evalFunctionObject((FunctionObject)contextVal, methodInvokeExpr, context);
            }
            if (returnObj != null) {
                log.debug("[evalFunction] MethodName: {} + COST: {}", (Object)methodInvokeExpr.methodName, (Object)(System.currentTimeMillis() - t));
                return returnObj;
            }
            Object cacheId = context.get("cacheId");
            for (IFunctionProvider funcProvider : this.publicFuncProviderList) {
                if (!funcProvider.existFunction(methodInvokeExpr.methodName)) continue;
                ArrayList<Object> pramList = new ArrayList<Object>(methodInvokeExpr.paramList.size());
                int len = methodInvokeExpr.paramList.size();
                if (cacheId instanceof String && methodInvokeExpr.methodName.equalsIgnoreCase("__BOTGetProperty")) {
                    pramList.add(cacheId);
                }
                for (int i = 0; i < len; ++i) {
                    CodeExpr pramExpr = methodInvokeExpr.paramList.get(i);
                    Object pramVal = this.evalExprInternal(pramExpr, context);
                    if (pramVal instanceof PrimitiveValue) {
                        pramVal = ((PrimitiveValue)pramVal).getBoxValue();
                    }
                    pramList.add(pramVal);
                }
                try {
                    Object obj = funcProvider.evalFunction(methodInvokeExpr.methodName, pramList);
                    log.debug("[evalFunction] MethodName:" + methodInvokeExpr.methodName + " COST:" + (System.currentTimeMillis() - t));
                    return obj;
                }
                catch (Exception e) {
                    throw (InterpreterException)new InterpreterException("eval function provider error. " + methodInvokeExpr.toString(), methodInvokeExpr, e).setInfoId("EXEC_PROVIDER_ERROR").addArg(funcProvider.getClass()).addArg(methodInvokeExpr.methodName).addArg(e.getMessage()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                }
            }
            String msg = "MethodInvokeExpr's owner is null. method name is : '" + methodInvokeExpr.methodName + "'";
            InterpreterException ex = (InterpreterException)new InterpreterException(msg, methodInvokeExpr).setErrorLineCode(this.getSource());
            throw ex;
        }
        Object[] pramValueArray = new Object[methodInvokeExpr.paramList.size()];
        Class[] pramClassArray = new Class[pramValueArray.length];
        for (int i = 0; i < pramValueArray.length; ++i) {
            pramValueArray[i] = this.evalExprInternal(methodInvokeExpr.paramList.get(i), context);
            if (pramValueArray[i] instanceof PrimitiveValue) {
                pramClassArray[i] = ((PrimitiveValue)pramValueArray[i]).getUnBoxType();
                pramValueArray[i] = ((PrimitiveValue)pramValueArray[i]).getBoxValue();
                continue;
            }
            if (pramValueArray[i] == null) continue;
            pramClassArray[i] = pramValueArray[i].getClass();
        }
        Class<?> type = ownerValue instanceof Class ? ownerValue : ownerValue.getClass();
        Method method = this.findMethod(type, methodInvokeExpr.methodName, pramClassArray);
        if (method == null) {
            throw (InterpreterException)new InterpreterException("method not found. method name is: " + methodInvokeExpr.methodName, methodInvokeExpr).setInfoId("EXEC_METHOD_NotFound").addArg(type).addArg(methodInvokeExpr.methodName).addArg(pramClassArray).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
        }
        Object rtnVal = this.invokMethod(method, ownerValue, pramValueArray);
        log.debug("[evalFunction] MethodName:" + methodInvokeExpr.methodName + " COST:" + (System.currentTimeMillis() - t));
        return rtnVal;
    }

    private Object evalFunctionObject(FunctionObject funcObjc, MethodInvokeExpr methodInvokeExpr, Map<String, Object> context) throws InterpreterException {
        HashMap<String, Object> evalContext = new HashMap<String, Object>(funcObjc.context);
        Object[] pramValueArray = new Object[methodInvokeExpr.paramList.size()];
        for (int i = 0; i < pramValueArray.length; ++i) {
            pramValueArray[i] = this.evalExprInternal(methodInvokeExpr.paramList.get(i), context);
            String argName = funcObjc.functionExpr.function.paramList.get(i);
            evalContext.put(argName, pramValueArray[i]);
        }
        Object rtnValue = this.evalFunction(funcObjc.functionExpr.function, methodInvokeExpr, evalContext);
        return rtnValue;
    }

    private Method findMethod(Class<?> c, String methodName, Class<?>[] pramClassArray) throws InterpreterException {
        Method[] methodArray = c.getMethods();
        ArrayList<Method> listByName = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(methodName)) continue;
            listByName.add(methodArray[i]);
        }
        if (listByName.isEmpty()) {
            return null;
        }
        if (listByName.size() == 1) {
            return (Method)listByName.get(0);
        }
        ArrayList<Method> listByLength = new ArrayList<Method>(listByName.size());
        for (int i = 0; i < listByName.size(); ++i) {
            Method method = (Method)listByName.get(i);
            Class<?>[] pramTypeArray = method.getParameterTypes();
            if (pramTypeArray.length != pramClassArray.length) continue;
            listByLength.add(method);
        }
        if (listByLength.isEmpty()) {
            return null;
        }
        if (listByLength.size() == 1) {
            return (Method)listByLength.get(0);
        }
        Method rtnValue = ReflectionUtils.getMethod(c, methodName, pramClassArray);
        if (rtnValue != null) {
            return rtnValue;
        }
        return FieldRuleInterpreter.findMethod(methodName, listByLength, pramClassArray);
    }

    private static Method findMethod(String methodName, List<Method> methodList, Class<?>[] pramClassArray) throws InterpreterException {
        Method method;
        int i;
        ArrayList<Method> resultList = new ArrayList<Method>();
        for (i = 0; i < methodList.size(); ++i) {
            method = methodList.get(i);
            boolean flag = true;
            for (int j = 0; j < pramClassArray.length; ++j) {
                Class<?> methodPramType = method.getParameterTypes()[j];
                if (pramClassArray[j] == null || methodPramType.isAssignableFrom(pramClassArray[j])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            resultList.add(method);
        }
        if (resultList.size() == 1) {
            return (Method)resultList.get(0);
        }
        if (resultList.isEmpty()) {
            if (pramClassArray.length == 1) {
                for (i = 0; i < methodList.size(); ++i) {
                    method = methodList.get(i);
                    if (!method.getParameterTypes()[0].equals(String.class)) continue;
                    return method;
                }
            }
            throw (InterpreterException)new InterpreterException("method not found. method is : " + methodName).setInfoId("EXEC_METHOD_NotFound").addArg(methodName).addArg("...").addArg(pramClassArray).addArg("...");
        }
        ArrayList<Method> fList = new ArrayList<Method>();
        block3: for (int mi = 0; mi < resultList.size(); ++mi) {
            Class<?> tCls;
            Method m = (Method)resultList.get(mi);
            for (int pi = 0; pi < pramClassArray.length && (tCls = pramClassArray[pi]) != null; ++pi) {
                if (tCls != m.getParameterTypes()[pi]) continue;
                fList.add(m);
                continue block3;
            }
        }
        if (fList.size() == 1) {
            return (Method)fList.get(0);
        }
        if (fList.isEmpty()) {
            fList = resultList;
        }
        for (int pi = 0; pi < pramClassArray.length; ++pi) {
            boolean breakMethod = false;
            Method method2 = null;
            for (int mio = 0; mio < fList.size() - 1; ++mio) {
                Class<?> cls = ((Method)fList.get(mio)).getParameterTypes()[pi];
                method2 = (Method)fList.get(mio);
                for (int mi = mio + 1; mi < fList.size(); ++mi) {
                    Class<?> aCls = ((Method)fList.get(mi)).getParameterTypes()[pi];
                    if (cls == aCls) continue;
                    if (cls.isAssignableFrom(aCls)) {
                        cls = aCls;
                        method2 = (Method)fList.get(mi);
                        continue;
                    }
                    if (aCls.isAssignableFrom(cls)) continue;
                    breakMethod = true;
                    method2 = null;
                    break;
                }
                if (breakMethod) break;
            }
            if (method2 == null) continue;
            return method2;
        }
        throw (InterpreterException)new InterpreterException("multi method found. method is : " + methodName).setInfoId("EXEC_METHOD_FoundMulti").addArg("...").addArg(methodName).addArg(pramClassArray).addArg("...");
    }

    private Object invokMethod(Method method, Object ownerObj, Object[] pramValueArray) throws InterpreterException {
        Class<?>[] pramClassArray = method.getParameterTypes();
        Object[] objArray = new Object[pramClassArray.length];
        for (int i = 0; i < pramClassArray.length; ++i) {
            objArray[i] = i >= pramValueArray.length || pramValueArray[i] == null ? null : (pramClassArray[i].isInstance(pramValueArray[i]) ? pramValueArray[i] : TypeUtils.castObject(pramClassArray[i], pramValueArray[i]));
        }
        return this.invokeMethod(ownerObj, method, objArray);
    }

    private Object evalArrayCreate(ObjectCreateExpr expr, Map<String, Object> param) throws InterpreterException {
        int arrayLength;
        char ch;
        String typeName = expr.objType;
        Class<?> arrayType = TypeUtils.classForName(this.namespaces, this.classMap, typeName);
        if (arrayType == null) {
            throw (InterpreterException)new InterpreterException("ClassNotFoundException, " + typeName, expr).setInfoId("ARRAY_CREATE_NO_CLS").addArg(expr.toString()).addArg(typeName).setErrorLineCode(this.getSource());
        }
        Class<?> componentType = arrayType.getComponentType();
        int dim = 0;
        for (int i = 0; i < typeName.length() && (ch = typeName.charAt(i)) == '['; ++i) {
            ++dim;
        }
        if (dim > 1) {
            throw new InterpreterException("TODO", expr);
        }
        if (expr.paramList.isEmpty()) {
            arrayLength = expr.initExprList.size();
        } else {
            CodeExpr pramExpr = expr.paramList.get(0);
            Object pramValue = this.evalExprInternal(pramExpr, param);
            if (pramValue instanceof PrimitiveValue) {
                pramValue = ((PrimitiveValue)pramValue).getBoxValue();
            }
            arrayLength = ((Number)pramValue).intValue();
        }
        Object rtnValue = Array.newInstance(componentType, arrayLength);
        for (int i = 0; i < expr.initExprList.size(); ++i) {
            CodeExpr itemExpr = expr.initExprList.get(i);
            Object itemValue = this.evalExprInternal(itemExpr, param);
            if (itemValue instanceof PrimitiveValue) {
                itemValue = ((PrimitiveValue)itemValue).getBoxValue();
            }
            Array.set(rtnValue, i, itemValue);
        }
        return rtnValue;
    }

    private Object evalObjectCreateExpr(ObjectCreateExpr expr, Map<String, Object> param) throws InterpreterException {
        Object rtnValue;
        String typeName = expr.objType;
        if (typeName.startsWith("[")) {
            return this.evalArrayCreate(expr, param);
        }
        Class<?> type = TypeUtils.classForName(this.namespaces, this.classMap, typeName);
        if (type == null) {
            throw (InterpreterException)new InterpreterException("ClassNotFoundException, " + typeName, expr).setInfoId("OBJECT_CREATE_NO_CLS").addArg(expr.toString()).addArg(typeName).setErrorLineCode(this.getSource());
        }
        Object[] pramValueArray = new Object[expr.paramList.size()];
        Class[] pramClassArray = new Class[pramValueArray.length];
        for (int i = 0; i < pramValueArray.length; ++i) {
            pramValueArray[i] = this.evalExprInternal(expr.paramList.get(i), param);
            if (pramValueArray[i] instanceof PrimitiveValue) {
                pramClassArray[i] = ((PrimitiveValue)pramValueArray[i]).getUnBoxType();
                pramValueArray[i] = ((PrimitiveValue)pramValueArray[i]).getBoxValue();
                continue;
            }
            pramClassArray[i] = pramValueArray[i].getClass();
        }
        Constructor<?> constructor = null;
        constructor = ReflectionUtils.getConstructor(type, pramClassArray);
        if (constructor == null) {
            throw (InterpreterException)new InterpreterException("not match constructor. " + type.getName(), expr).setInfoId("OBJECT_CREATE_NO_CONSTRUCTOR").addArg(expr.toString()).addArg(type.getName()).setErrorLineCode(this.getSource());
        }
        try {
            rtnValue = constructor.newInstance(pramValueArray);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw (InterpreterException)new InterpreterException("object new instance error", e2).setInfoId("OBJECT_construct_error").addArg(expr.toString()).addArg(constructor.getName()).addArg(e2.getMessage()).addArg(this.getContext(param)).setErrorLineCode(this.getSource());
        }
        return rtnValue;
    }

    private String getContext(Map<String, Object> param) {
        return "Context:=" + ToString.toString(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethod(Object ownerObj, Method method, Object[] params) throws InterpreterException {
        Object rtnObj;
        block12: {
            rtnObj = null;
            try {
                if (Modifier.isStatic(method.getModifiers())) {
                    rtnObj = FieldRuleFormulaUtil.evalJavaMethod(null, method, params);
                    break block12;
                }
                if (method.getName().equals("notify") || method.getName().equals("notifyAll") || method.getName().equals("wait")) {
                    Object object = ownerObj;
                    synchronized (object) {
                        rtnObj = FieldRuleFormulaUtil.evalJavaMethod(ownerObj, method, params);
                        break block12;
                    }
                }
                if (this.synchronizedCallMethod) {
                    Object object = ownerObj;
                    synchronized (object) {
                        rtnObj = FieldRuleFormulaUtil.evalJavaMethod(ownerObj, method, params);
                    }
                } else {
                    rtnObj = FieldRuleFormulaUtil.evalJavaMethod(ownerObj, method, params);
                }
                this.lazyLoadFileValue(rtnObj);
            }
            catch (Exception e) {
                this.doWitdInvokeException(e, ownerObj, method.getName(), params, null);
            }
        }
        return rtnObj;
    }

    private void doWitdInvokeException(Throwable ex, Object ownerObj, String methodName, Object objArray, Map<String, Object> context) throws InterpreterException {
        Throwable ex1 = ex;
        if (ex instanceof InvocationTargetException) {
            ex1 = ((InvocationTargetException)ex).getTargetException();
        }
        if (ex1 instanceof InterpreterException) {
            throw (InterpreterException)((Object)ex1);
        }
        String infoId = null;
        if (ex instanceof IllegalArgumentException) {
            infoId = "EXEC_METHOD_IllegalArgument";
        } else if (ex instanceof IllegalAccessException) {
            infoId = "EXEC_METHOD_IllegalAccess";
        } else if (ex instanceof InvocationTargetException) {
            infoId = "EXEC_METHOD_InvocationTarget";
        }
        InterpreterException ne = (InterpreterException)new InterpreterException("invoke method error", ex).setInfoId(infoId).addArg(ownerObj).addArg(methodName).addArg(objArray).addArg(this.getContext(context)).addArg(ex.getMessage()).setErrorLineCode(this.getSource());
        if (ex instanceof InvocationTargetException && ne.getOrigException() == null) {
            InvocationTargetException ite = (InvocationTargetException)ex;
            ne.setOrigException(ite.getCause());
        }
        throw ne;
    }

    private FunctionObject evalNewFuncExpr(NewFunctionExpr expr, Map<String, Object> context) {
        return new FunctionObject(expr, context);
    }

    private Object evalVectorCreateExpr(VectorCreateExpr expr, Map<String, Object> context) throws InterpreterException {
        ArrayList<Object> rtnValue = new ArrayList<Object>();
        for (CodeExpr pramExpr : expr.paramList) {
            Object pramVal = this.evalExprInternal(pramExpr, context);
            rtnValue.add(pramVal);
        }
        return rtnValue;
    }

    private Object evalArrayIndexerExpr(ArrayIndexerExpr expr, Map<String, Object> context) throws InterpreterException {
        Object targetObj = this.evalExprInternal(expr.targetObjExpr, context);
        Object indexerObj = this.evalExprInternal(expr.indexExpr, context);
        int index = ((Number)indexerObj).intValue();
        if (targetObj.getClass().isArray()) {
            return Array.get(targetObj, index);
        }
        if (targetObj instanceof List) {
            return ((List)targetObj).get(index);
        }
        if (this.isObjectCollection(targetObj)) {
            return this.getObjectCollectionChildByIndex(targetObj, index);
        }
        throw (InterpreterException)new InterpreterException("assign to array error. target must be array or list or IObjectCollection", expr).setInfoId("INDEX_EXPR_ERROR").addArg(expr.toString()).addArg(targetObj.toString()).addArg(targetObj.getClass().getName()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
    }

    private Object evalUnaryExpr(UnaryExpr unaryExpr, Map<String, Object> context) throws InterpreterException {
        if (unaryExpr.operator == 1) {
            return this.evalExprInternal(unaryExpr.expr, context);
        }
        if (unaryExpr.operator == 3) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            rtnValue = TypeUtils.add(rtnValue, new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException("Systax Err.Can't find indentifier in context.", identExpr).setInfoId("SELFIncrement_NO_IDENTIFIER").addArg(unaryExpr.toString()).addArg(identExpr.toString()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException("Systax Err. The expression is not an Identifier.", unaryExpr.expr).setInfoId("SELFIncrement_NOT_IDENTIFIER").addArg(unaryExpr.toString()).addArg(unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, rtnValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 4) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            Object postValue = TypeUtils.add(rtnValue, new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException("Systax Err.Can't find indentifier in context.", identExpr).setInfoId("SELFIncrement_NO_IDENTIFIER").addArg(unaryExpr.toString()).addArg(identExpr.toString()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException("Systax Err. The expression is not an Identifier.", unaryExpr.expr).setInfoId("SELFIncrement_NOT_IDENTIFIER").addArg(unaryExpr.toString()).addArg(unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, postValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 5) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            rtnValue = TypeUtils.sub(rtnValue, new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException("Systax Err.Can't find indentifier in context.", identExpr).setInfoId("SELFDecrement_NO_IDENTIFIER").addArg(unaryExpr.toString()).addArg(identExpr.toString()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException("Systax Err. The expression is not an Identifier.", unaryExpr.expr).setInfoId("SELFDecrement_NOT_IDENTIFIER").addArg(unaryExpr.toString()).addArg(unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, rtnValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 6) {
            IdentifierExpr identExpr;
            Object rtnValue = this.evalExprInternal(unaryExpr.expr, context);
            Object postValue = TypeUtils.sub(rtnValue, new PrimitiveInt(1));
            if (unaryExpr.expr instanceof IdentifierExpr) {
                identExpr = (IdentifierExpr)unaryExpr.expr;
                if (!context.containsKey(identExpr.value)) {
                    throw (InterpreterException)new InterpreterException("Systax Err.Can't find indentifier in context.", identExpr).setInfoId("SELFDecrement_NO_IDENTIFIER").addArg(unaryExpr.toString()).addArg(identExpr.toString()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
                }
            } else {
                throw (InterpreterException)new InterpreterException("Systax Err. The expression is not an Identifier.", unaryExpr.expr).setInfoId("SELFDecrement_NOT_IDENTIFIER").addArg(unaryExpr.toString()).addArg(unaryExpr.expr.toString()).setErrorLineCode(this.getSource());
            }
            context.put(identExpr.value, postValue);
            return rtnValue;
        }
        if (unaryExpr.operator == 7) {
            Object exprVal = this.evalExprInternal(unaryExpr.expr, context);
            if (exprVal instanceof Number) {
                return new PrimitiveInt(~((Number)exprVal).intValue());
            }
            throw (InterpreterException)new InterpreterException("Systax Err. operator ~ only use for integer.", unaryExpr.expr).setInfoId("Tilde_EXPR_ERROR").addArg(unaryExpr.toString()).addArg(exprVal.toString()).addArg(exprVal.getClass().getName()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
        }
        if (unaryExpr.operator == 0) {
            Object tempValue = this.evalExprInternal(unaryExpr.expr, context);
            if (tempValue instanceof Boolean) {
                return (Boolean)tempValue != false ? PrimitiveBoolean.FALSE : PrimitiveBoolean.TRUE;
            }
            if (tempValue instanceof PrimitiveBoolean) {
                return ((PrimitiveBoolean)tempValue).getValue() ? PrimitiveBoolean.FALSE : PrimitiveBoolean.TRUE;
            }
            throw (InterpreterException)new InterpreterException("Systax Err. operator ~ only use for integer.", unaryExpr.expr).setInfoId("Not_EXPR_ERROR").addArg(unaryExpr.toString()).addArg(tempValue.toString()).addArg(tempValue.getClass().getName()).addArg(this.getContext(context)).setErrorLineCode(this.getSource());
        }
        throw (InterpreterException)new InterpreterException("UNSUPPORT", unaryExpr).setInfoId("UNSUPPORTED_STATEMENT").addArg(unaryExpr.getExprClass().getName()).addArg(unaryExpr.toString()).setErrorLineCode(this.getSource());
    }

    private boolean isInternalFunction(MethodInvokeExpr methodInvokeExpr) {
        CodeExpr ownerExpr = methodInvokeExpr.owner;
        String methodName = methodInvokeExpr.methodName;
        String ownerStr = null;
        if (ownerExpr instanceof IdentifierExpr) {
            ownerStr = ((IdentifierExpr)ownerExpr).value;
        }
        if (ownerStr == null) {
            return internalFunctionList.contains(methodName);
        }
        return ownerStr.equals("Math") && methodName.endsWith("abs");
    }

    private Object evalInternalFunction(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param) throws InterpreterException {
        String methodName = methodInvokeExpr.methodName;
        if (methodName.equals("eval")) {
            CodeExpr pramExpr = methodInvokeExpr.paramList.get(0);
            if (pramExpr instanceof StringExpr) {
                String pramExprStr = ((StringExpr)pramExpr).text;
                try {
                    return this.eval(pramExprStr, param);
                }
                catch (ParserException e) {
                    throw (InterpreterException)new InterpreterException("Sytax Error.", pramExpr, (Throwable)((Object)e)).setInfoId("PARSE_ERROR").addArg(pramExpr.toString()).addArg(e.getMessage()).setErrorLineCode(this.getSource());
                }
            }
            throw (InterpreterException)new InterpreterException("Sytax Error. expression must be a String", pramExpr).setInfoId("EVAL_PARAM_NOT_STRING").addArg(methodInvokeExpr.toString()).addArg(pramExpr == null ? "null" : pramExpr.toString()).setErrorLineCode(this.getSource());
        }
        if (methodName.equals("abs")) {
            CodeExpr pramExpr = methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, param);
            if (pram instanceof Number) {
                Number num = (Number)pram;
                if (num.doubleValue() >= 0.0) {
                    return num;
                }
                return TypeUtils.multi(num, -1);
            }
            throw (InterpreterException)new InterpreterException("abs's parameter must be Number, but it is" + pram, methodInvokeExpr).setInfoId("ABS_PARAM_NOT_NUM").addArg(methodInvokeExpr.toString()).addArg(pram == null ? "null" : pram.toString()).addArg(pram == null ? "null" : pram.getClass().getName()).setErrorLineCode(this.getSource());
        }
        if (methodName.equals("len")) {
            CodeExpr pramExpr = methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, param);
            if (pram instanceof Collection) {
                return new PrimitiveInt(((Collection)pram).size());
            }
            if (pram.getClass().isArray()) {
                return new PrimitiveInt(Array.getLength(pram));
            }
            if (pram instanceof String) {
                return new PrimitiveInt(((String)pram).length());
            }
            throw (InterpreterException)new InterpreterException("len function err. parameter type not support. it should be a collection or array or String, but find" + pram.getClass().getName(), methodInvokeExpr).setInfoId("LEN_PARAM_NOT_SUIT").addArg(methodInvokeExpr.toString()).addArg(pram.toString()).addArg(pram.getClass().getName()).setErrorLineCode(this.getSource());
        }
        if (methodName.equals("newid")) {
            return Uuid.create();
        }
        if (methodName.equals("parseInt")) {
            CodeExpr pramExpr = methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, param);
            if (pram instanceof String) {
                return new PrimitiveInt(Integer.parseInt((String)pram));
            }
            if (pram instanceof Number) {
                return new PrimitiveInt(((Number)pram).intValue());
            }
            return new PrimitiveInt(Integer.parseInt(pram.toString()));
        }
        if (methodName.equals("parseFloat")) {
            CodeExpr pramExpr = methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, param);
            if (pram instanceof String) {
                return new PrimitiveFloat(Float.parseFloat((String)pram));
            }
            if (pram instanceof Number) {
                return new PrimitiveFloat(((Number)pram).floatValue());
            }
            return new PrimitiveFloat(Float.parseFloat(pram.toString()));
        }
        if (methodName.equals("print")) {
            CodeExpr pramExpr = methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, param);
            System.out.print(pram);
            return NoneReturnValue.NoneReturn;
        }
        if (methodName.equals("println")) {
            CodeExpr pramExpr = methodInvokeExpr.paramList.get(0);
            Object pram = this.evalExprInternal(pramExpr, param);
            System.out.println(pram);
            return NoneReturnValue.NoneReturn;
        }
        if (methodName.equals("Set")) {
            HashSet<Object> set = new HashSet<Object>();
            for (CodeExpr pramExpr : methodInvokeExpr.paramList) {
                Object pram = this.evalExprInternal(pramExpr, param);
                set.add(pram);
            }
            return set;
        }
        if (methodName.equals("List")) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (CodeExpr pramExpr : methodInvokeExpr.paramList) {
                Object pram = this.evalExprInternal(pramExpr, param);
                list.add(pram);
            }
            return list;
        }
        if (methodName.equalsIgnoreCase("first")) {
            return this.evalIMFirst(methodInvokeExpr, param, null);
        }
        if (methodName.equalsIgnoreCase("last")) {
            return this.evalIMLast(methodInvokeExpr, param, null);
        }
        if (methodName.equalsIgnoreCase("all")) {
            return this.evalIMAll(methodInvokeExpr, param, null);
        }
        if (methodName.equals("uniqueAll")) {
            return this.evalIMUniqueAll(methodInvokeExpr, param, null);
        }
        if (methodName.equalsIgnoreCase("getByIndex")) {
            return this.evalIMGetByIndex(methodInvokeExpr, param, null);
        }
        if (methodName.equals("max")) {
            return this.evalIMMax(methodInvokeExpr, param, null);
        }
        if (methodName.equals("min")) {
            return this.evalIMMin(methodInvokeExpr, param, null);
        }
        if (methodName.startsWith("conditional_")) {
            if (methodInvokeExpr.paramList.size() < 2) {
                throw (InterpreterException)new InterpreterException("syntax error 'conditional_sum', there must be 2 parameters", methodInvokeExpr).setErrorLineCode(this.getSource());
            }
            CodeExpr connStrExpr = methodInvokeExpr.paramList.remove(methodInvokeExpr.paramList.size() - 1);
            if (!(connStrExpr instanceof StringExpr)) {
                throw new TODOException("conditional_sum");
            }
            String connStr = ((StringExpr)connStrExpr).text;
            CodeExpr connExpr = null;
            try {
                ExprParser parser = new ExprParser(connStr);
                parser.expr();
            }
            catch (ParserException e) {
                e.printStackTrace();
                throw (InterpreterException)new InterpreterException("syntax error 'conditional_sum'", connStrExpr, (Throwable)((Object)e)).setInfoId("PARSE_ERROR").addArg(connStrExpr.toString()).addArg(e.toString()).setErrorLineCode(this.getSource());
            }
            if (methodName.equalsIgnoreCase("conditional_sum")) {
                return this.evalIMSum(methodInvokeExpr, param, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_avg")) {
                return this.evalIMAvg(methodInvokeExpr, param, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_max")) {
                return this.evalIMMax(methodInvokeExpr, param, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_min")) {
                return this.evalIMMin(methodInvokeExpr, param, connExpr);
            }
            if (methodName.equalsIgnoreCase("conditional_count")) {
                return this.evalIMCount(methodInvokeExpr, param, connExpr);
            }
            throw (InterpreterException)new InterpreterException("method name must be 'conditional_sum' or 'conditional_avg' or 'conditional_max' or 'conditional_min' or 'conditional_count'", connStrExpr).setErrorLineCode(this.getSource());
        }
        throw new InterpreterException("UNSUPPORT, unkonw method.methodName is" + methodName, methodInvokeExpr);
    }

    private Object evalIMSum(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria) throws InterpreterException {
        List<Object> list = this.evalIMAll(methodInvokeExpr, param, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object sumVal = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            sumVal = TypeUtils.add(sumVal, list.get(i));
        }
        return sumVal;
    }

    private List<Object> evalIMAll(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria) throws InterpreterException {
        return this.fetchAllElements(methodInvokeExpr, param, criteria, 0);
    }

    private List<Object> fetchAllElements(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria, int minSize) throws InterpreterException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (CodeExpr expr : methodInvokeExpr.paramList) {
            list.addAll(this.fetchElements(expr, param, criteria));
            if (minSize <= 0 || list.size() < minSize) continue;
            break;
        }
        return list;
    }

    private List<Object> fetchElements(CodeExpr paramExpr, Map<String, Object> context, CodeExpr criteria) throws InterpreterException {
        FieldRuleInterpreter botInter = criteria == null ? null : new FieldRuleInterpreter(this.ctx);
        ArrayList<Object> list = new ArrayList<Object>();
        if (paramExpr instanceof PropertyExpr) {
            PropertyExpr propExpr = (PropertyExpr)paramExpr;
            Object param = this.evalExprInternal(propExpr.owner, context);
            if (FieldRuleFormulaUtil.isCollection(param)) {
                Iterator<?> valIter = FieldRuleFormulaUtil.getIterator(param);
                while (valIter.hasNext()) {
                    Object owner = valIter.next();
                    Object value = this.getProperty(owner, propExpr.propName);
                    if (value == null) continue;
                    if (botInter != null) {
                        context.put(KS_COLLECT_OWNER, owner);
                        context.put(KS_COLLECT_VALUE, value);
                        Object cond = botInter.evalExpr(criteria, context);
                        if (!Boolean.TRUE.equals(cond)) continue;
                        list.add(value);
                        continue;
                    }
                    list.add(value);
                }
            } else {
                Object owner = param;
                param = this.getProperty(param, propExpr.propName);
                Iterator<?> valIter = FieldRuleFormulaUtil.getIterator(param);
                while (valIter.hasNext()) {
                    Object value = valIter.next();
                    if (value == null) continue;
                    if (botInter != null) {
                        context.put(KS_COLLECT_VALUE, value);
                        context.put(KS_COLLECT_OWNER, owner);
                        Object cond = botInter.evalExpr(criteria, context);
                        if (!Boolean.TRUE.equals(cond)) continue;
                        list.add(value);
                        continue;
                    }
                    list.add(value);
                }
            }
        } else {
            Object param = this.evalExprInternal(paramExpr, context);
            Iterator<?> valIter = FieldRuleFormulaUtil.getIterator(param);
            while (valIter.hasNext()) {
                Object value = valIter.next();
                if (value == null) continue;
                if (botInter != null) {
                    context.put(KS_COLLECT_VALUE, value);
                    Object cond = botInter.evalExpr(criteria, context);
                    if (!Boolean.TRUE.equals(cond)) continue;
                    list.add(value);
                    continue;
                }
                list.add(value);
            }
        }
        return list;
    }

    private Object getProperty(Object ownerValue, String property) throws InterpreterException {
        if (ownerValue == null) {
            return null;
        }
        Class<?> type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
        if (type.isArray() && property.equals("length")) {
            return new PrimitiveInt(Array.getLength(ownerValue));
        }
        this.lazyLoadGetProperty(ownerValue, property, null);
        Field field = TypeUtils.findField(type, property);
        Throwable ex = null;
        if (field == null) {
            String key = type.getName() + METHOD_GET + property;
            Method method = this.methodCache.get(key);
            if (method == null) {
                method = FieldRuleFormulaUtil.findGetMethod(type, property);
                this.methodCache.put(key, method);
            }
            if (method != null) {
                return this.invokeMethod(ownerValue, method, null);
            }
            if (this.isObjectValue(ownerValue)) {
                if (this.isObjectValueContainPropName(ownerValue, property)) {
                    return this.getObjectValuePropValueByName(ownerValue, property);
                }
                return this.lazyLoadGetProperty(ownerValue, property, null);
            }
            if (this.isObjectCollection(ownerValue)) {
                if (this.getObjectCollectionSize(ownerValue) <= 0) {
                    return null;
                }
                if ((ownerValue = this.getObjectCollectionChildByIndex(ownerValue, 0)) == null) {
                    throw new NullPointerException("properExpr's owner is null.");
                }
                type = ownerValue instanceof Class ? (Class<?>)ownerValue : ownerValue.getClass();
                this.lazyLoadGetProperty(ownerValue, property, null);
                field = TypeUtils.findField(type, property);
                if (field == null) {
                    key = type.getName() + METHOD_GET + property;
                    method = this.methodCache.get(key);
                    if (method == null) {
                        method = FieldRuleFormulaUtil.findGetMethod(type, property);
                        this.methodCache.put(key, method);
                    }
                    if (method != null) {
                        return this.invokeMethod(ownerValue, method, null);
                    }
                    if (this.isObjectValue(ownerValue)) {
                        PropertyExpr itemPropExpr = new PropertyExpr(null);
                        itemPropExpr.owner = new IdentifierExpr(null, "item");
                        itemPropExpr.propName = property;
                        HashMap<String, Object> itemCtx = new HashMap<String, Object>();
                        itemCtx.put("item", ownerValue);
                        return this.evalPropExpr(itemPropExpr, itemCtx);
                    }
                    throw (InterpreterException)new InterpreterException("eval properExpr error. not such field or getMethod.").setErrorLineCode(this.getSource());
                }
                try {
                    return field.get(ownerValue);
                }
                catch (Exception e) {
                    throw (InterpreterException)new InterpreterException("get property " + property + " error", e).setErrorLineCode(this.getSource());
                }
            }
            throw (InterpreterException)new InterpreterException("expr is : " + property, ex).setErrorLineCode(this.getSource());
        }
        try {
            field.setAccessible(true);
            return field.get(ownerValue);
        }
        catch (Exception e) {
            throw (InterpreterException)new InterpreterException("get property " + property + " error", e).setErrorLineCode(this.getSource());
        }
    }

    private List<Object> evalIMUniqueAll(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria) throws InterpreterException {
        List<Object> list = this.evalIMAll(methodInvokeExpr, param, criteria);
        if (list.isEmpty()) {
            return list;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Object value = list.remove(i);
            if (!list.contains(value)) {
                list.add(i, value);
                continue;
            }
            --i;
        }
        return list;
    }

    private Object evalIMFirst(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria) throws InterpreterException {
        List<Object> list = this.fetchAllElements(methodInvokeExpr, param, criteria, 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private Object evalIMLast(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria) throws InterpreterException {
        List<Object> list = this.fetchAllElements(methodInvokeExpr, param, criteria, 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    private Object evalIMGetByIndex(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria) throws InterpreterException {
        CodeExpr expr = methodInvokeExpr.paramList.remove(methodInvokeExpr.paramList.size() - 1);
        Object value = this.evalExpr(expr, param);
        int index = 0;
        if (value instanceof Integer) {
            index = (Integer)value;
        } else if (value != null) {
            index = Integer.parseInt(value.toString());
        } else {
            throw new InterpreterException("param[expr(" + expr + ") is null ] is error!");
        }
        List<Object> list = this.fetchAllElements(methodInvokeExpr, param, criteria, index + 1);
        if (list.size() <= index) {
            return null;
        }
        return list.get(index);
    }

    private Object evalIMMin(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria) throws InterpreterException {
        List<Object> list = this.evalIMAll(methodInvokeExpr, param, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object minVal = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (!TypeUtils.lessThan(list.get(i), minVal)) continue;
            minVal = list.get(i);
        }
        return minVal;
    }

    private Object evalIMMax(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria) throws InterpreterException {
        List<Object> list = this.evalIMAll(methodInvokeExpr, param, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object maxValue = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (!TypeUtils.greaterThan(list.get(i), maxValue)) continue;
            maxValue = list.get(i);
        }
        return maxValue;
    }

    private Object evalIMCount(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria) throws InterpreterException {
        List<Object> list = this.evalIMAll(methodInvokeExpr, param, criteria);
        return list.size();
    }

    private Object evalIMAvg(MethodInvokeExpr methodInvokeExpr, Map<String, Object> param, CodeExpr criteria) throws InterpreterException {
        List<Object> list = this.evalIMAll(methodInvokeExpr, param, criteria);
        if (list.isEmpty()) {
            return 0;
        }
        Object sumValue = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            sumValue = TypeUtils.add(list.get(i), sumValue);
        }
        Object avgValue = TypeUtils.div(sumValue, list.size());
        return avgValue == null ? Integer.valueOf(0) : avgValue;
    }

    private Object evalFunction(Function funcObj, MethodInvokeExpr methodInvokeExpr, Map<String, Object> param) throws InterpreterException {
        long t = System.currentTimeMillis();
        ArrayList<String> localVarList = new ArrayList<String>();
        HashMap<String, Object> replacedVarMap = new HashMap<String, Object>();
        for (int i = 0; i < funcObj.paramList.size(); ++i) {
            Object pramValue;
            String pram = funcObj.paramList.get(i);
            localVarList.add(pram);
            if (i < methodInvokeExpr.paramList.size()) {
                CodeExpr pramExpr = methodInvokeExpr.paramList.get(i);
                pramValue = this.evalExprInternal(pramExpr, param);
            } else {
                pramValue = null;
            }
            if (param.containsKey(pram)) {
                replacedVarMap.put(pram, param.get(pram));
            }
            param.put(pram, pramValue);
        }
        Object rtnValue = this.evalBlockStmtList(funcObj.stmtList, param);
        for (int i = 0; i < localVarList.size(); ++i) {
            param.remove(localVarList.get(i));
        }
        for (Map.Entry entry : replacedVarMap.entrySet()) {
            param.put((String)entry.getKey(), entry.getValue());
        }
        log.debug("[evalFunction] Function:" + funcObj.name + ", MethodName:" + methodInvokeExpr.methodName + " COST:" + (System.currentTimeMillis() - t));
        return rtnValue;
    }

    private void lazyLoadFileValue(Object value) throws InterpreterException {
        if (this.bizObjectProvider != null) {
            this.bizObjectProvider.lazyLoadFillValue(value);
        }
    }

    private boolean isObjectValue(Object value) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.isObjectValue(value);
        }
        return false;
    }

    private boolean isObjectCollection(Object value) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.isObjectCollection(value);
        }
        return false;
    }

    private Object lazyLoadGetProperty(Object objValue, String propName, PropertyExpr propExpr) throws InterpreterException {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.lazyLoadGetProperty(objValue, propName, propExpr);
        }
        return null;
    }

    private boolean isObjectValueContainPropName(Object value, String propName) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.isObjectValueContainPropName(value, propName);
        }
        return false;
    }

    private Object getObjectValuePropValueByName(Object value, String propName) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getObjectValuePropValueByName(value, propName);
        }
        return null;
    }

    private Object getObjectCollectionChildByIndex(Object value, int index) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getObjectCollectionChildByIndex(value, index);
        }
        return null;
    }

    private int getObjectCollectionSize(Object value) {
        if (this.bizObjectProvider != null) {
            return this.bizObjectProvider.getObjectCollectionSize(value);
        }
        return -1;
    }

    private void setObjectValuePropValue(Object value, String propName, Object val) {
        if (this.bizObjectProvider != null) {
            this.bizObjectProvider.setObjectValuePropValue(value, propName, val);
        }
    }

    static {
        internalFunctionList.add("abs");
        internalFunctionList.add("avg");
        internalFunctionList.add("count");
        internalFunctionList.add("eval");
        internalFunctionList.add("len");
        internalFunctionList.add("max");
        internalFunctionList.add("min");
        internalFunctionList.add("newid");
        internalFunctionList.add("parseInt");
        internalFunctionList.add("parseFloat");
        internalFunctionList.add("print");
        internalFunctionList.add("println");
        internalFunctionList.add("Set");
        internalFunctionList.add("List");
        internalFunctionList.add("sum");
        internalFunctionList.add("first");
        internalFunctionList.add("last");
        internalFunctionList.add("uniqueAll");
        internalFunctionList.add("all");
        internalFunctionList.add("getByIndex");
        internalFunctionList.add("conditional_sum");
        internalFunctionList.add("conditional_avg");
        internalFunctionList.add("conditional_max");
        internalFunctionList.add("conditional_min");
        internalFunctionList.add("conditional_count");
    }

    private static class NoneReturnValue {
        private String name;
        static NoneReturnValue NoneReturn = new NoneReturnValue("NoneReturn");

        private NoneReturnValue(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

