/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.CustomizedUnitCollection;
import com.kingdee.eas.ep.CustomizedUnitFactory;
import com.kingdee.eas.ep.CustomizedUnitInfo;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.ICustomizedUnit;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.BaseItemLevelUpRecordFactory;
import com.kingdee.shr.base.syssetting.BaseItemLevelUpRecordInfo;
import com.kingdee.shr.base.syssetting.IBaseItemLevelUpRecord;
import com.kingdee.shr.base.syssetting.SHRBasicItemCollection;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBasicItemUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingUIViewUtil;
import com.kingdee.shr.base.syssetting.util.custom.SHRCustomSchemeUtil;
import com.kingdee.shr.base.syssetting.util.custom.SHRCustomizedUnitUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.xpath.XPath;

public class BaseItemCustomLevelUpTools {
    private static Logger logger = Logger.getLogger(BaseItemCustomLevelUpTools.class);

    private static BaseItemLevelUpRecordInfo initBaseItemLevelUpRecord(int batchNumber, SHRBasicItemInfo shrBasicItemInfo, int stepNumber, String stepName, boolean isSuccess, String errorMessage) {
        BaseItemLevelUpRecordInfo model = new BaseItemLevelUpRecordInfo();
        model.setBatchNumber(batchNumber);
        model.setBasicItem(shrBasicItemInfo);
        model.setStepIndex(stepNumber);
        model.setIsSuccess(isSuccess);
        model.setErrorMessage(errorMessage);
        model.setStepName(stepName);
        return model;
    }

    public static void levelUpInit(Context ctx, SHRBasicItemCollection coll) throws EASBizException, BOSException {
        int i;
        if (null == coll || coll.size() <= 0) {
            return;
        }
        ctx.put((Object)"com.kingdee.bos.metadata.HostType.class", (Object)"MDHostType_3MDHostType_4");
        ICustomizedUnit iCustomizedUnit = CustomizedUnitFactory.getLocalInstance((Context)ctx);
        ICustomizedScheme iCustomizedScheme = CustomizedSchemeFactory.getLocalInstance((Context)ctx);
        ArrayList viewCreateList = new ArrayList();
        String tempDynamicMetadataTableName = MessageFormat.format("T_CON_DM{0}", String.valueOf(System.currentTimeMillis()));
        String tempCustomizedUnitName = MessageFormat.format("T_EP_CU{0}", String.valueOf(System.currentTimeMillis()));
        IBaseItemLevelUpRecord iBaseItemLevelUpRecord = BaseItemLevelUpRecordFactory.getLocalInstance(ctx);
        int batchNumber = iBaseItemLevelUpRecord.getMaxBatchNumber() + 1;
        BaseItemCustomLevelUpTools.initTempDynamicMetadataTableStructure(ctx, tempDynamicMetadataTableName);
        BaseItemCustomLevelUpTools.initTempCustomizedUnitTableStructure(ctx, tempCustomizedUnitName);
        String errorMessage = "";
        String stepName = SHRSysSettingResourceUtil.getResource("check_before_upgrade", ctx);
        int total = coll.size();
        for (i = 0; i < total; ++i) {
            SHRBasicItemInfo shrBasicItemInfo = coll.get(i);
            if (StringUtils.isEmpty((String)shrBasicItemInfo.getEntityName())) {
                errorMessage = SHRSysSettingResourceUtil.getResource("entity_name_not_null", ctx);
                logger.info((Object)errorMessage);
                iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 1, stepName, false, errorMessage));
                continue;
            }
            EntityObjectInfo entityObjectInfo = null;
            try {
                entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, shrBasicItemInfo.getEntityName());
            }
            catch (MetaDataNotFoundException e) {
                errorMessage = SHRSysSettingResourceUtil.getResource("entity_metadata_not_exist", ctx, shrBasicItemInfo.getEntityName());
                logger.info((Object)errorMessage);
                iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 1, stepName, false, errorMessage));
                continue;
            }
            if (null == entityObjectInfo || null == entityObjectInfo.getType() || null == entityObjectInfo.getBaseEntity()) {
                BaseItemCustomLevelUpTools.enableCustomizedScheme(ctx, shrBasicItemInfo.getEntityName());
                entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, shrBasicItemInfo.getEntityName());
            }
            if (null == entityObjectInfo || null == entityObjectInfo.getType() || null == entityObjectInfo.getBaseEntity()) {
                errorMessage = SHRSysSettingResourceUtil.getResource("entity_metadata_not_exist", ctx, shrBasicItemInfo.getEntityName());
                logger.info((Object)errorMessage);
                iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 1, stepName, false, errorMessage));
                continue;
            }
            if (!entityObjectInfo.isDynamic()) {
                errorMessage = SHRSysSettingResourceUtil.getResource("no_need_upgrade", ctx);
                iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 1, stepName, false, errorMessage));
                continue;
            }
            if (SysSettingSHRBaseItemUtil.isSHRBaseItem(entityObjectInfo.getBaseEntity())) {
                errorMessage = SHRSysSettingResourceUtil.getResource("entity_upgrade_already", ctx, shrBasicItemInfo.getEntityName());
                iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 1, stepName, false, errorMessage));
                continue;
            }
            if (!"com.kingdee.eas.framework.app.DataBase".equals(entityObjectInfo.getBaseEntity().getFullName())) {
                errorMessage = SHRSysSettingResourceUtil.getResource("entity_not_extends_database", ctx, shrBasicItemInfo.getEntityName());
                iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 1, stepName, false, errorMessage));
                logger.info((Object)errorMessage);
                continue;
            }
            CustomizedUnitInfo customizedUnitInfo = null;
            CustomizedSchemeInfo customizedSchemeInfo = null;
            CustomizedUnitCollection custUnitColl = iCustomizedUnit.getCustomizedUnitCollection(BaseItemCustomLevelUpTools.getCustomizedUnitEntityViewInfo(entityObjectInfo, null));
            if (null == custUnitColl || custUnitColl.size() <= 0) {
                errorMessage = SHRSysSettingResourceUtil.getResource("metadata_define_not_exist", ctx, shrBasicItemInfo.getEntityName());
                iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 1, stepName, false, errorMessage));
                continue;
            }
            customizedUnitInfo = custUnitColl.get(0);
            customizedSchemeInfo = iCustomizedScheme.getCustomizedSchemeInfo((IObjectPK)new ObjectUuidPK(customizedUnitInfo.getCustomizedSchemeID()));
            BaseItemCustomLevelUpTools.backupsMetadataToTempDynamicMetadataTableByCustomizedSchemeId(ctx, customizedSchemeInfo.getId().toString(), tempDynamicMetadataTableName);
            BaseItemCustomLevelUpTools.backupsMetadataToTempCustomizedUnitTableByCustomizedSchemeId(ctx, customizedSchemeInfo.getId().toString(), tempCustomizedUnitName);
            String successFilter = BaseItemCustomLevelUpTools.getNeedRecoveryImportOrAddNewMetaDatasFilter(ctx, customizedUnitInfo, entityObjectInfo, customizedSchemeInfo.getId().toString(), false);
            String failureFilter = BaseItemCustomLevelUpTools.getNeedRecoveryImportOrAddNewMetaDatasFilter(ctx, customizedUnitInfo, entityObjectInfo, customizedSchemeInfo.getId().toString(), true);
            HashMap<String, Object> mds = new HashMap<String, Object>();
            HashMap<String, ColumnInfo> mappingInfo = new HashMap<String, ColumnInfo>();
            mds.put("properties", entityObjectInfo.getProperties());
            int subTotal = entityObjectInfo.getProperties().size();
            for (int j = 0; j < subTotal; ++j) {
                PropertyInfo propertyInfo = entityObjectInfo.getProperties().get(j);
                mappingInfo.put(propertyInfo.getRealName(), propertyInfo.getMappingField());
                if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
                RelationshipInfo r = linkPropertyInfo.getRelationship();
                mds.put(linkPropertyInfo.getRealName(), r.getRuntimeCopy());
            }
            mds.put("tableInfo", entityObjectInfo.getTable());
            mds.put("columnInfos", entityObjectInfo.getTable().getColumns());
            mds.put("bosType", entityObjectInfo.getType());
            errorMessage = SHRSysSettingResourceUtil.getResource("entity_upgrade_start", ctx, customizedSchemeInfo.getName(), shrBasicItemInfo.getEntityName());
            logger.error((Object)errorMessage);
            iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 1, stepName, true, errorMessage));
            if (customizedSchemeInfo.isStart()) {
                stepName = SHRSysSettingResourceUtil.getResource("disable_upgrade_case", ctx);
                try {
                    SHRCustomSchemeUtil.disableScheme(ctx, new String[]{customizedSchemeInfo.getId().toString()}, customizedSchemeInfo.getAlias());
                    errorMessage = SHRSysSettingResourceUtil.getResource("disable_case_success", ctx, customizedSchemeInfo.getName());
                    iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 2, stepName, true, errorMessage));
                }
                catch (Exception e) {
                    errorMessage = SHRSysSettingResourceUtil.getResource("disable_case_fail", ctx, customizedSchemeInfo.getAlias(), e.getMessage());
                    logger.error((Object)errorMessage, (Throwable)e);
                    try {
                        SHRCustomSchemeUtil.enableScheme(ctx, new String[]{customizedSchemeInfo.getId().toString()}, customizedSchemeInfo.getAlias());
                    }
                    catch (Exception e1) {
                        logger.error((Object)("enableScheme " + customizedSchemeInfo.getAlias() + ", " + e1.getMessage()), (Throwable)e1);
                    }
                    iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 2, stepName, false, errorMessage));
                    continue;
                }
            }
            logger.error((Object)(entityObjectInfo.getFullName() + "," + entityObjectInfo.getAlias() + " ------upgrade starting -----"));
            stepName = SHRSysSettingResourceUtil.getResource("recreate_biz_unit", ctx);
            try {
                logger.error((Object)(entityObjectInfo.getFullName() + "," + entityObjectInfo.getAlias() + " ----delete starting -----"));
                SHRCustomizedUnitUtil.delete(ctx, customizedUnitInfo);
                logger.error((Object)(entityObjectInfo.getFullName() + "," + entityObjectInfo.getAlias() + " ----delete ending ----"));
                logger.error((Object)(entityObjectInfo.getFullName() + "," + entityObjectInfo.getAlias() + " ----copyCrate starting ----"));
                SHRCustomizedUnitUtil.copyCrate(ctx, customizedSchemeInfo, customizedUnitInfo, entityObjectInfo, mds);
                errorMessage = SHRSysSettingResourceUtil.getResource("create_biz_unit_success", ctx, customizedUnitInfo.getAlias(), shrBasicItemInfo.getEntityName());
                iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 3, stepName, true, errorMessage));
                logger.error((Object)(entityObjectInfo.getFullName() + "," + entityObjectInfo.getAlias() + " ----copyCrate starting ----"));
            }
            catch (Exception e) {
                logger.error((Object)(entityObjectInfo.getFullName() + "," + entityObjectInfo.getAlias() + " ---- upgrade error ----" + e.getMessage()), (Throwable)e);
                try {
                    BaseItemCustomLevelUpTools.deleteErrorDynamicMetadatas(ctx, failureFilter, customizedSchemeInfo.getId().toString(), tempDynamicMetadataTableName);
                    BaseItemCustomLevelUpTools.recoveryOrthrDynamicMetadatas(ctx, failureFilter, customizedSchemeInfo.getId().toString(), tempDynamicMetadataTableName, false);
                    BaseItemCustomLevelUpTools.deleteErrorCustomizedUnit(ctx, customizedUnitInfo.getId().toString());
                    BaseItemCustomLevelUpTools.recoveryCustomizedUnit(ctx, customizedUnitInfo.getId().toString(), tempCustomizedUnitName);
                }
                catch (Exception e1) {
                    logger.error((Object)(entityObjectInfo.getFullName() + "," + entityObjectInfo.getAlias() + " ---- metadata info rollback ----" + e.getMessage()), (Throwable)e);
                }
                errorMessage = SHRSysSettingResourceUtil.getResource("create_biz_unit_fail", ctx, customizedUnitInfo.getAlias(), shrBasicItemInfo.getEntityName());
                iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 3, stepName, false, errorMessage));
                continue;
            }
            logger.error((Object)(entityObjectInfo.getFullName() + "," + entityObjectInfo.getAlias() + " ---- upgrade ending ----"));
            customizedSchemeInfo = iCustomizedScheme.getCustomizedSchemeInfo((IObjectPK)new ObjectUuidPK(customizedUnitInfo.getCustomizedSchemeID()));
            BaseItemCustomLevelUpTools.insertLinkInfoToDynamicMetadataTable(ctx, customizedSchemeInfo.getId().toString(), tempDynamicMetadataTableName, entityObjectInfo);
            BaseItemCustomLevelUpTools.recoveryOrthrDynamicMetadatas(ctx, successFilter, customizedSchemeInfo.getId().toString(), tempDynamicMetadataTableName, true);
            BaseItemCustomLevelUpTools.updateCustomizedUnitInfo(iCustomizedUnit, entityObjectInfo, customizedUnitInfo, customizedSchemeInfo.getId().toString());
            if (!customizedSchemeInfo.isStart()) {
                stepName = SHRSysSettingResourceUtil.getResource("solution_enable", ctx);
                try {
                    SHRCustomSchemeUtil.enableScheme(ctx, new String[]{customizedSchemeInfo.getId().toString()}, customizedSchemeInfo.getAlias());
                    HashMap<String, String> viewCreateMap = new HashMap<String, String>();
                    viewCreateMap.put("alias", entityObjectInfo.getAlias());
                    viewCreateMap.put("name", entityObjectInfo.getName());
                    viewCreateMap.put("model", entityObjectInfo.getFullName());
                    viewCreateList.add(viewCreateMap);
                    errorMessage = SHRSysSettingResourceUtil.getResource("solution_enable_success", ctx, customizedSchemeInfo.getName());
                    iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 4, stepName, true, errorMessage));
                }
                catch (Exception e) {
                    logger.error((Object)(customizedSchemeInfo.getName() + " enabled solution fail: " + e.getMessage()), (Throwable)e);
                    errorMessage = SHRSysSettingResourceUtil.getResource("solution_enable_fail", ctx, customizedSchemeInfo.getName(), shrBasicItemInfo.getEntityName());
                    iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 4, stepName, false, errorMessage));
                    continue;
                }
            }
            stepName = SHRSysSettingResourceUtil.getResource("metadata_upgrade_end", ctx);
            errorMessage = SHRSysSettingResourceUtil.getResource("entity_upgrade_end", ctx, customizedSchemeInfo.getName(), shrBasicItemInfo.getEntityName());
            iBaseItemLevelUpRecord.save((CoreBaseInfo)BaseItemCustomLevelUpTools.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 5, stepName, true, errorMessage));
            logger.error((Object)("---------- solution upgrade end: " + customizedSchemeInfo.getName()));
        }
        BaseItemCustomLevelUpTools.dropTempDynamicMetadataTable(ctx, tempDynamicMetadataTableName);
        BaseItemCustomLevelUpTools.dropTempCustomizedUnitTable(ctx, tempCustomizedUnitName);
        if (null == viewCreateList || viewCreateList.size() <= 0) {
            return;
        }
        total = viewCreateList.size();
        for (i = 0; i < total; ++i) {
            Map viewCreateMap = (Map)viewCreateList.get(i);
            UIViewInfo model = new UIViewInfo();
            model.setType(UIType.form);
            model.setName((String)viewCreateMap.get("alias"));
            model.setModel((String)viewCreateMap.get("model"));
            model.setInner(false);
            try {
                SysSettingUIViewUtil.batchCreateBaseItemUIViews(ctx, model, true, iBaseItemLevelUpRecord, batchNumber);
            }
            catch (Exception e) {
                logger.error((Object)("data upgrade  " + (String)viewCreateMap.get("model") + " " + e.getMessage()), (Throwable)e);
                continue;
            }
            SysSettingSHRBasicItemUtil.removeSHRBasicItemInfoFromCacheByEntityName(ctx, (String)viewCreateMap.get("model"));
        }
    }

    private static void recoveryCustomizedUnit(Context ctx, String customizedUnitId, String tempCustomizedUnitName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_EP_CustomizedUnit SELECT * FROM ").append(tempCustomizedUnitName).append(" where fid =  '").append(customizedUnitId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void deleteErrorCustomizedUnit(Context ctx, String customizedUnitId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_EP_CustomizedUnit where fid = '").append(customizedUnitId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void backupsMetadataToTempCustomizedUnitTableByCustomizedSchemeId(Context ctx, String customizedUnitId, String tempCustomizedUnitName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(tempCustomizedUnitName).append(" SELECT t1.* FROM T_EP_CustomizedUnit t1").append(" where t1.FCUSTOMIZEDSCHEMEID = '").append(customizedUnitId).append("'").append(" and not exists(select 1 from ").append(tempCustomizedUnitName).append(" t0 where t0.fid=t1.fid)");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private static void dropTempCustomizedUnitTable(Context ctx, String tempCustomizedUnitName) throws BOSException {
        DbUtil.execute((Context)ctx, (String)MessageFormat.format("drop table {0}", tempCustomizedUnitName));
    }

    private static void initTempCustomizedUnitTableStructure(Context ctx, String tempCustomizedUnitName) throws BOSException {
        DbUtil.execute((Context)ctx, (String)MessageFormat.format("SELECT * into {0} FROM T_EP_CustomizedUnit where 1=2 ", tempCustomizedUnitName));
    }

    private static void deleteErrorDynamicMetadatas(Context ctx, String filter, String customizedSchemeId, String tempDynamicMetadataTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_CON_DynamicMetadata t1 where t1.fprojectid = '").append(customizedSchemeId).append("' and exists(").append("SELECT 1 from ").append(tempDynamicMetadataTableName).append(" t0 where t1.fid = t0.fid and t0.fprojectid = '").append(customizedSchemeId).append("' and ").append(filter).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void recoveryOrthrDynamicMetadatas(Context ctx, String filter, String customizedSchemeId, String tempDynamicMetadataTableName, boolean onlyRelation) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_CON_DynamicMetadata SELECT * from ").append(tempDynamicMetadataTableName).append(" t0 where t0.fprojectid = '").append(customizedSchemeId).append("' ");
        if (!StringUtils.isEmpty((String)filter)) {
            sql.append(" and (").append(filter).append(")");
        }
        if (onlyRelation) {
            sql.append(" and t0.FBOSTYPE = '").append("rlsp").append("'");
        }
        sql.append(" and not exists (SELECT * FROM T_CON_DynamicMetadata t1 where t0.fid = t1.fid and t1.fprojectid = '").append(customizedSchemeId).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updateCustomizedUnitInfo(ICustomizedUnit iCustomizedUnit, EntityObjectInfo entityObjectInfo, CustomizedUnitInfo customizedUnitInfo, String customizedSchemeId) throws BOSException, EASBizException {
        CustomizedUnitCollection custUnitCollAfter = iCustomizedUnit.getCustomizedUnitCollection(BaseItemCustomLevelUpTools.getCustomizedUnitEntityViewInfo(entityObjectInfo, customizedSchemeId));
        if (null != custUnitCollAfter && custUnitCollAfter.size() > 0) {
            CustomizedUnitInfo customizedUnitInfoAfter = custUnitCollAfter.get(0);
            customizedUnitInfoAfter.setCustomizedUnitObject(customizedUnitInfo.getCustomizedUnitObject());
            SelectorItemCollection updateSelectors = new SelectorItemCollection();
            if (StringUtils.isEmpty((String)customizedUnitInfoAfter.getMetaDataPK())) {
                updateSelectors.add(new SelectorItemInfo("metaDataPK"));
                customizedUnitInfoAfter.setMetaDataPK(entityObjectInfo.getBizUnitPK());
            }
            updateSelectors.add(new SelectorItemInfo("customizedUnitObject"));
            iCustomizedUnit.updatePartial((CoreBaseInfo)customizedUnitInfoAfter, updateSelectors);
        }
    }

    private static String getNeedRecoveryImportOrAddNewMetaDatasFilter(Context ctx, CustomizedUnitInfo customizedUnitInfo, EntityObjectInfo entityObjectInfo, String customizedSchemeId, boolean isLevelFail) throws BOSException, EASBizException {
        Set<String> excludeMetas = BaseItemCustomLevelUpTools.getExcludeMetas(ctx, entityObjectInfo, customizedSchemeId);
        StringBuffer sb = new StringBuffer();
        try {
            Document doc = XMLUtil.parseXML(customizedUnitInfo.getCustomizedUnitObject());
            Element rootElement = doc.getRootElement();
            StringBuffer linkInfo = new StringBuffer();
            StringBuffer others = new StringBuffer();
            BaseItemCustomLevelUpTools.handlerMetaDataInfo(ctx, rootElement, linkInfo, others, excludeMetas, "entity", isLevelFail);
            BaseItemCustomLevelUpTools.handlerMetaDataInfo(ctx, rootElement, linkInfo, others, excludeMetas, "query", isLevelFail);
            BaseItemCustomLevelUpTools.handlerMetaDataInfo(ctx, rootElement, linkInfo, others, excludeMetas, "facade", isLevelFail);
            BaseItemCustomLevelUpTools.handlerMetaDataInfo(ctx, rootElement, linkInfo, others, excludeMetas, "function", isLevelFail);
            BaseItemCustomLevelUpTools.handlerMetaDataInfo(ctx, rootElement, linkInfo, others, excludeMetas, "listui", isLevelFail);
            BaseItemCustomLevelUpTools.handlerMetaDataInfo(ctx, rootElement, linkInfo, others, excludeMetas, "editui", isLevelFail);
            if (!StringUtils.isEmpty((String)others.toString())) {
                sb.append(" t0.FMETADATAPK in (").append(others.toString()).append(")");
                if (!StringUtils.isEmpty((String)linkInfo.toString())) {
                    sb.append(" or ").append(linkInfo.toString());
                }
            } else if (!StringUtils.isEmpty((String)linkInfo.toString())) {
                sb.append(linkInfo.toString());
            }
        }
        catch (JDOMException e) {
            throw new BOSException((Throwable)e);
        }
        return sb.toString();
    }

    private static void handlerMetaDataInfo(Context ctx, Element rootElement, StringBuffer linkInfo, StringBuffer sb, Set<String> excludeMetas, String type, boolean isLevelFail) throws JDOMException, EASBizException {
        XPath xPathEntity = XPath.newInstance((String)("//" + type));
        List list = xPathEntity.selectNodes((Object)rootElement);
        for (Element e : list) {
            Element ePackage = e.getChild("package");
            Element eName = e.getChild("name");
            String metadataPK = MessageFormat.format("{0}.{1}", ePackage.getText(), eName.getText());
            if (!isLevelFail && excludeMetas.contains(metadataPK)) continue;
            if ("entity".equals(type)) {
                EntityObjectInfo entityObjectInfo;
                if (!StringUtils.isEmpty((String)sb.toString())) {
                    sb.append(",");
                }
                if (null == (entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, metadataPK)).getType()) {
                    throw new BaseItemException(BaseItemException.DEP_META_DAMAGED, new Object[]{metadataPK});
                }
                DataTableInfo dataTableInfo = entityObjectInfo.getTable();
                sb.append("'").append(entityObjectInfo.getFullName()).append("',");
                sb.append("'").append(dataTableInfo.getFullName()).append("'");
                if (!StringUtils.isEmpty((String)linkInfo.toString())) {
                    linkInfo.append(" or ");
                }
                linkInfo.append("t0.FMETADATAPK like '").append(entityObjectInfo.getPackage().replace(".app", "")).append("%R_").append(entityObjectInfo.getName()).append("_%'");
                continue;
            }
            if (!StringUtils.isEmpty((String)sb.toString())) {
                sb.append(",");
            }
            sb.append("'").append(metadataPK).append("'");
        }
    }

    private static Set<String> getExcludeMetas(Context ctx, EntityObjectInfo entityObjectInfo, String customizedSchemeId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FMETADATAPK  FROM T_CON_DynamicMetadata where fprojectid = '").append(customizedSchemeId).append("' and  FMETADATAPK like '").append(entityObjectInfo.getPackage().replace(".app", "")).append("%").append(entityObjectInfo.getName()).append("%'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashSet<String> excludeMetas = new HashSet<String>();
        try {
            while (rs.next()) {
                excludeMetas.add(rs.getString("FMETADATAPK"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return excludeMetas;
    }

    private static void dropTempDynamicMetadataTable(Context ctx, String tempDynamicMetadataTableName) throws BOSException {
        DbUtil.execute((Context)ctx, (String)MessageFormat.format("drop table {0}", tempDynamicMetadataTableName));
    }

    private static void insertLinkInfoToDynamicMetadataTable(Context ctx, String customizedSchemeId, String tempDynamicMetadataTableName, EntityObjectInfo entityObjectInfo) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into T_CON_DynamicMetadata SELECT t1.* from ").append(tempDynamicMetadataTableName).append(" t1").append(" where t1.fprojectid = '").append(customizedSchemeId).append("'").append(" and t1.fmetadatapk like '").append(entityObjectInfo.getPackage()).append("%").append(entityObjectInfo.getName()).append("%'").append(" and t1.fbostype='").append("rlsp").append("'").append(" and not exists(select 1 from T_CON_DynamicMetadata t0 where t0.fid=t1.fid)");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private static void backupsMetadataToTempDynamicMetadataTableByCustomizedSchemeId(Context ctx, String customizedSchemeId, String tempDynamicMetadataTableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(tempDynamicMetadataTableName).append(" SELECT t1.* FROM T_CON_DynamicMetadata t1").append(" where t1.fprojectid = '").append(customizedSchemeId).append("'").append(" and not exists(select 1 from ").append(tempDynamicMetadataTableName).append(" t0 where t0.fid=t1.fid)");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private static void initTempDynamicMetadataTableStructure(Context ctx, String tempDynamicMetadataTableName) throws BOSException {
        DbUtil.execute((Context)ctx, (String)MessageFormat.format("SELECT * into {0} FROM T_CON_DynamicMetadata where 1=2 ", tempDynamicMetadataTableName));
    }

    private static void enableCustomizedScheme(Context ctx, String entityName) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)BaseItemCustomLevelUpTools.getAllCustomizedSchemeIDSql(entityName));
        try {
            while (rs.next()) {
                boolean isStart = rs.getBoolean("fstart");
                String id = rs.getString("fid");
                String alias = rs.getString("falias");
                if (isStart) continue;
                result.put(id, alias);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (result.size() > 0) {
            for (String key : result.keySet()) {
                try {
                    SHRCustomSchemeUtil.enableScheme(ctx, new String[]{key}, (String)result.get(key));
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private static String getAllCustomizedSchemeIDSql(String entityFullName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT te.fid,te.fstart,te.falias FROM T_CON_DynamicMetadata tm").append(" inner join t_ep_customizedscheme te on te.fid = tm.fprojectid").append(" where tm.FMetaDataPK = '").append(entityFullName).append("'").append(" and tm.FBosType = '").append("enty").append("'");
        return sb.toString();
    }

    private static String getCustomizedSchemeIDSql(String entityFullName) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT te.fid FROM T_CON_DynamicMetadata tm").append(" inner join t_ep_customizedscheme te on te.fid = tm.fprojectid").append(" where te.fstart = 1").append(" and tm.FMetaDataPK = '").append(entityFullName).append("'").append(" and tm.FBosType = '").append("enty").append("'");
        return sb.toString();
    }

    private static EntityViewInfo getCustomizedUnitEntityViewInfo(EntityObjectInfo entityObjectInfo, String customizedSchemeId) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("nodeType", (Object)"CUSTOMIZED_UNIT", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        if (StringUtils.isEmpty((String)customizedSchemeId)) {
            filter.getFilterItems().add(new FilterItemInfo("customizedSchemeID", (Object)BaseItemCustomLevelUpTools.getCustomizedSchemeIDSql(entityObjectInfo.getFullName()), CompareType.INNER));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("customizedSchemeID", (Object)customizedSchemeId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("metaDataPK", (Object)entityObjectInfo.getBizUnitPK(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)entityObjectInfo.getName(), CompareType.EQUALS));
        filter.setMaskString("#0 AND #1 AND #2 AND (#3 OR #4)");
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("name"));
        coll.add(new SelectorItemInfo("number"));
        coll.add(new SelectorItemInfo("displayName"));
        coll.add(new SelectorItemInfo("longNumber"));
        coll.add(new SelectorItemInfo("level"));
        coll.add(new SelectorItemInfo("isLeaf"));
        coll.add(new SelectorItemInfo("nodeType"));
        coll.add(new SelectorItemInfo("customizedUnitObject"));
        coll.add(new SelectorItemInfo("customizedSchemeID"));
        coll.add(new SelectorItemInfo("metaDataPK"));
        coll.add(new SelectorItemInfo("alias"));
        coll.add(new SelectorItemInfo("appSolutionID"));
        coll.add(new SelectorItemInfo("parent.id"));
        coll.add(new SelectorItemInfo("parent.name"));
        coll.add(new SelectorItemInfo("parent.number"));
        coll.add(new SelectorItemInfo("parent.displayName"));
        coll.add(new SelectorItemInfo("parent.longNumber"));
        coll.add(new SelectorItemInfo("parent.level"));
        coll.add(new SelectorItemInfo("parent.isLeaf"));
        coll.add(new SelectorItemInfo("parent.nodeType"));
        coll.add(new SelectorItemInfo("parent.customizedUnitObject"));
        coll.add(new SelectorItemInfo("parent.customizedSchemeID"));
        coll.add(new SelectorItemInfo("parent.metaDataPK"));
        coll.add(new SelectorItemInfo("parent.alias"));
        coll.add(new SelectorItemInfo("parent.appSolutionID"));
        view.setSelector(coll);
        return view;
    }
}

