/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public final class DateUtils {
    public static final String SHORT_FORMAT = "yyyyMMdd";
    public static final String LONG_FORMAT = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HHmmss";
    public static final String YEAR_MONTH_FORMAT = "yyyyMM";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_SPLIT_FORMAT = "yyyy-MM-dd";
    public static final String TIME_SPLIT_FORMAT = "HH:mm:ss";
    public static final String TIMESTAMP_MILLISECOND_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";

    public static String getCustomDateString(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static String parseMillisecond2String(long time, String format) {
        SimpleDateFormat dateFormat = null;
        dateFormat = StringUtils.isEmpty((String)format) ? new SimpleDateFormat(TIMESTAMP_MILLISECOND_FORMAT) : new SimpleDateFormat(format);
        return dateFormat.format(time);
    }

    public static Date parseCustomDateString(String sDate, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date d = null;
        if (sDate != null && sDate.length() == format.length()) {
            try {
                d = dateFormat.parse(sDate);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return d;
    }

    public static Date parseDateLongFormat(String sDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_FORMAT);
        Date d = null;
        if (sDate != null && sDate.length() == LONG_FORMAT.length()) {
            try {
                d = dateFormat.parse(sDate);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return d;
    }

    public static String getLongDateString(Date date) {
        return DateUtils.getLongDateString(date, TimeZone.getDefault());
    }

    public static String getLongDateString(Date date, TimeZone zone) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_FORMAT);
        dateFormat.setTimeZone(zone);
        return dateFormat.format(date);
    }

    public static String paseTimestamp2String(Timestamp timestamp, String parten) {
        if (null == timestamp) {
            return "";
        }
        if (StringUtils.isEmpty((String)parten)) {
            parten = TIMESTAMP_FORMAT;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(parten);
        return sdf.format(timestamp);
    }

    public static void printEnd(String title, long begin, long end, Logger logger) {
        if (null == logger) {
            System.out.println(String.format("%s beginTime: %s,endTime: %s,cost: %d ms,%d s", title, DateUtils.parseMillisecond2String(begin, null), DateUtils.parseMillisecond2String(end, null), end - begin, (end - begin) / 1000L));
            return;
        }
        logger.error((Object)String.format("%s beginTime: %s,endTime: %s,cost: %d ms\uff0c%d s", title, DateUtils.parseMillisecond2String(begin, null), DateUtils.parseMillisecond2String(end, null), end - begin, (end - begin) / 1000L));
    }

    public static void printBegin(String title, long begin, Logger logger) {
        if (null == logger) {
            System.out.println(String.format("%s beginTime: %s", title, DateUtils.parseMillisecond2String(begin, null)));
            return;
        }
        logger.error((Object)String.format("%s beginTime: %s", title, DateUtils.parseMillisecond2String(begin, null)));
    }

    public static int calculateTimeDiff(Date bigDate, Date smallDate, int type) {
        long b = bigDate.getTime();
        long s = smallDate.getTime();
        int r = 0;
        long m = b - s;
        switch (type) {
            case 0: {
                r = (int)(m / 86400000L);
                break;
            }
            case 1: {
                r = (int)(m / 3600000L);
                break;
            }
            case 2: {
                r = (int)(m / 60000L);
                break;
            }
        }
        return r;
    }

    public static boolean isDaylight(String date) {
        String[] dayLight = new String[]{"1941-03-16 00:00:00", "1940-06-03 00:00:00", "1986-05-04 00:00:00", "1987-04-12 00:00:00", "1988-04-10 00:00:00", "1989-04-16 00:00:00", "1990-04-15 00:00:00", "1991-04-14 00:00:00"};
        for (int i = 0; i < dayLight.length; ++i) {
            if (!dayLight[i].contains(date)) continue;
            return true;
        }
        return false;
    }

    public static String format(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }
}

