/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.shr.shrimport.ISHRFileTemplate;
import com.kingdee.shr.shrimport.ImportTemplateMutexType;
import com.kingdee.shr.shrimport.ImportTemplateStateEnum;
import com.kingdee.shr.shrimport.SHRFileTemplateCollection;
import com.kingdee.shr.shrimport.SHRFileTemplateFactory;
import com.kingdee.shr.shrimport.SHRFileTemplateFieldsCollection;
import com.kingdee.shr.shrimport.SHRFileTemplateFieldsInfo;
import com.kingdee.shr.shrimport.SHRFileTemplateInfo;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SHRFileTemplateUtil {
    public static void generateCustomImportTemplate(Context ctx, EntityObjectInfo entityObjectInfo, String maintainUIPK, String importButton, List<String> importFields) throws EASBizException, BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entityFullName", (Object)entityObjectInfo.getFullName(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isPreset", (Object)Boolean.FALSE, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        ISHRFileTemplate iSHRFileTemplate = SHRFileTemplateFactory.getLocalInstance((Context)ctx);
        SHRFileTemplateCollection collection = iSHRFileTemplate.getSHRFileTemplateCollection(entityViewInfo);
        CoreBaseCollection newCollection = new CoreBaseCollection();
        if (null == collection || collection.size() <= 0) {
            SHRFileTemplateInfo model = null;
            SHRFileTemplateUtil.doSHRFileTemplateInfo(ctx, entityObjectInfo, newCollection, model, maintainUIPK, importButton, importFields);
        } else {
            int total = collection.size();
            for (int i = 0; i < total; ++i) {
                SHRFileTemplateInfo model = collection.get(i);
                SHRFileTemplateUtil.doSHRFileTemplateInfo(ctx, entityObjectInfo, newCollection, model, maintainUIPK, importButton, importFields);
            }
        }
        if (null == newCollection || newCollection.size() <= 0) {
            return;
        }
        iSHRFileTemplate.saveBatchData(newCollection);
    }

    private static void doSHRFileTemplateInfo(Context ctx, EntityObjectInfo entityObjectInfo, CoreBaseCollection newCollection, SHRFileTemplateInfo model, String uipk, String button, List<String> importFields) {
        String bund = uipk + "#" + button;
        boolean isAddOrUpdate = Boolean.FALSE;
        if (null == model || null == model.getId()) {
            model = new SHRFileTemplateInfo();
            model.setMutexType(ImportTemplateMutexType.ENTITY);
            isAddOrUpdate = Boolean.TRUE;
        }
        List<Map<String, String>> languageMapingList = BOSConfigUtil.getLanguageMapingList();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (Map<String, String> lan : languageMapingList) {
            String lang = lan.get("lang");
            Locale locale = LocaleUtils.getLocale(lang);
            String alias = entityObjectInfo.getAlias();
            if (lang.equals("l1")) {
                alias = entityObjectInfo.getName();
            }
            nameMap.put(lang, alias + "-" + SHRSysSettingResourceUtil.getResource("import", locale));
        }
        MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)"name", (IObjectValue)model, nameMap);
        isAddOrUpdate = Boolean.TRUE;
        if (StringUtils.isEmpty((CharSequence)model.getEntityTable())) {
            model.setEntityTable(entityObjectInfo.getTable().getName());
            isAddOrUpdate = Boolean.TRUE;
        }
        if (StringUtils.isEmpty((CharSequence)model.getEntityName())) {
            model.setEntityName(entityObjectInfo.getAlias());
            isAddOrUpdate = Boolean.TRUE;
        }
        if (StringUtils.isEmpty((CharSequence)model.getEntityFullName())) {
            model.setEntityFullName(entityObjectInfo.getFullName());
            isAddOrUpdate = Boolean.TRUE;
        }
        if (null == model.getId()) {
            model.setShowtype(Boolean.FALSE.booleanValue());
            model.setIsPreset(Boolean.FALSE.booleanValue());
            model.setState(ImportTemplateStateEnum.ENABLE);
        }
        if (StringUtils.isEmpty((CharSequence)model.getUipk()) || !model.getUipk().equals(uipk)) {
            model.setUipk(uipk);
            isAddOrUpdate = Boolean.TRUE;
        }
        if (StringUtils.isEmpty((CharSequence)model.getBindFun()) || !model.getBindFun().equals(bund)) {
            model.setBindFun(bund);
            isAddOrUpdate = Boolean.TRUE;
        }
        if (StringUtils.isEmpty((CharSequence)model.getImportTypes())) {
            model.setImportTypes("[{\"alias\":\"\u65b0\u589e\",\"aliasMultiLan\":{\"l1\":\"New\",\"l2\":\"\u65b0\u589e\",\"l3\":\"\u65b0\u589e\"},\"desc\":\"\",\"descMultiLan\":{\"l1\":\"\",\"l2\":\"\",\"l3\":\"\"},\"name\":\"NEW_IMPORT\",\"sortNum\":1,\"using\":false,\"value\":\"10\"},{\"alias\":\"\u8986\u76d6\",\"aliasMultiLan\":{\"l1\":\"Overwrite\",\"l2\":\"\u8986\u76d6\",\"l3\":\"\u8986\u84cb\"},\"desc\":\"\",\"descMultiLan\":{\"l1\":\"\",\"l2\":\"\",\"l3\":\"\"},\"name\":\"OVERRIDE_IMPORT\",\"sortNum\":2,\"using\":false,\"value\":\"20\"},{\"alias\":\"\u66f4\u65b0(\u4e0d\u65b0\u589e\u8bb0\u5f55)\",\"aliasMultiLan\":{\"l1\":\"Update (Without New Record)\",\"l2\":\"\u66f4\u65b0(\u4e0d\u65b0\u589e\u8bb0\u5f55)\",\"l3\":\"\u66f4\u65b0(\u4e0d\u65b0\u589e\u8a18\u9304)\"},\"desc\":\"\",\"descMultiLan\":{\"l1\":\"\",\"l2\":\"\",\"l3\":\"\"},\"name\":\"UPDATE_ONLY_IMPORT\",\"sortNum\":3,\"using\":false,\"value\":\"30\"},{\"alias\":\"\u66f4\u65b0(\u65b0\u589e\u8bb0\u5f55)\",\"aliasMultiLan\":{\"l1\":\"Update (With New Record)\",\"l2\":\"\u66f4\u65b0(\u65b0\u589e\u8bb0\u5f55)\",\"l3\":\"\u66f4\u65b0(\u65b0\u589e\u8a18\u9304)\"},\"desc\":\"\",\"descMultiLan\":{\"l1\":\"\",\"l2\":\"\",\"l3\":\"\"},\"name\":\"UPDATE_ADD_IMPORT\",\"sortNum\":4,\"using\":true,\"value\":\"40\"}]");
            isAddOrUpdate = Boolean.TRUE;
        }
        if (importFields == null) {
            if (SHRFileTemplateUtil.isNeedAddOrUpdate(model.getEntry(), "name")) {
                isAddOrUpdate = Boolean.TRUE;
                model.getEntry().add(SHRFileTemplateUtil.generateSHRFileTemplateFieldsInfo(model, "name", SHRFileTemplateUtil.getPropNameAlias(entityObjectInfo, "name"), model.getEntry().size() + 1, Boolean.TRUE, Boolean.FALSE, "XX"));
            }
            if (SHRFileTemplateUtil.isNeedAddOrUpdate(model.getEntry(), "number")) {
                isAddOrUpdate = Boolean.TRUE;
                model.getEntry().add(SHRFileTemplateUtil.generateSHRFileTemplateFieldsInfo(model, "number", SHRFileTemplateUtil.getPropNameAlias(entityObjectInfo, "number"), model.getEntry().size() + 1, Boolean.TRUE, Boolean.TRUE, "XX"));
            }
            if (SHRFileTemplateUtil.isNeedAddOrUpdate(model.getEntry(), "usePolicy")) {
                isAddOrUpdate = Boolean.TRUE;
                model.getEntry().add(SHRFileTemplateUtil.generateSHRFileTemplateFieldsInfo(model, "usePolicy", SHRFileTemplateUtil.getPropNameAlias(entityObjectInfo, "usePolicy"), model.getEntry().size() + 1, Boolean.TRUE, Boolean.FALSE, SHRSysSettingResourceUtil.getResource("global_share", ctx)));
            }
            if (SHRFileTemplateUtil.isNeedAddOrUpdate(model.getEntry(), "hrOrgUnit")) {
                isAddOrUpdate = Boolean.TRUE;
                model.getEntry().add(SHRFileTemplateUtil.generateSHRFileTemplateFieldsInfo(model, "hrOrgUnit", SHRFileTemplateUtil.getPropNameAlias(entityObjectInfo, "hrOrgUnit"), model.getEntry().size() + 1, Boolean.TRUE, Boolean.FALSE, "XXXX"));
            }
        } else {
            for (int i = 0; i < importFields.size(); ++i) {
                isAddOrUpdate = Boolean.TRUE;
                String fieldName = importFields.get(i);
                Boolean isPrimayField = false;
                if (i == 0) {
                    isPrimayField = true;
                }
                model.getEntry().add(SHRFileTemplateUtil.generateSHRFileTemplateFieldsInfo(model, fieldName, SHRFileTemplateUtil.getPropNameAlias(entityObjectInfo, fieldName), model.getEntry().size() + 1, Boolean.TRUE, isPrimayField, "XXXX"));
            }
        }
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        if (null == model.getCreateTime()) {
            model.setCreateTime(timestamp);
        }
        if (null == model.getLastUpdateTime()) {
            model.setLastUpdateTime(timestamp);
        }
        UserInfo u = new UserInfo();
        String userId = HRFilterUtils.getCurrentUserId(ctx);
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            u.setId(BOSUuid.read((String)userId));
            if (null == model.getCreator()) {
                model.setCreator(u);
            }
            if (null == model.getLastUpdateUser()) {
                model.setLastUpdateUser(u);
            }
        }
        if (isAddOrUpdate) {
            newCollection.add((CoreBaseInfo)model);
        }
    }

    private static String getPropNameAlias(EntityObjectInfo entityObjectInfo, String proName) {
        PropertyInfo propertyInfo = entityObjectInfo.getPropertyByNameRuntime(proName);
        return propertyInfo.getAlias();
    }

    private static boolean isNeedAddOrUpdate(SHRFileTemplateFieldsCollection coll, String proName) {
        if (null == coll || coll.size() <= 0) {
            return true;
        }
        int total = coll.size();
        for (int i = 0; i < total; ++i) {
            SHRFileTemplateFieldsInfo fieldInfo = coll.get(i);
            if (!proName.equals(fieldInfo.getPropName())) continue;
            return false;
        }
        return true;
    }

    private static SHRFileTemplateFieldsInfo generateSHRFileTemplateFieldsInfo(SHRFileTemplateInfo model, String propName, String name, int sortSn, boolean isNeed, boolean isPrimayField, String demo) {
        SHRFileTemplateFieldsInfo info = new SHRFileTemplateFieldsInfo();
        info.setIsPrimayField(isPrimayField);
        info.setCmpImportTemp(model);
        info.setPropName(propName);
        info.setWidth(4);
        info.setSortSn(sortSn);
        info.setIsNeed(isNeed);
        info.setDemo(demo);
        info.setName(name);
        return info;
    }
}

