/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifierUtil {
    private static Logger logger = LoggerFactory.getLogger(VerifierUtil.class);
    public static final String VERIFIER_TYPE_CELLPHONE = "isCellPhone";
    public static final String VERIFIER_TYPE_EMAIL = "isEmail";
    private static final String VERIFIER_PARAM_NUMBER_CELLPHONE = "IS_CELLPHONE_VERIFIER";
    private static final String VERIFIER_PARAM_NUMBER_EMAIL = "IS_EMAIL_VERIFIER";
    private static final String verifyEmailStr = "^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$";
    private static final Pattern verifyEmailPattern = Pattern.compile("^\\s*\\w+(?:\\.{0,1}[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$");

    public static boolean verifierCellphone(Context ctx, String cellPhoneNumber) throws EASBizException, BOSException {
        String hrOrgID = HRFilterUtils.getCurrentHROID(ctx);
        String verifyCellphoneStr = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(hrOrgID), (String)VERIFIER_PARAM_NUMBER_CELLPHONE);
        Pattern verifyCellphonePattern = Pattern.compile(verifyCellphoneStr);
        Matcher m = verifyCellphonePattern.matcher(cellPhoneNumber);
        return m.matches();
    }

    public static boolean verifierEmail(Context ctx, String emailAddress) throws EASBizException, BOSException {
        Matcher m = verifyEmailPattern.matcher(emailAddress);
        return m.matches();
    }

    public static String getVerifierEmailRule() throws EASBizException, BOSException {
        return verifyEmailStr;
    }

    public static String getverifierCellphoneRule(Context ctx) throws EASBizException, BOSException {
        String hrOrgID = HRFilterUtils.getCurrentHROID(ctx);
        String verifyCellphoneStr = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(hrOrgID), (String)VERIFIER_PARAM_NUMBER_CELLPHONE);
        return verifyCellphoneStr;
    }
}

