/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public final class UserNantionalUtil {
    public static Map<String, Object> getUserUTCInfo(Context ctx) throws EASBizException, BOSException {
        return UserNantionalUtil.getUserUTCInfo(ctx, UserNantionalUtil.getUserNationalFormat(ctx));
    }

    public static Map<String, Object> getUserUTCInfo(Context ctx, Map userNationalPlan) throws EASBizException, BOSException {
        if (null == userNationalPlan) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        HashMap<String, Object> utcServer = new HashMap<String, Object>(2);
        utcServer.put("value", TimeZone.getDefault().getRawOffset() / 3600000);
        utcServer.put("pattern", UserNantionalUtil.getServerDateFormat());
        result.put("utcServer", utcServer);
        HashMap<String, Object> utcUser = new HashMap<String, Object>(5);
        TimeZoneInfo timezoneInfo = (TimeZoneInfo)userNationalPlan.get("timezoneInfo");
        utcUser.put("id", timezoneInfo.getId().toString());
        String alias = timezoneInfo.getTimeZoneStandard().getName() + UserNantionalUtil.getTimeZoneDiffStringValue(timezoneInfo.getTimeDiff().getValue());
        utcUser.put("simpleAlias", alias);
        utcUser.put("alias", timezoneInfo.getName());
        utcUser.put("title", timezoneInfo.getName());
        utcUser.put("value", timezoneInfo.getTimeDiff().getValue());
        utcUser.put("pattern", UserNantionalUtil.getDateUTCFormat(userNationalPlan));
        result.put("utcUser", utcUser);
        result.put("showTimeZoneForCtrl", UserNantionalUtil.isShowTimeZoneForCtrl(ctx));
        return result;
    }

    public static DecimalFormat getUserNumberFormat(Context ctx) throws EASBizException, BOSException {
        return (DecimalFormat)UserNantionalUtil.getUserNationalFormat(ctx).get("numberFormat");
    }

    public static void setUserFormat(Context ctx, Map<String, Object> map) throws EASBizException, BOSException {
        UserNantionalUtil.setUserFormat(ctx, map, null);
    }

    public static void setUserFormat(Context ctx, Map<String, Object> map, Map<String, String> varDefine) throws EASBizException, BOSException {
        if (null == map) {
            return;
        }
        Map userNationalPlan = UserNantionalUtil.getUserNationalFormat(ctx);
        map.put("utcData", UserNantionalUtil.getUserUTCInfo(ctx, userNationalPlan));
        HashMap<String, Object> numberFormat = new HashMap<String, Object>();
        UserNantionalUtil.setUserNumberFormat(userNationalPlan, numberFormat, varDefine);
        map.put("numberFormat", numberFormat);
    }

    private static void setUserNumberFormat(Map userNationalPlan, Map<String, Object> numberFormat, Map<String, String> varDefine) {
        if (null == numberFormat) {
            return;
        }
        DecimalFormat numFormat = (DecimalFormat)userNationalPlan.get("numberFormat");
        DecimalFormatSymbols dfs = numFormat.getDecimalFormatSymbols();
        if (dfs.getGroupingSeparator() == '\u0000') {
            numberFormat.put("groupingSeparator", "");
        } else {
            numberFormat.put("groupingSeparator", String.valueOf(dfs.getGroupingSeparator()));
        }
        numberFormat.put("decimalSeparator", String.valueOf(dfs.getDecimalSeparator()));
        if (null == numberFormat.get("digitPoint")) {
            numberFormat.put("digitPoint", 2);
        }
        if (null != varDefine && varDefine.containsKey("decimalPrecision")) {
            numberFormat.put("digitPointCustom", varDefine.get("decimalPrecision"));
        } else {
            numberFormat.put("digitPointCustom", numberFormat.get("digitPoint"));
        }
    }

    private static void setUserNumberFormat(Map<String, Object> numberFormat) throws EASBizException, BOSException {
        if (null == numberFormat) {
            return;
        }
        if (null == numberFormat.get("decimalPrecision")) {
            numberFormat.put("decimalPrecision", 2);
        }
        if (null == numberFormat.get("ignoreDecimalFormatter")) {
            numberFormat.put("ignoreDecimalFormatter", false);
        }
        if (null == numberFormat.get("roundType")) {
            numberFormat.put("roundType", "round");
        }
    }

    public static String getTimeZoneDiffStringValue(double diff) {
        String diffValue = String.valueOf(diff);
        if (diffValue.indexOf(".0") != -1) {
            diffValue = diffValue.substring(0, diffValue.indexOf(".0"));
        }
        diffValue = diffValue.replace("-", "");
        if (diff >= 0.0) {
            diffValue = MessageFormat.format("{0}{1}", "+", diffValue);
        } else if (diff < 0.0) {
            diffValue = MessageFormat.format("{0}{1}", "-", diffValue);
        }
        return diffValue;
    }

    public static TimeZone getTimeZoneIDForSunJDK(Context ctx) throws EASBizException, BOSException {
        Map userNationalPlan = UserNantionalUtil.getUserNationalFormat(ctx);
        TimeZoneInfo timezoneInfo = (TimeZoneInfo)userNationalPlan.get("timezoneInfo");
        return UserNantionalUtil.getTimeZoneIDForSunJDK(ctx, timezoneInfo);
    }

    public static TimeZone getTimeZoneIDForSunJDK(Context ctx, TimeZoneInfo timezoneInfo) throws EASBizException, BOSException {
        return TimeZone.getTimeZone(MessageFormat.format("{0}{1}", "GMT", UserNantionalUtil.getTimeZoneDiffStringValue(timezoneInfo.getTimeDiff().getValue())));
    }

    public static Map<String, String> getSystemSolutionDateUTCFormat(Context ctx) throws EASBizException, BOSException {
        return UserNantionalUtil.getDateUTCFormat(UserNantionalUtil.getSystemSolutionNationalFormat(ctx));
    }

    public static Map getSystemSolutionNationalFormat(Context ctx) throws EASBizException, BOSException {
        return NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(null, null, null);
    }

    public static Map<String, String> getDateUTCFormat(Context ctx) throws EASBizException, BOSException {
        HashMap m = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ctx.getLocale().getDisplayName().toUpperCase());
        return UserNantionalUtil.getDateUTCFormat(m);
    }

    public static Map getUserNationalFormat(Context ctx) throws EASBizException, BOSException {
        return NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ctx.getLocale().getDisplayName().toUpperCase());
    }

    private static Map<String, String> getDateUTCFormat(Map nantionalMap) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(DataType.TIME.getName(), ((SimpleDateFormat)nantionalMap.get("timeFormat")).toPattern());
        m.put(DataType.DATE.getName(), ((SimpleDateFormat)nantionalMap.get("dateFormat")).toPattern());
        m.put(DataType.TIMESTAMP.getName(), ((SimpleDateFormat)nantionalMap.get("dateTimeFormat")).toPattern());
        return m;
    }

    private static Map<String, String> getServerDateFormat() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(DataType.TIME.getName(), "yyyy-MM-dd HH:mm:ss");
        m.put(DataType.DATE.getName(), "yyyy-MM-dd");
        m.put(DataType.TIMESTAMP.getName(), "yyyy-MM-dd HH:mm:ss");
        return m;
    }

    public static boolean isShowTimeZoneForCtrl(Context ctx) throws EASBizException, BOSException {
        return Boolean.parseBoolean(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"ShowTimeZoneForCtrl", null, (boolean)false));
    }

    public static boolean isTCToTWOpen(Context ctx) throws EASBizException, BOSException {
        return Boolean.parseBoolean(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"multiLan_sc_to_tc_open", null, (boolean)false));
    }

    public static boolean isShrExportExcelSensitiveOpen(Context ctx) throws EASBizException, BOSException {
        return Boolean.parseBoolean(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"SHR_EXPORTEXCEL_SENSITIVE", null, (boolean)false));
    }

    public static boolean isShrSensitiveRuleOpen(Context ctx) throws EASBizException, BOSException {
        return Boolean.parseBoolean(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"SHR_SENSITIVE_RULE_OPEN", null, (boolean)false));
    }

    public static String isShrExportExcelSetPwd(Context ctx) throws EASBizException, BOSException {
        return ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"SHR_ExportExcelSetPwd", null, (boolean)false);
    }

    public static void dateExtendOptionsSetting(Context ctx, Map<String, Object> extendOptions, boolean isOrigin, DataType dataType) throws EASBizException, BOSException {
        UserNantionalUtil.dateExtendOptionsSetting(ctx, extendOptions, isOrigin, dataType, null);
    }

    public static void dateExtendOptionsSetting(Context ctx, Map<String, Object> extendOptions, boolean isOrigin, DataType dataType, PropertyInfo propertyInfo) throws EASBizException, BOSException {
        if (null == extendOptions) {
            return;
        }
        Map datetimeOptions = null;
        datetimeOptions = null == extendOptions.get("datetimeOptions") ? new HashMap() : (Map)extendOptions.get("datetimeOptions");
        UserNantionalUtil.setDateExtendOptions(ctx, datetimeOptions, isOrigin, null, dataType, propertyInfo);
        extendOptions.put("datetimeOptions", datetimeOptions);
    }

    public static void dateExtendOptionsSetting(Context ctx, Map<String, Object> extendOptions, boolean isOrigin, Map<String, String> attributes, DataType dataType) throws EASBizException, BOSException {
        UserNantionalUtil.dateExtendOptionsSetting(ctx, extendOptions, isOrigin, attributes, dataType, null);
    }

    public static void dateExtendOptionsSetting(Context ctx, Map<String, Object> extendOptions, boolean isOrigin, Map<String, String> attributes, DataType dataType, PropertyInfo propertyInfo) throws EASBizException, BOSException {
        if (null == extendOptions) {
            return;
        }
        Map datetimeOptions = null;
        datetimeOptions = null == extendOptions.get("datetimeOptions") ? new HashMap() : (Map)extendOptions.get("datetimeOptions");
        UserNantionalUtil.setDateExtendOptions(ctx, datetimeOptions, isOrigin, attributes, dataType, propertyInfo);
        extendOptions.put("datetimeOptions", datetimeOptions);
    }

    public static void setDateExtendOptions(Context ctx, Map<String, Object> datetimeOptions, boolean isOrigin, Map<String, String> attributes, DataType dataType, PropertyInfo propertyInfo) throws EASBizException, BOSException {
        if (null != dataType) {
            datetimeOptions.put("ctrlType", dataType.getName());
        }
        if (null == datetimeOptions || null == datetimeOptions.get("isAutoTimeZoneTrans")) {
            if (null == attributes || StringUtils.isEmpty((String)attributes.get("isAutoTimeZoneTrans"))) {
                if (null == propertyInfo) {
                    datetimeOptions.put("isAutoTimeZoneTrans", isOrigin);
                } else if ("false".equals(propertyInfo.getExtendedProperty("isAutoTimeZoneTrans"))) {
                    datetimeOptions.put("isAutoTimeZoneTrans", false);
                } else {
                    datetimeOptions.put("isAutoTimeZoneTrans", true);
                }
            } else {
                datetimeOptions.put("isAutoTimeZoneTrans", Boolean.parseBoolean(attributes.get("isAutoTimeZoneTrans")));
            }
        }
        if (null == datetimeOptions || null == datetimeOptions.get("isShowUTC")) {
            if (null == attributes || StringUtils.isEmpty((String)attributes.get("isShowUTC"))) {
                datetimeOptions.put("isShowUTC", isOrigin);
            } else {
                datetimeOptions.put("isShowUTC", Boolean.parseBoolean(attributes.get("isShowUTC")));
            }
        }
        if (null == datetimeOptions || null == datetimeOptions.get("isReadonlyUTC")) {
            if (null == attributes || StringUtils.isEmpty((String)attributes.get("isReadonlyUTC"))) {
                datetimeOptions.put("isReadonlyUTC", isOrigin);
            } else {
                datetimeOptions.put("isReadonlyUTC", Boolean.parseBoolean(attributes.get("isReadonlyUTC")));
            }
        }
        if (null == datetimeOptions || null == datetimeOptions.get("isRemoveSeconds")) {
            if (null == attributes || StringUtils.isEmpty((String)attributes.get("isRemoveSeconds"))) {
                datetimeOptions.put("isRemoveSeconds", true);
            } else {
                datetimeOptions.put("isRemoveSeconds", Boolean.parseBoolean(attributes.get("isRemoveSeconds")));
            }
        }
        if (null == datetimeOptions || null == datetimeOptions.get("isRemoveDay")) {
            if (null == attributes || StringUtils.isEmpty((String)attributes.get("isRemoveDay"))) {
                datetimeOptions.put("isRemoveDay", false);
            } else {
                datetimeOptions.put("isRemoveDay", Boolean.parseBoolean(attributes.get("isRemoveDay")));
            }
        }
        if (DataType.DATE.equals((Object)dataType)) {
            datetimeOptions.put("isAutoTimeZoneTrans", false);
            datetimeOptions.put("isShowUTC", false);
            datetimeOptions.put("showTimeZoneForCtrl", false);
        }
        datetimeOptions.put("showTimeZoneForCtrl", UserNantionalUtil.isShowTimeZoneForCtrl(ctx));
    }

    public static void numberExtendOptionsSetting(Context ctx, Map<String, Object> extendOptions, boolean isOrigin) throws EASBizException, BOSException {
        if (null == extendOptions) {
            return;
        }
        Map numberOptions = null;
        numberOptions = null == extendOptions.get("numberOptions") ? new HashMap() : (Map)extendOptions.get("numberOptions");
        UserNantionalUtil.setUserNumberFormat(numberOptions);
        extendOptions.put("numberOptions", numberOptions);
    }

    public static void numberExtendOptionsSetting(Context ctx, Map<String, Object> extendOptions, boolean isOrigin, Map<String, String> attributes) throws EASBizException, BOSException {
        if (null == extendOptions) {
            return;
        }
        Map numberOptions = null;
        numberOptions = null == extendOptions.get("numberOptions") ? new HashMap() : (Map)extendOptions.get("numberOptions");
        UserNantionalUtil.setUserNumberFormat0(numberOptions, attributes);
        extendOptions.put("numberOptions", numberOptions);
    }

    public static String getUserDateStr(Context ctx, Date date) throws EASBizException, BOSException {
        Map formatAndTimeZone = UserNantionalUtil.getUserNationalFormat(ctx);
        SimpleDateFormat format = (SimpleDateFormat)formatAndTimeZone.get("dateTimeFormat");
        TimeZoneInfo timezoneInfo = (TimeZoneInfo)formatAndTimeZone.get("timezoneInfo");
        String timeDiff = UserNantionalUtil.getTimeZoneDiffStringValue(timezoneInfo.getTimeDiff().getValue());
        TimeZone timeZone = TimeZone.getTimeZone(MessageFormat.format("{0}{1}", "GMT", timeDiff));
        SimpleDateFormat sdf = new SimpleDateFormat(format.toPattern());
        sdf.setTimeZone(timeZone);
        return sdf.format(date);
    }

    private static void setUserNumberFormat0(Map<String, Object> numberFormat, Map<String, String> attributes) {
        if (null == numberFormat) {
            return;
        }
        if (null == attributes || StringUtils.isEmpty((String)attributes.get("decimalPrecision"))) {
            numberFormat.put("decimalPrecision", 2);
        } else {
            numberFormat.put("decimalPrecision", Integer.parseInt(attributes.get("decimalPrecision")));
        }
        if (null == attributes || StringUtils.isEmpty((String)attributes.get("ignoreDecimalFormatter"))) {
            numberFormat.put("ignoreDecimalFormatter", false);
        } else {
            numberFormat.put("ignoreDecimalFormatter", Boolean.parseBoolean(attributes.get("ignoreDecimalFormatter")));
        }
        if (null == attributes || StringUtils.isEmpty((String)attributes.get("roundType"))) {
            numberFormat.put("roundType", "round");
        } else {
            numberFormat.put("roundType", attributes.get("roundType"));
        }
    }

    public static void extendOptionsSetting(Context ctx, Map<String, Object> extendOptions, boolean isOrigin, DataType dataType, Map<String, String> attributes) throws EASBizException, BOSException {
        UserNantionalUtil.dateExtendOptionsSetting(ctx, extendOptions, isOrigin, attributes, dataType);
        UserNantionalUtil.numberExtendOptionsSetting(ctx, extendOptions, isOrigin, attributes);
    }

    public static void setNumberPrecisionByVarDefineForFormatoptions(Map<String, String> attributes, DataType dataType, Map<String, Object> data, Map<String, String> varDefine) {
        if (DataType.DOUBLE.equals((Object)dataType) || DataType.DECIMAL.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType)) {
            if (null != attributes && attributes.containsKey("decimalPrecision")) {
                return;
            }
            if (null != varDefine && varDefine.containsKey("decimalPrecision") && null != data.get("formatoptions")) {
                Map formatoptions = (Map)data.get("formatoptions");
                formatoptions.put("decimalPrecision", Integer.parseInt(varDefine.get("decimalPrecision")));
            }
        }
    }

    public static void setNumberPrecisionByVarDefineForExtendOptions(Map<String, String> attributes, DataType dataType, Map<String, Object> data, Map<String, String> varDefine) {
        if (DataType.DOUBLE.equals((Object)dataType) || DataType.DECIMAL.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType)) {
            Map extendOptions;
            if (null != attributes && attributes.containsKey("decimalPrecision")) {
                return;
            }
            if (null != varDefine && varDefine.containsKey("decimalPrecision") && null != data.get("extendOptions") && null != (extendOptions = (Map)data.get("extendOptions")).get("numberOptions")) {
                Map numberOptions = (Map)extendOptions.get("numberOptions");
                numberOptions.put("decimalPrecision", Integer.parseInt(varDefine.get("decimalPrecision")));
            }
        }
    }

    public static void setNumberPrecisionByVarDefineForExtendOptions(Map<String, String> attributes, Map<String, Object> data, Map<String, String> varDefine) {
        UserNantionalUtil.setNumberPrecisionByVarDefineForExtendOptions(attributes, DataType.DOUBLE, data, varDefine);
    }

    public static void setNumberPrecisionByVarDefineAndOrignExtendOptions(Map<String, Object> orignExtendOptions, DataType dataType, Map<String, Object> data, Map<String, String> varDefine) {
        if (null == orignExtendOptions || null == orignExtendOptions.get("numberOptions")) {
            return;
        }
        Map numberOptions = (Map)orignExtendOptions.get("numberOptions");
        if (numberOptions.containsKey("decimalPrecision")) {
            return;
        }
        UserNantionalUtil.setNumberPrecisionByVarDefineForExtendOptions(null, DataType.DOUBLE, data, varDefine);
    }
}

