/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula;

import com.kingdee.shr.validaterule.formula.ISalaryCalculator;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import com.kingdee.shr.validaterule.formula.TaskInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class SalayCalculatorMgr2
extends Thread {
    private static int taskCount = 0;
    public static int maxTasks = 1;
    public static int waitTime = 10;
    private static SalayCalculatorMgr2 instance = null;
    private static ArrayList<SalaryCalculator2> taskList = new ArrayList();
    private static ArrayList<TaskInfo> taskInfo = new ArrayList();

    public static synchronized void addTask(SalaryCalculator2 calculator) {
        taskList.add(calculator);
    }

    public static synchronized SalaryCalculator2 findTask(String uid) {
        int index;
        if (uid == null || "".equals(uid)) {
            return null;
        }
        for (index = 0; index < taskList.size(); ++index) {
            SalaryCalculator2 calculator = taskList.get(index);
            if (!uid.equals(calculator.getUID())) continue;
            return calculator;
        }
        for (index = 0; index < taskInfo.size(); ++index) {
            TaskInfo task = taskInfo.get(index);
            if (task.getUid().equals(uid)) {
                String info = task.getInfo();
                if (StringUtils.isEmpty((String)info)) {
                    info = "Calculation completed";
                }
                taskInfo.remove(index);
                throw new RuntimeException(info);
            }
            if (System.currentTimeMillis() - task.getEndTime() <= 6000000L) continue;
            taskInfo.remove(index);
            --index;
        }
        return null;
    }

    public static synchronized SalaryCalculator2 getTask() {
        SalaryCalculator2 calculator = null;
        for (int index = 0; index < taskList.size(); ++index) {
            calculator = taskList.get(index);
            if (calculator.getStatus() != 0) continue;
            calculator.setStatus(1);
            return calculator;
        }
        return null;
    }

    public static synchronized void removeTask(String uid, String cause) {
        int index;
        if (uid == null || "".equals(uid)) {
            return;
        }
        for (index = 0; index < taskList.size(); ++index) {
            ISalaryCalculator calculator = taskList.get(index);
            if (!uid.equals(calculator.getUID())) continue;
            taskList.remove(index);
            --taskCount;
        }
        for (index = 0; index < taskInfo.size(); ++index) {
            TaskInfo task = taskInfo.get(index);
            if (!task.getUid().equals(uid)) continue;
            task.setEndTime(System.currentTimeMillis());
            task.setInfo(cause);
            return;
        }
    }

    private boolean haveNewTask() {
        ISalaryCalculator calculator = null;
        for (int index = 0; index < taskList.size(); ++index) {
            calculator = taskList.get(index);
            if (calculator.getStatus() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        while (true) {
            System.out.println("==========taskCount is " + taskCount + "===========");
            while (taskCount >= maxTasks || !this.haveNewTask()) {
                try {
                    SalayCalculatorMgr2.sleep(waitTime * 1000);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                SalaryCalculator2 calculator = SalayCalculatorMgr2.getTask();
                if (calculator == null) continue;
                ++taskCount;
                taskInfo.add(new TaskInfo(calculator.getUID()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public synchronized void wakeup() {
        this.notifyAll();
    }
}

