/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula.result.analysis;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class GetClassFromInterface {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.validaterule.formula.result.analysis.GetClassFromInterface");
    public static Map<String, List<Class<?>>> classMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Class<?>> getAllClass(Context ctx, Class<?> interfaceClass, String calCategoryNum) throws Exception {
        String mapKey = interfaceClass.toString() + "_" + calCategoryNum;
        if (classMap.containsKey(mapKey)) return classMap.get(mapKey);
        Class<GetClassFromInterface> clazz = GetClassFromInterface.class;
        synchronized (GetClassFromInterface.class) {
            if (classMap.containsKey(mapKey)) return classMap.get(mapKey);
            List<Class<?>> classList = GetClassFromInterface.getAchieveClassByInterface(ctx, interfaceClass, calCategoryNum);
            classMap.put(mapKey, classList);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return classMap.get(mapKey);
        }
    }

    private static List<Class<?>> getAchieveClassByInterface(Context ctx, Class<?> interfaceClass, String calCategoryNum) throws Exception {
        ArrayList classList = new ArrayList();
        String sql = "select FImplClassStr from T_HR_SCalExecutorResultHandle where FInterFaceStr = ? and FCalCategoryNumber = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{interfaceClass.getName(), calCategoryNum});
        while (rowSet.next()) {
            String implClassStr = rowSet.getString("FImplClassStr");
            try {
                Class<?> implClass = Class.forName(implClassStr);
                classList.add(implClass);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        GetClassFromInterface.afterGetClass(classList, interfaceClass);
        return classList;
    }

    private static void afterGetClass(List<Class<?>> classList, Class<?> interfaceClass) throws Exception {
        for (int i = classList.size() - 1; i >= 0; --i) {
            Class<?>[] interfaces;
            boolean isChild = false;
            if (classList.get(i).isInterface() || Modifier.isAbstract(classList.get(i).getModifiers())) {
                classList.remove(i);
                continue;
            }
            for (Class<?> c : interfaces = classList.get(i).getInterfaces()) {
                if (!c.equals(interfaceClass)) continue;
                isChild = true;
                break;
            }
            if (isChild) continue;
            classList.remove(i);
        }
    }
}

