/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.org;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.invokecounter.RPCInvokeCounter;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.eas.base.myeas.SwitchOrgRecordFactory;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.base.uiframe.client.MainUIObjectManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IMultiOrgsClientCache;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.MultiOrgsClientCacheImplFactory;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.ext.IOrgClientExt;
import com.kingdee.eas.basedata.org.client.ext.OrgClientExtHelper;
import com.kingdee.eas.basedata.org.helper.OrgTypeRegister;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;

public class MultiOrgSwitchUtils {
    public static void switchOrg(Context ctx, String ouId) throws EASBizException, BOSException {
        OrgSwitchFacadeFactory.getLocalInstance(ctx).orgSwitch(ouId);
    }

    public static void switchOrgForLogin(Context ctx, String ouId) throws EASBizException, BOSException {
        OrgTypeRegister.getInstance().initOrgTypeMgrExt();
        if (ctx == null) {
            MultiOrgSwitchUtils.switchOrg(ouId);
            return;
        }
        HashMap map = (HashMap)ctx.get((Object)"OrgUnits");
        if (map != null) {
            MultiOrgSwitchUtils.updateSysContext(map);
            try {
                IOrgClientExt iOrgClient = OrgClientExtHelper.getClientOrgExt();
                iOrgClient.switchAccountScheme();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (CacheConfigManager.getConfig() != null) {
                CacheServiceFactory.getInstance().discardAll();
            }
        } else {
            MultiOrgSwitchUtils.switchOrg(ouId);
        }
    }

    public static boolean checkBeforeSwitch(Component owner) {
        if (MsgBox.showConfirm2((Component)owner, (String)EASResource.getString((String)UIFrameResource.class.getName(), (String)"MainMenuBar.switchOrgConfirm")) == 2) {
            return false;
        }
        return MainUIObjectManager.getInstance().closeAllNonSysApp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void switchOrgForClient(Component owner, String ouId) {
        try {
            MultiOrgSwitchUtils.setCursor(owner, 3);
            CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            String cuId = "";
            if (cuInfo != null && cuInfo.getId() != null) {
                cuId = cuInfo.getId().toString();
            }
            UIActionMonitor.clearAction();
            MultiOrgSwitchUtils.switchOrgForUI(ouId);
            MainFrameCallBack.firePropertyChange((String)"HRSwitchOrg", (Object)"old", (Object)ouId);
            CtrlUnitInfo cuInfo2 = SysContext.getSysContext().getCurrentCtrlUnit();
            String cuId2 = "";
            if (cuInfo2 != null && cuInfo2.getId() != null) {
                cuId2 = cuInfo2.getId().toString();
            }
            if (cuId.equals(cuId2)) {
                MainFrameCallBack.callWebRefresh((String)("org.0;" + ouId));
            } else {
                MainFrameCallBack.callWebRefresh((String)("org.1;" + ouId));
            }
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            SwitchOrgRecordFactory.getRemoteInstance().updateLastTime(userId, ouId);
        }
        catch (Exception e) {
            if (!ExceptionHandler.handleOrgMissingRecord((Component)owner, (Throwable)e)) {
                ExceptionHandler.handle((Component)owner, (Throwable)e);
            }
        }
        finally {
            MultiOrgSwitchUtils.setCursor(owner, 0);
        }
    }

    private static void setCursor(Component owner, int curType) {
        Cursor cursor = Cursor.getPredefinedCursor(curType);
        Window ancestor = SwingUtilities.getWindowAncestor(owner);
        if (ancestor == null) {
            owner.setCursor(cursor);
        } else {
            ((Component)ancestor).setCursor(cursor);
        }
        MultiOrgSwitchUtils.setCursorRecursively(owner, cursor);
    }

    private static void setCursorRecursively(Component comp, Cursor cursor) {
        comp.setCursor(cursor);
        if (comp instanceof Container) {
            Container container = (Container)comp;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component curComponent = container.getComponent(i);
                if (!curComponent.isFocusable()) continue;
                MultiOrgSwitchUtils.setCursorRecursively(curComponent, cursor);
            }
        }
    }

    public static void switchOrgForUI(String ouId) throws EASBizException, BOSException {
        IOrgSwitchFacade iSwitch = OrgSwitchFacadeFactory.getRemoteInstance();
        HashMap map = iSwitch.getOrgs(ouId);
        MultiOrgSwitchUtils.updateSysContext(map);
        Context ctx = ConfigMDUtil.getContextFromEnv();
        if (ctx != null) {
            ctx.put((Object)"OrgUnits", (Object)map);
        }
        IOrgClientExt iOrgClient = OrgClientExtHelper.getClientOrgExt();
        iOrgClient.switchAccountScheme();
        if (CacheConfigManager.getConfig() != null) {
            CacheServiceFactory.getInstance().discardAll();
        }
    }

    public static void switchOrg(String ouId) throws EASBizException, BOSException {
        if (MultiOrgSwitchUtils.isMultiOrgsClientCacheUsed()) {
            MultiOrgSwitchUtils.switchOrgFromClientCache(ouId);
            return;
        }
        IOrgSwitchFacade iSwitch = OrgSwitchFacadeFactory.getRemoteInstance();
        HashMap map = iSwitch.getOrgs(ouId);
        MultiOrgSwitchUtils.updateSysContext(map);
        if (CacheConfigManager.getConfig() != null) {
            CacheServiceFactory.getInstance().discardAll();
        }
        RPCInvokeCounter.clearActionSet();
    }

    private static void switchOrgFromClientCache(String ouId) throws BOSException, EASBizException {
        boolean hasSwitchOrg = false;
        IMultiOrgsClientCache orgClientCacheImpl = MultiOrgSwitchUtils.getClientCacheImpl(ouId);
        MultiOrgSwitchUtils.clearMultiOrgsWhenNeccessary(orgClientCacheImpl);
        if (MultiOrgSwitchUtils.isMultiOrgsExisted(orgClientCacheImpl)) {
            try {
                MultiOrgSwitchUtils.loadMultiOrgs(orgClientCacheImpl);
                hasSwitchOrg = true;
            }
            catch (Exception e) {
                try {
                    orgClientCacheImpl.clearMultiOrgs();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!hasSwitchOrg) {
            IOrgSwitchFacade iswitch = OrgSwitchFacadeFactory.getRemoteInstance();
            HashMap map = iswitch.getOrgs(ouId);
            MultiOrgSwitchUtils.updateSysContext(map);
            MultiOrgSwitchUtils.storeMultiOrgs(orgClientCacheImpl, map);
        }
        if (CacheConfigManager.getConfig() != null) {
            CacheServiceFactory.getInstance().discardAll();
        }
    }

    private static void updateSysContext(HashMap map) {
        List orgTypeList = OrgType.getEnumList();
        for (int i = 0; i < orgTypeList.size(); ++i) {
            OrgType curOrgType = (OrgType)((Object)orgTypeList.get(i));
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)map.get((Object)curOrgType);
            if (OrgType.UnionDebt.equals((Object)curOrgType)) continue;
            SysContext.getSysContext().setCurrentOrgUnit(curOrgType, orgUnitInfo);
        }
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)map.get("CurOU");
        SysContext.getSysContext().setCurrentOrgUnit((OrgUnitInfo)ouInfo);
        OrgUnitInfo fiInfo = (OrgUnitInfo)map.get((Object)OrgType.Company);
        if (fiInfo != null) {
            SysContext.getSysContext().setProperty((Object)"CompanyInfo", (Object)fiInfo);
            SysContext.getSysContext().setProperty((Object)"CurCompanyId", (Object)fiInfo.getId().toString());
        }
    }

    private static boolean isMultiOrgsClientCacheUsed() {
        return MultiOrgsClientCacheImplFactory.isMultiOrgsClientCacheUsed();
    }

    private static IMultiOrgsClientCache getClientCacheImpl(String ouId) throws BOSException {
        try {
            return MultiOrgsClientCacheImplFactory.create(ouId);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static boolean isMultiOrgsExisted(IMultiOrgsClientCache orgClientCacheImpl) throws BOSException {
        try {
            return orgClientCacheImpl.isMultiOrgsExisted();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void storeMultiOrgs(IMultiOrgsClientCache orgClientCacheImpl, HashMap map) throws BOSException {
        try {
            orgClientCacheImpl.storeMultiOrgs(map);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void loadMultiOrgs(IMultiOrgsClientCache orgClientCacheImpl) throws BOSException {
        try {
            orgClientCacheImpl.loadMultiOrgs();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void clearMultiOrgsWhenNeccessary(IMultiOrgsClientCache orgClientCacheImpl) throws BOSException {
        try {
            if (SysContext.getSysContext().isRefreshOrgUnit()) {
                orgClientCacheImpl.clearMultiOrgs();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

